/*
 * Decompiled with CFR 0.152.
 */
package constraints;

import constraints.Constraint;
import constraints.hard.ConflictsStructure;
import constraints.hard.CtrExtension;
import constraints.hard.extension.structures.Bits;
import constraints.hard.global.SumSimple;
import constraints.hard.global.SumWeighted;
import interfaces.FilteringSpecific;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Types;
import problem.Problem;
import propagation.order1.PropagationForward;
import propagation.structures.revisers.Reviser;
import propagation.structures.revisers.Reviser3;
import propagation.structures.supporters.SupporterHard;
import propagation.structures.supporters.SupporterHardBary;
import propagation.structures.supporters.SupporterHardNary;
import utility.Kit;
import variables.Variable;
import variables.domains.Domain;
import variables.domains.DomainInteger;

public abstract class CtrHard
extends Constraint {
    protected ConflictsStructure conflictsStructure;

    @Override
    public ConflictsStructure conflictsStructure() {
        return this.conflictsStructure;
    }

    @Override
    public void cloneStructures(boolean onlyConflictsStructure) {
        if (this.conflictsStructure != null && this.conflictsStructure.registeredCtrs().size() > 1) {
            this.conflictsStructure.unregister(this);
            this.conflictsStructure = new ConflictsStructure(this.conflictsStructure, this);
        }
    }

    public void updateConflictsStructures(int[] frontier) {
        if (this.conflictsStructure != null && Stream.of(this.scp).anyMatch(x -> x.dom.lastRemoved() != frontier[x.num]) && !this.usePredefinedMaxNumberOfConflicts()) {
            if (this.conflictsStructure.registeredCtrs().size() > 1) {
                this.cloneStructures(true);
            }
            this.conflictsStructure.updateCounters(frontier);
        }
    }

    public int giveUpperBoundOfMaxNumberOfConflictsFor(Variable x, int a) {
        return -10;
    }

    public boolean usePredefinedMaxNumberOfConflicts() {
        return this.giveUpperBoundOfMaxNumberOfConflictsFor(this.scp[0], this.scp[0].dom.first()) != -10;
    }

    protected CtrHard() {
    }

    public CtrHard(Problem pb, Variable[] scp) {
        super(pb, scp);
        this.buildSupporter();
    }

    @Override
    public void buildSupporter() {
        if (this.pb.rs.cp.propagating.residues != (this.supporter != null)) {
            this.supporter = this.pb.rs.cp.propagating.residues && this.scp.length > 1 && !(this instanceof FilteringSpecific) && (!this.pb.rs.cp.propagating.classForRevisions.equals(Reviser3.class.getSimpleName()) || !(this.extStructure() instanceof Bits)) ? (this.scp.length == 2 ? new SupporterHardBary(this) : new SupporterHardNary(this)) : null;
        }
    }

    public abstract boolean checkValues(int[] var1);

    public boolean checkIndexes(int[] t) {
        ++this.pb.stuff.nCcks;
        return this.indexesMatchValues ? this.checkValues(t) : this.checkValues(this.toVals(t));
    }

    public boolean checkCurrentInstantiation() {
        return this.checkIndexes(this.buildCurrentInstantiationTuple());
    }

    private final boolean seekSupport() {
        return this.tupleManager.findValidTupleSuchThat(t -> this.checkIndexes((int[])t));
    }

    public final boolean seekFirstSupport() {
        this.tupleManager.firstValidTuple();
        return this.seekSupport();
    }

    public final boolean seekFirstSupport(int[] buffer) {
        this.tupleManager.firstValidTuple(buffer);
        return this.seekSupport();
    }

    public final boolean seekFirstSupportWith(int x, int a) {
        this.tupleManager.firstValidTupleWith(x, a);
        return this.seekSupport();
    }

    public boolean seekFirstSupportWith(int x, int a, int[] buffer) {
        this.tupleManager.firstValidTupleWith(x, a, buffer);
        return this.seekSupport();
    }

    public final boolean seekFirstSupportWith(int x, int a, int y, int b) {
        this.tupleManager.firstValidTupleWith(x, a, y, b);
        return this.seekSupport();
    }

    public final boolean seekFirstSupportWith(int x, int a, int y, int b, int[] buffer) {
        this.tupleManager.firstValidTupleWith(x, a, y, b, buffer);
        return this.seekSupport();
    }

    public final boolean seekNextSupport() {
        return this.tupleManager.nextValidTupleCautiously() != -1 && this.seekSupport();
    }

    private final boolean seekConflict() {
        return this.tupleManager.findValidTupleSuchThat(t -> !this.checkIndexes((int[])t));
    }

    public final boolean seekFirstConflict() {
        this.tupleManager.firstValidTuple();
        return this.seekConflict();
    }

    public final boolean seekFirstConflictWith(int x, int a) {
        this.tupleManager.firstValidTupleWith(x, a);
        return this.seekConflict();
    }

    public long nSupports() {
        this.tupleManager.firstValidTuple();
        return this.tupleManager.countValidTuplesSuchThat(t -> this.checkIndexes((int[])t));
    }

    public long nConflicts() {
        this.tupleManager.firstValidTuple();
        return this.tupleManager.countValidTuplesSuchThat(t -> !this.checkIndexes((int[])t));
    }

    public long nSupportsFor(int x, int a) {
        this.tupleManager.firstValidTupleWith(x, a);
        return this.tupleManager.countValidTuplesSuchThat(t -> this.checkIndexes((int[])t));
    }

    public long nConflictsFor(int x, int a) {
        this.tupleManager.firstValidTupleWith(x, a);
        return this.tupleManager.countValidTuplesSuchThat(t -> !this.checkIndexes((int[])t));
    }

    @Override
    public long costOfIdxs(int[] idxs) {
        return this.checkIndexes(idxs) ? 0L : (long)this.cost;
    }

    @Override
    public long minCostOfTuplesWith(int x, int a) {
        return this.seekFirstSupportWith(x, a) ? 0L : (long)this.cost;
    }

    public boolean findArcSupportFor(int x, int a) {
        if (this.supporter != null) {
            return ((SupporterHard)this.supporter).findArcSupportFor(x, a);
        }
        if (this.extStructure() instanceof Bits) {
            long[] t1 = ((Bits)this.extStructure()).bitSupsFor(x)[a];
            long[] t2 = this.scp[x == 0 ? 1 : 0].dom.binaryRepresentation();
            for (int i = 0; i < t1.length; ++i) {
                ++this.pb.stuff.nCcks;
                if ((t1[i] & t2[i]) == 0L) continue;
                return true;
            }
            return false;
        }
        return this.seekFirstSupportWith(x, a);
    }

    private boolean genericFiltering(Variable x) {
        Reviser reviser = ((PropagationForward)this.pb.solver.propagation).reviser;
        if (x.isAssigned()) {
            for (int i = this.futvars.limit; i >= 0; --i) {
                if (reviser.revise(this, this.scp[this.futvars.dense[i]])) continue;
                return false;
            }
        } else {
            boolean revisingEventVarToo = this.scp.length == 1;
            for (int i = this.futvars.limit; i >= 0; --i) {
                Variable y = this.scp[this.futvars.dense[i]];
                if (y == x) continue;
                if (this.timestamp < y.timestamp) {
                    revisingEventVarToo = true;
                }
                if (reviser.revise(this, y)) continue;
                return false;
            }
            if (revisingEventVarToo && !reviser.revise(this, x)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public final boolean filterFrom(Variable x) {
        if (this.hugeDomainVars.length > 0) {
            if (this.futvars.size() == 0) {
                return this.checkCurrentInstantiation();
            }
            if (this.futvars.size() == 1) {
                if (this instanceof SumSimple.SumSimpleEQ) {
                    ((SumSimple.SumSimpleEQ)this).deduce();
                    return true;
                }
                if (this instanceof SumWeighted.SumWeightedEQ) {
                    ((SumWeighted.SumWeightedEQ)this).deduce();
                    return true;
                }
            }
            if (this.futvars.size() > 0) {
                return true;
            }
        }
        if (this.pb.framework == Types.TypeFramework.CSP) {
            if (this.futvars.size() == 0) {
                if (this.isGuaranteedGAC()) {
                    assert (this.checkCurrentInstantiation());
                    return true;
                }
                return this.checkCurrentInstantiation();
            }
            if (this.futvars.size() == 1 && x.isFuture() && this.scp.length > 1) {
                return true;
            }
        }
        int nBefore = this.pb.nValuesRemoved;
        boolean consistent = true;
        if (this instanceof FilteringSpecific) {
            if (this.timestamp > x.timestamp && this.completeFilteringAtEachCall()) {
                return true;
            }
            consistent = ((FilteringSpecific)((Object)this)).runPropagator(x);
        } else {
            if (this.timestamp > x.timestamp || this.futvars.size() > this.genericFilteringThreshold) {
                return true;
            }
            consistent = this.genericFiltering(x);
        }
        if (!consistent || this.pb.nValuesRemoved != nBefore) {
            this.handleEffectiveFilterings();
        }
        if (!consistent) {
            return false;
        }
        this.timestamp = this.pb.solver.propagation.incrementTime();
        return true;
    }

    public boolean isIrreflexive() {
        Kit.control(this.scp.length == 2);
        int[] tuple = this.tupleManager.localTuple;
        int p = this.scp[0].dom.size() > this.scp[1].dom.size() ? 1 : 0;
        int q = p == 0 ? 1 : 0;
        Domain dom = this.scp[p].dom;
        Domain domSib = this.scp[q].dom;
        int a = dom.first();
        while (a != -1) {
            int b = domSib.toIdx(dom.toVal(a));
            if (b >= 0) {
                tuple[p] = a;
                tuple[q] = b;
                if (this.checkIndexes(tuple)) {
                    return false;
                }
            }
            a = dom.next(a);
        }
        return true;
    }

    @Override
    public boolean isSubstitutableBy(Variable x, int a, int b) {
        int px = this.positionOf(x);
        this.tupleManager.firstValidTupleWith(px, a);
        return !this.tupleManager.findValidTupleSuchThat(t -> {
            t[px] = a;
            boolean b1 = this.checkIndexes((int[])t);
            t[px] = b;
            boolean b2 = this.checkIndexes((int[])t);
            return b1 && !b2;
        });
    }

    @Override
    public boolean controlArcConsistency() {
        if (this.ignored) {
            return true;
        }
        if (Variable.nValidTuplesBoundedAtMaxValueFor(this.scp) > 1000L) {
            return true;
        }
        for (int i = 0; i < this.scp.length; ++i) {
            int a = this.doms[i].first();
            while (a != -1) {
                if (!this.seekFirstSupportWith(i, a)) {
                    Kit.log.warning(" " + this.scp[i] + "=" + a + " not supported by " + this);
                    this.display(true);
                    return false;
                }
                a = this.doms[i].next(a);
            }
        }
        return true;
    }

    public void save4Baudouin() {
        if (!(this instanceof CtrExtension)) {
            return;
        }
        boolean toIdx = true;
        int[][] tuples = null;
        if (this instanceof CtrExtension && ((CtrExtension)this).extStructure().originalTuples != null && ((CtrExtension)this).extStructure().originalPositive) {
            tuples = ((CtrExtension)this).extStructure().originalTuples;
            if (toIdx) {
                for (int i = 0; i < tuples.length; ++i) {
                    int[] t2 = tuples[i];
                    tuples[i] = IntStream.range(0, this.scp.length).map(j -> this.scp[j].dom.toIdx(t2[j])).toArray();
                }
            }
        } else {
            ArrayList<int[]> list = new ArrayList<int[]>();
            this.tupleManager.firstValidTuple();
            this.tupleManager.overValidTuples(t -> {
                if (this.checkIndexes((int[])t)) {
                    list.add(toIdx ? (int[])t.clone() : (int[])this.toVals((int[])t).clone());
                }
            });
            tuples = Kit.intArray2D(list);
        }
        System.out.println(this.pb.name());
        int first = this.pb.name().lastIndexOf(File.separator) + 1;
        int last = this.pb.name().indexOf(".xml");
        String s = (last != -1 ? this.pb.name().substring(first, last) : this.pb.name().substring(first)) + "-" + (this.num == 0 ? Integer.valueOf(tuples.length) : "tab" + this.num);
        System.out.println("Saving Baudouin Data in filename = " + s);
        try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(s)));){
            out.println(this.scp.length + " variables");
            if (toIdx) {
                Stream.of(this.scp).forEach(x -> out.println(x.id() + " " + 0 + ".." + (x.dom.initSize() - 1)));
            } else {
                Stream.of(this.scp).forEach(x -> out.println(x.id() + " " + (x.dom instanceof DomainInteger.DomainRange ? x.dom.firstValue() + ".." + x.dom.lastValue() : Kit.join((Object)((DomainInteger.DomainValues)x.dom).values, new String[0]))));
            }
            out.println(tuples.length + " tuples");
            for (int[] t3 : tuples) {
                out.println(Kit.join((Object)t3, new String[0]));
            }
        }
        catch (Exception e) {
            Kit.exit("Pb " + e);
        }
    }
}

