/*
 * Decompiled with CFR 0.152.
 */
package constraints;

import constraints.CtrHard;
import constraints.TupleManager;
import constraints.hard.ConflictsStructure;
import constraints.hard.CtrExtension;
import constraints.hard.extension.structures.ExtensionStructure;
import heuristics.variables.dynamic.HeuristicVariablesConflictBased;
import interfaces.FilteringGlobal;
import interfaces.FilteringSpecific;
import interfaces.ObserverConstruction;
import interfaces.TagFilteringCompleteAtEachCall;
import interfaces.TagFilteringPartialAtEachCall;
import interfaces.TagGACGuaranteed;
import interfaces.TagGACUnguaranteed;
import interfaces.TagSymmetric;
import interfaces.TagUnsymmetric;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.modeler.definitions.ICtr;
import problem.Problem;
import propagation.structures.supporters.Supporter;
import search.backtrack.SolverBacktrack;
import utility.Kit;
import utility.exceptions.MissingImplementationException;
import utility.exceptions.UnreachableCodeException;
import utility.operations.Calculator;
import utility.sets.SetDense;
import utility.sets.SetSparse;
import variables.Variable;
import variables.domains.Domain;
import variables.domains.DomainHuge;

public abstract class Constraint
implements ICtr,
ObserverConstruction,
Comparable<Constraint> {
    public static final int MAX_FILTERING_COMPLEXITY = 2;
    private static Map<String, int[]> symmetryMatchings = Collections.synchronizedMap(new HashMap());
    public static final Constraint TAG = new CtrHard(){

        @Override
        public boolean checkValues(int[] t) {
            throw new UnreachableCodeException();
        }
    };
    public final Problem pb;
    public int num = -1;
    private String id;
    public final Variable[] scp;
    private int[] vaps;
    public SetDense futvars;
    public boolean ignored;
    public String key;
    public final TupleManager tupleManager;
    protected Supporter<? extends Constraint> supporter;
    public final boolean indexesMatchValues;
    protected final int[] vals;
    public final Domain[] doms;
    public int cost = 1;
    public long timestamp;
    public int filteringComplexity;
    public final int genericFilteringThreshold;
    public int nEffectiveFilterings;
    public Variable[] hugeDomainVars;
    public Object data;

    @Override
    public int compareTo(Constraint c) {
        boolean b2;
        boolean b1 = this.id == null;
        boolean bl = b2 = c.id == null;
        return b1 && !b2 ? -1 : (!b1 && b2 ? 1 : (!b1 && !b2 ? this.id.compareTo(c.id) : Integer.compare(this.num, c.num)));
    }

    @Override
    public void onConstructionProblemFinished() {
        if (this.pb.rs.cp.settingCtrs.arityLimitForVapArray < this.scp.length && (this.pb.variables.length < this.pb.rs.cp.settingCtrs.arityLimitForVapArrayUB || this.scp.length > this.pb.variables.length / 3)) {
            this.vaps = Kit.repeat(-1, this.pb.variables.length);
            for (int i = 0; i < this.scp.length; ++i) {
                this.vaps[this.scp[i].num] = i;
            }
        } else {
            this.vaps = null;
        }
        this.control(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getSymmetryMatching(String key) {
        Map<String, int[]> map = symmetryMatchings;
        synchronized (map) {
            return symmetryMatchings.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putSymmetryMatching(String key, int[] value) {
        Map<String, int[]> map = symmetryMatchings;
        synchronized (map) {
            symmetryMatchings.put(key, value);
        }
    }

    public static int nPairsOfCtrsWithSimilarScopeIn(Constraint ... ctrs) {
        return IntStream.range(0, ctrs.length).map(i -> (int)IntStream.range(i + 1, ctrs.length).filter(j -> Variable.areSimilarArrays(ctrs[i].scp, ctrs[j].scp)).count()).sum();
    }

    public static final boolean areNumsNormalized(Constraint[] ctrs) {
        return IntStream.range(0, ctrs.length).noneMatch(i -> i != ctrs[i].num);
    }

    public static final boolean isInvolvingAbsentVar(Constraint c, boolean[] presentVars) {
        return Stream.of(c.scp).anyMatch(x -> !presentVars[x.num]);
    }

    public static final boolean isGuaranteedGACOn(Constraint[] ctrs) {
        return Stream.of(ctrs).allMatch(c -> c.isGuaranteedGAC());
    }

    public static final long costOfCoveredConstraintsIn(Constraint[] ctrs) {
        long cost = 0L;
        for (Constraint c : ctrs) {
            if (c.futvars.size() != 0) continue;
            cost = Calculator.add(cost, c.costOfCurrInstantiation());
        }
        return cost;
    }

    public static final int howManyVarsWithin(int[] sizes, int spaceLimitation) {
        int i;
        double limit = Math.pow(2.0, spaceLimitation);
        Arrays.sort(sizes);
        double prod = 1.0;
        for (i = sizes.length - 1; i >= 0 && prod <= limit; prod *= (double)sizes[i], --i) {
        }
        return prod > limit ? sizes.length - i - 1 : Integer.MAX_VALUE;
    }

    public static final int howManyVarsWithin(Variable[] vars, int spaceLimitation) {
        return Constraint.howManyVarsWithin(Stream.of(vars).mapToInt(x -> x.dom.size()).toArray(), spaceLimitation);
    }

    public final String defaultId() {
        return "c" + this.num;
    }

    public final String explicitId() {
        return this.id;
    }

    public final String getId() {
        return this.id != null ? this.id : this.defaultId();
    }

    public final Constraint setId(String id) {
        this.id = id;
        return this;
    }

    public Boolean isSymmetric() {
        if (this instanceof TagSymmetric) {
            return Boolean.TRUE;
        }
        if (this instanceof TagUnsymmetric) {
            return Boolean.FALSE;
        }
        return null;
    }

    public int[] defineSymmetryMatching() {
        Boolean b = this.isSymmetric();
        Kit.control(b != null);
        return b != false ? Kit.repeat(1, this.scp.length) : Kit.range(1, this.scp.length);
    }

    public final int[] getSymmetryMatching() {
        return Constraint.getSymmetryMatching(this.key);
    }

    public void handleEffectiveFilterings() {
        if (this.pb.solver instanceof SolverBacktrack) {
            ((SolverBacktrack)this.pb.solver).proofer.updateProof(this);
        }
        ++this.nEffectiveFilterings;
        ++this.pb.stuff.nEffectiveFilterings;
    }

    public final int computeGenericFilteringThreshold() {
        if (this instanceof FilteringSpecific || this instanceof CtrExtension) {
            return Integer.MAX_VALUE;
        }
        int arityLimit = this.pb.rs.cp.propagating.arityLimitForGACGuaranteed;
        if (this.scp.length <= arityLimit) {
            return Integer.MAX_VALUE;
        }
        int futureLimitation = this.pb.rs.cp.propagating.futureLimitation;
        if (futureLimitation != -1) {
            return futureLimitation < this.scp.length ? Math.max(arityLimit, futureLimitation) : Integer.MAX_VALUE;
        }
        int spaceLimitation = this.pb.rs.cp.propagating.spaceLimitation;
        if (spaceLimitation != -1) {
            return Math.max(arityLimit, Constraint.howManyVarsWithin(this.scp, spaceLimitation));
        }
        return Integer.MAX_VALUE;
    }

    public boolean completeFilteringAtEachCall() {
        if (this instanceof TagFilteringCompleteAtEachCall) {
            return true;
        }
        if (this instanceof TagFilteringPartialAtEachCall) {
            return false;
        }
        throw new MissingImplementationException(this.getClass().getName());
    }

    public boolean isGuaranteedGAC() {
        if (this.hugeDomainVars.length > 0) {
            return false;
        }
        if (this instanceof TagGACGuaranteed) {
            return true;
        }
        if (this instanceof TagGACUnguaranteed) {
            return false;
        }
        if (this instanceof FilteringSpecific) {
            throw new MissingImplementationException(this.getClass().getName());
        }
        return this.genericFilteringThreshold == Integer.MAX_VALUE;
    }

    public final int positionOf(Variable x) {
        if (this.vaps != null) {
            return this.vaps[x.num];
        }
        for (int i = this.scp.length - 1; i >= 0; --i) {
            if (this.scp[i] != x) continue;
            return i;
        }
        return -1;
    }

    public final boolean involves(Variable x) {
        return this.positionOf(x) != -1;
    }

    public final boolean involves(Variable x, Variable y) {
        return this.positionOf(x) != -1 && this.positionOf(y) != -1;
    }

    public final boolean isScopeCoveredBy(Variable[] vars) {
        int cnt = 0;
        for (int i = 0; i < vars.length; ++i) {
            if (!this.involves(vars[i]) || ++cnt != this.scp.length) continue;
            return true;
        }
        return false;
    }

    public Supporter<? extends Constraint> supporter() {
        return this.supporter;
    }

    public abstract void buildSupporter();

    public final double wdeg() {
        return ((HeuristicVariablesConflictBased)((SolverBacktrack)this.pb.solver).heuristicVars).cscores[this.num];
    }

    public ExtensionStructure extStructure() {
        return null;
    }

    public ConflictsStructure conflictsStructure() {
        return null;
    }

    public void cloneStructures(boolean onlyConflictsStructure) {
    }

    public final void reset() {
        Kit.control(this.futvars.free() == 0);
        this.nEffectiveFilterings = 0;
        this.timestamp = 0L;
    }

    protected Constraint() {
        this.pb = null;
        this.scp = new Variable[0];
        this.tupleManager = null;
        this.vals = null;
        this.doms = null;
        this.genericFilteringThreshold = Integer.MAX_VALUE;
        this.indexesMatchValues = false;
        this.hugeDomainVars = new Variable[0];
    }

    public Constraint(Problem pb, Variable[] scp) {
        this.pb = pb;
        scp = (Variable[])Stream.of(scp).distinct().toArray(Variable[]::new);
        this.scp = scp;
        assert (scp.length >= 1 && Stream.of(scp).allMatch(x -> x != null) && Variable.areAllDistinct(scp)) : this + " with a scope badly formed ";
        Stream.of(scp).forEach(x -> x.collectedCtrs.add(this));
        this.hugeDomainVars = (Variable[])Stream.of(scp).filter(x -> x.dom instanceof DomainHuge).toArray(Variable[]::new);
        this.doms = Variable.buildDomainsArrayFor(scp);
        this.tupleManager = new TupleManager((Domain[])this.doms.clone());
        this.vals = new int[scp.length];
        this.genericFilteringThreshold = this.computeGenericFilteringThreshold();
        this.indexesMatchValues = Stream.of(scp).allMatch(x -> x.dom.indexesMatchValues());
        if (this instanceof FilteringSpecific) {
            ++pb.stuff.nSpecificCtrs;
        }
        if (this instanceof FilteringGlobal) {
            ++pb.stuff.nGlobalCtrs;
        }
        if (this instanceof ObserverConstruction) {
            pb.rs.observersConstruction.add(this);
        }
        this.futvars = scp.length <= pb.rs.cp.settingCtrs.arityLimitForVapArray ? new SetDense(scp.length, true) : new SetSparse(scp.length, true);
    }

    public final void doPastVariable(Variable x) {
        if (this.vaps != null && this.futvars instanceof SetSparse) {
            ((SetSparse)this.futvars).remove(this.vaps[x.num]);
        } else {
            for (int i = this.futvars.limit; i >= 0; --i) {
                if (this.scp[this.futvars.dense[i]] != x) continue;
                this.futvars.removeAtPosition(i);
                break;
            }
        }
    }

    public final void undoPastVariable(Variable x) {
        assert (x.isAssigned() && this.scp[this.futvars.dense[this.futvars.size()]] == x);
        ++this.futvars.limit;
    }

    public int[] buildCurrentInstantiationTuple() {
        int[] tuple = this.tupleManager.localTuple;
        for (int i = tuple.length - 1; i >= 0; --i) {
            tuple[i] = this.doms[i].unique();
        }
        return tuple;
    }

    public int[] toVals(int[] idxs) {
        for (int i = this.vals.length - 1; i >= 0; --i) {
            this.vals[i] = this.doms[i].toVal(idxs[i]);
        }
        return this.vals;
    }

    public int[] toIdxs(int[] vals, int[] idxs) {
        for (int i = vals.length - 1; i >= 0; --i) {
            idxs[i] = this.doms[i].toIdx(vals[i]);
        }
        return idxs;
    }

    public final boolean isValid(int[] tuple) {
        for (int i = tuple.length - 1; i >= 0; --i) {
            if (this.doms[i].isPresent(tuple[i])) continue;
            return false;
        }
        return true;
    }

    public long costOfCurrInstantiation() {
        return this.costOfIdxs(this.buildCurrentInstantiationTuple());
    }

    public abstract long costOfIdxs(int[] var1);

    public abstract long minCostOfTuplesWith(int var1, int var2);

    public abstract boolean filterFrom(Variable var1);

    public boolean removeTuple(int ... idxs) {
        throw new UnreachableCodeException();
    }

    public abstract boolean isSubstitutableBy(Variable var1, int var2, int var3);

    public abstract boolean controlArcConsistency();

    public void control(boolean conditionToBeRespected) {
        Kit.control(conditionToBeRespected);
    }

    public StringBuilder signature() {
        return Variable.signatureFor(this.scp);
    }

    public String toString() {
        return this.getId() + "(" + Variable.joinNames(this.scp, ",") + ")";
    }

    public void display(boolean exhaustively) {
        Kit.log.finer("Constraint " + this.toString());
        Kit.log.finer("\tClass = " + this.getClass().getName() + (this instanceof CtrExtension ? ":" + ((CtrExtension)this).extStructure().getClass().getSimpleName() : ""));
        Kit.log.finer("\tKey = " + this.key);
        int[] t = Constraint.getSymmetryMatching(this.key);
        Kit.log.finer("\tSymmetryMatching = " + (t == null ? " undefined " : Kit.join((Object)t, new String[0])));
        Kit.log.finer("\tCost = " + this.cost);
    }

    protected String compact(Variable[] vars) {
        return this.pb.varEntities.compact(vars);
    }

    protected String compactOrdered(Variable[] vars) {
        return this.pb.varEntities.compactOrdered(vars);
    }
}

