# snaptrade-python-sdk@10.8.0
Connect brokerage accounts to your app for live positions and trading


## Requirements

Python >=3.7

## Installing

```sh
pip install snaptrade-python-sdk==10.8.0
```

## Getting Started

```python
import os
import uuid
from pprint import pprint
from snaptrade_client import SnapTrade

# 1) Initialize a client with your clientID and consumerKey.
snaptrade = SnapTrade(
    consumer_key=os.environ["SNAPTRADE_CONSUMER_KEY"],
    client_id=os.environ["SNAPTRADE_CLIENT_ID"],
)

# 2) Check that the client is able to make a request to the API server.
api_response = snaptrade.api_status.check()
pprint(api_response.body)

# 3) Create a new user on SnapTrade
user_id = str(uuid.uuid4())
register_response = snaptrade.authentication.register_snap_trade_user(
    body={"userId": user_id}
)
pprint(register_response.body)

# Note: A user secret is only generated once. It's required to access
# resources for certain endpoints.
user_secret = register_response.body["userSecret"]

# 4) Get a redirect URI. Users will need this to connect
# their brokerage to the SnapTrade server.
redirect_uri = snaptrade.authentication.login_snap_trade_user(
    query_params={"userId": user_id, "userSecret": user_secret}
)
print(redirect_uri.body)


snaptrade.portfolio_management.create(
    query_params={"userId": user_id, "userSecret": user_secret},
    body={"id": str(uuid.uuid4()), "name": "MyPortfolio"},
)
res = snaptrade.portfolio_management.list(
    query_params={"userId": user_id, "userSecret": user_secret}
)
pprint(res.body)

snaptrade.api_disclaimer.accept(
    query_params={"userId": user_id, "userSecret": user_secret}, body={"accepted": True}
)

# 5) Obtaining account holdings data
holdings = snaptrade.account_information.get_all_user_holdings(
    query_params={"userId": user_id, "userSecret": user_secret}
)
pprint(holdings.body)

# 6) Deleting a user
deleted_response = snaptrade.authentication.delete_snap_trade_user(
    query_params={"userId": user_id}
)
pprint(deleted_response.body)
```

## Documentation for API Endpoints

All URIs are relative to *https://api.snaptrade.com/api/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*APIDisclaimerApi* | [**accept**](docs/apis/tags/APIDisclaimerApi.md#accept) | **post** /snapTrade/acceptDisclaimer | Accept or Reject SnapTrade disclaimer agreement
*APIStatusApi* | [**check**](docs/apis/tags/APIStatusApi.md#check) | **get** / | Get API Status
*AccountInformationApi* | [**get_all_user_holdings**](docs/apis/tags/AccountInformationApi.md#get_all_user_holdings) | **get** /holdings | List all accounts for the user, plus balances and positions for each account.
*AccountInformationApi* | [**get_user_account_balance**](docs/apis/tags/AccountInformationApi.md#get_user_account_balance) | **get** /accounts/{accountId}/balances | Get all cash balances of an investment account
*AccountInformationApi* | [**get_user_account_details**](docs/apis/tags/AccountInformationApi.md#get_user_account_details) | **get** /accounts/{accountId} | Return details of a specific investment account
*AccountInformationApi* | [**get_user_account_orders**](docs/apis/tags/AccountInformationApi.md#get_user_account_orders) | **get** /accounts/{accountId}/orders | Get all history of orders placed in account
*AccountInformationApi* | [**get_user_account_positions**](docs/apis/tags/AccountInformationApi.md#get_user_account_positions) | **get** /accounts/{accountId}/positions | Get all positions of an investment account
*AccountInformationApi* | [**get_user_holdings**](docs/apis/tags/AccountInformationApi.md#get_user_holdings) | **get** /accounts/{accountId}/holdings | List balances, positions and orders for the specified account.
*AccountInformationApi* | [**list_user_accounts**](docs/apis/tags/AccountInformationApi.md#list_user_accounts) | **get** /accounts | List all investment accounts for the user
*AccountInformationApi* | [**update_user_account**](docs/apis/tags/AccountInformationApi.md#update_user_account) | **put** /accounts/{accountId} | Update details of an investment account
*AuthenticationApi* | [**delete_snap_trade_user**](docs/apis/tags/AuthenticationApi.md#delete_snap_trade_user) | **delete** /snapTrade/deleteUser | Delete user from SnapTrade, disabling all brokerage authorizations and permanently deleting all data associated with the user
*AuthenticationApi* | [**get_user_jwt**](docs/apis/tags/AuthenticationApi.md#get_user_jwt) | **get** /snapTrade/encryptedJWT | Obtains an encrypted JWT tokens that should be decrypted on a user&#x27;s local device
*AuthenticationApi* | [**list_snap_trade_users**](docs/apis/tags/AuthenticationApi.md#list_snap_trade_users) | **get** /snapTrade/listUsers | Get a list of all SnapTrade users you&#x27;ve registered on our platform
*AuthenticationApi* | [**login_snap_trade_user**](docs/apis/tags/AuthenticationApi.md#login_snap_trade_user) | **post** /snapTrade/login | Generate a redirect URI to securely login a user to the SnapTrade Connection Portal
*AuthenticationApi* | [**register_snap_trade_user**](docs/apis/tags/AuthenticationApi.md#register_snap_trade_user) | **post** /snapTrade/registerUser | Register user with SnapTrade in order to create secure brokerage authorizations
*ConnectionsApi* | [**detail_brokerage_authorization**](docs/apis/tags/ConnectionsApi.md#detail_brokerage_authorization) | **get** /authorizations/{authorizationId} | Get detail of a specific brokerage authorizations for the user
*ConnectionsApi* | [**list_brokerage_authorizations**](docs/apis/tags/ConnectionsApi.md#list_brokerage_authorizations) | **get** /authorizations | List all brokerage authorizations for the user
*ConnectionsApi* | [**remove_brokerage_authorization**](docs/apis/tags/ConnectionsApi.md#remove_brokerage_authorization) | **delete** /authorizations/{authorizationId} | Remove a brokerage authorization.
*ConnectionsApi* | [**session_events**](docs/apis/tags/ConnectionsApi.md#session_events) | **get** /sessionEvents | List all session events for the partner
*ErrorLogsApi* | [**list_user_errors**](docs/apis/tags/ErrorLogsApi.md#list_user_errors) | **get** /snapTrade/listUserErrors | Retrieve error logs on behalf of your SnapTrade users
*OptionsApi* | [**get_option_strategy**](docs/apis/tags/OptionsApi.md#get_option_strategy) | **post** /accounts/{accountId}/optionStrategy | Creates an option strategy object that will be used to place an option strategy order
*OptionsApi* | [**get_options_chain**](docs/apis/tags/OptionsApi.md#get_options_chain) | **get** /accounts/{accountId}/optionsChain | Get the options chain
*OptionsApi* | [**get_options_strategy_quote**](docs/apis/tags/OptionsApi.md#get_options_strategy_quote) | **get** /accounts/{accountId}/optionStrategy/{optionStrategyId} | Get latest market data of option strategy
*OptionsApi* | [**list_option_holdings**](docs/apis/tags/OptionsApi.md#list_option_holdings) | **get** /accounts/{accountId}/options | Get the options holdings in the account
*OptionsApi* | [**place_option_strategy**](docs/apis/tags/OptionsApi.md#place_option_strategy) | **post** /accounts/{accountId}/optionStrategy/{optionStrategyId}/execute | Place an option strategy order on the brokerage
*PortfolioManagementApi* | [**add_portfolio_excluded_asset**](docs/apis/tags/PortfolioManagementApi.md#add_portfolio_excluded_asset) | **post** /portfolioGroups/{portfolioGroupId}/excludedassets | Adds an asset to exclude to a portfolio group
*PortfolioManagementApi* | [**create**](docs/apis/tags/PortfolioManagementApi.md#create) | **post** /portfolioGroups | Create new portfolio group
*PortfolioManagementApi* | [**create_asset_class**](docs/apis/tags/PortfolioManagementApi.md#create_asset_class) | **post** /modelAssetClass | Create a new model asset class
*PortfolioManagementApi* | [**create_model_portfolio**](docs/apis/tags/PortfolioManagementApi.md#create_model_portfolio) | **post** /modelPortfolio | Creates a new model portfolio
*PortfolioManagementApi* | [**delete_asset_class**](docs/apis/tags/PortfolioManagementApi.md#delete_asset_class) | **delete** /modelAssetClass/{modelAssetClassId} | Deletes a model asset class
*PortfolioManagementApi* | [**delete_excluded_asset**](docs/apis/tags/PortfolioManagementApi.md#delete_excluded_asset) | **delete** /portfolioGroups/{portfolioGroupId}/excludedassets/{symbolId} | Unexclude an asset from a portfolio group
*PortfolioManagementApi* | [**delete_model_portfolio_by_id**](docs/apis/tags/PortfolioManagementApi.md#delete_model_portfolio_by_id) | **delete** /modelPortfolio/{modelPortfolioId} | Deletes a model portfolio
*PortfolioManagementApi* | [**delete_portfoli**](docs/apis/tags/PortfolioManagementApi.md#delete_portfoli) | **delete** /portfolioGroups/{portfolioGroupId} | Remove a target portfolio.
*PortfolioManagementApi* | [**delete_portfolio_target_by_id**](docs/apis/tags/PortfolioManagementApi.md#delete_portfolio_target_by_id) | **delete** /portfolioGroups/{portfolioGroupId}/targets/{targetAssetId} | Remove a TargetAsset.
*PortfolioManagementApi* | [**detail_asset_class**](docs/apis/tags/PortfolioManagementApi.md#detail_asset_class) | **get** /modelAssetClass/{modelAssetClassId} | Get details of a model asset class
*PortfolioManagementApi* | [**get_calculated_trade_by_id**](docs/apis/tags/PortfolioManagementApi.md#get_calculated_trade_by_id) | **get** /portfolioGroups/{portfolioGroupId}/calculatedtrades/{calculatedTradeId}/{TradeId} | Return an individual trade
*PortfolioManagementApi* | [**get_model_details_by_id**](docs/apis/tags/PortfolioManagementApi.md#get_model_details_by_id) | **get** /modelPortfolio/{modelPortfolioId} | Get details of a model portfolio
*PortfolioManagementApi* | [**get_portfolio_balances**](docs/apis/tags/PortfolioManagementApi.md#get_portfolio_balances) | **get** /portfolioGroups/{portfolioGroupId}/balances | Get sum of cash balances in portfolio group
*PortfolioManagementApi* | [**get_portfolio_details_by_id**](docs/apis/tags/PortfolioManagementApi.md#get_portfolio_details_by_id) | **get** /portfolioGroups/{portfolioGroupId} | Get details of a target portfolio
*PortfolioManagementApi* | [**get_portfolio_info**](docs/apis/tags/PortfolioManagementApi.md#get_portfolio_info) | **get** /portfolioGroups/{portfolioGroupId}/info | Return a whole bunch of relevant information relating to a portfolio group.
*PortfolioManagementApi* | [**get_portfolio_positions**](docs/apis/tags/PortfolioManagementApi.md#get_portfolio_positions) | **get** /portfolioGroups/{portfolioGroupId}/positions | Get total of each postions owned in portfolio group
*PortfolioManagementApi* | [**get_portfolio_settings**](docs/apis/tags/PortfolioManagementApi.md#get_portfolio_settings) | **get** /portfolioGroups/{portfolioGroupId}/settings | Get portfolio group settings
*PortfolioManagementApi* | [**get_portfolio_target_by_id**](docs/apis/tags/PortfolioManagementApi.md#get_portfolio_target_by_id) | **get** /portfolioGroups/{portfolioGroupId}/targets/{targetAssetId} | Get a specific target from a portfolio group
*PortfolioManagementApi* | [**get_portfolio_targets**](docs/apis/tags/PortfolioManagementApi.md#get_portfolio_targets) | **get** /portfolioGroups/{portfolioGroupId}/targets | Get all target assets under the specified PortfolioGroup.
*PortfolioManagementApi* | [**get_portoflio_excluded_assets**](docs/apis/tags/PortfolioManagementApi.md#get_portoflio_excluded_assets) | **get** /portfolioGroups/{portfolioGroupId}/excludedassets | Get an array of excluded assets associated with a portfolio group\\
*PortfolioManagementApi* | [**import_model_portfolio**](docs/apis/tags/PortfolioManagementApi.md#import_model_portfolio) | **post** /portfolioGroups/{portfolioGroupId}/import | Import target allocation based on portfolio group
*PortfolioManagementApi* | [**list**](docs/apis/tags/PortfolioManagementApi.md#list) | **get** /portfolioGroups | List all portfolio groups
*PortfolioManagementApi* | [**list_asset_classes**](docs/apis/tags/PortfolioManagementApi.md#list_asset_classes) | **get** /modelAssetClass | List of model asset class
*PortfolioManagementApi* | [**list_calculated_trades**](docs/apis/tags/PortfolioManagementApi.md#list_calculated_trades) | **get** /portfolioGroups/{portfolioGroupId}/calculatedtrades | List of trades to make to rebalance portfolio group
*PortfolioManagementApi* | [**list_model_portfolio**](docs/apis/tags/PortfolioManagementApi.md#list_model_portfolio) | **get** /modelPortfolio | List of model portfolio
*PortfolioManagementApi* | [**list_portfolio_accounts**](docs/apis/tags/PortfolioManagementApi.md#list_portfolio_accounts) | **get** /portfolioGroups/{portfolioGroupId}/accounts | Get all accounts associated with a portfolio group
*PortfolioManagementApi* | [**modify_model_portfolio_by_id**](docs/apis/tags/PortfolioManagementApi.md#modify_model_portfolio_by_id) | **post** /modelPortfolio/{modelPortfolioId} | Updates model portfolio object
*PortfolioManagementApi* | [**save_portfolio**](docs/apis/tags/PortfolioManagementApi.md#save_portfolio) | **patch** /portfolioGroups/{portfolioGroupId} | Update an existing target portfolio.
*PortfolioManagementApi* | [**search_portfolio_symbols**](docs/apis/tags/PortfolioManagementApi.md#search_portfolio_symbols) | **post** /portfolioGroups/{portfolioGroupId}/symbols | Search for symbols limited to brokerages under the specified portfolio group
*PortfolioManagementApi* | [**set_portfolio_targets**](docs/apis/tags/PortfolioManagementApi.md#set_portfolio_targets) | **post** /portfolioGroups/{portfolioGroupId}/targets | Set a new list of target assets under the specified PortfolioGroup. All existing target assets under this portfolio group will be replaced with the new list.
*PortfolioManagementApi* | [**update_asset_class**](docs/apis/tags/PortfolioManagementApi.md#update_asset_class) | **post** /modelAssetClass/{modelAssetClassId} | Updates model asset class objects
*PortfolioManagementApi* | [**update_portfolio_settings**](docs/apis/tags/PortfolioManagementApi.md#update_portfolio_settings) | **patch** /portfolioGroups/{portfolioGroupId}/settings | Updates portfolio group settings
*PortfolioManagementApi* | [**update_portfolio_target_by_id**](docs/apis/tags/PortfolioManagementApi.md#update_portfolio_target_by_id) | **patch** /portfolioGroups/{portfolioGroupId}/targets/{targetAssetId} | Update a TargetAsset under the specified PortfolioGroup.
*ReferenceDataApi* | [**get_currency_exchange_rate_pair**](docs/apis/tags/ReferenceDataApi.md#get_currency_exchange_rate_pair) | **get** /currencies/rates/{currencyPair} | Return the exchange rate of a currency pair
*ReferenceDataApi* | [**get_partner_info**](docs/apis/tags/ReferenceDataApi.md#get_partner_info) | **get** /snapTrade/partners | Get metadata related to Snaptrade partner
*ReferenceDataApi* | [**get_security_types**](docs/apis/tags/ReferenceDataApi.md#get_security_types) | **get** /securityTypes | List of all security types.
*ReferenceDataApi* | [**get_stock_exchanges**](docs/apis/tags/ReferenceDataApi.md#get_stock_exchanges) | **get** /exchanges | Return list of stock exchanges on Passiv and their suffixes
*ReferenceDataApi* | [**get_symbols**](docs/apis/tags/ReferenceDataApi.md#get_symbols) | **post** /symbols | Search for symbols
*ReferenceDataApi* | [**get_symbols_by_ticker**](docs/apis/tags/ReferenceDataApi.md#get_symbols_by_ticker) | **get** /symbols/{ticker} | Get details of a symbol by the ticker
*ReferenceDataApi* | [**list_all_brokerage_authorization_type**](docs/apis/tags/ReferenceDataApi.md#list_all_brokerage_authorization_type) | **get** /brokerageAuthorizationTypes | List of all brokerage authorization types
*ReferenceDataApi* | [**list_all_brokerages**](docs/apis/tags/ReferenceDataApi.md#list_all_brokerages) | **get** /brokerages | List of all brokerages.
*ReferenceDataApi* | [**list_all_currencies**](docs/apis/tags/ReferenceDataApi.md#list_all_currencies) | **get** /currencies | List of all supported currencies
*ReferenceDataApi* | [**list_all_currencies_rates**](docs/apis/tags/ReferenceDataApi.md#list_all_currencies_rates) | **get** /currencies/rates | Return the exchange rates of all supported currencies
*ReferenceDataApi* | [**symbol_search_user_account**](docs/apis/tags/ReferenceDataApi.md#symbol_search_user_account) | **post** /accounts/{accountId}/symbols | Search for symbols that are supported by a brokerage account using a substring
*TradingApi* | [**cancel_user_account_order**](docs/apis/tags/TradingApi.md#cancel_user_account_order) | **post** /accounts/{accountId}/orders/cancel | Cancel open order in account
*TradingApi* | [**get_calculated_trade_impact_by_id**](docs/apis/tags/TradingApi.md#get_calculated_trade_impact_by_id) | **get** /portfolioGroups/{portfolioGroupId}/calculatedtrades/{calculatedTradeId}/modify/{tradeId} | Return details of a specific trade before it&#x27;s placed
*TradingApi* | [**get_calculated_trades_impact**](docs/apis/tags/TradingApi.md#get_calculated_trades_impact) | **get** /portfolioGroups/{portfolioGroupId}/calculatedtrades/{calculatedTradeId}/impact | Return the impact of placing a series of trades on the portfolio
*TradingApi* | [**get_order_impact**](docs/apis/tags/TradingApi.md#get_order_impact) | **post** /trade/impact | Check impact of trades on account.
*TradingApi* | [**get_user_account_quotes**](docs/apis/tags/TradingApi.md#get_user_account_quotes) | **get** /accounts/{accountId}/quotes | Get symbol quotes
*TradingApi* | [**modify_calculated_trade_by_id**](docs/apis/tags/TradingApi.md#modify_calculated_trade_by_id) | **patch** /portfolioGroups/{portfolioGroupId}/calculatedtrades/{calculatedTradeId}/modify/{tradeId} | Modify units of a trade before it is placed
*TradingApi* | [**place_calculated_trades**](docs/apis/tags/TradingApi.md#place_calculated_trades) | **post** /portfolioGroups/{portfolioGroupId}/calculatedtrades/{calculatedTradeId}/placeOrders | Place orders for the CalculatedTrades in series
*TradingApi* | [**place_force_order**](docs/apis/tags/TradingApi.md#place_force_order) | **post** /trade/place | Place a trade with NO validation.
*TradingApi* | [**place_oco_order**](docs/apis/tags/TradingApi.md#place_oco_order) | **post** /trade/oco | Place a OCO (One Cancels Other) order
*TradingApi* | [**place_order**](docs/apis/tags/TradingApi.md#place_order) | **post** /trade/{tradeId} | Place order
*TransactionsAndReportingApi* | [**get_activities**](docs/apis/tags/TransactionsAndReportingApi.md#get_activities) | **get** /activities | Get transaction history for a user
*TransactionsAndReportingApi* | [**get_reporting_custom_range**](docs/apis/tags/TransactionsAndReportingApi.md#get_reporting_custom_range) | **get** /performance/custom | Get performance information for a specific timeframe

## Documentation For Models

 - [Account](docs/models/Account.md)
 - [AccountHoldings](docs/models/AccountHoldings.md)
 - [AccountHoldingsAccount](docs/models/AccountHoldingsAccount.md)
 - [AccountIDs](docs/models/AccountIDs.md)
 - [AccountOrderRecord](docs/models/AccountOrderRecord.md)
 - [AccountOrderRecordStatus](docs/models/AccountOrderRecordStatus.md)
 - [AccountSimple](docs/models/AccountSimple.md)
 - [AccountSyncStatus](docs/models/AccountSyncStatus.md)
 - [Action](docs/models/Action.md)
 - [Balance](docs/models/Balance.md)
 - [Brokerage](docs/models/Brokerage.md)
 - [BrokerageAuthIDs](docs/models/BrokerageAuthIDs.md)
 - [BrokerageAuthorization](docs/models/BrokerageAuthorization.md)
 - [BrokerageAuthorizationType](docs/models/BrokerageAuthorizationType.md)
 - [BrokerageAuthorizationTypeReadOnly](docs/models/BrokerageAuthorizationTypeReadOnly.md)
 - [BrokerageSymbol](docs/models/BrokerageSymbol.md)
 - [BrokerageType](docs/models/BrokerageType.md)
 - [CalculatedTrade](docs/models/CalculatedTrade.md)
 - [Cash](docs/models/Cash.md)
 - [CashRestriction](docs/models/CashRestriction.md)
 - [ClientID](docs/models/ClientID.md)
 - [ConsumerKey](docs/models/ConsumerKey.md)
 - [Currency](docs/models/Currency.md)
 - [DeleteUserResponse](docs/models/DeleteUserResponse.md)
 - [DividendAtDate](docs/models/DividendAtDate.md)
 - [Email](docs/models/Email.md)
 - [EncryptedResponse](docs/models/EncryptedResponse.md)
 - [Exchange](docs/models/Exchange.md)
 - [ExchangeRatePairs](docs/models/ExchangeRatePairs.md)
 - [ExcludedAsset](docs/models/ExcludedAsset.md)
 - [Id](docs/models/Id.md)
 - [JWT](docs/models/JWT.md)
 - [LoginRedirectURI](docs/models/LoginRedirectURI.md)
 - [ManualTrade](docs/models/ManualTrade.md)
 - [ManualTradeAndImpact](docs/models/ManualTradeAndImpact.md)
 - [ManualTradeBalance](docs/models/ManualTradeBalance.md)
 - [ManualTradeForm](docs/models/ManualTradeForm.md)
 - [ManualTradeSymbol](docs/models/ManualTradeSymbol.md)
 - [Model400FailedRequestResponse](docs/models/Model400FailedRequestResponse.md)
 - [Model401FailedRequestResponse](docs/models/Model401FailedRequestResponse.md)
 - [Model403FailedRequestResponse](docs/models/Model403FailedRequestResponse.md)
 - [Model404FailedRequestResponse](docs/models/Model404FailedRequestResponse.md)
 - [ModelAssetClass](docs/models/ModelAssetClass.md)
 - [ModelAssetClassDetails](docs/models/ModelAssetClassDetails.md)
 - [ModelAssetClassTarget](docs/models/ModelAssetClassTarget.md)
 - [ModelPortfolio](docs/models/ModelPortfolio.md)
 - [ModelPortfolioAssetClass](docs/models/ModelPortfolioAssetClass.md)
 - [ModelPortfolioDetails](docs/models/ModelPortfolioDetails.md)
 - [ModelPortfolioSecurity](docs/models/ModelPortfolioSecurity.md)
 - [MonthlyDividends](docs/models/MonthlyDividends.md)
 - [NetContributions](docs/models/NetContributions.md)
 - [NetDividend](docs/models/NetDividend.md)
 - [OptionChain](docs/models/OptionChain.md)
 - [OptionLeg](docs/models/OptionLeg.md)
 - [OptionStrategy](docs/models/OptionStrategy.md)
 - [OptionsHoldings](docs/models/OptionsHoldings.md)
 - [OptionsPosition](docs/models/OptionsPosition.md)
 - [OptionsSymbol](docs/models/OptionsSymbol.md)
 - [OrderType](docs/models/OrderType.md)
 - [PartnerData](docs/models/PartnerData.md)
 - [PastValue](docs/models/PastValue.md)
 - [Percent](docs/models/Percent.md)
 - [PerformanceCustom](docs/models/PerformanceCustom.md)
 - [PortfolioGroup](docs/models/PortfolioGroup.md)
 - [PortfolioGroupInfo](docs/models/PortfolioGroupInfo.md)
 - [PortfolioGroupPosition](docs/models/PortfolioGroupPosition.md)
 - [PortfolioGroupSettings](docs/models/PortfolioGroupSettings.md)
 - [Position](docs/models/Position.md)
 - [PositionSymbol](docs/models/PositionSymbol.md)
 - [Price](docs/models/Price.md)
 - [RedirectTokenandPin](docs/models/RedirectTokenandPin.md)
 - [ReportingDate](docs/models/ReportingDate.md)
 - [ReportingFrequency](docs/models/ReportingFrequency.md)
 - [RsaPublicKey](docs/models/RsaPublicKey.md)
 - [SecurityType](docs/models/SecurityType.md)
 - [SessionEvent](docs/models/SessionEvent.md)
 - [Signature](docs/models/Signature.md)
 - [SignedContent](docs/models/SignedContent.md)
 - [SnapTradeAPIDisclaimerAcceptStatus](docs/models/SnapTradeAPIDisclaimerAcceptStatus.md)
 - [SnapTradeHoldingsAccount](docs/models/SnapTradeHoldingsAccount.md)
 - [SnapTradeHoldingsAccountAccountId](docs/models/SnapTradeHoldingsAccountAccountId.md)
 - [SnapTradeHoldingsTotalValue](docs/models/SnapTradeHoldingsTotalValue.md)
 - [SnapTradeLoginUserRequestBody](docs/models/SnapTradeLoginUserRequestBody.md)
 - [SnapTradeRegisterUserRequestBody](docs/models/SnapTradeRegisterUserRequestBody.md)
 - [SnapTradeUserID](docs/models/SnapTradeUserID.md)
 - [SnapTradeUserSecret](docs/models/SnapTradeUserSecret.md)
 - [Status](docs/models/Status.md)
 - [StopPrice](docs/models/StopPrice.md)
 - [StrategyImpact](docs/models/StrategyImpact.md)
 - [StrategyOrderPlace](docs/models/StrategyOrderPlace.md)
 - [StrategyOrderQuotes](docs/models/StrategyOrderQuotes.md)
 - [StrategyOrderRecord](docs/models/StrategyOrderRecord.md)
 - [StrategyQuotes](docs/models/StrategyQuotes.md)
 - [SubPeriodReturnRate](docs/models/SubPeriodReturnRate.md)
 - [Symbol](docs/models/Symbol.md)
 - [SymbolQuery](docs/models/SymbolQuery.md)
 - [SymbolsQuotes](docs/models/SymbolsQuotes.md)
 - [SyncStatusDate](docs/models/SyncStatusDate.md)
 - [TargetAsset](docs/models/TargetAsset.md)
 - [TargetAssetList](docs/models/TargetAssetList.md)
 - [Time](docs/models/Time.md)
 - [TimeInForce](docs/models/TimeInForce.md)
 - [Timestamp](docs/models/Timestamp.md)
 - [Trade](docs/models/Trade.md)
 - [TradeExecutionStatus](docs/models/TradeExecutionStatus.md)
 - [TradeImpact](docs/models/TradeImpact.md)
 - [TransactionsStatus](docs/models/TransactionsStatus.md)
 - [USExchange](docs/models/USExchange.md)
 - [UnderlyingSymbol](docs/models/UnderlyingSymbol.md)
 - [Units](docs/models/Units.md)
 - [UniversalActivity](docs/models/UniversalActivity.md)
 - [UniversalSymbol](docs/models/UniversalSymbol.md)
 - [UniversalSymbolTicker](docs/models/UniversalSymbolTicker.md)
 - [UserErrorLog](docs/models/UserErrorLog.md)
 - [UserID](docs/models/UserID.md)
 - [UserIDandSecret](docs/models/UserIDandSecret.md)
 - [UserList](docs/models/UserList.md)
 - [UserSecret](docs/models/UserSecret.md)
 - [UserSettings](docs/models/UserSettings.md)


## Author
This Python package is automatically generated by [Konfig](https://konfigthis.com)
