import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/helpers-internal';
/**
 * Properties for defining a `CfnComponentType`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html
 */
export interface CfnComponentTypeProps {
    /**
     * `AWS::IoTTwinMaker::ComponentType.ComponentTypeId`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-componenttypeid
     */
    readonly componentTypeId: string;
    /**
     * `AWS::IoTTwinMaker::ComponentType.WorkspaceId`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-workspaceid
     */
    readonly workspaceId: string;
    /**
     * `AWS::IoTTwinMaker::ComponentType.Description`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-description
     */
    readonly description?: string;
    /**
     * `AWS::IoTTwinMaker::ComponentType.ExtendsFrom`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-extendsfrom
     */
    readonly extendsFrom?: string[];
    /**
     * `AWS::IoTTwinMaker::ComponentType.Functions`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-functions
     */
    readonly functions?: {
        [key: string]: (CfnComponentType.FunctionProperty | cdk.IResolvable);
    } | cdk.IResolvable;
    /**
     * `AWS::IoTTwinMaker::ComponentType.IsSingleton`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-issingleton
     */
    readonly isSingleton?: boolean | cdk.IResolvable;
    /**
     * `AWS::IoTTwinMaker::ComponentType.PropertyDefinitions`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-propertydefinitions
     */
    readonly propertyDefinitions?: {
        [key: string]: (CfnComponentType.PropertyDefinitionProperty | cdk.IResolvable);
    } | cdk.IResolvable;
    /**
     * `AWS::IoTTwinMaker::ComponentType.Tags`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-tags
     */
    readonly tags?: {
        [key: string]: (string);
    };
}
/**
 * A CloudFormation `AWS::IoTTwinMaker::ComponentType`
 *
 *
 *
 * @cloudformationResource AWS::IoTTwinMaker::ComponentType
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html
 */
export declare class CfnComponentType extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoTTwinMaker::ComponentType";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnComponentType;
    /**
     *
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     *
     * @cloudformationAttribute CreationDateTime
     */
    readonly attrCreationDateTime: string;
    /**
     *
     * @cloudformationAttribute IsAbstract
     */
    readonly attrIsAbstract: cdk.IResolvable;
    /**
     *
     * @cloudformationAttribute IsSchemaInitialized
     */
    readonly attrIsSchemaInitialized: cdk.IResolvable;
    /**
     *
     * @cloudformationAttribute UpdateDateTime
     */
    readonly attrUpdateDateTime: string;
    /**
     * `AWS::IoTTwinMaker::ComponentType.ComponentTypeId`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-componenttypeid
     */
    componentTypeId: string;
    /**
     * `AWS::IoTTwinMaker::ComponentType.WorkspaceId`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-workspaceid
     */
    workspaceId: string;
    /**
     * `AWS::IoTTwinMaker::ComponentType.Description`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-description
     */
    description: string | undefined;
    /**
     * `AWS::IoTTwinMaker::ComponentType.ExtendsFrom`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-extendsfrom
     */
    extendsFrom: string[] | undefined;
    /**
     * `AWS::IoTTwinMaker::ComponentType.Functions`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-functions
     */
    functions: {
        [key: string]: (CfnComponentType.FunctionProperty | cdk.IResolvable);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::IoTTwinMaker::ComponentType.IsSingleton`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-issingleton
     */
    isSingleton: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::IoTTwinMaker::ComponentType.PropertyDefinitions`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-propertydefinitions
     */
    propertyDefinitions: {
        [key: string]: (CfnComponentType.PropertyDefinitionProperty | cdk.IResolvable);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::IoTTwinMaker::ComponentType.Tags`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::IoTTwinMaker::ComponentType`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnComponentTypeProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnComponentType {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-dataconnector.html
     */
    interface DataConnectorProperty {
        /**
         * `CfnComponentType.DataConnectorProperty.IsNative`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-dataconnector.html#cfn-iottwinmaker-componenttype-dataconnector-isnative
         */
        readonly isNative?: boolean | cdk.IResolvable;
        /**
         * `CfnComponentType.DataConnectorProperty.Lambda`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-dataconnector.html#cfn-iottwinmaker-componenttype-dataconnector-lambda
         */
        readonly lambda?: CfnComponentType.LambdaFunctionProperty | cdk.IResolvable;
    }
}
export declare namespace CfnComponentType {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datatype.html
     */
    interface DataTypeProperty {
        /**
         * `CfnComponentType.DataTypeProperty.AllowedValues`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datatype.html#cfn-iottwinmaker-componenttype-datatype-allowedvalues
         */
        readonly allowedValues?: Array<CfnComponentType.DataValueProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnComponentType.DataTypeProperty.NestedType`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datatype.html#cfn-iottwinmaker-componenttype-datatype-nestedtype
         */
        readonly nestedType?: CfnComponentType.DataTypeProperty | cdk.IResolvable;
        /**
         * `CfnComponentType.DataTypeProperty.Relationship`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datatype.html#cfn-iottwinmaker-componenttype-datatype-relationship
         */
        readonly relationship?: CfnComponentType.RelationshipProperty | cdk.IResolvable;
        /**
         * `CfnComponentType.DataTypeProperty.Type`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datatype.html#cfn-iottwinmaker-componenttype-datatype-type
         */
        readonly type: string;
        /**
         * `CfnComponentType.DataTypeProperty.UnitOfMeasure`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datatype.html#cfn-iottwinmaker-componenttype-datatype-unitofmeasure
         */
        readonly unitOfMeasure?: string;
    }
}
export declare namespace CfnComponentType {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datavalue.html
     */
    interface DataValueProperty {
        /**
         * `CfnComponentType.DataValueProperty.BooleanValue`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datavalue.html#cfn-iottwinmaker-componenttype-datavalue-booleanvalue
         */
        readonly booleanValue?: boolean | cdk.IResolvable;
        /**
         * `CfnComponentType.DataValueProperty.DoubleValue`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datavalue.html#cfn-iottwinmaker-componenttype-datavalue-doublevalue
         */
        readonly doubleValue?: number;
        /**
         * `CfnComponentType.DataValueProperty.Expression`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datavalue.html#cfn-iottwinmaker-componenttype-datavalue-expression
         */
        readonly expression?: string;
        /**
         * `CfnComponentType.DataValueProperty.IntegerValue`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datavalue.html#cfn-iottwinmaker-componenttype-datavalue-integervalue
         */
        readonly integerValue?: number;
        /**
         * `CfnComponentType.DataValueProperty.ListValue`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datavalue.html#cfn-iottwinmaker-componenttype-datavalue-listvalue
         */
        readonly listValue?: Array<CfnComponentType.DataValueProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnComponentType.DataValueProperty.LongValue`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datavalue.html#cfn-iottwinmaker-componenttype-datavalue-longvalue
         */
        readonly longValue?: number;
        /**
         * `CfnComponentType.DataValueProperty.MapValue`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datavalue.html#cfn-iottwinmaker-componenttype-datavalue-mapvalue
         */
        readonly mapValue?: {
            [key: string]: (CfnComponentType.DataValueProperty | cdk.IResolvable);
        } | cdk.IResolvable;
        /**
         * `CfnComponentType.DataValueProperty.RelationshipValue`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datavalue.html#cfn-iottwinmaker-componenttype-datavalue-relationshipvalue
         */
        readonly relationshipValue?: any | cdk.IResolvable;
        /**
         * `CfnComponentType.DataValueProperty.StringValue`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datavalue.html#cfn-iottwinmaker-componenttype-datavalue-stringvalue
         */
        readonly stringValue?: string;
    }
}
export declare namespace CfnComponentType {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-function.html
     */
    interface FunctionProperty {
        /**
         * `CfnComponentType.FunctionProperty.ImplementedBy`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-function.html#cfn-iottwinmaker-componenttype-function-implementedby
         */
        readonly implementedBy?: CfnComponentType.DataConnectorProperty | cdk.IResolvable;
        /**
         * `CfnComponentType.FunctionProperty.RequiredProperties`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-function.html#cfn-iottwinmaker-componenttype-function-requiredproperties
         */
        readonly requiredProperties?: string[];
        /**
         * `CfnComponentType.FunctionProperty.Scope`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-function.html#cfn-iottwinmaker-componenttype-function-scope
         */
        readonly scope?: string;
    }
}
export declare namespace CfnComponentType {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-lambdafunction.html
     */
    interface LambdaFunctionProperty {
        /**
         * `CfnComponentType.LambdaFunctionProperty.Arn`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-lambdafunction.html#cfn-iottwinmaker-componenttype-lambdafunction-arn
         */
        readonly arn: string;
    }
}
export declare namespace CfnComponentType {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-propertydefinition.html
     */
    interface PropertyDefinitionProperty {
        /**
         * `CfnComponentType.PropertyDefinitionProperty.Configurations`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-propertydefinition.html#cfn-iottwinmaker-componenttype-propertydefinition-configurations
         */
        readonly configurations?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnComponentType.PropertyDefinitionProperty.DataType`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-propertydefinition.html#cfn-iottwinmaker-componenttype-propertydefinition-datatype
         */
        readonly dataType?: CfnComponentType.DataTypeProperty | cdk.IResolvable;
        /**
         * `CfnComponentType.PropertyDefinitionProperty.DefaultValue`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-propertydefinition.html#cfn-iottwinmaker-componenttype-propertydefinition-defaultvalue
         */
        readonly defaultValue?: CfnComponentType.DataValueProperty | cdk.IResolvable;
        /**
         * `CfnComponentType.PropertyDefinitionProperty.IsExternalId`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-propertydefinition.html#cfn-iottwinmaker-componenttype-propertydefinition-isexternalid
         */
        readonly isExternalId?: boolean | cdk.IResolvable;
        /**
         * `CfnComponentType.PropertyDefinitionProperty.IsRequiredInEntity`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-propertydefinition.html#cfn-iottwinmaker-componenttype-propertydefinition-isrequiredinentity
         */
        readonly isRequiredInEntity?: boolean | cdk.IResolvable;
        /**
         * `CfnComponentType.PropertyDefinitionProperty.IsStoredExternally`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-propertydefinition.html#cfn-iottwinmaker-componenttype-propertydefinition-isstoredexternally
         */
        readonly isStoredExternally?: boolean | cdk.IResolvable;
        /**
         * `CfnComponentType.PropertyDefinitionProperty.IsTimeSeries`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-propertydefinition.html#cfn-iottwinmaker-componenttype-propertydefinition-istimeseries
         */
        readonly isTimeSeries?: boolean | cdk.IResolvable;
    }
}
export declare namespace CfnComponentType {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-relationship.html
     */
    interface RelationshipProperty {
        /**
         * `CfnComponentType.RelationshipProperty.RelationshipType`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-relationship.html#cfn-iottwinmaker-componenttype-relationship-relationshiptype
         */
        readonly relationshipType?: string;
        /**
         * `CfnComponentType.RelationshipProperty.TargetComponentTypeId`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-relationship.html#cfn-iottwinmaker-componenttype-relationship-targetcomponenttypeid
         */
        readonly targetComponentTypeId?: string;
    }
}
/**
 * Properties for defining a `CfnEntity`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html
 */
export interface CfnEntityProps {
    /**
     * `AWS::IoTTwinMaker::Entity.EntityName`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-entityname
     */
    readonly entityName: string;
    /**
     * `AWS::IoTTwinMaker::Entity.WorkspaceId`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-workspaceid
     */
    readonly workspaceId: string;
    /**
     * `AWS::IoTTwinMaker::Entity.Components`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-components
     */
    readonly components?: {
        [key: string]: (CfnEntity.ComponentProperty | cdk.IResolvable);
    } | cdk.IResolvable;
    /**
     * `AWS::IoTTwinMaker::Entity.Description`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-description
     */
    readonly description?: string;
    /**
     * `AWS::IoTTwinMaker::Entity.EntityId`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-entityid
     */
    readonly entityId?: string;
    /**
     * `AWS::IoTTwinMaker::Entity.ParentEntityId`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-parententityid
     */
    readonly parentEntityId?: string;
    /**
     * `AWS::IoTTwinMaker::Entity.Tags`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-tags
     */
    readonly tags?: {
        [key: string]: (string);
    };
}
/**
 * A CloudFormation `AWS::IoTTwinMaker::Entity`
 *
 *
 *
 * @cloudformationResource AWS::IoTTwinMaker::Entity
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html
 */
export declare class CfnEntity extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoTTwinMaker::Entity";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnEntity;
    /**
     *
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     *
     * @cloudformationAttribute CreationDateTime
     */
    readonly attrCreationDateTime: string;
    /**
     *
     * @cloudformationAttribute HasChildEntities
     */
    readonly attrHasChildEntities: cdk.IResolvable;
    /**
     *
     * @cloudformationAttribute UpdateDateTime
     */
    readonly attrUpdateDateTime: string;
    /**
     * `AWS::IoTTwinMaker::Entity.EntityName`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-entityname
     */
    entityName: string;
    /**
     * `AWS::IoTTwinMaker::Entity.WorkspaceId`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-workspaceid
     */
    workspaceId: string;
    /**
     * `AWS::IoTTwinMaker::Entity.Components`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-components
     */
    components: {
        [key: string]: (CfnEntity.ComponentProperty | cdk.IResolvable);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::IoTTwinMaker::Entity.Description`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-description
     */
    description: string | undefined;
    /**
     * `AWS::IoTTwinMaker::Entity.EntityId`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-entityid
     */
    entityId: string | undefined;
    /**
     * `AWS::IoTTwinMaker::Entity.ParentEntityId`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-parententityid
     */
    parentEntityId: string | undefined;
    /**
     * `AWS::IoTTwinMaker::Entity.Tags`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-entity.html#cfn-iottwinmaker-entity-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::IoTTwinMaker::Entity`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEntityProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnEntity {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-component.html
     */
    interface ComponentProperty {
        /**
         * `CfnEntity.ComponentProperty.ComponentName`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-component.html#cfn-iottwinmaker-entity-component-componentname
         */
        readonly componentName?: string;
        /**
         * `CfnEntity.ComponentProperty.ComponentTypeId`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-component.html#cfn-iottwinmaker-entity-component-componenttypeid
         */
        readonly componentTypeId?: string;
        /**
         * `CfnEntity.ComponentProperty.DefinedIn`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-component.html#cfn-iottwinmaker-entity-component-definedin
         */
        readonly definedIn?: string;
        /**
         * `CfnEntity.ComponentProperty.Description`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-component.html#cfn-iottwinmaker-entity-component-description
         */
        readonly description?: string;
        /**
         * `CfnEntity.ComponentProperty.Properties`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-component.html#cfn-iottwinmaker-entity-component-properties
         */
        readonly properties?: {
            [key: string]: (CfnEntity.PropertyProperty | cdk.IResolvable);
        } | cdk.IResolvable;
        /**
         * `CfnEntity.ComponentProperty.Status`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-component.html#cfn-iottwinmaker-entity-component-status
         */
        readonly status?: CfnEntity.StatusProperty | cdk.IResolvable;
    }
}
export declare namespace CfnEntity {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datavalue.html
     */
    interface DataValueProperty {
        /**
         * `CfnEntity.DataValueProperty.BooleanValue`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datavalue.html#cfn-iottwinmaker-entity-datavalue-booleanvalue
         */
        readonly booleanValue?: boolean | cdk.IResolvable;
        /**
         * `CfnEntity.DataValueProperty.DoubleValue`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datavalue.html#cfn-iottwinmaker-entity-datavalue-doublevalue
         */
        readonly doubleValue?: number;
        /**
         * `CfnEntity.DataValueProperty.Expression`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datavalue.html#cfn-iottwinmaker-entity-datavalue-expression
         */
        readonly expression?: string;
        /**
         * `CfnEntity.DataValueProperty.IntegerValue`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datavalue.html#cfn-iottwinmaker-entity-datavalue-integervalue
         */
        readonly integerValue?: number;
        /**
         * `CfnEntity.DataValueProperty.ListValue`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datavalue.html#cfn-iottwinmaker-entity-datavalue-listvalue
         */
        readonly listValue?: Array<CfnEntity.DataValueProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnEntity.DataValueProperty.LongValue`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datavalue.html#cfn-iottwinmaker-entity-datavalue-longvalue
         */
        readonly longValue?: number;
        /**
         * `CfnEntity.DataValueProperty.MapValue`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datavalue.html#cfn-iottwinmaker-entity-datavalue-mapvalue
         */
        readonly mapValue?: {
            [key: string]: (CfnEntity.DataValueProperty | cdk.IResolvable);
        } | cdk.IResolvable;
        /**
         * `CfnEntity.DataValueProperty.RelationshipValue`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datavalue.html#cfn-iottwinmaker-entity-datavalue-relationshipvalue
         */
        readonly relationshipValue?: any | cdk.IResolvable;
        /**
         * `CfnEntity.DataValueProperty.StringValue`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-datavalue.html#cfn-iottwinmaker-entity-datavalue-stringvalue
         */
        readonly stringValue?: string;
    }
}
export declare namespace CfnEntity {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-property.html
     */
    interface PropertyProperty {
        /**
         * `CfnEntity.PropertyProperty.Definition`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-property.html#cfn-iottwinmaker-entity-property-definition
         */
        readonly definition?: any | cdk.IResolvable;
        /**
         * `CfnEntity.PropertyProperty.Value`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-property.html#cfn-iottwinmaker-entity-property-value
         */
        readonly value?: CfnEntity.DataValueProperty | cdk.IResolvable;
    }
}
export declare namespace CfnEntity {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-status.html
     */
    interface StatusProperty {
        /**
         * `CfnEntity.StatusProperty.Error`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-status.html#cfn-iottwinmaker-entity-status-error
         */
        readonly error?: any | cdk.IResolvable;
        /**
         * `CfnEntity.StatusProperty.State`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-entity-status.html#cfn-iottwinmaker-entity-status-state
         */
        readonly state?: string;
    }
}
/**
 * Properties for defining a `CfnScene`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-scene.html
 */
export interface CfnSceneProps {
    /**
     * `AWS::IoTTwinMaker::Scene.ContentLocation`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-scene.html#cfn-iottwinmaker-scene-contentlocation
     */
    readonly contentLocation: string;
    /**
     * `AWS::IoTTwinMaker::Scene.SceneId`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-scene.html#cfn-iottwinmaker-scene-sceneid
     */
    readonly sceneId: string;
    /**
     * `AWS::IoTTwinMaker::Scene.WorkspaceId`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-scene.html#cfn-iottwinmaker-scene-workspaceid
     */
    readonly workspaceId: string;
    /**
     * `AWS::IoTTwinMaker::Scene.Capabilities`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-scene.html#cfn-iottwinmaker-scene-capabilities
     */
    readonly capabilities?: string[];
    /**
     * `AWS::IoTTwinMaker::Scene.Description`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-scene.html#cfn-iottwinmaker-scene-description
     */
    readonly description?: string;
    /**
     * `AWS::IoTTwinMaker::Scene.Tags`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-scene.html#cfn-iottwinmaker-scene-tags
     */
    readonly tags?: {
        [key: string]: (string);
    };
}
/**
 * A CloudFormation `AWS::IoTTwinMaker::Scene`
 *
 *
 *
 * @cloudformationResource AWS::IoTTwinMaker::Scene
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-scene.html
 */
export declare class CfnScene extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoTTwinMaker::Scene";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnScene;
    /**
     *
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     *
     * @cloudformationAttribute CreationDateTime
     */
    readonly attrCreationDateTime: string;
    /**
     *
     * @cloudformationAttribute UpdateDateTime
     */
    readonly attrUpdateDateTime: string;
    /**
     * `AWS::IoTTwinMaker::Scene.ContentLocation`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-scene.html#cfn-iottwinmaker-scene-contentlocation
     */
    contentLocation: string;
    /**
     * `AWS::IoTTwinMaker::Scene.SceneId`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-scene.html#cfn-iottwinmaker-scene-sceneid
     */
    sceneId: string;
    /**
     * `AWS::IoTTwinMaker::Scene.WorkspaceId`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-scene.html#cfn-iottwinmaker-scene-workspaceid
     */
    workspaceId: string;
    /**
     * `AWS::IoTTwinMaker::Scene.Capabilities`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-scene.html#cfn-iottwinmaker-scene-capabilities
     */
    capabilities: string[] | undefined;
    /**
     * `AWS::IoTTwinMaker::Scene.Description`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-scene.html#cfn-iottwinmaker-scene-description
     */
    description: string | undefined;
    /**
     * `AWS::IoTTwinMaker::Scene.Tags`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-scene.html#cfn-iottwinmaker-scene-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::IoTTwinMaker::Scene`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSceneProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `CfnWorkspace`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-workspace.html
 */
export interface CfnWorkspaceProps {
    /**
     * `AWS::IoTTwinMaker::Workspace.Role`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-workspace.html#cfn-iottwinmaker-workspace-role
     */
    readonly role: string;
    /**
     * `AWS::IoTTwinMaker::Workspace.S3Location`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-workspace.html#cfn-iottwinmaker-workspace-s3location
     */
    readonly s3Location: string;
    /**
     * `AWS::IoTTwinMaker::Workspace.WorkspaceId`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-workspace.html#cfn-iottwinmaker-workspace-workspaceid
     */
    readonly workspaceId: string;
    /**
     * `AWS::IoTTwinMaker::Workspace.Description`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-workspace.html#cfn-iottwinmaker-workspace-description
     */
    readonly description?: string;
    /**
     * `AWS::IoTTwinMaker::Workspace.Tags`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-workspace.html#cfn-iottwinmaker-workspace-tags
     */
    readonly tags?: {
        [key: string]: (string);
    };
}
/**
 * A CloudFormation `AWS::IoTTwinMaker::Workspace`
 *
 *
 *
 * @cloudformationResource AWS::IoTTwinMaker::Workspace
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-workspace.html
 */
export declare class CfnWorkspace extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoTTwinMaker::Workspace";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnWorkspace;
    /**
     *
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     *
     * @cloudformationAttribute CreationDateTime
     */
    readonly attrCreationDateTime: string;
    /**
     *
     * @cloudformationAttribute UpdateDateTime
     */
    readonly attrUpdateDateTime: string;
    /**
     * `AWS::IoTTwinMaker::Workspace.Role`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-workspace.html#cfn-iottwinmaker-workspace-role
     */
    role: string;
    /**
     * `AWS::IoTTwinMaker::Workspace.S3Location`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-workspace.html#cfn-iottwinmaker-workspace-s3location
     */
    s3Location: string;
    /**
     * `AWS::IoTTwinMaker::Workspace.WorkspaceId`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-workspace.html#cfn-iottwinmaker-workspace-workspaceid
     */
    workspaceId: string;
    /**
     * `AWS::IoTTwinMaker::Workspace.Description`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-workspace.html#cfn-iottwinmaker-workspace-description
     */
    description: string | undefined;
    /**
     * `AWS::IoTTwinMaker::Workspace.Tags`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-workspace.html#cfn-iottwinmaker-workspace-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::IoTTwinMaker::Workspace`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnWorkspaceProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
