#  Contributing to alv

This software was written as a solution to my own perceived need. Since then, I have understood that
there are quite a few people that have a similar need and I am very happy that `alv` may help
others. Maybe you have an idea of how to improve `alv`? There are several ways to contribute, for
example:

* Bug reports
* Feature requests
* Better examples
* Better documentation (which is very limited as of this writing)
* Code contributions

This is a small project and it should not be hard to contribute. Still, you may be helped by 
reading some suggestions below. Also, have a look at THANKS.md for how some have contributed.

/Lars Arvestad

## The aim of alv

`alv` is intended to be a lightweight, easy-to-use, console-only MSA viewer that works well in a
command-line environment. We will follow the Unix spirit of tools having a main purpose and
integrate well in the environment, rather than try to make a "Swiss-army-knife inspired" workbench
for sequence analysis.

Contributions should be made with this aim in mind. If you want to take `alv`
to "the next level", then consider forking this project, rename, and start something new.

## Bug reports and feature requests

Please consider creating an issue in the `alv` repo if you have a bug report or feature
request. Emails are welcome too, but are harder to keep track of in relation to `alv`
development. GitHub has a guide called [Mastering
Issues](https://guides.github.com/features/issues/) to get you started. It is easier than it may
look!

A bug report becomes easier to understand and address if it is accompanied with:

* A clear and detailed description of the problem.
* An example invocation.
* Sample data. 

## Code and text contributions

Any code or text contribution is welcome! Bug fixes, examples, speed improvements, and feature
additions --- anything that might improve `alv` usage.

* Pull requests are preferred. The recommended workflow is to
    - fork this repo on github.com, 
	- work in your own copy, 
	- create a pull request to the original alv repo. 
  See GitHub's guide [Forking Projects](https://guides.github.com/activities/forking/). 
* Please try to add a unit test for a contributed feature or fixed bug.
* For large changes, please discuss with @arvestad first. Or just fork, rename, and continue! This
  is Free Software.
* Code contributions are expected to be under GPL v3, see the LICENSE file.
