# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['SimulationApplicationArgs', 'SimulationApplication']

@pulumi.input_type
class SimulationApplicationArgs:
    def __init__(__self__, *,
                 robot_software_suite: pulumi.Input['SimulationApplicationRobotSoftwareSuiteArgs'],
                 simulation_software_suite: pulumi.Input['SimulationApplicationSimulationSoftwareSuiteArgs'],
                 current_revision_id: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rendering_engine: Optional[pulumi.Input['SimulationApplicationRenderingEngineArgs']] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input['SimulationApplicationSourceConfigArgs']]]] = None,
                 tags: Optional[pulumi.Input['SimulationApplicationTagsArgs']] = None):
        """
        The set of arguments for constructing a SimulationApplication resource.
        :param pulumi.Input['SimulationApplicationRobotSoftwareSuiteArgs'] robot_software_suite: The robot software suite used by the simulation application.
        :param pulumi.Input['SimulationApplicationSimulationSoftwareSuiteArgs'] simulation_software_suite: The simulation software suite used by the simulation application.
        :param pulumi.Input[str] current_revision_id: The current revision id.
        :param pulumi.Input[str] environment: The URI of the Docker image for the robot application.
        :param pulumi.Input[str] name: The name of the simulation application.
        :param pulumi.Input['SimulationApplicationRenderingEngineArgs'] rendering_engine: The rendering engine for the simulation application.
        :param pulumi.Input[Sequence[pulumi.Input['SimulationApplicationSourceConfigArgs']]] sources: The sources of the simulation application.
        """
        pulumi.set(__self__, "robot_software_suite", robot_software_suite)
        pulumi.set(__self__, "simulation_software_suite", simulation_software_suite)
        if current_revision_id is not None:
            pulumi.set(__self__, "current_revision_id", current_revision_id)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rendering_engine is not None:
            pulumi.set(__self__, "rendering_engine", rendering_engine)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="robotSoftwareSuite")
    def robot_software_suite(self) -> pulumi.Input['SimulationApplicationRobotSoftwareSuiteArgs']:
        """
        The robot software suite used by the simulation application.
        """
        return pulumi.get(self, "robot_software_suite")

    @robot_software_suite.setter
    def robot_software_suite(self, value: pulumi.Input['SimulationApplicationRobotSoftwareSuiteArgs']):
        pulumi.set(self, "robot_software_suite", value)

    @property
    @pulumi.getter(name="simulationSoftwareSuite")
    def simulation_software_suite(self) -> pulumi.Input['SimulationApplicationSimulationSoftwareSuiteArgs']:
        """
        The simulation software suite used by the simulation application.
        """
        return pulumi.get(self, "simulation_software_suite")

    @simulation_software_suite.setter
    def simulation_software_suite(self, value: pulumi.Input['SimulationApplicationSimulationSoftwareSuiteArgs']):
        pulumi.set(self, "simulation_software_suite", value)

    @property
    @pulumi.getter(name="currentRevisionId")
    def current_revision_id(self) -> Optional[pulumi.Input[str]]:
        """
        The current revision id.
        """
        return pulumi.get(self, "current_revision_id")

    @current_revision_id.setter
    def current_revision_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "current_revision_id", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of the Docker image for the robot application.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the simulation application.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="renderingEngine")
    def rendering_engine(self) -> Optional[pulumi.Input['SimulationApplicationRenderingEngineArgs']]:
        """
        The rendering engine for the simulation application.
        """
        return pulumi.get(self, "rendering_engine")

    @rendering_engine.setter
    def rendering_engine(self, value: Optional[pulumi.Input['SimulationApplicationRenderingEngineArgs']]):
        pulumi.set(self, "rendering_engine", value)

    @property
    @pulumi.getter
    def sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SimulationApplicationSourceConfigArgs']]]]:
        """
        The sources of the simulation application.
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SimulationApplicationSourceConfigArgs']]]]):
        pulumi.set(self, "sources", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input['SimulationApplicationTagsArgs']]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input['SimulationApplicationTagsArgs']]):
        pulumi.set(self, "tags", value)


class SimulationApplication(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 current_revision_id: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rendering_engine: Optional[pulumi.Input[pulumi.InputType['SimulationApplicationRenderingEngineArgs']]] = None,
                 robot_software_suite: Optional[pulumi.Input[pulumi.InputType['SimulationApplicationRobotSoftwareSuiteArgs']]] = None,
                 simulation_software_suite: Optional[pulumi.Input[pulumi.InputType['SimulationApplicationSimulationSoftwareSuiteArgs']]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SimulationApplicationSourceConfigArgs']]]]] = None,
                 tags: Optional[pulumi.Input[pulumi.InputType['SimulationApplicationTagsArgs']]] = None,
                 __props__=None):
        """
        An example resource schema demonstrating some basic constructs and validation rules.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] current_revision_id: The current revision id.
        :param pulumi.Input[str] environment: The URI of the Docker image for the robot application.
        :param pulumi.Input[str] name: The name of the simulation application.
        :param pulumi.Input[pulumi.InputType['SimulationApplicationRenderingEngineArgs']] rendering_engine: The rendering engine for the simulation application.
        :param pulumi.Input[pulumi.InputType['SimulationApplicationRobotSoftwareSuiteArgs']] robot_software_suite: The robot software suite used by the simulation application.
        :param pulumi.Input[pulumi.InputType['SimulationApplicationSimulationSoftwareSuiteArgs']] simulation_software_suite: The simulation software suite used by the simulation application.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SimulationApplicationSourceConfigArgs']]]] sources: The sources of the simulation application.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SimulationApplicationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An example resource schema demonstrating some basic constructs and validation rules.

        :param str resource_name: The name of the resource.
        :param SimulationApplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SimulationApplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 current_revision_id: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rendering_engine: Optional[pulumi.Input[pulumi.InputType['SimulationApplicationRenderingEngineArgs']]] = None,
                 robot_software_suite: Optional[pulumi.Input[pulumi.InputType['SimulationApplicationRobotSoftwareSuiteArgs']]] = None,
                 simulation_software_suite: Optional[pulumi.Input[pulumi.InputType['SimulationApplicationSimulationSoftwareSuiteArgs']]] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SimulationApplicationSourceConfigArgs']]]]] = None,
                 tags: Optional[pulumi.Input[pulumi.InputType['SimulationApplicationTagsArgs']]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SimulationApplicationArgs.__new__(SimulationApplicationArgs)

            __props__.__dict__["current_revision_id"] = current_revision_id
            __props__.__dict__["environment"] = environment
            __props__.__dict__["name"] = name
            __props__.__dict__["rendering_engine"] = rendering_engine
            if robot_software_suite is None and not opts.urn:
                raise TypeError("Missing required property 'robot_software_suite'")
            __props__.__dict__["robot_software_suite"] = robot_software_suite
            if simulation_software_suite is None and not opts.urn:
                raise TypeError("Missing required property 'simulation_software_suite'")
            __props__.__dict__["simulation_software_suite"] = simulation_software_suite
            __props__.__dict__["sources"] = sources
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
        super(SimulationApplication, __self__).__init__(
            'aws-native:robomaker:SimulationApplication',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'SimulationApplication':
        """
        Get an existing SimulationApplication resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = SimulationApplicationArgs.__new__(SimulationApplicationArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["current_revision_id"] = None
        __props__.__dict__["environment"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["rendering_engine"] = None
        __props__.__dict__["robot_software_suite"] = None
        __props__.__dict__["simulation_software_suite"] = None
        __props__.__dict__["sources"] = None
        __props__.__dict__["tags"] = None
        return SimulationApplication(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="currentRevisionId")
    def current_revision_id(self) -> pulumi.Output[Optional[str]]:
        """
        The current revision id.
        """
        return pulumi.get(self, "current_revision_id")

    @property
    @pulumi.getter
    def environment(self) -> pulumi.Output[Optional[str]]:
        """
        The URI of the Docker image for the robot application.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the simulation application.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="renderingEngine")
    def rendering_engine(self) -> pulumi.Output[Optional['outputs.SimulationApplicationRenderingEngine']]:
        """
        The rendering engine for the simulation application.
        """
        return pulumi.get(self, "rendering_engine")

    @property
    @pulumi.getter(name="robotSoftwareSuite")
    def robot_software_suite(self) -> pulumi.Output['outputs.SimulationApplicationRobotSoftwareSuite']:
        """
        The robot software suite used by the simulation application.
        """
        return pulumi.get(self, "robot_software_suite")

    @property
    @pulumi.getter(name="simulationSoftwareSuite")
    def simulation_software_suite(self) -> pulumi.Output['outputs.SimulationApplicationSimulationSoftwareSuite']:
        """
        The simulation software suite used by the simulation application.
        """
        return pulumi.get(self, "simulation_software_suite")

    @property
    @pulumi.getter
    def sources(self) -> pulumi.Output[Optional[Sequence['outputs.SimulationApplicationSourceConfig']]]:
        """
        The sources of the simulation application.
        """
        return pulumi.get(self, "sources")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional['outputs.SimulationApplicationTags']]:
        return pulumi.get(self, "tags")

