# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ReplicationGroupArgs', 'ReplicationGroup']

@pulumi.input_type
class ReplicationGroupArgs:
    def __init__(__self__, *,
                 replication_group_description: pulumi.Input[str],
                 at_rest_encryption_enabled: Optional[pulumi.Input[bool]] = None,
                 auth_token: Optional[pulumi.Input[str]] = None,
                 auto_minor_version_upgrade: Optional[pulumi.Input[bool]] = None,
                 automatic_failover_enabled: Optional[pulumi.Input[bool]] = None,
                 cache_node_type: Optional[pulumi.Input[str]] = None,
                 cache_parameter_group_name: Optional[pulumi.Input[str]] = None,
                 cache_security_group_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cache_subnet_group_name: Optional[pulumi.Input[str]] = None,
                 configuration_end_point_address: Optional[pulumi.Input[str]] = None,
                 configuration_end_point_port: Optional[pulumi.Input[str]] = None,
                 data_tiering_enabled: Optional[pulumi.Input[bool]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 global_replication_group_id: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 log_delivery_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationGroupLogDeliveryConfigurationRequestArgs']]]] = None,
                 multi_az_enabled: Optional[pulumi.Input[bool]] = None,
                 node_group_configuration: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationGroupNodeGroupConfigurationArgs']]]] = None,
                 notification_topic_arn: Optional[pulumi.Input[str]] = None,
                 num_cache_clusters: Optional[pulumi.Input[int]] = None,
                 num_node_groups: Optional[pulumi.Input[int]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 preferred_cache_cluster_azs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[str]] = None,
                 primary_cluster_id: Optional[pulumi.Input[str]] = None,
                 primary_end_point_address: Optional[pulumi.Input[str]] = None,
                 primary_end_point_port: Optional[pulumi.Input[str]] = None,
                 read_end_point_addresses: Optional[pulumi.Input[str]] = None,
                 read_end_point_addresses_list: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 read_end_point_ports: Optional[pulumi.Input[str]] = None,
                 read_end_point_ports_list: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 reader_end_point_address: Optional[pulumi.Input[str]] = None,
                 reader_end_point_port: Optional[pulumi.Input[str]] = None,
                 replicas_per_node_group: Optional[pulumi.Input[int]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 snapshot_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 snapshot_name: Optional[pulumi.Input[str]] = None,
                 snapshot_retention_limit: Optional[pulumi.Input[int]] = None,
                 snapshot_window: Optional[pulumi.Input[str]] = None,
                 snapshotting_cluster_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationGroupTagArgs']]]] = None,
                 transit_encryption_enabled: Optional[pulumi.Input[bool]] = None,
                 user_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a ReplicationGroup resource.
        """
        pulumi.set(__self__, "replication_group_description", replication_group_description)
        if at_rest_encryption_enabled is not None:
            pulumi.set(__self__, "at_rest_encryption_enabled", at_rest_encryption_enabled)
        if auth_token is not None:
            pulumi.set(__self__, "auth_token", auth_token)
        if auto_minor_version_upgrade is not None:
            pulumi.set(__self__, "auto_minor_version_upgrade", auto_minor_version_upgrade)
        if automatic_failover_enabled is not None:
            pulumi.set(__self__, "automatic_failover_enabled", automatic_failover_enabled)
        if cache_node_type is not None:
            pulumi.set(__self__, "cache_node_type", cache_node_type)
        if cache_parameter_group_name is not None:
            pulumi.set(__self__, "cache_parameter_group_name", cache_parameter_group_name)
        if cache_security_group_names is not None:
            pulumi.set(__self__, "cache_security_group_names", cache_security_group_names)
        if cache_subnet_group_name is not None:
            pulumi.set(__self__, "cache_subnet_group_name", cache_subnet_group_name)
        if configuration_end_point_address is not None:
            pulumi.set(__self__, "configuration_end_point_address", configuration_end_point_address)
        if configuration_end_point_port is not None:
            pulumi.set(__self__, "configuration_end_point_port", configuration_end_point_port)
        if data_tiering_enabled is not None:
            pulumi.set(__self__, "data_tiering_enabled", data_tiering_enabled)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if global_replication_group_id is not None:
            pulumi.set(__self__, "global_replication_group_id", global_replication_group_id)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if log_delivery_configurations is not None:
            pulumi.set(__self__, "log_delivery_configurations", log_delivery_configurations)
        if multi_az_enabled is not None:
            pulumi.set(__self__, "multi_az_enabled", multi_az_enabled)
        if node_group_configuration is not None:
            pulumi.set(__self__, "node_group_configuration", node_group_configuration)
        if notification_topic_arn is not None:
            pulumi.set(__self__, "notification_topic_arn", notification_topic_arn)
        if num_cache_clusters is not None:
            pulumi.set(__self__, "num_cache_clusters", num_cache_clusters)
        if num_node_groups is not None:
            pulumi.set(__self__, "num_node_groups", num_node_groups)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if preferred_cache_cluster_azs is not None:
            pulumi.set(__self__, "preferred_cache_cluster_azs", preferred_cache_cluster_azs)
        if preferred_maintenance_window is not None:
            pulumi.set(__self__, "preferred_maintenance_window", preferred_maintenance_window)
        if primary_cluster_id is not None:
            pulumi.set(__self__, "primary_cluster_id", primary_cluster_id)
        if primary_end_point_address is not None:
            pulumi.set(__self__, "primary_end_point_address", primary_end_point_address)
        if primary_end_point_port is not None:
            pulumi.set(__self__, "primary_end_point_port", primary_end_point_port)
        if read_end_point_addresses is not None:
            pulumi.set(__self__, "read_end_point_addresses", read_end_point_addresses)
        if read_end_point_addresses_list is not None:
            pulumi.set(__self__, "read_end_point_addresses_list", read_end_point_addresses_list)
        if read_end_point_ports is not None:
            pulumi.set(__self__, "read_end_point_ports", read_end_point_ports)
        if read_end_point_ports_list is not None:
            pulumi.set(__self__, "read_end_point_ports_list", read_end_point_ports_list)
        if reader_end_point_address is not None:
            pulumi.set(__self__, "reader_end_point_address", reader_end_point_address)
        if reader_end_point_port is not None:
            pulumi.set(__self__, "reader_end_point_port", reader_end_point_port)
        if replicas_per_node_group is not None:
            pulumi.set(__self__, "replicas_per_node_group", replicas_per_node_group)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if snapshot_arns is not None:
            pulumi.set(__self__, "snapshot_arns", snapshot_arns)
        if snapshot_name is not None:
            pulumi.set(__self__, "snapshot_name", snapshot_name)
        if snapshot_retention_limit is not None:
            pulumi.set(__self__, "snapshot_retention_limit", snapshot_retention_limit)
        if snapshot_window is not None:
            pulumi.set(__self__, "snapshot_window", snapshot_window)
        if snapshotting_cluster_id is not None:
            pulumi.set(__self__, "snapshotting_cluster_id", snapshotting_cluster_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if transit_encryption_enabled is not None:
            pulumi.set(__self__, "transit_encryption_enabled", transit_encryption_enabled)
        if user_group_ids is not None:
            pulumi.set(__self__, "user_group_ids", user_group_ids)

    @property
    @pulumi.getter(name="replicationGroupDescription")
    def replication_group_description(self) -> pulumi.Input[str]:
        return pulumi.get(self, "replication_group_description")

    @replication_group_description.setter
    def replication_group_description(self, value: pulumi.Input[str]):
        pulumi.set(self, "replication_group_description", value)

    @property
    @pulumi.getter(name="atRestEncryptionEnabled")
    def at_rest_encryption_enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "at_rest_encryption_enabled")

    @at_rest_encryption_enabled.setter
    def at_rest_encryption_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "at_rest_encryption_enabled", value)

    @property
    @pulumi.getter(name="authToken")
    def auth_token(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "auth_token")

    @auth_token.setter
    def auth_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_token", value)

    @property
    @pulumi.getter(name="autoMinorVersionUpgrade")
    def auto_minor_version_upgrade(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "auto_minor_version_upgrade")

    @auto_minor_version_upgrade.setter
    def auto_minor_version_upgrade(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_minor_version_upgrade", value)

    @property
    @pulumi.getter(name="automaticFailoverEnabled")
    def automatic_failover_enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "automatic_failover_enabled")

    @automatic_failover_enabled.setter
    def automatic_failover_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "automatic_failover_enabled", value)

    @property
    @pulumi.getter(name="cacheNodeType")
    def cache_node_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cache_node_type")

    @cache_node_type.setter
    def cache_node_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cache_node_type", value)

    @property
    @pulumi.getter(name="cacheParameterGroupName")
    def cache_parameter_group_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cache_parameter_group_name")

    @cache_parameter_group_name.setter
    def cache_parameter_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cache_parameter_group_name", value)

    @property
    @pulumi.getter(name="cacheSecurityGroupNames")
    def cache_security_group_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "cache_security_group_names")

    @cache_security_group_names.setter
    def cache_security_group_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "cache_security_group_names", value)

    @property
    @pulumi.getter(name="cacheSubnetGroupName")
    def cache_subnet_group_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cache_subnet_group_name")

    @cache_subnet_group_name.setter
    def cache_subnet_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cache_subnet_group_name", value)

    @property
    @pulumi.getter(name="configurationEndPointAddress")
    def configuration_end_point_address(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "configuration_end_point_address")

    @configuration_end_point_address.setter
    def configuration_end_point_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration_end_point_address", value)

    @property
    @pulumi.getter(name="configurationEndPointPort")
    def configuration_end_point_port(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "configuration_end_point_port")

    @configuration_end_point_port.setter
    def configuration_end_point_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "configuration_end_point_port", value)

    @property
    @pulumi.getter(name="dataTieringEnabled")
    def data_tiering_enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "data_tiering_enabled")

    @data_tiering_enabled.setter
    def data_tiering_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "data_tiering_enabled", value)

    @property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="globalReplicationGroupId")
    def global_replication_group_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "global_replication_group_id")

    @global_replication_group_id.setter
    def global_replication_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "global_replication_group_id", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="logDeliveryConfigurations")
    def log_delivery_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationGroupLogDeliveryConfigurationRequestArgs']]]]:
        return pulumi.get(self, "log_delivery_configurations")

    @log_delivery_configurations.setter
    def log_delivery_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationGroupLogDeliveryConfigurationRequestArgs']]]]):
        pulumi.set(self, "log_delivery_configurations", value)

    @property
    @pulumi.getter(name="multiAZEnabled")
    def multi_az_enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "multi_az_enabled")

    @multi_az_enabled.setter
    def multi_az_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multi_az_enabled", value)

    @property
    @pulumi.getter(name="nodeGroupConfiguration")
    def node_group_configuration(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationGroupNodeGroupConfigurationArgs']]]]:
        return pulumi.get(self, "node_group_configuration")

    @node_group_configuration.setter
    def node_group_configuration(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationGroupNodeGroupConfigurationArgs']]]]):
        pulumi.set(self, "node_group_configuration", value)

    @property
    @pulumi.getter(name="notificationTopicArn")
    def notification_topic_arn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "notification_topic_arn")

    @notification_topic_arn.setter
    def notification_topic_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notification_topic_arn", value)

    @property
    @pulumi.getter(name="numCacheClusters")
    def num_cache_clusters(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "num_cache_clusters")

    @num_cache_clusters.setter
    def num_cache_clusters(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_cache_clusters", value)

    @property
    @pulumi.getter(name="numNodeGroups")
    def num_node_groups(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "num_node_groups")

    @num_node_groups.setter
    def num_node_groups(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "num_node_groups", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="preferredCacheClusterAZs")
    def preferred_cache_cluster_azs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "preferred_cache_cluster_azs")

    @preferred_cache_cluster_azs.setter
    def preferred_cache_cluster_azs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "preferred_cache_cluster_azs", value)

    @property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "preferred_maintenance_window")

    @preferred_maintenance_window.setter
    def preferred_maintenance_window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_maintenance_window", value)

    @property
    @pulumi.getter(name="primaryClusterId")
    def primary_cluster_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "primary_cluster_id")

    @primary_cluster_id.setter
    def primary_cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_cluster_id", value)

    @property
    @pulumi.getter(name="primaryEndPointAddress")
    def primary_end_point_address(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "primary_end_point_address")

    @primary_end_point_address.setter
    def primary_end_point_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_end_point_address", value)

    @property
    @pulumi.getter(name="primaryEndPointPort")
    def primary_end_point_port(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "primary_end_point_port")

    @primary_end_point_port.setter
    def primary_end_point_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_end_point_port", value)

    @property
    @pulumi.getter(name="readEndPointAddresses")
    def read_end_point_addresses(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "read_end_point_addresses")

    @read_end_point_addresses.setter
    def read_end_point_addresses(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "read_end_point_addresses", value)

    @property
    @pulumi.getter(name="readEndPointAddressesList")
    def read_end_point_addresses_list(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "read_end_point_addresses_list")

    @read_end_point_addresses_list.setter
    def read_end_point_addresses_list(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "read_end_point_addresses_list", value)

    @property
    @pulumi.getter(name="readEndPointPorts")
    def read_end_point_ports(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "read_end_point_ports")

    @read_end_point_ports.setter
    def read_end_point_ports(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "read_end_point_ports", value)

    @property
    @pulumi.getter(name="readEndPointPortsList")
    def read_end_point_ports_list(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "read_end_point_ports_list")

    @read_end_point_ports_list.setter
    def read_end_point_ports_list(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "read_end_point_ports_list", value)

    @property
    @pulumi.getter(name="readerEndPointAddress")
    def reader_end_point_address(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "reader_end_point_address")

    @reader_end_point_address.setter
    def reader_end_point_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reader_end_point_address", value)

    @property
    @pulumi.getter(name="readerEndPointPort")
    def reader_end_point_port(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "reader_end_point_port")

    @reader_end_point_port.setter
    def reader_end_point_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reader_end_point_port", value)

    @property
    @pulumi.getter(name="replicasPerNodeGroup")
    def replicas_per_node_group(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "replicas_per_node_group")

    @replicas_per_node_group.setter
    def replicas_per_node_group(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replicas_per_node_group", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="snapshotArns")
    def snapshot_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "snapshot_arns")

    @snapshot_arns.setter
    def snapshot_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "snapshot_arns", value)

    @property
    @pulumi.getter(name="snapshotName")
    def snapshot_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "snapshot_name")

    @snapshot_name.setter
    def snapshot_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_name", value)

    @property
    @pulumi.getter(name="snapshotRetentionLimit")
    def snapshot_retention_limit(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "snapshot_retention_limit")

    @snapshot_retention_limit.setter
    def snapshot_retention_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "snapshot_retention_limit", value)

    @property
    @pulumi.getter(name="snapshotWindow")
    def snapshot_window(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "snapshot_window")

    @snapshot_window.setter
    def snapshot_window(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_window", value)

    @property
    @pulumi.getter(name="snapshottingClusterId")
    def snapshotting_cluster_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "snapshotting_cluster_id")

    @snapshotting_cluster_id.setter
    def snapshotting_cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshotting_cluster_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationGroupTagArgs']]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationGroupTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="transitEncryptionEnabled")
    def transit_encryption_enabled(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "transit_encryption_enabled")

    @transit_encryption_enabled.setter
    def transit_encryption_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "transit_encryption_enabled", value)

    @property
    @pulumi.getter(name="userGroupIds")
    def user_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "user_group_ids")

    @user_group_ids.setter
    def user_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "user_group_ids", value)


warnings.warn("""ReplicationGroup is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""", DeprecationWarning)


class ReplicationGroup(pulumi.CustomResource):
    warnings.warn("""ReplicationGroup is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 at_rest_encryption_enabled: Optional[pulumi.Input[bool]] = None,
                 auth_token: Optional[pulumi.Input[str]] = None,
                 auto_minor_version_upgrade: Optional[pulumi.Input[bool]] = None,
                 automatic_failover_enabled: Optional[pulumi.Input[bool]] = None,
                 cache_node_type: Optional[pulumi.Input[str]] = None,
                 cache_parameter_group_name: Optional[pulumi.Input[str]] = None,
                 cache_security_group_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cache_subnet_group_name: Optional[pulumi.Input[str]] = None,
                 configuration_end_point_address: Optional[pulumi.Input[str]] = None,
                 configuration_end_point_port: Optional[pulumi.Input[str]] = None,
                 data_tiering_enabled: Optional[pulumi.Input[bool]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 global_replication_group_id: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 log_delivery_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ReplicationGroupLogDeliveryConfigurationRequestArgs']]]]] = None,
                 multi_az_enabled: Optional[pulumi.Input[bool]] = None,
                 node_group_configuration: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ReplicationGroupNodeGroupConfigurationArgs']]]]] = None,
                 notification_topic_arn: Optional[pulumi.Input[str]] = None,
                 num_cache_clusters: Optional[pulumi.Input[int]] = None,
                 num_node_groups: Optional[pulumi.Input[int]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 preferred_cache_cluster_azs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[str]] = None,
                 primary_cluster_id: Optional[pulumi.Input[str]] = None,
                 primary_end_point_address: Optional[pulumi.Input[str]] = None,
                 primary_end_point_port: Optional[pulumi.Input[str]] = None,
                 read_end_point_addresses: Optional[pulumi.Input[str]] = None,
                 read_end_point_addresses_list: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 read_end_point_ports: Optional[pulumi.Input[str]] = None,
                 read_end_point_ports_list: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 reader_end_point_address: Optional[pulumi.Input[str]] = None,
                 reader_end_point_port: Optional[pulumi.Input[str]] = None,
                 replicas_per_node_group: Optional[pulumi.Input[int]] = None,
                 replication_group_description: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 snapshot_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 snapshot_name: Optional[pulumi.Input[str]] = None,
                 snapshot_retention_limit: Optional[pulumi.Input[int]] = None,
                 snapshot_window: Optional[pulumi.Input[str]] = None,
                 snapshotting_cluster_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ReplicationGroupTagArgs']]]]] = None,
                 transit_encryption_enabled: Optional[pulumi.Input[bool]] = None,
                 user_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::ElastiCache::ReplicationGroup

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReplicationGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::ElastiCache::ReplicationGroup

        :param str resource_name: The name of the resource.
        :param ReplicationGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReplicationGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 at_rest_encryption_enabled: Optional[pulumi.Input[bool]] = None,
                 auth_token: Optional[pulumi.Input[str]] = None,
                 auto_minor_version_upgrade: Optional[pulumi.Input[bool]] = None,
                 automatic_failover_enabled: Optional[pulumi.Input[bool]] = None,
                 cache_node_type: Optional[pulumi.Input[str]] = None,
                 cache_parameter_group_name: Optional[pulumi.Input[str]] = None,
                 cache_security_group_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cache_subnet_group_name: Optional[pulumi.Input[str]] = None,
                 configuration_end_point_address: Optional[pulumi.Input[str]] = None,
                 configuration_end_point_port: Optional[pulumi.Input[str]] = None,
                 data_tiering_enabled: Optional[pulumi.Input[bool]] = None,
                 engine: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 global_replication_group_id: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 log_delivery_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ReplicationGroupLogDeliveryConfigurationRequestArgs']]]]] = None,
                 multi_az_enabled: Optional[pulumi.Input[bool]] = None,
                 node_group_configuration: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ReplicationGroupNodeGroupConfigurationArgs']]]]] = None,
                 notification_topic_arn: Optional[pulumi.Input[str]] = None,
                 num_cache_clusters: Optional[pulumi.Input[int]] = None,
                 num_node_groups: Optional[pulumi.Input[int]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 preferred_cache_cluster_azs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 preferred_maintenance_window: Optional[pulumi.Input[str]] = None,
                 primary_cluster_id: Optional[pulumi.Input[str]] = None,
                 primary_end_point_address: Optional[pulumi.Input[str]] = None,
                 primary_end_point_port: Optional[pulumi.Input[str]] = None,
                 read_end_point_addresses: Optional[pulumi.Input[str]] = None,
                 read_end_point_addresses_list: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 read_end_point_ports: Optional[pulumi.Input[str]] = None,
                 read_end_point_ports_list: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 reader_end_point_address: Optional[pulumi.Input[str]] = None,
                 reader_end_point_port: Optional[pulumi.Input[str]] = None,
                 replicas_per_node_group: Optional[pulumi.Input[int]] = None,
                 replication_group_description: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 snapshot_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 snapshot_name: Optional[pulumi.Input[str]] = None,
                 snapshot_retention_limit: Optional[pulumi.Input[int]] = None,
                 snapshot_window: Optional[pulumi.Input[str]] = None,
                 snapshotting_cluster_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ReplicationGroupTagArgs']]]]] = None,
                 transit_encryption_enabled: Optional[pulumi.Input[bool]] = None,
                 user_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        pulumi.log.warn("""ReplicationGroup is deprecated: ReplicationGroup is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""")
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReplicationGroupArgs.__new__(ReplicationGroupArgs)

            __props__.__dict__["at_rest_encryption_enabled"] = at_rest_encryption_enabled
            __props__.__dict__["auth_token"] = auth_token
            __props__.__dict__["auto_minor_version_upgrade"] = auto_minor_version_upgrade
            __props__.__dict__["automatic_failover_enabled"] = automatic_failover_enabled
            __props__.__dict__["cache_node_type"] = cache_node_type
            __props__.__dict__["cache_parameter_group_name"] = cache_parameter_group_name
            __props__.__dict__["cache_security_group_names"] = cache_security_group_names
            __props__.__dict__["cache_subnet_group_name"] = cache_subnet_group_name
            __props__.__dict__["configuration_end_point_address"] = configuration_end_point_address
            __props__.__dict__["configuration_end_point_port"] = configuration_end_point_port
            __props__.__dict__["data_tiering_enabled"] = data_tiering_enabled
            __props__.__dict__["engine"] = engine
            __props__.__dict__["engine_version"] = engine_version
            __props__.__dict__["global_replication_group_id"] = global_replication_group_id
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["log_delivery_configurations"] = log_delivery_configurations
            __props__.__dict__["multi_az_enabled"] = multi_az_enabled
            __props__.__dict__["node_group_configuration"] = node_group_configuration
            __props__.__dict__["notification_topic_arn"] = notification_topic_arn
            __props__.__dict__["num_cache_clusters"] = num_cache_clusters
            __props__.__dict__["num_node_groups"] = num_node_groups
            __props__.__dict__["port"] = port
            __props__.__dict__["preferred_cache_cluster_azs"] = preferred_cache_cluster_azs
            __props__.__dict__["preferred_maintenance_window"] = preferred_maintenance_window
            __props__.__dict__["primary_cluster_id"] = primary_cluster_id
            __props__.__dict__["primary_end_point_address"] = primary_end_point_address
            __props__.__dict__["primary_end_point_port"] = primary_end_point_port
            __props__.__dict__["read_end_point_addresses"] = read_end_point_addresses
            __props__.__dict__["read_end_point_addresses_list"] = read_end_point_addresses_list
            __props__.__dict__["read_end_point_ports"] = read_end_point_ports
            __props__.__dict__["read_end_point_ports_list"] = read_end_point_ports_list
            __props__.__dict__["reader_end_point_address"] = reader_end_point_address
            __props__.__dict__["reader_end_point_port"] = reader_end_point_port
            __props__.__dict__["replicas_per_node_group"] = replicas_per_node_group
            if replication_group_description is None and not opts.urn:
                raise TypeError("Missing required property 'replication_group_description'")
            __props__.__dict__["replication_group_description"] = replication_group_description
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["snapshot_arns"] = snapshot_arns
            __props__.__dict__["snapshot_name"] = snapshot_name
            __props__.__dict__["snapshot_retention_limit"] = snapshot_retention_limit
            __props__.__dict__["snapshot_window"] = snapshot_window
            __props__.__dict__["snapshotting_cluster_id"] = snapshotting_cluster_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["transit_encryption_enabled"] = transit_encryption_enabled
            __props__.__dict__["user_group_ids"] = user_group_ids
            __props__.__dict__["replication_group_id"] = None
        super(ReplicationGroup, __self__).__init__(
            'aws-native:elasticache:ReplicationGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ReplicationGroup':
        """
        Get an existing ReplicationGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ReplicationGroupArgs.__new__(ReplicationGroupArgs)

        __props__.__dict__["at_rest_encryption_enabled"] = None
        __props__.__dict__["auth_token"] = None
        __props__.__dict__["auto_minor_version_upgrade"] = None
        __props__.__dict__["automatic_failover_enabled"] = None
        __props__.__dict__["cache_node_type"] = None
        __props__.__dict__["cache_parameter_group_name"] = None
        __props__.__dict__["cache_security_group_names"] = None
        __props__.__dict__["cache_subnet_group_name"] = None
        __props__.__dict__["configuration_end_point_address"] = None
        __props__.__dict__["configuration_end_point_port"] = None
        __props__.__dict__["data_tiering_enabled"] = None
        __props__.__dict__["engine"] = None
        __props__.__dict__["engine_version"] = None
        __props__.__dict__["global_replication_group_id"] = None
        __props__.__dict__["kms_key_id"] = None
        __props__.__dict__["log_delivery_configurations"] = None
        __props__.__dict__["multi_az_enabled"] = None
        __props__.__dict__["node_group_configuration"] = None
        __props__.__dict__["notification_topic_arn"] = None
        __props__.__dict__["num_cache_clusters"] = None
        __props__.__dict__["num_node_groups"] = None
        __props__.__dict__["port"] = None
        __props__.__dict__["preferred_cache_cluster_azs"] = None
        __props__.__dict__["preferred_maintenance_window"] = None
        __props__.__dict__["primary_cluster_id"] = None
        __props__.__dict__["primary_end_point_address"] = None
        __props__.__dict__["primary_end_point_port"] = None
        __props__.__dict__["read_end_point_addresses"] = None
        __props__.__dict__["read_end_point_addresses_list"] = None
        __props__.__dict__["read_end_point_ports"] = None
        __props__.__dict__["read_end_point_ports_list"] = None
        __props__.__dict__["reader_end_point_address"] = None
        __props__.__dict__["reader_end_point_port"] = None
        __props__.__dict__["replicas_per_node_group"] = None
        __props__.__dict__["replication_group_description"] = None
        __props__.__dict__["replication_group_id"] = None
        __props__.__dict__["security_group_ids"] = None
        __props__.__dict__["snapshot_arns"] = None
        __props__.__dict__["snapshot_name"] = None
        __props__.__dict__["snapshot_retention_limit"] = None
        __props__.__dict__["snapshot_window"] = None
        __props__.__dict__["snapshotting_cluster_id"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["transit_encryption_enabled"] = None
        __props__.__dict__["user_group_ids"] = None
        return ReplicationGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="atRestEncryptionEnabled")
    def at_rest_encryption_enabled(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "at_rest_encryption_enabled")

    @property
    @pulumi.getter(name="authToken")
    def auth_token(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "auth_token")

    @property
    @pulumi.getter(name="autoMinorVersionUpgrade")
    def auto_minor_version_upgrade(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "auto_minor_version_upgrade")

    @property
    @pulumi.getter(name="automaticFailoverEnabled")
    def automatic_failover_enabled(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "automatic_failover_enabled")

    @property
    @pulumi.getter(name="cacheNodeType")
    def cache_node_type(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "cache_node_type")

    @property
    @pulumi.getter(name="cacheParameterGroupName")
    def cache_parameter_group_name(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "cache_parameter_group_name")

    @property
    @pulumi.getter(name="cacheSecurityGroupNames")
    def cache_security_group_names(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "cache_security_group_names")

    @property
    @pulumi.getter(name="cacheSubnetGroupName")
    def cache_subnet_group_name(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "cache_subnet_group_name")

    @property
    @pulumi.getter(name="configurationEndPointAddress")
    def configuration_end_point_address(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "configuration_end_point_address")

    @property
    @pulumi.getter(name="configurationEndPointPort")
    def configuration_end_point_port(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "configuration_end_point_port")

    @property
    @pulumi.getter(name="dataTieringEnabled")
    def data_tiering_enabled(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "data_tiering_enabled")

    @property
    @pulumi.getter
    def engine(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter(name="globalReplicationGroupId")
    def global_replication_group_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "global_replication_group_id")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="logDeliveryConfigurations")
    def log_delivery_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.ReplicationGroupLogDeliveryConfigurationRequest']]]:
        return pulumi.get(self, "log_delivery_configurations")

    @property
    @pulumi.getter(name="multiAZEnabled")
    def multi_az_enabled(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "multi_az_enabled")

    @property
    @pulumi.getter(name="nodeGroupConfiguration")
    def node_group_configuration(self) -> pulumi.Output[Optional[Sequence['outputs.ReplicationGroupNodeGroupConfiguration']]]:
        return pulumi.get(self, "node_group_configuration")

    @property
    @pulumi.getter(name="notificationTopicArn")
    def notification_topic_arn(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "notification_topic_arn")

    @property
    @pulumi.getter(name="numCacheClusters")
    def num_cache_clusters(self) -> pulumi.Output[Optional[int]]:
        return pulumi.get(self, "num_cache_clusters")

    @property
    @pulumi.getter(name="numNodeGroups")
    def num_node_groups(self) -> pulumi.Output[Optional[int]]:
        return pulumi.get(self, "num_node_groups")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[int]]:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="preferredCacheClusterAZs")
    def preferred_cache_cluster_azs(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "preferred_cache_cluster_azs")

    @property
    @pulumi.getter(name="preferredMaintenanceWindow")
    def preferred_maintenance_window(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "preferred_maintenance_window")

    @property
    @pulumi.getter(name="primaryClusterId")
    def primary_cluster_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "primary_cluster_id")

    @property
    @pulumi.getter(name="primaryEndPointAddress")
    def primary_end_point_address(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "primary_end_point_address")

    @property
    @pulumi.getter(name="primaryEndPointPort")
    def primary_end_point_port(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "primary_end_point_port")

    @property
    @pulumi.getter(name="readEndPointAddresses")
    def read_end_point_addresses(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "read_end_point_addresses")

    @property
    @pulumi.getter(name="readEndPointAddressesList")
    def read_end_point_addresses_list(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "read_end_point_addresses_list")

    @property
    @pulumi.getter(name="readEndPointPorts")
    def read_end_point_ports(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "read_end_point_ports")

    @property
    @pulumi.getter(name="readEndPointPortsList")
    def read_end_point_ports_list(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "read_end_point_ports_list")

    @property
    @pulumi.getter(name="readerEndPointAddress")
    def reader_end_point_address(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "reader_end_point_address")

    @property
    @pulumi.getter(name="readerEndPointPort")
    def reader_end_point_port(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "reader_end_point_port")

    @property
    @pulumi.getter(name="replicasPerNodeGroup")
    def replicas_per_node_group(self) -> pulumi.Output[Optional[int]]:
        return pulumi.get(self, "replicas_per_node_group")

    @property
    @pulumi.getter(name="replicationGroupDescription")
    def replication_group_description(self) -> pulumi.Output[str]:
        return pulumi.get(self, "replication_group_description")

    @property
    @pulumi.getter(name="replicationGroupId")
    def replication_group_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "replication_group_id")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="snapshotArns")
    def snapshot_arns(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "snapshot_arns")

    @property
    @pulumi.getter(name="snapshotName")
    def snapshot_name(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "snapshot_name")

    @property
    @pulumi.getter(name="snapshotRetentionLimit")
    def snapshot_retention_limit(self) -> pulumi.Output[Optional[int]]:
        return pulumi.get(self, "snapshot_retention_limit")

    @property
    @pulumi.getter(name="snapshotWindow")
    def snapshot_window(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "snapshot_window")

    @property
    @pulumi.getter(name="snapshottingClusterId")
    def snapshotting_cluster_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "snapshotting_cluster_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.ReplicationGroupTag']]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="transitEncryptionEnabled")
    def transit_encryption_enabled(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "transit_encryption_enabled")

    @property
    @pulumi.getter(name="userGroupIds")
    def user_group_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "user_group_ids")

