"""drop manifests

Revision ID: 6cf114485e53
Revises: 23296991a8e5
Create Date: 2020-10-17 16:27:26.467159

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql

# revision identifiers, used by Alembic.
revision = '6cf114485e53'
down_revision = '23296991a8e5'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('backups')
    op.create_index('index1', 'config', ['keyword', 'host_id'], unique=True)
    op.create_index(op.f('ix_config_host_id'), 'config', ['host_id'], unique=False)
    with op.batch_alter_table('config', schema=None) as batch_op:
        batch_op.create_foreign_key('config_ibfk_1', 'hosts', ['host_id'], ['id'])

    with op.batch_alter_table('files', schema=None) as batch_op:
        batch_op.alter_column('path',
               existing_type=mysql.VARCHAR(length=512),
               nullable=False)
    op.add_column('savesets', sa.Column('files', sa.BIGINT(), nullable=True))
    op.add_column('savesets', sa.Column('size', sa.BIGINT(), nullable=True))

    # op.drop_index('fk_backups_files', table_name='backups')
    # op.drop_index('id_UNIQUE', table_name='backups')
    # op.create_index(op.f('ix_files_host_id'), 'files', ['host_id'], unique=False)

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    """
    op.drop_index(op.f('ix_volumes_host_id'), table_name='volumes')
    op.drop_column('savesets', 'size')
    op.drop_column('savesets', 'files')
    op.drop_index(op.f('ix_files_host_id'), table_name='files')
    op.alter_column('files', 'path',
               existing_type=mysql.VARCHAR(length=512),
               nullable=True)
    op.drop_constraint(None, 'config', type_='foreignkey')
    op.drop_index(op.f('ix_config_host_id'), table_name='config')
    op.drop_index('index1', table_name='config')
    op.create_table('backups',
    sa.Column('id', mysql.BIGINT(display_width=20, unsigned=True), autoincrement=True, nullable=False),
    sa.Column('saveset_id', mysql.INTEGER(display_width=10, unsigned=True), autoincrement=False, nullable=False),
    sa.Column('volume_id', mysql.INTEGER(display_width=10, unsigned=True), autoincrement=False, nullable=False),
    sa.Column('file_id', mysql.BIGINT(display_width=20, unsigned=True), autoincrement=False, nullable=False),
    sa.ForeignKeyConstraint(['file_id'], ['files.id'], name='backups_ibfk_1'),
    sa.ForeignKeyConstraint(['saveset_id'], ['savesets.id'], name='fk_backups_savesets1', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['volume_id'], ['volumes.id'], name='fk_backups_volumes1'),
    sa.PrimaryKeyConstraint('id'),
    mysql_default_charset='utf8',
    mysql_engine='InnoDB'
    )
    op.create_index('id_UNIQUE', 'backups', ['id'], unique=True)
    op.create_index('fk_backups_files', 'backups', ['file_id'], unique=False)
    """
    # ### end Alembic commands ###
    pass
