# mypy-boto3-elb

[![PyPI - mypy-boto3-elb](https://img.shields.io/pypi/v/mypy-boto3-elb.svg?color=blue)](https://pypi.org/project/mypy-boto3-elb)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-elb.svg?color=blue)](https://pypi.org/project/mypy-boto3-elb)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.ElasticLoadBalancing 1.17.16](https://boto3.amazonaws.com/v1/documentation/api/1.17.16/reference/services/elb.html#ElasticLoadBalancing) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 4.4.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-elb](#mypy-boto3-elb)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `ElasticLoadBalancing` service.

```bash
python -m pip install boto3-stubs[elb]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[elb]` in your environment: `python -m pip install 'boto3-stubs[elb]'`

Both type checking and auto-complete should work for `ElasticLoadBalancing` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[elb]` in your environment: `python -m pip install 'boto3-stubs[elb]'`

Both type checking and auto-complete should work for `ElasticLoadBalancing` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[elb]` in your environment: `python -m pip install 'boto3-stubs[elb]'`
- Run `mypy` as usual

Type checking should work for `ElasticLoadBalancing` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[elb]` in your environment: `python -m pip install 'boto3-stubs[elb]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `ElasticLoadBalancing` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`ElasticLoadBalancingClient` provides annotations for `boto3.client("elb")`.

```python
import boto3

from mypy_boto3_elb import ElasticLoadBalancingClient

client: ElasticLoadBalancingClient = boto3.client("elb")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: ElasticLoadBalancingClient = session.client("elb")
```

### Paginators annotations

`mypy_boto3_elb.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_elb import ElasticLoadBalancingClient
from mypy_boto3_elb.paginator import (
    DescribeAccountLimitsPaginator,
    DescribeLoadBalancersPaginator,
)

client: ElasticLoadBalancingClient = boto3.client("elb")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_account_limits_paginator: DescribeAccountLimitsPaginator = client.get_paginator("describe_account_limits")
describe_load_balancers_paginator: DescribeLoadBalancersPaginator = client.get_paginator("describe_load_balancers")
```


### Waiters annotations

`mypy_boto3_elb.waiter` module contains type annotations for all waiters.

```python
from mypy_boto3_elb import ElasticLoadBalancingClient
from mypy_boto3_elb.waiter import (
    AnyInstanceInServiceWaiter,
    InstanceDeregisteredWaiter,
    InstanceInServiceWaiter,
)

client: ElasticLoadBalancingClient = boto3.client("elb")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
any_instance_in_service_waiter: AnyInstanceInServiceWaiter = client.get_waiter("any_instance_in_service")
instance_deregistered_waiter: InstanceDeregisteredWaiter = client.get_waiter("instance_deregistered")
instance_in_service_waiter: InstanceInServiceWaiter = client.get_waiter("instance_in_service")
```





### Typed dictionations

`mypy_boto3_elb.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_elb.type_defs import (
    AccessLogTypeDef,
    AdditionalAttributeTypeDef,
    AppCookieStickinessPolicyTypeDef,
    BackendServerDescriptionTypeDef,
    ConnectionDrainingTypeDef,
    ConnectionSettingsTypeDef,
    CrossZoneLoadBalancingTypeDef,
    HealthCheckTypeDef,
    InstanceStateTypeDef,
    InstanceTypeDef,
    LBCookieStickinessPolicyTypeDef,
    LimitTypeDef,
    ListenerDescriptionTypeDef,
    ListenerTypeDef,
    LoadBalancerAttributesTypeDef,
    LoadBalancerDescriptionTypeDef,
    PoliciesTypeDef,
    PolicyAttributeDescriptionTypeDef,
    PolicyAttributeTypeDescriptionTypeDef,
    PolicyDescriptionTypeDef,
    PolicyTypeDescriptionTypeDef,
    ResponseMetadata,
    SourceSecurityGroupTypeDef,
    TagDescriptionTypeDef,
    TagTypeDef,
    AddAvailabilityZonesOutputTypeDef,
    ApplySecurityGroupsToLoadBalancerOutputTypeDef,
    AttachLoadBalancerToSubnetsOutputTypeDef,
    ConfigureHealthCheckOutputTypeDef,
    CreateAccessPointOutputTypeDef,
    DeregisterEndPointsOutputTypeDef,
    DescribeAccessPointsOutputTypeDef,
    DescribeAccountLimitsOutputTypeDef,
    DescribeEndPointStateOutputTypeDef,
    DescribeLoadBalancerAttributesOutputTypeDef,
    DescribeLoadBalancerPoliciesOutputTypeDef,
    DescribeLoadBalancerPolicyTypesOutputTypeDef,
    DescribeTagsOutputTypeDef,
    DetachLoadBalancerFromSubnetsOutputTypeDef,
    ModifyLoadBalancerAttributesOutputTypeDef,
    PaginatorConfigTypeDef,
    PolicyAttributeTypeDef,
    RegisterEndPointsOutputTypeDef,
    RemoveAvailabilityZonesOutputTypeDef,
    TagKeyOnlyTypeDef,
    WaiterConfigTypeDef,
)

def get_structure() -> AccessLogTypeDef:
    return {
      ...
    }
```
