"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DockerCredential = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Represents a credential used to authenticate to a docker registry.
 * Uses the official Docker Login GitHub Action to authenticate.
 *
 * @see https://github.com/marketplace/actions/docker-login
 */
class DockerCredential {
    constructor(name, registry, usernameKey, passwordKey) {
        this.name = name;
        this.registry = registry;
        this.usernameKey = usernameKey;
        this.passwordKey = passwordKey;
    }
    /**
     * Reference credential secrets to authenticate to DockerHub. This method assumes
     * that your credentials will be stored as long-lived GitHub Secrets under the
     * usernameKey and personalAccessTokenKey.
     *
     * The default for usernameKey is `DOCKERHUB_USERNAME`. The default for personalAccessTokenKey
     * is `DOCKERHUB_TOKEN`. If you do not set these values, your credentials should be
     * found in your GitHub Secrets under these default keys.
     */
    static dockerHub(creds = {}) {
        return new DockerCredential('docker', undefined, creds.usernameKey ?? 'DOCKERHUB_USERNAME', creds.personalAccessTokenKey ?? 'DOCKERHUB_TOKEN');
    }
    /**
     * Create a credential for ECR. This method will reuse your AWS credentials to log in to AWS.
     * Your AWS credentials are already used to deploy your CDK stacks. It can be supplied via
     * GitHub Secrets or using an IAM role that trusts the GitHub OIDC identity provider.
     *
     * NOTE - All ECR repositories in the same account and region share a domain name
     * (e.g., 0123456789012.dkr.ecr.eu-west-1.amazonaws.com), and can only have one associated
     * set of credentials (and DockerCredential). Attempting to associate one set of credentials
     * with one ECR repo and another with another ECR repo in the same account and region will
     * result in failures when using these credentials in the pipeline.
     */
    static ecr(registry) {
        return new DockerCredential('ecr', registry);
    }
    /**
     * Create a credential for a custom registry. This method assumes that you will have long-lived
     * GitHub Secrets stored under the usernameKey and passwordKey that will authenticate to the
     * registry you provide.
     *
     * @see https://github.com/marketplace/actions/docker-login
     */
    static customRegistry(registry, creds) {
        return new DockerCredential('custom', registry, creds.usernameKey, creds.passwordKey);
    }
}
exports.DockerCredential = DockerCredential;
_a = JSII_RTTI_SYMBOL_1;
DockerCredential[_a] = { fqn: "cdk-pipelines-github.DockerCredential", version: "0.3.118" };
//# sourceMappingURL=data:application/json;base64,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