"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoadBalancer = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
class LoadBalancer {
    static metrics(name, full_name) {
        let header = new aws_cloudwatch_1.TextWidget({
            width: 24,
            height: 1,
            markdown: `# ${name} - Application Load Balancer`,
        });
        let requestCountMetric = new aws_cloudwatch_1.Metric({
            namespace: 'AWS/ApplicationELB',
            metricName: 'RequestCount',
            dimensionsMap: {
                LoadBalancer: full_name,
            },
            period: aws_cdk_lib_1.Duration.seconds(300),
            statistic: 'Sum',
        });
        let responseTimeMetric = new aws_cloudwatch_1.Metric({
            namespace: 'AWS/ApplicationELB',
            metricName: 'TargetResponseTime',
            dimensionsMap: {
                LoadBalancer: full_name,
            },
            period: aws_cdk_lib_1.Duration.seconds(300),
        });
        let requestCount = new aws_cloudwatch_1.GraphWidget({
            height: 6,
            width: 12,
        });
        requestCount.addRightMetric(requestCountMetric);
        requestCount.addLeftMetric(new aws_cloudwatch_1.MathExpression({
            expression: 'ANOMALY_DETECTION_BAND(m1, 2)',
            label: 'RequestCount (expected)',
            period: aws_cdk_lib_1.Duration.seconds(300),
            color: '#666666',
            usingMetrics: {
                m1: requestCountMetric,
            },
        }));
        let responseTime = new aws_cloudwatch_1.GraphWidget({
            height: 6,
            width: 12,
        });
        responseTime.addLeftMetric(new aws_cloudwatch_1.MathExpression({
            expression: 'ANOMALY_DETECTION_BAND(m1, 2)',
            label: 'TargetResponseTime (expected)',
            period: aws_cdk_lib_1.Duration.seconds(300),
            color: '#666666',
            usingMetrics: {
                m1: responseTimeMetric,
            },
        }));
        responseTime.addRightMetric(responseTimeMetric);
        return [header, requestCount, responseTime];
    }
}
exports.LoadBalancer = LoadBalancer;
//# sourceMappingURL=data:application/json;base64,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