"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoScaling = void 0;
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
class AutoScaling {
    static metrics(name, max_capacity) {
        let header = new aws_cloudwatch_1.TextWidget({
            width: 24,
            height: 1,
            markdown: `# ${name} - Auto Scaling Group`,
        });
        let groupInServiceInstancesMetric = new aws_cloudwatch_1.Metric({
            namespace: 'AWS/AutoScaling',
            metricName: 'GroupInServiceInstances',
            dimensionsMap: {
                AutoScalingGroupName: name,
            },
        });
        let leftAnnotations = null;
        if (typeof (max_capacity) == 'number') {
            leftAnnotations = [
                {
                    label: 'Max Instances in ASG',
                    value: max_capacity,
                },
            ];
        }
        let GroupInServiceInstancesProps = {
            height: 6,
            width: 12,
            leftYAxis: {
                min: 0,
                label: 'Instances',
                showUnits: false,
            },
            leftAnnotations: leftAnnotations,
        };
        let GroupInServiceInstances = new aws_cloudwatch_1.GraphWidget(GroupInServiceInstancesProps);
        GroupInServiceInstances.addRightMetric(groupInServiceInstancesMetric);
        GroupInServiceInstances.addLeftMetric(new aws_cloudwatch_1.MathExpression({
            expression: 'ANOMALY_DETECTION_BAND(m1, 2)',
            label: 'GroupInServiceInstances (expected)',
            color: '#666666',
            usingMetrics: {
                m1: groupInServiceInstancesMetric,
            },
        }));
        let cpuUtilizationAverageMetric = new aws_cloudwatch_1.Metric({
            namespace: 'AWS/EC2',
            metricName: 'CPUUtilization',
            dimensionsMap: {
                AutoScalingGroupName: name,
            },
            statistic: 'Average',
        });
        let cpuUtilizationAverage = new aws_cloudwatch_1.GraphWidget({
            height: 6,
            width: 12,
        });
        cpuUtilizationAverage.addRightMetric(cpuUtilizationAverageMetric);
        cpuUtilizationAverage.addLeftMetric(new aws_cloudwatch_1.MathExpression({
            expression: 'ANOMALY_DETECTION_BAND(m1, 2)',
            label: 'Average CPUUtilization (expected)',
            color: '#666666',
            usingMetrics: {
                m1: cpuUtilizationAverageMetric,
            },
        }));
        let cpuUtilizationMaximumMetric = new aws_cloudwatch_1.Metric({
            namespace: 'AWS/EC2',
            metricName: 'CPUUtilization',
            dimensionsMap: {
                AutoScalingGroupName: name,
            },
            statistic: 'Maximum',
        });
        let cpuUtilizationMaximum = new aws_cloudwatch_1.GraphWidget({
            height: 6,
            width: 12,
        });
        cpuUtilizationMaximum.addRightMetric(cpuUtilizationMaximumMetric);
        cpuUtilizationMaximum.addLeftMetric(new aws_cloudwatch_1.MathExpression({
            expression: 'ANOMALY_DETECTION_BAND(m1, 2)',
            label: 'Maximum CPUUtilization (expected)',
            color: '#666666',
            usingMetrics: {
                m1: cpuUtilizationMaximumMetric,
            },
        }));
        let networkInMetric = new aws_cloudwatch_1.Metric({
            namespace: 'AWS/EC2',
            metricName: 'NetworkIn',
            dimensionsMap: {
                AutoScalingGroupName: name,
            },
            statistic: 'Average',
        });
        let networkIn = new aws_cloudwatch_1.GraphWidget({
            height: 6,
            width: 12,
        });
        networkIn.addRightMetric(networkInMetric);
        networkIn.addLeftMetric(new aws_cloudwatch_1.MathExpression({
            expression: 'ANOMALY_DETECTION_BAND(m1, 2)',
            label: 'NetworkIn (expected)',
            color: '#666666',
            usingMetrics: {
                m1: networkInMetric,
            },
        }));
        let networkOutMetric = new aws_cloudwatch_1.Metric({
            namespace: 'AWS/EC2',
            metricName: 'NetworkOut',
            dimensionsMap: {
                AutoScalingGroupName: name,
            },
            statistic: 'Average',
        });
        let networkOut = new aws_cloudwatch_1.GraphWidget({
            height: 6,
            width: 12,
        });
        networkOut.addRightMetric(networkOutMetric);
        networkOut.addLeftMetric(new aws_cloudwatch_1.MathExpression({
            expression: 'ANOMALY_DETECTION_BAND(m1, 2)',
            label: 'NetworkOut (expected)',
            color: '#666666',
            usingMetrics: {
                m1: networkOutMetric,
            },
        }));
        return [header, GroupInServiceInstances, cpuUtilizationAverage, cpuUtilizationMaximum, networkIn, networkOut];
    }
}
exports.AutoScaling = AutoScaling;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXV0by1zY2FsaW5nLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL2F1dG8tc2NhbGluZy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSwrREFBd0g7QUFFeEgsTUFBYSxXQUFXO0lBQ3RCLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBWSxFQUFFLFlBQXFCO1FBQ2hELElBQUksTUFBTSxHQUFHLElBQUksMkJBQVUsQ0FBQztZQUMxQixLQUFLLEVBQUUsRUFBRTtZQUNULE1BQU0sRUFBRSxDQUFDO1lBQ1QsUUFBUSxFQUFFLEtBQUssSUFBSSx1QkFBdUI7U0FDM0MsQ0FBQyxDQUFDO1FBQ0gsSUFBSSw2QkFBNkIsR0FBRyxJQUFJLHVCQUFNLENBQUM7WUFDN0MsU0FBUyxFQUFFLGlCQUFpQjtZQUM1QixVQUFVLEVBQUUseUJBQXlCO1lBQ3JDLGFBQWEsRUFBRTtnQkFDYixvQkFBb0IsRUFBRSxJQUFLO2FBQzVCO1NBQ0YsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxlQUFlLEdBQVEsSUFBSSxDQUFDO1FBQ2hDLElBQUssT0FBTSxDQUFDLFlBQVksQ0FBQyxJQUFJLFFBQVEsRUFBRTtZQUNyQyxlQUFlLEdBQUc7Z0JBQ2hCO29CQUNFLEtBQUssRUFBRSxzQkFBc0I7b0JBQzdCLEtBQUssRUFBRSxZQUFZO2lCQUNwQjthQUNGLENBQUM7U0FDSDtRQUNELElBQUksNEJBQTRCLEdBQW9CO1lBQ2xELE1BQU0sRUFBRSxDQUFDO1lBQ1QsS0FBSyxFQUFFLEVBQUU7WUFDVCxTQUFTLEVBQUU7Z0JBQ1QsR0FBRyxFQUFFLENBQUM7Z0JBQ04sS0FBSyxFQUFFLFdBQVc7Z0JBQ2xCLFNBQVMsRUFBRSxLQUFLO2FBQ2pCO1lBQ0QsZUFBZSxFQUFFLGVBQWU7U0FDakMsQ0FBQztRQUNGLElBQUksdUJBQXVCLEdBQUcsSUFBSSw0QkFBVyxDQUFDLDRCQUE0QixDQUFDLENBQUM7UUFDNUUsdUJBQXVCLENBQUMsY0FBYyxDQUFDLDZCQUE2QixDQUFDLENBQUM7UUFDdEUsdUJBQXVCLENBQUMsYUFBYSxDQUNuQyxJQUFJLCtCQUFjLENBQUM7WUFDakIsVUFBVSxFQUFFLCtCQUErQjtZQUMzQyxLQUFLLEVBQUUsb0NBQW9DO1lBQzNDLEtBQUssRUFBRSxTQUFTO1lBQ2hCLFlBQVksRUFBRTtnQkFDWixFQUFFLEVBQUUsNkJBQTZCO2FBQ2xDO1NBQ0YsQ0FBQyxDQUNILENBQUM7UUFFRixJQUFJLDJCQUEyQixHQUFHLElBQUksdUJBQU0sQ0FBQztZQUMzQyxTQUFTLEVBQUUsU0FBUztZQUNwQixVQUFVLEVBQUUsZ0JBQWdCO1lBQzVCLGFBQWEsRUFBRTtnQkFDYixvQkFBb0IsRUFBRSxJQUFLO2FBQzVCO1lBQ0QsU0FBUyxFQUFFLFNBQVM7U0FDckIsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxxQkFBcUIsR0FBRyxJQUFJLDRCQUFXLENBQUM7WUFDMUMsTUFBTSxFQUFFLENBQUM7WUFDVCxLQUFLLEVBQUUsRUFBRTtTQUNWLENBQUMsQ0FBQztRQUNILHFCQUFxQixDQUFDLGNBQWMsQ0FBQywyQkFBMkIsQ0FBQyxDQUFDO1FBQ2xFLHFCQUFxQixDQUFDLGFBQWEsQ0FDakMsSUFBSSwrQkFBYyxDQUFDO1lBQ2pCLFVBQVUsRUFBRSwrQkFBK0I7WUFDM0MsS0FBSyxFQUFFLG1DQUFtQztZQUMxQyxLQUFLLEVBQUUsU0FBUztZQUNoQixZQUFZLEVBQUU7Z0JBQ1osRUFBRSxFQUFFLDJCQUEyQjthQUNoQztTQUNGLENBQUMsQ0FDSCxDQUFDO1FBRUYsSUFBSSwyQkFBMkIsR0FBRyxJQUFJLHVCQUFNLENBQUM7WUFDM0MsU0FBUyxFQUFFLFNBQVM7WUFDcEIsVUFBVSxFQUFFLGdCQUFnQjtZQUM1QixhQUFhLEVBQUU7Z0JBQ2Isb0JBQW9CLEVBQUUsSUFBSzthQUM1QjtZQUNELFNBQVMsRUFBRSxTQUFTO1NBQ3JCLENBQUMsQ0FBQztRQUNILElBQUkscUJBQXFCLEdBQUcsSUFBSSw0QkFBVyxDQUFDO1lBQzFDLE1BQU0sRUFBRSxDQUFDO1lBQ1QsS0FBSyxFQUFFLEVBQUU7U0FDVixDQUFDLENBQUM7UUFDSCxxQkFBcUIsQ0FBQyxjQUFjLENBQUMsMkJBQTJCLENBQUMsQ0FBQztRQUNsRSxxQkFBcUIsQ0FBQyxhQUFhLENBQ2pDLElBQUksK0JBQWMsQ0FBQztZQUNqQixVQUFVLEVBQUUsK0JBQStCO1lBQzNDLEtBQUssRUFBRSxtQ0FBbUM7WUFDMUMsS0FBSyxFQUFFLFNBQVM7WUFDaEIsWUFBWSxFQUFFO2dCQUNaLEVBQUUsRUFBRSwyQkFBMkI7YUFDaEM7U0FDRixDQUFDLENBQ0gsQ0FBQztRQUVGLElBQUksZUFBZSxHQUFHLElBQUksdUJBQU0sQ0FBQztZQUMvQixTQUFTLEVBQUUsU0FBUztZQUNwQixVQUFVLEVBQUUsV0FBVztZQUN2QixhQUFhLEVBQUU7Z0JBQ2Isb0JBQW9CLEVBQUUsSUFBSzthQUM1QjtZQUNELFNBQVMsRUFBRSxTQUFTO1NBQ3JCLENBQUMsQ0FBQztRQUNILElBQUksU0FBUyxHQUFHLElBQUksNEJBQVcsQ0FBQztZQUM5QixNQUFNLEVBQUUsQ0FBQztZQUNULEtBQUssRUFBRSxFQUFFO1NBQ1YsQ0FBQyxDQUFDO1FBQ0gsU0FBUyxDQUFDLGNBQWMsQ0FBQyxlQUFlLENBQUMsQ0FBQztRQUMxQyxTQUFTLENBQUMsYUFBYSxDQUNyQixJQUFJLCtCQUFjLENBQUM7WUFDakIsVUFBVSxFQUFFLCtCQUErQjtZQUMzQyxLQUFLLEVBQUUsc0JBQXNCO1lBQzdCLEtBQUssRUFBRSxTQUFTO1lBQ2hCLFlBQVksRUFBRTtnQkFDWixFQUFFLEVBQUUsZUFBZTthQUNwQjtTQUNGLENBQUMsQ0FDSCxDQUFDO1FBRUYsSUFBSSxnQkFBZ0IsR0FBRyxJQUFJLHVCQUFNLENBQUM7WUFDaEMsU0FBUyxFQUFFLFNBQVM7WUFDcEIsVUFBVSxFQUFFLFlBQVk7WUFDeEIsYUFBYSxFQUFFO2dCQUNiLG9CQUFvQixFQUFFLElBQUs7YUFDNUI7WUFDRCxTQUFTLEVBQUUsU0FBUztTQUNyQixDQUFDLENBQUM7UUFDSCxJQUFJLFVBQVUsR0FBRyxJQUFJLDRCQUFXLENBQUM7WUFDL0IsTUFBTSxFQUFFLENBQUM7WUFDVCxLQUFLLEVBQUUsRUFBRTtTQUNWLENBQUMsQ0FBQztRQUNILFVBQVUsQ0FBQyxjQUFjLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztRQUM1QyxVQUFVLENBQUMsYUFBYSxDQUN0QixJQUFJLCtCQUFjLENBQUM7WUFDakIsVUFBVSxFQUFFLCtCQUErQjtZQUMzQyxLQUFLLEVBQUUsdUJBQXVCO1lBQzlCLEtBQUssRUFBRSxTQUFTO1lBQ2hCLFlBQVksRUFBRTtnQkFDWixFQUFFLEVBQUUsZ0JBQWdCO2FBQ3JCO1NBQ0YsQ0FBQyxDQUNILENBQUM7UUFFRixPQUFPLENBQUMsTUFBTSxFQUFFLHVCQUF1QixFQUFFLHFCQUFxQixFQUFFLHFCQUFxQixFQUFFLFNBQVMsRUFBRSxVQUFVLENBQUMsQ0FBQztJQUNoSCxDQUFDO0NBQ0Y7QUFoSkQsa0NBZ0pDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgSVdpZGdldCwgVGV4dFdpZGdldCwgTWV0cmljLCBHcmFwaFdpZGdldCwgTWF0aEV4cHJlc3Npb24sIEdyYXBoV2lkZ2V0UHJvcHMgfSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtY2xvdWR3YXRjaCc7XG5cbmV4cG9ydCBjbGFzcyBBdXRvU2NhbGluZyB7XG4gIHN0YXRpYyBtZXRyaWNzKG5hbWU/OnN0cmluZywgbWF4X2NhcGFjaXR5PzogbnVtYmVyKTogSVdpZGdldFtdIHtcbiAgICBsZXQgaGVhZGVyID0gbmV3IFRleHRXaWRnZXQoe1xuICAgICAgd2lkdGg6IDI0LFxuICAgICAgaGVpZ2h0OiAxLFxuICAgICAgbWFya2Rvd246IGAjICR7bmFtZX0gLSBBdXRvIFNjYWxpbmcgR3JvdXBgLFxuICAgIH0pO1xuICAgIGxldCBncm91cEluU2VydmljZUluc3RhbmNlc01ldHJpYyA9IG5ldyBNZXRyaWMoe1xuICAgICAgbmFtZXNwYWNlOiAnQVdTL0F1dG9TY2FsaW5nJyxcbiAgICAgIG1ldHJpY05hbWU6ICdHcm91cEluU2VydmljZUluc3RhbmNlcycsXG4gICAgICBkaW1lbnNpb25zTWFwOiB7XG4gICAgICAgIEF1dG9TY2FsaW5nR3JvdXBOYW1lOiBuYW1lISxcbiAgICAgIH0sXG4gICAgfSk7XG4gICAgbGV0IGxlZnRBbm5vdGF0aW9uczogYW55ID0gbnVsbDtcbiAgICBpZiAoIHR5cGVvZihtYXhfY2FwYWNpdHkpID09ICdudW1iZXInKSB7XG4gICAgICBsZWZ0QW5ub3RhdGlvbnMgPSBbXG4gICAgICAgIHtcbiAgICAgICAgICBsYWJlbDogJ01heCBJbnN0YW5jZXMgaW4gQVNHJyxcbiAgICAgICAgICB2YWx1ZTogbWF4X2NhcGFjaXR5LFxuICAgICAgICB9LFxuICAgICAgXTtcbiAgICB9XG4gICAgbGV0IEdyb3VwSW5TZXJ2aWNlSW5zdGFuY2VzUHJvcHM6R3JhcGhXaWRnZXRQcm9wcyA9IHtcbiAgICAgIGhlaWdodDogNixcbiAgICAgIHdpZHRoOiAxMixcbiAgICAgIGxlZnRZQXhpczoge1xuICAgICAgICBtaW46IDAsXG4gICAgICAgIGxhYmVsOiAnSW5zdGFuY2VzJyxcbiAgICAgICAgc2hvd1VuaXRzOiBmYWxzZSxcbiAgICAgIH0sXG4gICAgICBsZWZ0QW5ub3RhdGlvbnM6IGxlZnRBbm5vdGF0aW9ucyxcbiAgICB9O1xuICAgIGxldCBHcm91cEluU2VydmljZUluc3RhbmNlcyA9IG5ldyBHcmFwaFdpZGdldChHcm91cEluU2VydmljZUluc3RhbmNlc1Byb3BzKTtcbiAgICBHcm91cEluU2VydmljZUluc3RhbmNlcy5hZGRSaWdodE1ldHJpYyhncm91cEluU2VydmljZUluc3RhbmNlc01ldHJpYyk7XG4gICAgR3JvdXBJblNlcnZpY2VJbnN0YW5jZXMuYWRkTGVmdE1ldHJpYyhcbiAgICAgIG5ldyBNYXRoRXhwcmVzc2lvbih7XG4gICAgICAgIGV4cHJlc3Npb246ICdBTk9NQUxZX0RFVEVDVElPTl9CQU5EKG0xLCAyKScsXG4gICAgICAgIGxhYmVsOiAnR3JvdXBJblNlcnZpY2VJbnN0YW5jZXMgKGV4cGVjdGVkKScsXG4gICAgICAgIGNvbG9yOiAnIzY2NjY2NicsXG4gICAgICAgIHVzaW5nTWV0cmljczoge1xuICAgICAgICAgIG0xOiBncm91cEluU2VydmljZUluc3RhbmNlc01ldHJpYyxcbiAgICAgICAgfSxcbiAgICAgIH0pLFxuICAgICk7XG5cbiAgICBsZXQgY3B1VXRpbGl6YXRpb25BdmVyYWdlTWV0cmljID0gbmV3IE1ldHJpYyh7XG4gICAgICBuYW1lc3BhY2U6ICdBV1MvRUMyJyxcbiAgICAgIG1ldHJpY05hbWU6ICdDUFVVdGlsaXphdGlvbicsXG4gICAgICBkaW1lbnNpb25zTWFwOiB7XG4gICAgICAgIEF1dG9TY2FsaW5nR3JvdXBOYW1lOiBuYW1lISxcbiAgICAgIH0sXG4gICAgICBzdGF0aXN0aWM6ICdBdmVyYWdlJyxcbiAgICB9KTtcbiAgICBsZXQgY3B1VXRpbGl6YXRpb25BdmVyYWdlID0gbmV3IEdyYXBoV2lkZ2V0KHtcbiAgICAgIGhlaWdodDogNixcbiAgICAgIHdpZHRoOiAxMixcbiAgICB9KTtcbiAgICBjcHVVdGlsaXphdGlvbkF2ZXJhZ2UuYWRkUmlnaHRNZXRyaWMoY3B1VXRpbGl6YXRpb25BdmVyYWdlTWV0cmljKTtcbiAgICBjcHVVdGlsaXphdGlvbkF2ZXJhZ2UuYWRkTGVmdE1ldHJpYyhcbiAgICAgIG5ldyBNYXRoRXhwcmVzc2lvbih7XG4gICAgICAgIGV4cHJlc3Npb246ICdBTk9NQUxZX0RFVEVDVElPTl9CQU5EKG0xLCAyKScsXG4gICAgICAgIGxhYmVsOiAnQXZlcmFnZSBDUFVVdGlsaXphdGlvbiAoZXhwZWN0ZWQpJyxcbiAgICAgICAgY29sb3I6ICcjNjY2NjY2JyxcbiAgICAgICAgdXNpbmdNZXRyaWNzOiB7XG4gICAgICAgICAgbTE6IGNwdVV0aWxpemF0aW9uQXZlcmFnZU1ldHJpYyxcbiAgICAgICAgfSxcbiAgICAgIH0pLFxuICAgICk7XG5cbiAgICBsZXQgY3B1VXRpbGl6YXRpb25NYXhpbXVtTWV0cmljID0gbmV3IE1ldHJpYyh7XG4gICAgICBuYW1lc3BhY2U6ICdBV1MvRUMyJyxcbiAgICAgIG1ldHJpY05hbWU6ICdDUFVVdGlsaXphdGlvbicsXG4gICAgICBkaW1lbnNpb25zTWFwOiB7XG4gICAgICAgIEF1dG9TY2FsaW5nR3JvdXBOYW1lOiBuYW1lISxcbiAgICAgIH0sXG4gICAgICBzdGF0aXN0aWM6ICdNYXhpbXVtJyxcbiAgICB9KTtcbiAgICBsZXQgY3B1VXRpbGl6YXRpb25NYXhpbXVtID0gbmV3IEdyYXBoV2lkZ2V0KHtcbiAgICAgIGhlaWdodDogNixcbiAgICAgIHdpZHRoOiAxMixcbiAgICB9KTtcbiAgICBjcHVVdGlsaXphdGlvbk1heGltdW0uYWRkUmlnaHRNZXRyaWMoY3B1VXRpbGl6YXRpb25NYXhpbXVtTWV0cmljKTtcbiAgICBjcHVVdGlsaXphdGlvbk1heGltdW0uYWRkTGVmdE1ldHJpYyhcbiAgICAgIG5ldyBNYXRoRXhwcmVzc2lvbih7XG4gICAgICAgIGV4cHJlc3Npb246ICdBTk9NQUxZX0RFVEVDVElPTl9CQU5EKG0xLCAyKScsXG4gICAgICAgIGxhYmVsOiAnTWF4aW11bSBDUFVVdGlsaXphdGlvbiAoZXhwZWN0ZWQpJyxcbiAgICAgICAgY29sb3I6ICcjNjY2NjY2JyxcbiAgICAgICAgdXNpbmdNZXRyaWNzOiB7XG4gICAgICAgICAgbTE6IGNwdVV0aWxpemF0aW9uTWF4aW11bU1ldHJpYyxcbiAgICAgICAgfSxcbiAgICAgIH0pLFxuICAgICk7XG5cbiAgICBsZXQgbmV0d29ya0luTWV0cmljID0gbmV3IE1ldHJpYyh7XG4gICAgICBuYW1lc3BhY2U6ICdBV1MvRUMyJyxcbiAgICAgIG1ldHJpY05hbWU6ICdOZXR3b3JrSW4nLFxuICAgICAgZGltZW5zaW9uc01hcDoge1xuICAgICAgICBBdXRvU2NhbGluZ0dyb3VwTmFtZTogbmFtZSEsXG4gICAgICB9LFxuICAgICAgc3RhdGlzdGljOiAnQXZlcmFnZScsXG4gICAgfSk7XG4gICAgbGV0IG5ldHdvcmtJbiA9IG5ldyBHcmFwaFdpZGdldCh7XG4gICAgICBoZWlnaHQ6IDYsXG4gICAgICB3aWR0aDogMTIsXG4gICAgfSk7XG4gICAgbmV0d29ya0luLmFkZFJpZ2h0TWV0cmljKG5ldHdvcmtJbk1ldHJpYyk7XG4gICAgbmV0d29ya0luLmFkZExlZnRNZXRyaWMoXG4gICAgICBuZXcgTWF0aEV4cHJlc3Npb24oe1xuICAgICAgICBleHByZXNzaW9uOiAnQU5PTUFMWV9ERVRFQ1RJT05fQkFORChtMSwgMiknLFxuICAgICAgICBsYWJlbDogJ05ldHdvcmtJbiAoZXhwZWN0ZWQpJyxcbiAgICAgICAgY29sb3I6ICcjNjY2NjY2JyxcbiAgICAgICAgdXNpbmdNZXRyaWNzOiB7XG4gICAgICAgICAgbTE6IG5ldHdvcmtJbk1ldHJpYyxcbiAgICAgICAgfSxcbiAgICAgIH0pLFxuICAgICk7XG5cbiAgICBsZXQgbmV0d29ya091dE1ldHJpYyA9IG5ldyBNZXRyaWMoe1xuICAgICAgbmFtZXNwYWNlOiAnQVdTL0VDMicsXG4gICAgICBtZXRyaWNOYW1lOiAnTmV0d29ya091dCcsXG4gICAgICBkaW1lbnNpb25zTWFwOiB7XG4gICAgICAgIEF1dG9TY2FsaW5nR3JvdXBOYW1lOiBuYW1lISxcbiAgICAgIH0sXG4gICAgICBzdGF0aXN0aWM6ICdBdmVyYWdlJyxcbiAgICB9KTtcbiAgICBsZXQgbmV0d29ya091dCA9IG5ldyBHcmFwaFdpZGdldCh7XG4gICAgICBoZWlnaHQ6IDYsXG4gICAgICB3aWR0aDogMTIsXG4gICAgfSk7XG4gICAgbmV0d29ya091dC5hZGRSaWdodE1ldHJpYyhuZXR3b3JrT3V0TWV0cmljKTtcbiAgICBuZXR3b3JrT3V0LmFkZExlZnRNZXRyaWMoXG4gICAgICBuZXcgTWF0aEV4cHJlc3Npb24oe1xuICAgICAgICBleHByZXNzaW9uOiAnQU5PTUFMWV9ERVRFQ1RJT05fQkFORChtMSwgMiknLFxuICAgICAgICBsYWJlbDogJ05ldHdvcmtPdXQgKGV4cGVjdGVkKScsXG4gICAgICAgIGNvbG9yOiAnIzY2NjY2NicsXG4gICAgICAgIHVzaW5nTWV0cmljczoge1xuICAgICAgICAgIG0xOiBuZXR3b3JrT3V0TWV0cmljLFxuICAgICAgICB9LFxuICAgICAgfSksXG4gICAgKTtcblxuICAgIHJldHVybiBbaGVhZGVyLCBHcm91cEluU2VydmljZUluc3RhbmNlcywgY3B1VXRpbGl6YXRpb25BdmVyYWdlLCBjcHVVdGlsaXphdGlvbk1heGltdW0sIG5ldHdvcmtJbiwgbmV0d29ya091dF07XG4gIH1cbn0iXX0=