## Description

PyGPE is a CUDA-accelerated Python library for solving the Gross-Pitaevskii equations for use in simulating
Bose-Einstein condensate systems.

- Documentation: https://wheelermt.github.io/pygpe-docs/

### Supported features

- Scalar, spin-1, and spin-2 BEC systems.
- 1D, 2D, and 3D grid lattices.
- HDF5 data saving system.
- Method for generating vortices within the system.

### Requirements

- Python (3.9 and above),
- [h5py](https://github.com/h5py/h5py) (>=3.6.0),
- CUDA Toolkit (>=11.2)
- [CuPy](https://github.com/cupy/cupy) (>=10.2.0).
