"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TmUserPoolClient = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const cognito = require("aws-cdk-lib/aws-cognito");
const constructs_1 = require("constructs");
class TmUserPoolClient extends constructs_1.Construct {
    constructor(scope, id, userPoolProps = {}, userPoolClientProps = {}) {
        super(scope, id);
        this.defaultUserPoolProps = {
            signInCaseSensitive: false,
            selfSignUpEnabled: true,
            passwordPolicy: {
                minLength: 12,
                requireDigits: true,
                requireLowercase: true,
                requireUppercase: true,
            },
            signInAliases: {
                email: true,
                phone: false,
                username: false,
                preferredUsername: false,
            },
        };
        this.defaultUserPoolClientProps = {
            oAuth: {
                flows: {
                    authorizationCodeGrant: true
                },
                callbackUrls: ["http://localhost:8000/oauth2/token"],
                logoutUrls: ["http://localhost:8000/logged-out"],
                scopes: [cognito.OAuthScope.EMAIL, cognito.OAuthScope.OPENID]
            },
            idTokenValidity: aws_cdk_lib_1.Duration.hours(24)
        };
        let luserPoolProps = {
            ...this.defaultUserPoolProps,
            ...userPoolProps
        };
        this.userPool = new cognito.UserPool(this, `${id}-userpool`, luserPoolProps);
        let lUserPoolClientProps = {
            userPool: this.userPool,
            ...this.defaultUserPoolClientProps,
            ...userPoolClientProps
        };
        //
        this.userPoolClientSecret = new cognito.UserPoolClient(this, "UserPoolClientSecret", { ...lUserPoolClientProps, ...{ generateSecret: true } });
        this.userPoolClient = new cognito.UserPoolClient(this, "UserPoolClient", { ...lUserPoolClientProps, ...{ generateSecret: false } });
        const describeCognitoUserPoolClient = new aws_cdk_lib_1.custom_resources.AwsCustomResource(this, 'DescribeCognitoUserPoolClient', {
            resourceType: 'Custom::DescribeCognitoUserPoolClient',
            onCreate: {
                region: aws_cdk_lib_1.Stack.of(this).region,
                service: 'CognitoIdentityServiceProvider',
                action: 'describeUserPoolClient',
                parameters: {
                    UserPoolId: this.userPool.userPoolId,
                    ClientId: this.userPoolClientSecret.userPoolClientId,
                },
                physicalResourceId: aws_cdk_lib_1.custom_resources.PhysicalResourceId.of(this.userPoolClientSecret.userPoolClientId),
            },
            // TODO: can we restrict this policy more?
            policy: aws_cdk_lib_1.custom_resources.AwsCustomResourcePolicy.fromSdkCalls({
                resources: aws_cdk_lib_1.custom_resources.AwsCustomResourcePolicy.ANY_RESOURCE,
            }),
        });
        const userPoolClientSecret = describeCognitoUserPoolClient.getResponseField('UserPoolClient.ClientSecret');
        new aws_cdk_lib_1.CfnOutput(this, "CognitoUserPoolId", { value: this.userPool.userPoolId, exportName: 'CognitoUserPoolId' });
        new aws_cdk_lib_1.CfnOutput(this, "CognitoUserPoolClientId", { value: this.userPoolClient.userPoolClientId, exportName: 'CognitoUserPoolClientId' });
        new aws_cdk_lib_1.CfnOutput(this, "CognitoUserPoolClientSecret", { value: userPoolClientSecret, exportName: 'CognitoUserPoolClientSecret' });
    }
}
exports.TmUserPoolClient = TmUserPoolClient;
_a = JSII_RTTI_SYMBOL_1;
TmUserPoolClient[_a] = { fqn: "@toumoro-cdk/cognito.TmUserPoolClient", version: "1.0.13" };
//# sourceMappingURL=data:application/json;base64,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