# -*- coding: utf-8 -*-
"""
Test suite for the community-developed Python SDK for interacting with Lacework APIs.
"""

import random

import pytest

from datetime import datetime, timedelta, timezone

from laceworksdk.api.vulnerability import VulnerabilityAPI


# Build start/end times
current_time = datetime.now(timezone.utc)
start_time = current_time - timedelta(days=6)
start_time = start_time.strftime("%Y-%m-%dT%H:%M:%SZ")
end_time = current_time.strftime("%Y-%m-%dT%H:%M:%SZ")


# Tests

def test_vulnerability_api_object_creation(api):
    assert isinstance(api.vulnerabilities, VulnerabilityAPI)


def test_vulnerability_api_get_container_assessments_by_date(api):
    response = api.vulnerabilities.get_container_assessments_by_date(start_time=start_time,
                                                                     end_time=end_time)
    assert response["ok"]


def test_vulnerability_api_get_container_vulnerabilities(api):
    response = api.vulnerabilities.get_container_vulnerabilities(image_digest="sha256:123",
                                                                 start_time=start_time,
                                                                 end_time=end_time)
    assert response["ok"]


@pytest.mark.ci_exempt
def test_vulnerability_api_initiate_container_scan(api):
    response = api.vulnerabilities.initiate_container_scan("index.docker.io",
                                                           "alannix/vulnerable-struts",
                                                           "latest")
    assert response["ok"]


def test_vulnerability_api_get_host_vulnerabilities_date(api):
    response = api.vulnerabilities.get_host_vulnerabilities(start_time=start_time,
                                                            end_time=end_time)
    assert response["ok"]


def test_vulnerability_api_get_host_vulnerabilities_namespace(api):
    response = api.vulnerabilities.get_host_vulnerabilities(namespace="test")
    assert response["ok"]


def test_vulnerability_api_get_host_vulnerabilities_severity(api):
    response = api.vulnerabilities.get_host_vulnerabilities(severity="critical")
    assert response["ok"]


def test_vulnerability_api_get_host_vulnerabilities_by_cve(api):
    host_vulnerabilities = api.vulnerabilities.get_host_vulnerabilities(start_time=start_time,
                                                                        end_time=end_time)

    if len(host_vulnerabilities["data"]):
        cve_name = random.choice(host_vulnerabilities["data"])["cve_id"]
        response = api.vulnerabilities.get_host_vulnerabilities_by_cve(cve=cve_name)
        assert response["ok"]

        response = api.vulnerabilities.get_host_vulnerabilities_by_cve(cve=cve_name, machine_status="Active")
        assert response["ok"]


@pytest.mark.ci_exempt
def test_vulnerability_api_get_host_vulnerabilities_by_machine_id(api):
    host_vulnerabilities = api.vulnerabilities.get_host_vulnerabilities(start_time=start_time,
                                                                        end_time=end_time)

    if len(host_vulnerabilities["data"]):
        cve_name = random.choice(host_vulnerabilities["data"])["cve_id"]
        vulns_by_cve = api.vulnerabilities.get_host_vulnerabilities_by_cve(cve=cve_name)

        if len(vulns_by_cve["data"]):
            vuln_by_cve = random.choice(vulns_by_cve["data"])
            machine_id = vuln_by_cve["host"]["machine_id"]
            response = api.vulnerabilities.get_host_vulnerabilities_by_machine_id(machine=machine_id,
                                                                                  start_time=start_time,
                                                                                  end_time=end_time)
            assert response["ok"]


@pytest.mark.ci_exempt
def test_vulnerability_api_initiate_package_scan(api):
    response = api.vulnerabilities.initiate_package_scan(os="Ubuntu",
                                                         os_version="18.04",
                                                         package="openssl",
                                                         package_version="1.1.1-1ubuntu2.1~18.04.5")
    assert response["ok"]


@pytest.mark.ci_exempt
def test_vulnerability_api_initiate_package_scan_multi(api):
    response = api.vulnerabilities.initiate_package_scan(os_pkg_info_list=[{
        "os": "Ubuntu",
        "os_ver": "18.04",
        "pkg": "openssl",
        "pkg_ver": "1.1.1-1ubuntu2.1~18.04.5"
    }, {
        "os": "Ubuntu",
        "os_ver": "20.04",
        "pkg": "openssl",
        "pkg_ver": "1.1.1-1ubuntu2.1~20.04"
    }])
    assert response["ok"]
