"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const core_1 = require("@aws-cdk/core");
const test_origin_1 = require("./test-origin");
let app;
let stack;
beforeEach(() => {
    app = new core_1.App();
    stack = new core_1.Stack(app, 'Stack', {
        env: { account: '1234', region: 'testregion' },
    });
});
test.each([
    core_1.Duration.seconds(0),
    core_1.Duration.seconds(0.5),
    core_1.Duration.seconds(10.5),
    core_1.Duration.seconds(11),
    core_1.Duration.minutes(5),
])('validates connectionTimeout is an int between 1 and 10 seconds', (connectionTimeout) => {
    expect(() => {
        new test_origin_1.TestOrigin('www.example.com', {
            connectionTimeout,
        });
    }).toThrow(`connectionTimeout: Must be an int between 1 and 10 seconds (inclusive); received ${connectionTimeout.toSeconds()}.`);
});
test.each([-0.5, 0.5, 1.5, 4])('validates connectionAttempts is an int between 1 and 3', (connectionAttempts) => {
    expect(() => {
        new test_origin_1.TestOrigin('www.example.com', {
            connectionAttempts,
        });
    }).toThrow(`connectionAttempts: Must be an int between 1 and 3 (inclusive); received ${connectionAttempts}.`);
});
test.each(['api', '/api', '/api/', 'api/'])('enforces that originPath starts but does not end, with a /', (originPath) => {
    var _a;
    const origin = new test_origin_1.TestOrigin('www.example.com', {
        originPath,
    });
    const originBindConfig = origin.bind(stack, { originId: '0' });
    expect((_a = originBindConfig.originProperty) === null || _a === void 0 ? void 0 : _a.originPath).toEqual('/api');
});
//# sourceMappingURL=data:application/json;base64,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