"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const lib_1 = require("../lib");
describe.each([
    ['whitelist', lib_1.GeoRestriction.whitelist],
    ['blacklist', lib_1.GeoRestriction.blacklist],
])('%s', (type, geoFn) => {
    test('throws is location is empty', () => {
        expect(() => { geoFn(); }).toThrow(/Should provide at least 1 location/);
    });
    test('throws if locations are the wrong format', () => {
        const error = /Invalid location format for location: .*/;
        expect(() => { geoFn('a'); }).toThrow(error);
        expect(() => { geoFn('abc'); }).toThrow(error);
        expect(() => { geoFn('ab'); }).toThrow(error);
        expect(() => { geoFn('a1'); }).toThrow(error);
    });
    test('includes proper restriction type and location list', () => {
        const restriction = geoFn('US', 'GB');
        expect(restriction.restrictionType).toEqual(type);
        expect(restriction.locations).toEqual(['US', 'GB']);
    });
});
//# sourceMappingURL=data:application/json;base64,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