"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HelmChart = void 0;
const core_1 = require("@aws-cdk/core");
/**
 * Represents a helm chart within the Kubernetes system.
 *
 * Applies/deletes the resources using `kubectl` in sync with the resource.
 */
class HelmChart extends core_1.Construct {
    constructor(scope, id, props) {
        var _a, _b, _c, _d, _e;
        super(scope, id);
        const stack = core_1.Stack.of(this);
        const provider = props.cluster._kubectlProvider;
        const timeout = (_a = props.timeout) === null || _a === void 0 ? void 0 : _a.toSeconds();
        if (timeout && timeout > 900) {
            throw new Error('Helm chart timeout cannot be higher than 15 minutes.');
        }
        // default not to wait
        const wait = (_b = props.wait) !== null && _b !== void 0 ? _b : false;
        // default to create new namespace
        const createNamespace = (_c = props.createNamespace) !== null && _c !== void 0 ? _c : true;
        new core_1.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            resourceType: HelmChart.RESOURCE_TYPE,
            properties: {
                ClusterName: props.cluster.clusterName,
                RoleArn: props.cluster._kubectlCreationRole.roleArn,
                Release: (_d = props.release) !== null && _d !== void 0 ? _d : this.node.uniqueId.slice(-53).toLowerCase(),
                Chart: props.chart,
                Version: props.version,
                Wait: wait || undefined,
                Timeout: timeout ? `${timeout.toString()}s` : undefined,
                Values: (props.values ? stack.toJsonString(props.values) : undefined),
                Namespace: (_e = props.namespace) !== null && _e !== void 0 ? _e : 'default',
                Repository: props.repository,
                CreateNamespace: createNamespace || undefined,
            },
        });
    }
}
exports.HelmChart = HelmChart;
/**
 * The CloudFormation resource type.
 */
HelmChart.RESOURCE_TYPE = 'Custom::AWSCDK-EKS-HelmChart';
//# sourceMappingURL=data:application/json;base64,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