"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FargateCluster = void 0;
const cluster_1 = require("./cluster");
/**
 * Defines an EKS cluster that runs entirely on AWS Fargate.
 *
 * The cluster is created with a default Fargate Profile that matches the
 * "default" and "kube-system" namespaces. You can add additional profiles using
 * `addFargateProfile`.
 */
class FargateCluster extends cluster_1.Cluster {
    constructor(scope, id, props = {}) {
        var _a, _b, _c, _d;
        super(scope, id, {
            ...props,
            defaultCapacity: 0,
            kubectlEnabled: true,
            coreDnsComputeType: (_a = props.coreDnsComputeType) !== null && _a !== void 0 ? _a : cluster_1.CoreDnsComputeType.FARGATE,
        });
        this.addFargateProfile((_c = (_b = props.defaultProfile) === null || _b === void 0 ? void 0 : _b.fargateProfileName) !== null && _c !== void 0 ? _c : (props.defaultProfile ? 'custom' : 'default'), (_d = props.defaultProfile) !== null && _d !== void 0 ? _d : {
            selectors: [
                { namespace: 'default' },
                { namespace: 'kube-system' },
            ],
        });
    }
}
exports.FargateCluster = FargateCluster;
//# sourceMappingURL=data:application/json;base64,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