'''List of GE p-file offsets.

This code is taken from the VESPA project https://scion.duhs.duke.edu/vespa/project.
I therefore include their BSD statement here.

    Copyright (c) 2010, Duke University. All rights reserved.

    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions are met:
        * Redistributions of source code must retain the above copyright notice,
          this list of conditions and the following disclaimer.
        * Redistributions in binary form must reproduce the above copyright
          notice, this list of conditions and the following disclaimer in the
          documentation and/or other materials provided with the distribution.
        * Neither the name of Duke University nor the United States Department
          of Veterans Affairs may be used to endorse or promote products derived
          from this software without specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ''AS
    IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
    THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
    PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE
    FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
    DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
    SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
    CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
    LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
    OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
    DAMAGE.

    For portions of this code, copyright and license information differs from
    the above. In these cases, copyright and/or license information is inline.

In turn some of the code in this file was derived from the Python package
pfile-tools project, https://github.com/njvack/pfile-tools
and as such we have included their BSD statement in this file.

    Copyright (c) 2012, Board of Regents of the University of Wisconsin
    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
    are permitted provided that the following conditions are met:

        * Redistributions of source code must retain the above copyright notice, this list
          of conditions and the following disclaimer.
        * Redistributions in binary form must reproduce the above copyright notice, this
          list of conditions and the following disclaimer in the documentation and/or
          other materials provided with the distribution.
        * Neither the name of the University of Wisconsin nor the names of its
          contributors may be used to endorse or promote products derived from this
          software without specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
    ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
    WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
    DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
    ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
    (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
    LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
    ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
    (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
    SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'''

import ctypes as ct
import numpy as np


class UnknownPfileHdr(RuntimeError):
    pass


def get_pfile_hdr_fields(version):
    """
    This function returns a list of fields for mapping a GE P-file header
    to a ctypes class structure. We define different paddings and variable
    names depending on the software version that created the P-file.

    """
    plist = []

    version_major = int(np.trunc(version))

    # ARC 20220209 : consistent with previous _version_major mapping
    if version_major in (7, 8):
        plist.append(('rhr_rh_rdbm_rev',          ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 12))
        plist.append(('rhr_rh_scan_date',         ct.c_char * 10))
        plist.append(('rhr_rh_scan_time',         ct.c_char * 8))
        plist.append(('rhr_rh_logo',              ct.c_char * 10))
        plist.append(('rhr_rh_file_contents',     ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 10))
        plist.append(('rhr_rh_data_collect_type', ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 6))
        plist.append(('rhr_rh_npasses',           ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 2))
        plist.append(('rhr_rh_nslices',           ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 10))
        plist.append(('rhr_rh_frame_size',        ct.c_short))
        plist.append(('rhr_rh_point_size',        ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 32))
        plist.append(('rhr_rh_raw_pass_size',     ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 80))
        plist.append(('rhr_rh_dab[0]_start_rcv',  ct.c_short))
        plist.append(('rhr_rh_dab[0]_stop_rcv',   ct.c_short))
        plist.append(('rhr_rh_dab[1]_start_rcv',  ct.c_short))
        plist.append(('rhr_rh_dab[1]_stop_rcv',   ct.c_short))
        plist.append(('rhr_rh_dab[2]_start_rcv',  ct.c_short))
        plist.append(('rhr_rh_dab[2]_stop_rcv',   ct.c_short))
        plist.append(('rhr_rh_dab[3]_start_rcv',  ct.c_short))
        plist.append(('rhr_rh_dab[3]_stop_rcv',   ct.c_short))
        plist.append(('rhr_rh_user0',             ct.c_float))
        plist.append(('rhr_rh_user1',             ct.c_float))
        plist.append(('rhr_rh_user2',             ct.c_float))
        plist.append(('rhr_rh_user3',             ct.c_float))
        plist.append(('rhr_rh_user4',             ct.c_float))
        plist.append(('rhr_rh_user5',             ct.c_float))
        plist.append(('rhr_rh_user6',             ct.c_float))
        plist.append(('rhr_rh_user7',             ct.c_float))
        plist.append(('rhr_rh_user8',             ct.c_float))
        plist.append(('rhr_rh_user9',             ct.c_float))
        plist.append(('rhr_rh_user10',            ct.c_float))
        plist.append(('rhr_rh_user11',            ct.c_float))
        plist.append(('rhr_rh_user12',            ct.c_float))
        plist.append(('rhr_rh_user13',            ct.c_float))
        plist.append(('rhr_rh_user14',            ct.c_float))
        plist.append(('rhr_rh_user15',            ct.c_float))
        plist.append(('rhr_rh_user16',            ct.c_float))
        plist.append(('rhr_rh_user17',            ct.c_float))
        plist.append(('rhr_rh_user18',            ct.c_float))
        plist.append(('rhr_rh_user19',            ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 72))
        plist.append(('rhr_spectral_width',       ct.c_float))
        plist.append(('rhr_csi_dims',             ct.c_short))
        plist.append(('rhr_xcsi',                 ct.c_short))
        plist.append(('rhr_ycsi',                 ct.c_short))
        plist.append(('rhr_zcsi',                 ct.c_short))
        plist.append(('rhr_roilenx',              ct.c_float))
        plist.append(('rhr_roileny',              ct.c_float))
        plist.append(('rhr_roilenz',              ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 32))
        plist.append(('rhr_rh_ps_mps_freq',       ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 560))
        plist.append(('rhr_rh_user_usage_tag',    ct.c_uint))
        plist.append(('pad_xx',                   ct.c_char * 8))
        plist.append(('rhr_rh_user20',            ct.c_float))
        plist.append(('rhr_rh_user21',            ct.c_float))
        plist.append(('rhr_rh_user22',            ct.c_float))
        plist.append(('rhr_rh_user23',            ct.c_float))
        plist.append(('rhr_rh_user24',            ct.c_float))
        plist.append(('rhr_rh_user25',            ct.c_float))
        plist.append(('rhr_rh_user26',            ct.c_float))
        plist.append(('rhr_rh_user27',            ct.c_float))
        plist.append(('rhr_rh_user28',            ct.c_float))
        plist.append(('rhr_rh_user29',            ct.c_float))
        plist.append(('rhr_rh_user30',            ct.c_float))
        plist.append(('rhr_rh_user31',            ct.c_float))
        plist.append(('rhr_rh_user32',            ct.c_float))
        plist.append(('rhr_rh_user33',            ct.c_float))
        plist.append(('rhr_rh_user34',            ct.c_float))
        plist.append(('rhr_rh_user35',            ct.c_float))
        plist.append(('rhr_rh_user36',            ct.c_float))
        plist.append(('rhr_rh_user37',            ct.c_float))
        plist.append(('rhr_rh_user38',            ct.c_float))
        plist.append(('rhr_rh_user39',            ct.c_float))
        plist.append(('rhr_rh_user40',            ct.c_float))
        plist.append(('rhr_rh_user41',            ct.c_float))
        plist.append(('rhr_rh_user42',            ct.c_float))
        plist.append(('rhr_rh_user43',            ct.c_float))
        plist.append(('rhr_rh_user44',            ct.c_float))
        plist.append(('rhr_rh_user45',            ct.c_float))
        plist.append(('rhr_rh_user46',            ct.c_float))
        plist.append(('rhr_rh_user47',            ct.c_float))
        plist.append(('rhr_rh_user48',            ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 35764))
        plist.append(('rhe_ex_no',                ct.c_ushort))
        plist.append(('rhe_hospname',             ct.c_char * 33))
        plist.append(('pad_xx',                   ct.c_char * 41))
        plist.append(('rhe_magstrength',          ct.c_int))
        plist.append(('rhe_patid',                ct.c_char * 13))
        plist.append(('rhe_patname',              ct.c_char * 25))
        plist.append(('pad_xx',                   ct.c_char * 4))
        plist.append(('rhe_patsex',               ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 67))
        plist.append(('rhe_reqnum',               ct.c_char * 13))
        plist.append(('rhe_ex_datetime',          ct.c_int))
        plist.append(('rhe_refphy',               ct.c_char * 33))
        plist.append(('pad_xx',                   ct.c_char * 79))
        plist.append(('rhe_ex_sysid',             ct.c_char * 9))
        plist.append(('pad_xx',                   ct.c_char * 27))
        plist.append(('rhe_ex_verscre',           ct.c_char * 2))
        plist.append(('pad_xx',                   ct.c_char * 84))
        plist.append(('rhe_uniq_sys_id',          ct.c_char * 16))
        plist.append(('pad_xx',                   ct.c_char * 20))
        plist.append(('rhe_study_uid',            ct.c_char * 32))
        plist.append(('pad_xx',                   ct.c_char * 66))
        plist.append(('rhe_patnameff',            ct.c_char * 65))
        plist.append(('rhe_patidff',              ct.c_char * 65))
        plist.append(('rhe_reqnumff',             ct.c_char * 17))
        plist.append(('rhe_dateofbirth',          ct.c_char * 9))
        plist.append(('pad_xx',                   ct.c_char * 310))
        plist.append(('rhs_se_no',                ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 8))
        plist.append(('rhs_se_desc',              ct.c_char * 30))
        plist.append(('pad_xx',                   ct.c_char * 26))
        plist.append(('rhs_position',             ct.c_int))
        plist.append(('rhs_entry',                ct.c_int))
        plist.append(('rhs_anref',                ct.c_char * 3))
        plist.append(('pad_xx',                   ct.c_char * 257))
        plist.append(('rhs_series_uid',           ct.c_char * 32))
        plist.append(('rhs_landmark_uid',         ct.c_char * 32))
        plist.append(('pad_xx',                   ct.c_char * 656))
        plist.append(('rhi_dfov',                 ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 80))
        plist.append(('rhi_scanspacing',          ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 8))
        plist.append(('rhi_loc',                  ct.c_float))
        plist.append(('rhi_ctr_R',                ct.c_float))
        plist.append(('rhi_ctr_A',                ct.c_float))
        plist.append(('rhi_ctr_S',                ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 12))
        plist.append(('rhi_tlhc_R',               ct.c_float))
        plist.append(('rhi_tlhc_A',               ct.c_float))
        plist.append(('rhi_tlhc_S',               ct.c_float))
        plist.append(('rhi_trhc_R',               ct.c_float))
        plist.append(('rhi_trhc_A',               ct.c_float))
        plist.append(('rhi_trhc_S',               ct.c_float))
        plist.append(('rhi_brhc_R',               ct.c_float))
        plist.append(('rhi_brhc_A',               ct.c_float))
        plist.append(('rhi_brhc_S',               ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 4))
        plist.append(('rhi_tr',                   ct.c_int))
        plist.append(('rhi_ti',                   ct.c_int))
        plist.append(('rhi_te',                   ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 4))
        plist.append(('rhi_numecho',              ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 6))
        plist.append(('rhi_nex',                  ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 32))
        plist.append(('rhi_mr_flip',              ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 58))
        plist.append(('rhi_psdname',              ct.c_char * 33))
        plist.append(('pad_xx',                   ct.c_char * 21))
        plist.append(('rhi_ctyp',                 ct.c_short))
        plist.append(('rhi_cname',                ct.c_char * 17))
        plist.append(('pad_xx',                   ct.c_char * 31))
        plist.append(('rhi_user0',                ct.c_float))
        plist.append(('rhi_user1',                ct.c_float))
        plist.append(('rhi_user2',                ct.c_float))
        plist.append(('rhi_user3',                ct.c_float))
        plist.append(('rhi_user4',                ct.c_float))
        plist.append(('rhi_user5',                ct.c_float))
        plist.append(('rhi_user6',                ct.c_float))
        plist.append(('rhi_user7',                ct.c_float))
        plist.append(('rhi_user8',                ct.c_float))
        plist.append(('rhi_user9',                ct.c_float))
        plist.append(('rhi_user10',               ct.c_float))
        plist.append(('rhi_user11',               ct.c_float))
        plist.append(('rhi_user12',               ct.c_float))
        plist.append(('rhi_user13',               ct.c_float))
        plist.append(('rhi_user14',               ct.c_float))
        plist.append(('rhi_user15',               ct.c_float))
        plist.append(('rhi_user16',               ct.c_float))
        plist.append(('rhi_user17',               ct.c_float))
        plist.append(('rhi_user18',               ct.c_float))
        plist.append(('rhi_user19',               ct.c_float))
        plist.append(('rhi_user20',               ct.c_float))
        plist.append(('rhi_user21',               ct.c_float))
        plist.append(('rhi_user22',               ct.c_float))
        plist.append(('rhi_user23',               ct.c_float))
        plist.append(('rhi_user24',               ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 240))
        plist.append(('rhi_freq_dir',             ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 2))
        plist.append(('rhi_image_uid',            ct.c_char * 32))
        plist.append(('pad_xx',                   ct.c_char * 100))
        plist.append(('rhi_user25',               ct.c_float))
        plist.append(('rhi_user26',               ct.c_float))
        plist.append(('rhi_user27',               ct.c_float))
        plist.append(('rhi_user28',               ct.c_float))
        plist.append(('rhi_user29',               ct.c_float))
        plist.append(('rhi_user30',               ct.c_float))
        plist.append(('rhi_user31',               ct.c_float))
        plist.append(('rhi_user32',               ct.c_float))
        plist.append(('rhi_user33',               ct.c_float))
        plist.append(('rhi_user34',               ct.c_float))
        plist.append(('rhi_user35',               ct.c_float))
        plist.append(('rhi_user36',               ct.c_float))
        plist.append(('rhi_user37',               ct.c_float))
        plist.append(('rhi_user38',               ct.c_float))
        plist.append(('rhi_user39',               ct.c_float))
        plist.append(('rhi_user40',               ct.c_float))
        plist.append(('rhi_user41',               ct.c_float))
        plist.append(('rhi_user42',               ct.c_float))
        plist.append(('rhi_user43',               ct.c_float))
        plist.append(('rhi_user44',               ct.c_float))
        plist.append(('rhi_user45',               ct.c_float))
        plist.append(('rhi_user46',               ct.c_float))
        plist.append(('rhi_user47',               ct.c_float))
        plist.append(('rhi_user48',               ct.c_float))

    elif version_major == 9:
        plist.append(('rhr_rh_rdbm_rev',          ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 12))
        plist.append(('rhr_rh_scan_date',         ct.c_char * 10))
        plist.append(('rhr_rh_scan_time',         ct.c_char * 8))
        plist.append(('rhr_rh_logo',              ct.c_char * 10))
        plist.append(('rhr_rh_file_contents',     ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 10))
        plist.append(('rhr_rh_data_collect_type', ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 6))
        plist.append(('rhr_rh_npasses',           ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 2))
        plist.append(('rhr_rh_nslices',           ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 10))
        plist.append(('rhr_rh_frame_size',        ct.c_ushort))
        plist.append(('rhr_rh_point_size',        ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 32))
        plist.append(('rhr_rh_raw_pass_size',     ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 80))
        plist.append(('rhr_rh_dab[0]_start_rcv',  ct.c_short))
        plist.append(('rhr_rh_dab[0]_stop_rcv',   ct.c_short))
        plist.append(('rhr_rh_dab[1]_start_rcv',  ct.c_short))
        plist.append(('rhr_rh_dab[1]_stop_rcv',   ct.c_short))
        plist.append(('rhr_rh_dab[2]_start_rcv',  ct.c_short))
        plist.append(('rhr_rh_dab[2]_stop_rcv',   ct.c_short))
        plist.append(('rhr_rh_dab[3]_start_rcv',  ct.c_short))
        plist.append(('rhr_rh_dab[3]_stop_rcv',   ct.c_short))
        plist.append(('rhr_rh_user0',             ct.c_float))
        plist.append(('rhr_rh_user1',             ct.c_float))
        plist.append(('rhr_rh_user2',             ct.c_float))
        plist.append(('rhr_rh_user3',             ct.c_float))
        plist.append(('rhr_rh_user4',             ct.c_float))
        plist.append(('rhr_rh_user5',             ct.c_float))
        plist.append(('rhr_rh_user6',             ct.c_float))
        plist.append(('rhr_rh_user7',             ct.c_float))
        plist.append(('rhr_rh_user8',             ct.c_float))
        plist.append(('rhr_rh_user9',             ct.c_float))
        plist.append(('rhr_rh_user10',            ct.c_float))
        plist.append(('rhr_rh_user11',            ct.c_float))
        plist.append(('rhr_rh_user12',            ct.c_float))
        plist.append(('rhr_rh_user13',            ct.c_float))
        plist.append(('rhr_rh_user14',            ct.c_float))
        plist.append(('rhr_rh_user15',            ct.c_float))
        plist.append(('rhr_rh_user16',            ct.c_float))
        plist.append(('rhr_rh_user17',            ct.c_float))
        plist.append(('rhr_rh_user18',            ct.c_float))
        plist.append(('rhr_rh_user19',            ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 72))
        plist.append(('rhr_spectral_width',       ct.c_float))
        plist.append(('rhr_csi_dims',             ct.c_short))
        plist.append(('rhr_xcsi',                 ct.c_short))
        plist.append(('rhr_ycsi',                 ct.c_short))
        plist.append(('rhr_zcsi',                 ct.c_short))
        plist.append(('rhr_roilenx',              ct.c_float))
        plist.append(('rhr_roileny',              ct.c_float))
        plist.append(('rhr_roilenz',              ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 32))
        plist.append(('rhr_rh_ps_mps_freq',       ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 560))
        plist.append(('rhr_rh_user_usage_tag',    ct.c_uint))
        plist.append(('pad_xx',                   ct.c_char * 8))
        plist.append(('rhr_rh_user20',            ct.c_float))
        plist.append(('rhr_rh_user21',            ct.c_float))
        plist.append(('rhr_rh_user22',            ct.c_float))
        plist.append(('rhr_rh_user23',            ct.c_float))
        plist.append(('rhr_rh_user24',            ct.c_float))
        plist.append(('rhr_rh_user25',            ct.c_float))
        plist.append(('rhr_rh_user26',            ct.c_float))
        plist.append(('rhr_rh_user27',            ct.c_float))
        plist.append(('rhr_rh_user28',            ct.c_float))
        plist.append(('rhr_rh_user29',            ct.c_float))
        plist.append(('rhr_rh_user30',            ct.c_float))
        plist.append(('rhr_rh_user31',            ct.c_float))
        plist.append(('rhr_rh_user32',            ct.c_float))
        plist.append(('rhr_rh_user33',            ct.c_float))
        plist.append(('rhr_rh_user34',            ct.c_float))
        plist.append(('rhr_rh_user35',            ct.c_float))
        plist.append(('rhr_rh_user36',            ct.c_float))
        plist.append(('rhr_rh_user37',            ct.c_float))
        plist.append(('rhr_rh_user38',            ct.c_float))
        plist.append(('rhr_rh_user39',            ct.c_float))
        plist.append(('rhr_rh_user40',            ct.c_float))
        plist.append(('rhr_rh_user41',            ct.c_float))
        plist.append(('rhr_rh_user42',            ct.c_float))
        plist.append(('rhr_rh_user43',            ct.c_float))
        plist.append(('rhr_rh_user44',            ct.c_float))
        plist.append(('rhr_rh_user45',            ct.c_float))
        plist.append(('rhr_rh_user46',            ct.c_float))
        plist.append(('rhr_rh_user47',            ct.c_float))
        plist.append(('rhr_rh_user48',            ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 56244))
        plist.append(('rhe_ex_no',                ct.c_ushort))
        plist.append(('rhe_hospname',             ct.c_char * 33))
        plist.append(('pad_xx',                   ct.c_char * 41))
        plist.append(('rhe_magstrength',          ct.c_int))
        plist.append(('rhe_patid',                ct.c_char * 13))
        plist.append(('rhe_patname',              ct.c_char * 25))
        plist.append(('pad_xx',                   ct.c_char * 4))
        plist.append(('rhe_patsex',               ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 67))
        plist.append(('rhe_reqnum',               ct.c_char * 13))
        plist.append(('rhe_ex_datetime',          ct.c_int))
        plist.append(('rhe_refphy',               ct.c_char * 33))
        plist.append(('pad_xx',                   ct.c_char * 79))
        plist.append(('rhe_ex_sysid',             ct.c_char * 9))
        plist.append(('pad_xx',                   ct.c_char * 27))
        plist.append(('rhe_ex_verscre',           ct.c_char * 2))
        plist.append(('pad_xx',                   ct.c_char * 84))
        plist.append(('rhe_uniq_sys_id',          ct.c_char * 16))
        plist.append(('pad_xx',                   ct.c_char * 20))
        plist.append(('rhe_study_uid',            ct.c_char * 32))
        plist.append(('pad_xx',                   ct.c_char * 66))
        plist.append(('rhe_patnameff',            ct.c_char * 65))
        plist.append(('rhe_patidff',              ct.c_char * 65))
        plist.append(('rhe_reqnumff',             ct.c_char * 17))
        plist.append(('rhe_dateofbirth',          ct.c_char * 9))
        plist.append(('pad_xx',                   ct.c_char * 310))
        plist.append(('rhs_se_no',                ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 8))
        plist.append(('rhs_se_desc',              ct.c_char * 30))
        plist.append(('pad_xx',                   ct.c_char * 26))
        plist.append(('rhs_position',             ct.c_int))
        plist.append(('rhs_entry',                ct.c_int))
        plist.append(('rhs_anref',                ct.c_char * 3))
        plist.append(('pad_xx',                   ct.c_char * 257))
        plist.append(('rhs_series_uid',           ct.c_char * 32))
        plist.append(('rhs_landmark_uid',         ct.c_char * 32))
        plist.append(('pad_xx',                   ct.c_char * 1164))
        plist.append(('rhi_dfov',                 ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 80))
        plist.append(('rhi_scanspacing',          ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 8))
        plist.append(('rhi_loc',                  ct.c_float))
        plist.append(('rhi_ctr_R',                ct.c_float))
        plist.append(('rhi_ctr_A',                ct.c_float))
        plist.append(('rhi_ctr_S',                ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 12))
        plist.append(('rhi_tlhc_R',               ct.c_float))
        plist.append(('rhi_tlhc_A',               ct.c_float))
        plist.append(('rhi_tlhc_S',               ct.c_float))
        plist.append(('rhi_trhc_R',               ct.c_float))
        plist.append(('rhi_trhc_A',               ct.c_float))
        plist.append(('rhi_trhc_S',               ct.c_float))
        plist.append(('rhi_brhc_R',               ct.c_float))
        plist.append(('rhi_brhc_A',               ct.c_float))
        plist.append(('rhi_brhc_S',               ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 4))
        plist.append(('rhi_tr',                   ct.c_int))
        plist.append(('rhi_ti',                   ct.c_int))
        plist.append(('rhi_te',                   ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 4))
        plist.append(('rhi_numecho',              ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 6))
        plist.append(('rhi_nex',                  ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 32))
        plist.append(('rhi_mr_flip',              ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 58))
        plist.append(('rhi_psdname',              ct.c_char * 33))
        plist.append(('pad_xx',                   ct.c_char * 21))
        plist.append(('rhi_ctyp',                 ct.c_short))
        plist.append(('rhi_cname',                ct.c_char * 17))
        plist.append(('pad_xx',                   ct.c_char * 31))
        plist.append(('rhi_user0',                ct.c_float))
        plist.append(('rhi_user1',                ct.c_float))
        plist.append(('rhi_user2',                ct.c_float))
        plist.append(('rhi_user3',                ct.c_float))
        plist.append(('rhi_user4',                ct.c_float))
        plist.append(('rhi_user5',                ct.c_float))
        plist.append(('rhi_user6',                ct.c_float))
        plist.append(('rhi_user7',                ct.c_float))
        plist.append(('rhi_user8',                ct.c_float))
        plist.append(('rhi_user9',                ct.c_float))
        plist.append(('rhi_user10',               ct.c_float))
        plist.append(('rhi_user11',               ct.c_float))
        plist.append(('rhi_user12',               ct.c_float))
        plist.append(('rhi_user13',               ct.c_float))
        plist.append(('rhi_user14',               ct.c_float))
        plist.append(('rhi_user15',               ct.c_float))
        plist.append(('rhi_user16',               ct.c_float))
        plist.append(('rhi_user17',               ct.c_float))
        plist.append(('rhi_user18',               ct.c_float))
        plist.append(('rhi_user19',               ct.c_float))
        plist.append(('rhi_user20',               ct.c_float))
        plist.append(('rhi_user21',               ct.c_float))
        plist.append(('rhi_user22',               ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 92))
        plist.append(('rhi_user23',               ct.c_float))
        plist.append(('rhi_user24',               ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 148))
        plist.append(('rhi_freq_dir',             ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 2))
        plist.append(('rhi_image_uid',            ct.c_char * 32))
        plist.append(('pad_xx',                   ct.c_char * 100))
        plist.append(('rhi_user25',               ct.c_float))
        plist.append(('rhi_user26',               ct.c_float))
        plist.append(('rhi_user27',               ct.c_float))
        plist.append(('rhi_user28',               ct.c_float))
        plist.append(('rhi_user29',               ct.c_float))
        plist.append(('rhi_user30',               ct.c_float))
        plist.append(('rhi_user31',               ct.c_float))
        plist.append(('rhi_user32',               ct.c_float))
        plist.append(('rhi_user33',               ct.c_float))
        plist.append(('rhi_user34',               ct.c_float))
        plist.append(('rhi_user35',               ct.c_float))
        plist.append(('rhi_user36',               ct.c_float))
        plist.append(('rhi_user37',               ct.c_float))
        plist.append(('rhi_user38',               ct.c_float))
        plist.append(('rhi_user39',               ct.c_float))
        plist.append(('rhi_user40',               ct.c_float))
        plist.append(('rhi_user41',               ct.c_float))
        plist.append(('rhi_user42',               ct.c_float))
        plist.append(('rhi_user43',               ct.c_float))
        plist.append(('rhi_user44',               ct.c_float))
        plist.append(('rhi_user45',               ct.c_float))
        plist.append(('rhi_user46',               ct.c_float))
        plist.append(('rhi_user47',               ct.c_float))
        plist.append(('rhi_user48',               ct.c_float))

    elif version_major in (11, 12):
        plist.append(('rhr_rh_rdbm_rev',          ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 12))
        plist.append(('rhr_rh_scan_date',         ct.c_char * 10))
        plist.append(('rhr_rh_scan_time',         ct.c_char * 8))
        plist.append(('rhr_rh_logo',              ct.c_char * 10))
        plist.append(('rhr_rh_file_contents',     ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 10))
        plist.append(('rhr_rh_data_collect_type', ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 6))
        plist.append(('rhr_rh_npasses',           ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 2))
        plist.append(('rhr_rh_nslices',           ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 10))
        plist.append(('rhr_rh_frame_size',        ct.c_ushort))
        plist.append(('rhr_rh_point_size',        ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 32))
        plist.append(('rhr_rh_raw_pass_size',     ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 80))
        plist.append(('rhr_rh_dab[0]_start_rcv',  ct.c_short))
        plist.append(('rhr_rh_dab[0]_stop_rcv',   ct.c_short))
        plist.append(('rhr_rh_dab[1]_start_rcv',  ct.c_short))
        plist.append(('rhr_rh_dab[1]_stop_rcv',   ct.c_short))
        plist.append(('rhr_rh_dab[2]_start_rcv',  ct.c_short))
        plist.append(('rhr_rh_dab[2]_stop_rcv',   ct.c_short))
        plist.append(('rhr_rh_dab[3]_start_rcv',  ct.c_short))
        plist.append(('rhr_rh_dab[3]_stop_rcv',   ct.c_short))
        plist.append(('rhr_rh_user0',             ct.c_float))
        plist.append(('rhr_rh_user1',             ct.c_float))
        plist.append(('rhr_rh_user2',             ct.c_float))
        plist.append(('rhr_rh_user3',             ct.c_float))
        plist.append(('rhr_rh_user4',             ct.c_float))
        plist.append(('rhr_rh_user5',             ct.c_float))
        plist.append(('rhr_rh_user6',             ct.c_float))
        plist.append(('rhr_rh_user7',             ct.c_float))
        plist.append(('rhr_rh_user8',             ct.c_float))
        plist.append(('rhr_rh_user9',             ct.c_float))
        plist.append(('rhr_rh_user10',            ct.c_float))
        plist.append(('rhr_rh_user11',            ct.c_float))
        plist.append(('rhr_rh_user12',            ct.c_float))
        plist.append(('rhr_rh_user13',            ct.c_float))
        plist.append(('rhr_rh_user14',            ct.c_float))
        plist.append(('rhr_rh_user15',            ct.c_float))
        plist.append(('rhr_rh_user16',            ct.c_float))
        plist.append(('rhr_rh_user17',            ct.c_float))
        plist.append(('rhr_rh_user18',            ct.c_float))
        plist.append(('rhr_rh_user19',            ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 72))
        plist.append(('rhr_spectral_width',       ct.c_float))
        plist.append(('rhr_csi_dims',             ct.c_short))
        plist.append(('rhr_xcsi',                 ct.c_short))
        plist.append(('rhr_ycsi',                 ct.c_short))
        plist.append(('rhr_zcsi',                 ct.c_short))
        plist.append(('rhr_roilenx',              ct.c_float))
        plist.append(('rhr_roileny',              ct.c_float))
        plist.append(('rhr_roilenz',              ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 32))
        plist.append(('rhr_rh_ps_mps_freq',       ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 560))
        plist.append(('rhr_rh_user_usage_tag',    ct.c_uint))
        plist.append(('pad_xx',                   ct.c_char * 8))
        plist.append(('rhr_rh_user20',            ct.c_float))
        plist.append(('rhr_rh_user21',            ct.c_float))
        plist.append(('rhr_rh_user22',            ct.c_float))
        plist.append(('rhr_rh_user23',            ct.c_float))
        plist.append(('rhr_rh_user24',            ct.c_float))
        plist.append(('rhr_rh_user25',            ct.c_float))
        plist.append(('rhr_rh_user26',            ct.c_float))
        plist.append(('rhr_rh_user27',            ct.c_float))
        plist.append(('rhr_rh_user28',            ct.c_float))
        plist.append(('rhr_rh_user29',            ct.c_float))
        plist.append(('rhr_rh_user30',            ct.c_float))
        plist.append(('rhr_rh_user31',            ct.c_float))
        plist.append(('rhr_rh_user32',            ct.c_float))
        plist.append(('rhr_rh_user33',            ct.c_float))
        plist.append(('rhr_rh_user34',            ct.c_float))
        plist.append(('rhr_rh_user35',            ct.c_float))
        plist.append(('rhr_rh_user36',            ct.c_float))
        plist.append(('rhr_rh_user37',            ct.c_float))
        plist.append(('rhr_rh_user38',            ct.c_float))
        plist.append(('rhr_rh_user39',            ct.c_float))
        plist.append(('rhr_rh_user40',            ct.c_float))
        plist.append(('rhr_rh_user41',            ct.c_float))
        plist.append(('rhr_rh_user42',            ct.c_float))
        plist.append(('rhr_rh_user43',            ct.c_float))
        plist.append(('rhr_rh_user44',            ct.c_float))
        plist.append(('rhr_rh_user45',            ct.c_float))
        plist.append(('rhr_rh_user46',            ct.c_float))
        plist.append(('rhr_rh_user47',            ct.c_float))
        plist.append(('rhr_rh_user48',            ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 352))
        plist.append(('rhr_rdb_hdr_off_data',     ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 60088))
        plist.append(('rhe_magstrength',          ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 4))
        plist.append(('rhe_ex_datetime',          ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 4))
        plist.append(('rhe_ex_no',                ct.c_ushort))
        plist.append(('pad_xx',                   ct.c_char * 22))
        plist.append(('rhe_patsex',               ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 75))
        plist.append(('rhe_reqnum',               ct.c_char * 13))
        plist.append(('rhe_refphy',               ct.c_char * 33))
        plist.append(('pad_xx',                   ct.c_char * 105))
        plist.append(('rhe_ex_sysid',             ct.c_char * 9))
        plist.append(('pad_xx',                   ct.c_char * 14))
        plist.append(('rhe_hospname',             ct.c_char * 33))
        plist.append(('rhe_patid',                ct.c_char * 13))
        plist.append(('rhe_patname',              ct.c_char * 25))
        plist.append(('pad_xx',                   ct.c_char * 4))
        plist.append(('rhe_ex_verscre',           ct.c_char * 2))
        plist.append(('pad_xx',                   ct.c_char * 2))
        plist.append(('rhe_uniq_sys_id',          ct.c_char * 16))
        plist.append(('pad_xx',                   ct.c_char * 20))
        plist.append(('rhe_study_uid',            ct.c_char * 32))
        plist.append(('pad_xx',                   ct.c_char * 64))
        plist.append(('rhe_patnameff',            ct.c_char * 65))
        plist.append(('rhe_patidff',              ct.c_char * 65))
        plist.append(('rhe_reqnumff',             ct.c_char * 17))
        plist.append(('rhe_dateofbirth',          ct.c_char * 9))
        plist.append(('pad_xx',                   ct.c_char * 422))
        plist.append(('rhs_position',             ct.c_int))
        plist.append(('rhs_entry',                ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 62))
        plist.append(('rhs_se_no',                ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 74))
        plist.append(('rhs_se_desc',              ct.c_char * 65))
        plist.append(('pad_xx',                   ct.c_char * 18))
        plist.append(('rhs_anref',                ct.c_char * 3))
        plist.append(('pad_xx',                   ct.c_char * 27))
        plist.append(('rhs_series_uid',           ct.c_char * 32))
        plist.append(('rhs_landmark_uid',         ct.c_char * 32))
        plist.append(('pad_xx',                   ct.c_char * 1573))
        plist.append(('rhi_dfov',                 ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 12))
        plist.append(('rhi_scanspacing',          ct.c_float))
        plist.append(('rhi_loc',                  ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 4))
        plist.append(('rhi_nex',                  ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 20))
        plist.append(('rhi_user0',                ct.c_float))
        plist.append(('rhi_user1',                ct.c_float))
        plist.append(('rhi_user2',                ct.c_float))
        plist.append(('rhi_user3',                ct.c_float))
        plist.append(('rhi_user4',                ct.c_float))
        plist.append(('rhi_user5',                ct.c_float))
        plist.append(('rhi_user6',                ct.c_float))
        plist.append(('rhi_user7',                ct.c_float))
        plist.append(('rhi_user8',                ct.c_float))
        plist.append(('rhi_user9',                ct.c_float))
        plist.append(('rhi_user10',               ct.c_float))
        plist.append(('rhi_user11',               ct.c_float))
        plist.append(('rhi_user12',               ct.c_float))
        plist.append(('rhi_user13',               ct.c_float))
        plist.append(('rhi_user14',               ct.c_float))
        plist.append(('rhi_user15',               ct.c_float))
        plist.append(('rhi_user16',               ct.c_float))
        plist.append(('rhi_user17',               ct.c_float))
        plist.append(('rhi_user18',               ct.c_float))
        plist.append(('rhi_user19',               ct.c_float))
        plist.append(('rhi_user20',               ct.c_float))
        plist.append(('rhi_user21',               ct.c_float))
        plist.append(('rhi_user22',               ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 8))
        plist.append(('rhi_user23',               ct.c_float))
        plist.append(('rhi_user24',               ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 60))
        plist.append(('rhi_user25',               ct.c_float))
        plist.append(('rhi_user26',               ct.c_float))
        plist.append(('rhi_user27',               ct.c_float))
        plist.append(('rhi_user28',               ct.c_float))
        plist.append(('rhi_user29',               ct.c_float))
        plist.append(('rhi_user30',               ct.c_float))
        plist.append(('rhi_user31',               ct.c_float))
        plist.append(('rhi_user32',               ct.c_float))
        plist.append(('rhi_user33',               ct.c_float))
        plist.append(('rhi_user34',               ct.c_float))
        plist.append(('rhi_user35',               ct.c_float))
        plist.append(('rhi_user36',               ct.c_float))
        plist.append(('rhi_user37',               ct.c_float))
        plist.append(('rhi_user38',               ct.c_float))
        plist.append(('rhi_user39',               ct.c_float))
        plist.append(('rhi_user40',               ct.c_float))
        plist.append(('rhi_user41',               ct.c_float))
        plist.append(('rhi_user42',               ct.c_float))
        plist.append(('rhi_user43',               ct.c_float))
        plist.append(('rhi_user44',               ct.c_float))
        plist.append(('rhi_user45',               ct.c_float))
        plist.append(('rhi_user46',               ct.c_float))
        plist.append(('rhi_user47',               ct.c_float))
        plist.append(('rhi_user48',               ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 76))
        plist.append(('rhi_ctr_R',                ct.c_float))
        plist.append(('rhi_ctr_A',                ct.c_float))
        plist.append(('rhi_ctr_S',                ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 12))
        plist.append(('rhi_tlhc_R',               ct.c_float))
        plist.append(('rhi_tlhc_A',               ct.c_float))
        plist.append(('rhi_tlhc_S',               ct.c_float))
        plist.append(('rhi_trhc_R',               ct.c_float))
        plist.append(('rhi_trhc_A',               ct.c_float))
        plist.append(('rhi_trhc_S',               ct.c_float))
        plist.append(('rhi_brhc_R',               ct.c_float))
        plist.append(('rhi_brhc_A',               ct.c_float))
        plist.append(('rhi_brhc_S',               ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 36))
        plist.append(('rhi_tr',                   ct.c_int))
        plist.append(('rhi_ti',                   ct.c_int))
        plist.append(('rhi_te',                   ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 170))
        plist.append(('rhi_numecho',              ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 36))
        plist.append(('rhi_mr_flip',              ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 22))
        plist.append(('rhi_ctyp',                 ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 64))
        plist.append(('rhi_freq_dir',             ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 38))
        plist.append(('rhi_psdname',              ct.c_char * 33))
        plist.append(('pad_xx',                   ct.c_char * 84))
        plist.append(('rhi_cname',                ct.c_char * 17))
        plist.append(('pad_xx',                   ct.c_char * 51))
        plist.append(('rhi_image_uid',            ct.c_char * 32))

    elif version_major == 14:
        plist.append(('rhr_rh_rdbm_rev',          ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 12))
        plist.append(('rhr_rh_scan_date',         ct.c_char * 10))
        plist.append(('rhr_rh_scan_time',         ct.c_char * 8))
        plist.append(('rhr_rh_logo',              ct.c_char * 10))
        plist.append(('rhr_rh_file_contents',     ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 10))
        plist.append(('rhr_rh_data_collect_type', ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 6))
        plist.append(('rhr_rh_npasses',           ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 2))
        plist.append(('rhr_rh_nslices',           ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 10))
        plist.append(('rhr_rh_frame_size',        ct.c_ushort))
        plist.append(('rhr_rh_point_size',        ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 32))
        plist.append(('rhr_rh_raw_pass_size',     ct.c_uint))
        plist.append(('pad_xx',                   ct.c_char * 80))
        plist.append(('rhr_rh_dab[0]_start_rcv',  ct.c_short))
        plist.append(('rhr_rh_dab[0]_stop_rcv',   ct.c_short))
        plist.append(('rhr_rh_dab[1]_start_rcv',  ct.c_short))
        plist.append(('rhr_rh_dab[1]_stop_rcv',   ct.c_short))
        plist.append(('rhr_rh_dab[2]_start_rcv',  ct.c_short))
        plist.append(('rhr_rh_dab[2]_stop_rcv',   ct.c_short))
        plist.append(('rhr_rh_dab[3]_start_rcv',  ct.c_short))
        plist.append(('rhr_rh_dab[3]_stop_rcv',   ct.c_short))
        plist.append(('rhr_rh_user0',             ct.c_float))
        plist.append(('rhr_rh_user1',             ct.c_float))
        plist.append(('rhr_rh_user2',             ct.c_float))
        plist.append(('rhr_rh_user3',             ct.c_float))
        plist.append(('rhr_rh_user4',             ct.c_float))
        plist.append(('rhr_rh_user5',             ct.c_float))
        plist.append(('rhr_rh_user6',             ct.c_float))
        plist.append(('rhr_rh_user7',             ct.c_float))
        plist.append(('rhr_rh_user8',             ct.c_float))
        plist.append(('rhr_rh_user9',             ct.c_float))
        plist.append(('rhr_rh_user10',            ct.c_float))
        plist.append(('rhr_rh_user11',            ct.c_float))
        plist.append(('rhr_rh_user12',            ct.c_float))
        plist.append(('rhr_rh_user13',            ct.c_float))
        plist.append(('rhr_rh_user14',            ct.c_float))
        plist.append(('rhr_rh_user15',            ct.c_float))
        plist.append(('rhr_rh_user16',            ct.c_float))
        plist.append(('rhr_rh_user17',            ct.c_float))
        plist.append(('rhr_rh_user18',            ct.c_float))
        plist.append(('rhr_rh_user19',            ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 72))
        plist.append(('rhr_spectral_width',       ct.c_float))
        plist.append(('rhr_csi_dims',             ct.c_short))
        plist.append(('rhr_xcsi',                 ct.c_short))
        plist.append(('rhr_ycsi',                 ct.c_short))
        plist.append(('rhr_zcsi',                 ct.c_short))
        plist.append(('rhr_roilenx',              ct.c_float))
        plist.append(('rhr_roileny',              ct.c_float))
        plist.append(('rhr_roilenz',              ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 32))
        plist.append(('rhr_rh_ps_mps_freq',       ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 560))
        plist.append(('rhr_rh_user_usage_tag',    ct.c_uint))
        plist.append(('pad_xx',                   ct.c_char * 8))
        plist.append(('rhr_rh_user20',            ct.c_float))
        plist.append(('rhr_rh_user21',            ct.c_float))
        plist.append(('rhr_rh_user22',            ct.c_float))
        plist.append(('rhr_rh_user23',            ct.c_float))
        plist.append(('rhr_rh_user24',            ct.c_float))
        plist.append(('rhr_rh_user25',            ct.c_float))
        plist.append(('rhr_rh_user26',            ct.c_float))
        plist.append(('rhr_rh_user27',            ct.c_float))
        plist.append(('rhr_rh_user28',            ct.c_float))
        plist.append(('rhr_rh_user29',            ct.c_float))
        plist.append(('rhr_rh_user30',            ct.c_float))
        plist.append(('rhr_rh_user31',            ct.c_float))
        plist.append(('rhr_rh_user32',            ct.c_float))
        plist.append(('rhr_rh_user33',            ct.c_float))
        plist.append(('rhr_rh_user34',            ct.c_float))
        plist.append(('rhr_rh_user35',            ct.c_float))
        plist.append(('rhr_rh_user36',            ct.c_float))
        plist.append(('rhr_rh_user37',            ct.c_float))
        plist.append(('rhr_rh_user38',            ct.c_float))
        plist.append(('rhr_rh_user39',            ct.c_float))
        plist.append(('rhr_rh_user40',            ct.c_float))
        plist.append(('rhr_rh_user41',            ct.c_float))
        plist.append(('rhr_rh_user42',            ct.c_float))
        plist.append(('rhr_rh_user43',            ct.c_float))
        plist.append(('rhr_rh_user44',            ct.c_float))
        plist.append(('rhr_rh_user45',            ct.c_float))
        plist.append(('rhr_rh_user46',            ct.c_float))
        plist.append(('rhr_rh_user47',            ct.c_float))
        plist.append(('rhr_rh_user48',            ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 352))
        plist.append(('rhr_rdb_hdr_off_data',     ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 139508))
        plist.append(('rhe_magstrength',          ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 4))
        plist.append(('rhe_ex_datetime',          ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 52))
        plist.append(('rhe_ex_no',                ct.c_ushort))
        plist.append(('pad_xx',                   ct.c_char * 22))
        plist.append(('rhe_patsex',               ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 91))
        plist.append(('rhe_reqnum',               ct.c_char * 13))
        plist.append(('rhe_refphy',               ct.c_char * 33))
        plist.append(('pad_xx',                   ct.c_char * 105))
        plist.append(('rhe_ex_sysid',             ct.c_char * 9))
        plist.append(('pad_xx',                   ct.c_char * 14))
        plist.append(('rhe_hospname',             ct.c_char * 33))
        plist.append(('rhe_patid',                ct.c_char * 13))
        plist.append(('rhe_patname',              ct.c_char * 25))
        plist.append(('pad_xx',                   ct.c_char * 4))
        plist.append(('rhe_ex_verscre',           ct.c_char * 2))
        plist.append(('pad_xx',                   ct.c_char * 2))
        plist.append(('rhe_uniq_sys_id',          ct.c_char * 16))
        plist.append(('pad_xx',                   ct.c_char * 20))
        plist.append(('rhe_study_uid',            ct.c_char * 32))
        plist.append(('pad_xx',                   ct.c_char * 64))
        plist.append(('rhe_patnameff',            ct.c_char * 65))
        plist.append(('rhe_patidff',              ct.c_char * 65))
        plist.append(('rhe_reqnumff',             ct.c_char * 17))
        plist.append(('rhe_dateofbirth',          ct.c_char * 9))
        plist.append(('pad_xx',                   ct.c_char * 358))
        plist.append(('rhs_position',             ct.c_int))
        plist.append(('rhs_entry',                ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 126))
        plist.append(('rhs_se_no',                ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 122))
        plist.append(('rhs_se_desc',              ct.c_char * 65))
        plist.append(('pad_xx',                   ct.c_char * 18))
        plist.append(('rhs_anref',                ct.c_char * 3))
        plist.append(('pad_xx',                   ct.c_char * 27))
        plist.append(('rhs_series_uid',           ct.c_char * 32))
        plist.append(('rhs_landmark_uid',         ct.c_char * 32))
        plist.append(('pad_xx',                   ct.c_char * 1429))
        plist.append(('rhi_dfov',                 ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 12))
        plist.append(('rhi_scanspacing',          ct.c_float))
        plist.append(('rhi_loc',                  ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 4))
        plist.append(('rhi_nex',                  ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 20))
        plist.append(('rhi_user0',                ct.c_float))
        plist.append(('rhi_user1',                ct.c_float))
        plist.append(('rhi_user2',                ct.c_float))
        plist.append(('rhi_user3',                ct.c_float))
        plist.append(('rhi_user4',                ct.c_float))
        plist.append(('rhi_user5',                ct.c_float))
        plist.append(('rhi_user6',                ct.c_float))
        plist.append(('rhi_user7',                ct.c_float))
        plist.append(('rhi_user8',                ct.c_float))
        plist.append(('rhi_user9',                ct.c_float))
        plist.append(('rhi_user10',               ct.c_float))
        plist.append(('rhi_user11',               ct.c_float))
        plist.append(('rhi_user12',               ct.c_float))
        plist.append(('rhi_user13',               ct.c_float))
        plist.append(('rhi_user14',               ct.c_float))
        plist.append(('rhi_user15',               ct.c_float))
        plist.append(('rhi_user16',               ct.c_float))
        plist.append(('rhi_user17',               ct.c_float))
        plist.append(('rhi_user18',               ct.c_float))
        plist.append(('rhi_user19',               ct.c_float))
        plist.append(('rhi_user20',               ct.c_float))
        plist.append(('rhi_user21',               ct.c_float))
        plist.append(('rhi_user22',               ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 8))
        plist.append(('rhi_user23',               ct.c_float))
        plist.append(('rhi_user24',               ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 60))
        plist.append(('rhi_user25',               ct.c_float))
        plist.append(('rhi_user26',               ct.c_float))
        plist.append(('rhi_user27',               ct.c_float))
        plist.append(('rhi_user28',               ct.c_float))
        plist.append(('rhi_user29',               ct.c_float))
        plist.append(('rhi_user30',               ct.c_float))
        plist.append(('rhi_user31',               ct.c_float))
        plist.append(('rhi_user32',               ct.c_float))
        plist.append(('rhi_user33',               ct.c_float))
        plist.append(('rhi_user34',               ct.c_float))
        plist.append(('rhi_user35',               ct.c_float))
        plist.append(('rhi_user36',               ct.c_float))
        plist.append(('rhi_user37',               ct.c_float))
        plist.append(('rhi_user38',               ct.c_float))
        plist.append(('rhi_user39',               ct.c_float))
        plist.append(('rhi_user40',               ct.c_float))
        plist.append(('rhi_user41',               ct.c_float))
        plist.append(('rhi_user42',               ct.c_float))
        plist.append(('rhi_user43',               ct.c_float))
        plist.append(('rhi_user44',               ct.c_float))
        plist.append(('rhi_user45',               ct.c_float))
        plist.append(('rhi_user46',               ct.c_float))
        plist.append(('rhi_user47',               ct.c_float))
        plist.append(('rhi_user48',               ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 76))
        plist.append(('rhi_ctr_R',                ct.c_float))
        plist.append(('rhi_ctr_A',                ct.c_float))
        plist.append(('rhi_ctr_S',                ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 12))
        plist.append(('rhi_tlhc_R',               ct.c_float))
        plist.append(('rhi_tlhc_A',               ct.c_float))
        plist.append(('rhi_tlhc_S',               ct.c_float))
        plist.append(('rhi_trhc_R',               ct.c_float))
        plist.append(('rhi_trhc_A',               ct.c_float))
        plist.append(('rhi_trhc_S',               ct.c_float))
        plist.append(('rhi_brhc_R',               ct.c_float))
        plist.append(('rhi_brhc_A',               ct.c_float))
        plist.append(('rhi_brhc_S',               ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 196))
        plist.append(('rhi_tr',                   ct.c_int))
        plist.append(('rhi_ti',                   ct.c_int))
        plist.append(('rhi_te',                   ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 306))
        plist.append(('rhi_numecho',              ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 36))
        plist.append(('rhi_mr_flip',              ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 22))
        plist.append(('rhi_ctyp',                 ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 64))
        plist.append(('rhi_freq_dir',             ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 112))
        plist.append(('rhi_psdname',              ct.c_char * 33))
        plist.append(('pad_xx',                   ct.c_char * 84))
        plist.append(('rhi_cname',                ct.c_char * 17))
        plist.append(('pad_xx',                   ct.c_char * 51))
        plist.append(('rhi_image_uid',            ct.c_char * 32))

    elif version_major == 15:
        plist.append(('rhr_rh_rdbm_rev',          ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 12))
        plist.append(('rhr_rh_scan_date',         ct.c_char * 10))
        plist.append(('rhr_rh_scan_time',         ct.c_char * 8))
        plist.append(('rhr_rh_logo',              ct.c_char * 10))
        plist.append(('rhr_rh_file_contents',     ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 10))
        plist.append(('rhr_rh_data_collect_type', ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 6))
        plist.append(('rhr_rh_npasses',           ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 2))
        plist.append(('rhr_rh_nslices',           ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 10))
        plist.append(('rhr_rh_frame_size',        ct.c_ushort))
        plist.append(('rhr_rh_point_size',        ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 32))
        plist.append(('rhr_rh_raw_pass_size',     ct.c_uint))
        plist.append(('pad_xx',                   ct.c_char * 80))
        plist.append(('rhr_rh_dab[0]_start_rcv',  ct.c_short))
        plist.append(('rhr_rh_dab[0]_stop_rcv',   ct.c_short))
        plist.append(('rhr_rh_dab[1]_start_rcv',  ct.c_short))
        plist.append(('rhr_rh_dab[1]_stop_rcv',   ct.c_short))
        plist.append(('rhr_rh_dab[2]_start_rcv',  ct.c_short))
        plist.append(('rhr_rh_dab[2]_stop_rcv',   ct.c_short))
        plist.append(('rhr_rh_dab[3]_start_rcv',  ct.c_short))
        plist.append(('rhr_rh_dab[3]_stop_rcv',   ct.c_short))
        plist.append(('rhr_rh_user0',             ct.c_float))
        plist.append(('rhr_rh_user1',             ct.c_float))
        plist.append(('rhr_rh_user2',             ct.c_float))
        plist.append(('rhr_rh_user3',             ct.c_float))
        plist.append(('rhr_rh_user4',             ct.c_float))
        plist.append(('rhr_rh_user5',             ct.c_float))
        plist.append(('rhr_rh_user6',             ct.c_float))
        plist.append(('rhr_rh_user7',             ct.c_float))
        plist.append(('rhr_rh_user8',             ct.c_float))
        plist.append(('rhr_rh_user9',             ct.c_float))
        plist.append(('rhr_rh_user10',            ct.c_float))
        plist.append(('rhr_rh_user11',            ct.c_float))
        plist.append(('rhr_rh_user12',            ct.c_float))
        plist.append(('rhr_rh_user13',            ct.c_float))
        plist.append(('rhr_rh_user14',            ct.c_float))
        plist.append(('rhr_rh_user15',            ct.c_float))
        plist.append(('rhr_rh_user16',            ct.c_float))
        plist.append(('rhr_rh_user17',            ct.c_float))
        plist.append(('rhr_rh_user18',            ct.c_float))
        plist.append(('rhr_rh_user19',            ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 72))
        plist.append(('rhr_spectral_width',       ct.c_float))
        plist.append(('rhr_csi_dims',             ct.c_short))
        plist.append(('rhr_xcsi',                 ct.c_short))
        plist.append(('rhr_ycsi',                 ct.c_short))
        plist.append(('rhr_zcsi',                 ct.c_short))
        plist.append(('rhr_roilenx',              ct.c_float))
        plist.append(('rhr_roileny',              ct.c_float))
        plist.append(('rhr_roilenz',              ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 32))
        plist.append(('rhr_rh_ps_mps_freq',       ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 560))
        plist.append(('rhr_rh_user_usage_tag',    ct.c_uint))
        plist.append(('pad_xx',                   ct.c_char * 8))
        plist.append(('rhr_rh_user20',            ct.c_float))
        plist.append(('rhr_rh_user21',            ct.c_float))
        plist.append(('rhr_rh_user22',            ct.c_float))
        plist.append(('rhr_rh_user23',            ct.c_float))
        plist.append(('rhr_rh_user24',            ct.c_float))
        plist.append(('rhr_rh_user25',            ct.c_float))
        plist.append(('rhr_rh_user26',            ct.c_float))
        plist.append(('rhr_rh_user27',            ct.c_float))
        plist.append(('rhr_rh_user28',            ct.c_float))
        plist.append(('rhr_rh_user29',            ct.c_float))
        plist.append(('rhr_rh_user30',            ct.c_float))
        plist.append(('rhr_rh_user31',            ct.c_float))
        plist.append(('rhr_rh_user32',            ct.c_float))
        plist.append(('rhr_rh_user33',            ct.c_float))
        plist.append(('rhr_rh_user34',            ct.c_float))
        plist.append(('rhr_rh_user35',            ct.c_float))
        plist.append(('rhr_rh_user36',            ct.c_float))
        plist.append(('rhr_rh_user37',            ct.c_float))
        plist.append(('rhr_rh_user38',            ct.c_float))
        plist.append(('rhr_rh_user39',            ct.c_float))
        plist.append(('rhr_rh_user40',            ct.c_float))
        plist.append(('rhr_rh_user41',            ct.c_float))
        plist.append(('rhr_rh_user42',            ct.c_float))
        plist.append(('rhr_rh_user43',            ct.c_float))
        plist.append(('rhr_rh_user44',            ct.c_float))
        plist.append(('rhr_rh_user45',            ct.c_float))
        plist.append(('rhr_rh_user46',            ct.c_float))
        plist.append(('rhr_rh_user47',            ct.c_float))
        plist.append(('rhr_rh_user48',            ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 352))
        plist.append(('rhr_rdb_hdr_off_data',     ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 139508))
        plist.append(('rhe_magstrength',          ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 4))
        plist.append(('rhe_ex_datetime',          ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 52))
        plist.append(('rhe_ex_no',                ct.c_ushort))
        plist.append(('pad_xx',                   ct.c_char * 22))
        plist.append(('rhe_patsex',               ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 91))
        plist.append(('rhe_reqnum',               ct.c_char * 13))
        plist.append(('rhe_refphy',               ct.c_char * 33))
        plist.append(('pad_xx',                   ct.c_char * 105))
        plist.append(('rhe_ex_sysid',             ct.c_char * 9))
        plist.append(('pad_xx',                   ct.c_char * 14))
        plist.append(('rhe_hospname',             ct.c_char * 33))
        plist.append(('rhe_patid',                ct.c_char * 13))
        plist.append(('rhe_patname',              ct.c_char * 25))
        plist.append(('pad_xx',                   ct.c_char * 4))
        plist.append(('rhe_ex_verscre',           ct.c_char * 2))
        plist.append(('pad_xx',                   ct.c_char * 2))
        plist.append(('rhe_uniq_sys_id',          ct.c_char * 16))
        plist.append(('pad_xx',                   ct.c_char * 20))
        plist.append(('rhe_study_uid',            ct.c_char * 32))
        plist.append(('pad_xx',                   ct.c_char * 64))
        plist.append(('rhe_patnameff',            ct.c_char * 65))
        plist.append(('rhe_patidff',              ct.c_char * 65))
        plist.append(('rhe_reqnumff',             ct.c_char * 17))
        plist.append(('rhe_dateofbirth',          ct.c_char * 9))
        plist.append(('pad_xx',                   ct.c_char * 358))
        plist.append(('rhs_position',             ct.c_int))
        plist.append(('rhs_entry',                ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 126))
        plist.append(('rhs_se_no',                ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 122))
        plist.append(('rhs_se_desc',              ct.c_char * 65))
        plist.append(('pad_xx',                   ct.c_char * 18))
        plist.append(('rhs_anref',                ct.c_char * 3))
        plist.append(('pad_xx',                   ct.c_char * 27))
        plist.append(('rhs_series_uid',           ct.c_char * 32))
        plist.append(('rhs_landmark_uid',         ct.c_char * 32))
        plist.append(('pad_xx',                   ct.c_char * 1429))
        plist.append(('rhi_dfov',                 ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 12))
        plist.append(('rhi_scanspacing',          ct.c_float))
        plist.append(('rhi_loc',                  ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 4))
        plist.append(('rhi_nex',                  ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 20))
        plist.append(('rhi_user0',                ct.c_float))
        plist.append(('rhi_user1',                ct.c_float))
        plist.append(('rhi_user2',                ct.c_float))
        plist.append(('rhi_user3',                ct.c_float))
        plist.append(('rhi_user4',                ct.c_float))
        plist.append(('rhi_user5',                ct.c_float))
        plist.append(('rhi_user6',                ct.c_float))
        plist.append(('rhi_user7',                ct.c_float))
        plist.append(('rhi_user8',                ct.c_float))
        plist.append(('rhi_user9',                ct.c_float))
        plist.append(('rhi_user10',               ct.c_float))
        plist.append(('rhi_user11',               ct.c_float))
        plist.append(('rhi_user12',               ct.c_float))
        plist.append(('rhi_user13',               ct.c_float))
        plist.append(('rhi_user14',               ct.c_float))
        plist.append(('rhi_user15',               ct.c_float))
        plist.append(('rhi_user16',               ct.c_float))
        plist.append(('rhi_user17',               ct.c_float))
        plist.append(('rhi_user18',               ct.c_float))
        plist.append(('rhi_user19',               ct.c_float))
        plist.append(('rhi_user20',               ct.c_float))
        plist.append(('rhi_user21',               ct.c_float))
        plist.append(('rhi_user22',               ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 8))
        plist.append(('rhi_user23',               ct.c_float))
        plist.append(('rhi_user24',               ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 60))
        plist.append(('rhi_user25',               ct.c_float))
        plist.append(('rhi_user26',               ct.c_float))
        plist.append(('rhi_user27',               ct.c_float))
        plist.append(('rhi_user28',               ct.c_float))
        plist.append(('rhi_user29',               ct.c_float))
        plist.append(('rhi_user30',               ct.c_float))
        plist.append(('rhi_user31',               ct.c_float))
        plist.append(('rhi_user32',               ct.c_float))
        plist.append(('rhi_user33',               ct.c_float))
        plist.append(('rhi_user34',               ct.c_float))
        plist.append(('rhi_user35',               ct.c_float))
        plist.append(('rhi_user36',               ct.c_float))
        plist.append(('rhi_user37',               ct.c_float))
        plist.append(('rhi_user38',               ct.c_float))
        plist.append(('rhi_user39',               ct.c_float))
        plist.append(('rhi_user40',               ct.c_float))
        plist.append(('rhi_user41',               ct.c_float))
        plist.append(('rhi_user42',               ct.c_float))
        plist.append(('rhi_user43',               ct.c_float))
        plist.append(('rhi_user44',               ct.c_float))
        plist.append(('rhi_user45',               ct.c_float))
        plist.append(('rhi_user46',               ct.c_float))
        plist.append(('rhi_user47',               ct.c_float))
        plist.append(('rhi_user48',               ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 76))
        plist.append(('rhi_ctr_R',                ct.c_float))
        plist.append(('rhi_ctr_A',                ct.c_float))
        plist.append(('rhi_ctr_S',                ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 12))
        plist.append(('rhi_tlhc_R',               ct.c_float))
        plist.append(('rhi_tlhc_A',               ct.c_float))
        plist.append(('rhi_tlhc_S',               ct.c_float))
        plist.append(('rhi_trhc_R',               ct.c_float))
        plist.append(('rhi_trhc_A',               ct.c_float))
        plist.append(('rhi_trhc_S',               ct.c_float))
        plist.append(('rhi_brhc_R',               ct.c_float))
        plist.append(('rhi_brhc_A',               ct.c_float))
        plist.append(('rhi_brhc_S',               ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 196))
        plist.append(('rhi_tr',                   ct.c_int))
        plist.append(('rhi_ti',                   ct.c_int))
        plist.append(('rhi_te',                   ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 306))
        plist.append(('rhi_numecho',              ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 32))
        plist.append(('rhi_mr_flip',              ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 22))
        plist.append(('rhi_ctyp',                 ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 64))
        plist.append(('rhi_freq_dir',             ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 116))
        plist.append(('rhi_psdname',              ct.c_char * 33))
        plist.append(('pad_xx',                   ct.c_char * 84))
        plist.append(('rhi_cname',                ct.c_char * 17))
        plist.append(('pad_xx',                   ct.c_char * 51))
        plist.append(('rhi_image_uid',            ct.c_char * 32))

    elif version_major == 16:
        plist.append(('rhr_rh_rdbm_rev',          ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 12))
        plist.append(('rhr_rh_scan_date',         ct.c_char * 10))
        plist.append(('rhr_rh_scan_time',         ct.c_char * 8))
        plist.append(('rhr_rh_logo',              ct.c_char * 10))
        plist.append(('rhr_rh_file_contents',     ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 10))
        plist.append(('rhr_rh_data_collect_type', ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 6))
        plist.append(('rhr_rh_npasses',           ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 2))
        plist.append(('rhr_rh_nslices',           ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 10))
        plist.append(('rhr_rh_frame_size',        ct.c_ushort))
        plist.append(('rhr_rh_point_size',        ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 32))
        plist.append(('rhr_rh_raw_pass_size',     ct.c_uint))
        plist.append(('pad_xx',                   ct.c_char * 80))
        plist.append(('rhr_rh_dab[0]_start_rcv',  ct.c_short))
        plist.append(('rhr_rh_dab[0]_stop_rcv',   ct.c_short))
        plist.append(('rhr_rh_dab[1]_start_rcv',  ct.c_short))
        plist.append(('rhr_rh_dab[1]_stop_rcv',   ct.c_short))
        plist.append(('rhr_rh_dab[2]_start_rcv',  ct.c_short))
        plist.append(('rhr_rh_dab[2]_stop_rcv',   ct.c_short))
        plist.append(('rhr_rh_dab[3]_start_rcv',  ct.c_short))
        plist.append(('rhr_rh_dab[3]_stop_rcv',   ct.c_short))
        plist.append(('rhr_rh_user0',             ct.c_float))
        plist.append(('rhr_rh_user1',             ct.c_float))
        plist.append(('rhr_rh_user2',             ct.c_float))
        plist.append(('rhr_rh_user3',             ct.c_float))
        plist.append(('rhr_rh_user4',             ct.c_float))
        plist.append(('rhr_rh_user5',             ct.c_float))
        plist.append(('rhr_rh_user6',             ct.c_float))
        plist.append(('rhr_rh_user7',             ct.c_float))
        plist.append(('rhr_rh_user8',             ct.c_float))
        plist.append(('rhr_rh_user9',             ct.c_float))
        plist.append(('rhr_rh_user10',            ct.c_float))
        plist.append(('rhr_rh_user11',            ct.c_float))
        plist.append(('rhr_rh_user12',            ct.c_float))
        plist.append(('rhr_rh_user13',            ct.c_float))
        plist.append(('rhr_rh_user14',            ct.c_float))
        plist.append(('rhr_rh_user15',            ct.c_float))
        plist.append(('rhr_rh_user16',            ct.c_float))
        plist.append(('rhr_rh_user17',            ct.c_float))
        plist.append(('rhr_rh_user18',            ct.c_float))
        plist.append(('rhr_rh_user19',            ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 72))
        plist.append(('rhr_spectral_width',       ct.c_float))
        plist.append(('rhr_csi_dims',             ct.c_short))
        plist.append(('rhr_xcsi',                 ct.c_short))
        plist.append(('rhr_ycsi',                 ct.c_short))
        plist.append(('rhr_zcsi',                 ct.c_short))
        plist.append(('rhr_roilenx',              ct.c_float))
        plist.append(('rhr_roileny',              ct.c_float))
        plist.append(('rhr_roilenz',              ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 32))
        plist.append(('rhr_rh_ps_mps_freq',       ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 560))
        plist.append(('rhr_rh_user_usage_tag',    ct.c_uint))
        plist.append(('pad_xx',                   ct.c_char * 8))
        plist.append(('rhr_rh_user20',            ct.c_float))
        plist.append(('rhr_rh_user21',            ct.c_float))
        plist.append(('rhr_rh_user22',            ct.c_float))
        plist.append(('rhr_rh_user23',            ct.c_float))
        plist.append(('rhr_rh_user24',            ct.c_float))
        plist.append(('rhr_rh_user25',            ct.c_float))
        plist.append(('rhr_rh_user26',            ct.c_float))
        plist.append(('rhr_rh_user27',            ct.c_float))
        plist.append(('rhr_rh_user28',            ct.c_float))
        plist.append(('rhr_rh_user29',            ct.c_float))
        plist.append(('rhr_rh_user30',            ct.c_float))
        plist.append(('rhr_rh_user31',            ct.c_float))
        plist.append(('rhr_rh_user32',            ct.c_float))
        plist.append(('rhr_rh_user33',            ct.c_float))
        plist.append(('rhr_rh_user34',            ct.c_float))
        plist.append(('rhr_rh_user35',            ct.c_float))
        plist.append(('rhr_rh_user36',            ct.c_float))
        plist.append(('rhr_rh_user37',            ct.c_float))
        plist.append(('rhr_rh_user38',            ct.c_float))
        plist.append(('rhr_rh_user39',            ct.c_float))
        plist.append(('rhr_rh_user40',            ct.c_float))
        plist.append(('rhr_rh_user41',            ct.c_float))
        plist.append(('rhr_rh_user42',            ct.c_float))
        plist.append(('rhr_rh_user43',            ct.c_float))
        plist.append(('rhr_rh_user44',            ct.c_float))
        plist.append(('rhr_rh_user45',            ct.c_float))
        plist.append(('rhr_rh_user46',            ct.c_float))
        plist.append(('rhr_rh_user47',            ct.c_float))
        plist.append(('rhr_rh_user48',            ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 352))
        plist.append(('rhr_rdb_hdr_off_data',     ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 139508))
        plist.append(('rhe_magstrength',          ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 4))
        plist.append(('rhe_ex_datetime',          ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 52))
        plist.append(('rhe_ex_no',                ct.c_ushort))
        plist.append(('pad_xx',                   ct.c_char * 22))
        plist.append(('rhe_patsex',               ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 91))
        plist.append(('rhe_reqnum',               ct.c_char * 13))
        plist.append(('rhe_refphy',               ct.c_char * 33))
        plist.append(('pad_xx',                   ct.c_char * 105))
        plist.append(('rhe_ex_sysid',             ct.c_char * 9))
        plist.append(('pad_xx',                   ct.c_char * 14))
        plist.append(('rhe_hospname',             ct.c_char * 33))
        plist.append(('rhe_patid',                ct.c_char * 13))
        plist.append(('rhe_patname',              ct.c_char * 25))
        plist.append(('pad_xx',                   ct.c_char * 4))
        plist.append(('rhe_ex_verscre',           ct.c_char * 2))
        plist.append(('pad_xx',                   ct.c_char * 2))
        plist.append(('rhe_uniq_sys_id',          ct.c_char * 16))
        plist.append(('pad_xx',                   ct.c_char * 20))
        plist.append(('rhe_study_uid',            ct.c_char * 32))
        plist.append(('pad_xx',                   ct.c_char * 64))
        plist.append(('rhe_patnameff',            ct.c_char * 65))
        plist.append(('rhe_patidff',              ct.c_char * 65))
        plist.append(('rhe_reqnumff',             ct.c_char * 17))
        plist.append(('rhe_dateofbirth',          ct.c_char * 9))
        plist.append(('pad_xx',                   ct.c_char * 358))
        plist.append(('rhs_position',             ct.c_int))
        plist.append(('rhs_entry',                ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 126))
        plist.append(('rhs_se_no',                ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 122))
        plist.append(('rhs_se_desc',              ct.c_char * 65))
        plist.append(('pad_xx',                   ct.c_char * 18))
        plist.append(('rhs_anref',                ct.c_char * 3))
        plist.append(('pad_xx',                   ct.c_char * 27))
        plist.append(('rhs_series_uid',           ct.c_char * 32))
        plist.append(('rhs_landmark_uid',         ct.c_char * 32))
        plist.append(('pad_xx',                   ct.c_char * 1477))
        plist.append(('rhi_dfov',                 ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 12))
        plist.append(('rhi_scanspacing',          ct.c_float))
        plist.append(('rhi_loc',                  ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 4))
        plist.append(('rhi_nex',                  ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 20))
        plist.append(('rhi_user0',                ct.c_float))
        plist.append(('rhi_user1',                ct.c_float))
        plist.append(('rhi_user2',                ct.c_float))
        plist.append(('rhi_user3',                ct.c_float))
        plist.append(('rhi_user4',                ct.c_float))
        plist.append(('rhi_user5',                ct.c_float))
        plist.append(('rhi_user6',                ct.c_float))
        plist.append(('rhi_user7',                ct.c_float))
        plist.append(('rhi_user8',                ct.c_float))
        plist.append(('rhi_user9',                ct.c_float))
        plist.append(('rhi_user10',               ct.c_float))
        plist.append(('rhi_user11',               ct.c_float))
        plist.append(('rhi_user12',               ct.c_float))
        plist.append(('rhi_user13',               ct.c_float))
        plist.append(('rhi_user14',               ct.c_float))
        plist.append(('rhi_user15',               ct.c_float))
        plist.append(('rhi_user16',               ct.c_float))
        plist.append(('rhi_user17',               ct.c_float))
        plist.append(('rhi_user18',               ct.c_float))
        plist.append(('rhi_user19',               ct.c_float))
        plist.append(('rhi_user20',               ct.c_float))
        plist.append(('rhi_user21',               ct.c_float))
        plist.append(('rhi_user22',               ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 8))
        plist.append(('rhi_user23',               ct.c_float))
        plist.append(('rhi_user24',               ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 60))
        plist.append(('rhi_user25',               ct.c_float))
        plist.append(('rhi_user26',               ct.c_float))
        plist.append(('rhi_user27',               ct.c_float))
        plist.append(('rhi_user28',               ct.c_float))
        plist.append(('rhi_user29',               ct.c_float))
        plist.append(('rhi_user30',               ct.c_float))
        plist.append(('rhi_user31',               ct.c_float))
        plist.append(('rhi_user32',               ct.c_float))
        plist.append(('rhi_user33',               ct.c_float))
        plist.append(('rhi_user34',               ct.c_float))
        plist.append(('rhi_user35',               ct.c_float))
        plist.append(('rhi_user36',               ct.c_float))
        plist.append(('rhi_user37',               ct.c_float))
        plist.append(('rhi_user38',               ct.c_float))
        plist.append(('rhi_user39',               ct.c_float))
        plist.append(('rhi_user40',               ct.c_float))
        plist.append(('rhi_user41',               ct.c_float))
        plist.append(('rhi_user42',               ct.c_float))
        plist.append(('rhi_user43',               ct.c_float))
        plist.append(('rhi_user44',               ct.c_float))
        plist.append(('rhi_user45',               ct.c_float))
        plist.append(('rhi_user46',               ct.c_float))
        plist.append(('rhi_user47',               ct.c_float))
        plist.append(('rhi_user48',               ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 76))
        plist.append(('rhi_ctr_R',                ct.c_float))
        plist.append(('rhi_ctr_A',                ct.c_float))
        plist.append(('rhi_ctr_S',                ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 12))
        plist.append(('rhi_tlhc_R',               ct.c_float))
        plist.append(('rhi_tlhc_A',               ct.c_float))
        plist.append(('rhi_tlhc_S',               ct.c_float))
        plist.append(('rhi_trhc_R',               ct.c_float))
        plist.append(('rhi_trhc_A',               ct.c_float))
        plist.append(('rhi_trhc_S',               ct.c_float))
        plist.append(('rhi_brhc_R',               ct.c_float))
        plist.append(('rhi_brhc_A',               ct.c_float))
        plist.append(('rhi_brhc_S',               ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 196))
        plist.append(('rhi_tr',                   ct.c_int))
        plist.append(('rhi_ti',                   ct.c_int))
        plist.append(('rhi_te',                   ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 306))
        plist.append(('rhi_numecho',              ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 32))
        plist.append(('rhi_mr_flip',              ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 22))
        plist.append(('rhi_ctyp',                 ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 64))
        plist.append(('rhi_freq_dir',             ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 116))
        plist.append(('rhi_psdname',              ct.c_char * 33))
        plist.append(('pad_xx',                   ct.c_char * 84))
        plist.append(('rhi_cname',                ct.c_char * 17))
        plist.append(('pad_xx',                   ct.c_char * 51))
        plist.append(('rhi_image_uid',            ct.c_char * 32))

    elif version_major == 20:
        plist.append(('rhr_rh_rdbm_rev',          ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 12))
        plist.append(('rhr_rh_scan_date',         ct.c_char * 10))
        plist.append(('rhr_rh_scan_time',         ct.c_char * 8))
        plist.append(('rhr_rh_logo',              ct.c_char * 10))
        plist.append(('rhr_rh_file_contents',     ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 10))
        plist.append(('rhr_rh_data_collect_type', ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 6))
        plist.append(('rhr_rh_npasses',           ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 2))
        plist.append(('rhr_rh_nslices',           ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 10))
        plist.append(('rhr_rh_frame_size',        ct.c_ushort))
        plist.append(('rhr_rh_point_size',        ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 116))
        plist.append(('rhr_rh_dab[0]_start_rcv',  ct.c_short))
        plist.append(('rhr_rh_dab[0]_stop_rcv',   ct.c_short))
        plist.append(('rhr_rh_dab[1]_start_rcv',  ct.c_short))
        plist.append(('rhr_rh_dab[1]_stop_rcv',   ct.c_short))
        plist.append(('rhr_rh_dab[2]_start_rcv',  ct.c_short))
        plist.append(('rhr_rh_dab[2]_stop_rcv',   ct.c_short))
        plist.append(('rhr_rh_dab[3]_start_rcv',  ct.c_short))
        plist.append(('rhr_rh_dab[3]_stop_rcv',   ct.c_short))
        plist.append(('rhr_rh_user0',             ct.c_float))
        plist.append(('rhr_rh_user1',             ct.c_float))
        plist.append(('rhr_rh_user2',             ct.c_float))
        plist.append(('rhr_rh_user3',             ct.c_float))
        plist.append(('rhr_rh_user4',             ct.c_float))
        plist.append(('rhr_rh_user5',             ct.c_float))
        plist.append(('rhr_rh_user6',             ct.c_float))
        plist.append(('rhr_rh_user7',             ct.c_float))
        plist.append(('rhr_rh_user8',             ct.c_float))
        plist.append(('rhr_rh_user9',             ct.c_float))
        plist.append(('rhr_rh_user10',            ct.c_float))
        plist.append(('rhr_rh_user11',            ct.c_float))
        plist.append(('rhr_rh_user12',            ct.c_float))
        plist.append(('rhr_rh_user13',            ct.c_float))
        plist.append(('rhr_rh_user14',            ct.c_float))
        plist.append(('rhr_rh_user15',            ct.c_float))
        plist.append(('rhr_rh_user16',            ct.c_float))
        plist.append(('rhr_rh_user17',            ct.c_float))
        plist.append(('rhr_rh_user18',            ct.c_float))
        plist.append(('rhr_rh_user19',            ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 72))
        plist.append(('rhr_spectral_width',       ct.c_float))
        plist.append(('rhr_csi_dims',             ct.c_short))
        plist.append(('rhr_xcsi',                 ct.c_short))
        plist.append(('rhr_ycsi',                 ct.c_short))
        plist.append(('rhr_zcsi',                 ct.c_short))
        plist.append(('rhr_roilenx',              ct.c_float))
        plist.append(('rhr_roileny',              ct.c_float))
        plist.append(('rhr_roilenz',              ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 32))
        plist.append(('rhr_rh_ps_mps_freq',       ct.c_uint))
        plist.append(('pad_xx',                   ct.c_char * 560))
        plist.append(('rhr_rh_user_usage_tag',    ct.c_uint))
        plist.append(('pad_xx',                   ct.c_char * 8))
        plist.append(('rhr_rh_user20',            ct.c_float))
        plist.append(('rhr_rh_user21',            ct.c_float))
        plist.append(('rhr_rh_user22',            ct.c_float))
        plist.append(('rhr_rh_user23',            ct.c_float))
        plist.append(('rhr_rh_user24',            ct.c_float))
        plist.append(('rhr_rh_user25',            ct.c_float))
        plist.append(('rhr_rh_user26',            ct.c_float))
        plist.append(('rhr_rh_user27',            ct.c_float))
        plist.append(('rhr_rh_user28',            ct.c_float))
        plist.append(('rhr_rh_user29',            ct.c_float))
        plist.append(('rhr_rh_user30',            ct.c_float))
        plist.append(('rhr_rh_user31',            ct.c_float))
        plist.append(('rhr_rh_user32',            ct.c_float))
        plist.append(('rhr_rh_user33',            ct.c_float))
        plist.append(('rhr_rh_user34',            ct.c_float))
        plist.append(('rhr_rh_user35',            ct.c_float))
        plist.append(('rhr_rh_user36',            ct.c_float))
        plist.append(('rhr_rh_user37',            ct.c_float))
        plist.append(('rhr_rh_user38',            ct.c_float))
        plist.append(('rhr_rh_user39',            ct.c_float))
        plist.append(('rhr_rh_user40',            ct.c_float))
        plist.append(('rhr_rh_user41',            ct.c_float))
        plist.append(('rhr_rh_user42',            ct.c_float))
        plist.append(('rhr_rh_user43',            ct.c_float))
        plist.append(('rhr_rh_user44',            ct.c_float))
        plist.append(('rhr_rh_user45',            ct.c_float))
        plist.append(('rhr_rh_user46',            ct.c_float))
        plist.append(('rhr_rh_user47',            ct.c_float))
        plist.append(('rhr_rh_user48',            ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 352))
        plist.append(('rhr_rdb_hdr_off_data',     ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 188))
        plist.append(('rhr_rh_raw_pass_size',     ct.c_longlong))
        plist.append(('pad_xx',                   ct.c_char * 141724))
        plist.append(('rhe_magstrength',          ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 4))
        plist.append(('rhe_ex_datetime',          ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 112))
        plist.append(('rhe_ex_no',                ct.c_ushort))
        plist.append(('pad_xx',                   ct.c_char * 22))
        plist.append(('rhe_patsex',               ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 335))
        plist.append(('rhe_refphy',               ct.c_char * 65))
        plist.append(('pad_xx',                   ct.c_char * 198))
        plist.append(('rhe_ex_sysid',             ct.c_char * 9))
        plist.append(('pad_xx',                   ct.c_char * 14))
        plist.append(('rhe_hospname',             ct.c_char * 33))
        plist.append(('pad_xx',                   ct.c_char * 4))
        plist.append(('rhe_ex_verscre',           ct.c_char * 2))
        plist.append(('pad_xx',                   ct.c_char * 2))
        plist.append(('rhe_uniq_sys_id',          ct.c_char * 16))
        plist.append(('pad_xx',                   ct.c_char * 20))
        plist.append(('rhe_study_uid',            ct.c_char * 32))
        plist.append(('pad_xx',                   ct.c_char * 64))
        plist.append(('rhe_patname',              ct.c_char * 65))
        plist.append(('rhe_patid',                ct.c_char * 65))
        plist.append(('rhe_reqnum',               ct.c_char * 17))
        plist.append(('rhe_dateofbirth',          ct.c_char * 9))
        plist.append(('pad_xx',                   ct.c_char * 928))
        plist.append(('rhs_position',             ct.c_int))
        plist.append(('rhs_entry',                ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 194))
        plist.append(('rhs_se_no',                ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 138))
        plist.append(('rhs_se_desc',              ct.c_char * 65))
        plist.append(('pad_xx',                   ct.c_char * 18))
        plist.append(('rhs_anref',                ct.c_char * 3))
        plist.append(('pad_xx',                   ct.c_char * 27))
        plist.append(('rhs_series_uid',           ct.c_char * 32))
        plist.append(('rhs_landmark_uid',         ct.c_char * 32))
        plist.append(('pad_xx',                   ct.c_char * 1705))
        plist.append(('rhi_dfov',                 ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 12))
        plist.append(('rhi_scanspacing',          ct.c_float))
        plist.append(('rhi_loc',                  ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 4))
        plist.append(('rhi_nex',                  ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 20))
        plist.append(('rhi_user0',                ct.c_float))
        plist.append(('rhi_user1',                ct.c_float))
        plist.append(('rhi_user2',                ct.c_float))
        plist.append(('rhi_user3',                ct.c_float))
        plist.append(('rhi_user4',                ct.c_float))
        plist.append(('rhi_user5',                ct.c_float))
        plist.append(('rhi_user6',                ct.c_float))
        plist.append(('rhi_user7',                ct.c_float))
        plist.append(('rhi_user8',                ct.c_float))
        plist.append(('rhi_user9',                ct.c_float))
        plist.append(('rhi_user10',               ct.c_float))
        plist.append(('rhi_user11',               ct.c_float))
        plist.append(('rhi_user12',               ct.c_float))
        plist.append(('rhi_user13',               ct.c_float))
        plist.append(('rhi_user14',               ct.c_float))
        plist.append(('rhi_user15',               ct.c_float))
        plist.append(('rhi_user16',               ct.c_float))
        plist.append(('rhi_user17',               ct.c_float))
        plist.append(('rhi_user18',               ct.c_float))
        plist.append(('rhi_user19',               ct.c_float))
        plist.append(('rhi_user20',               ct.c_float))
        plist.append(('rhi_user21',               ct.c_float))
        plist.append(('rhi_user22',               ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 8))
        plist.append(('rhi_user23',               ct.c_float))
        plist.append(('rhi_user24',               ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 60))
        plist.append(('rhi_user25',               ct.c_float))
        plist.append(('rhi_user26',               ct.c_float))
        plist.append(('rhi_user27',               ct.c_float))
        plist.append(('rhi_user28',               ct.c_float))
        plist.append(('rhi_user29',               ct.c_float))
        plist.append(('rhi_user30',               ct.c_float))
        plist.append(('rhi_user31',               ct.c_float))
        plist.append(('rhi_user32',               ct.c_float))
        plist.append(('rhi_user33',               ct.c_float))
        plist.append(('rhi_user34',               ct.c_float))
        plist.append(('rhi_user35',               ct.c_float))
        plist.append(('rhi_user36',               ct.c_float))
        plist.append(('rhi_user37',               ct.c_float))
        plist.append(('rhi_user38',               ct.c_float))
        plist.append(('rhi_user39',               ct.c_float))
        plist.append(('rhi_user40',               ct.c_float))
        plist.append(('rhi_user41',               ct.c_float))
        plist.append(('rhi_user42',               ct.c_float))
        plist.append(('rhi_user43',               ct.c_float))
        plist.append(('rhi_user44',               ct.c_float))
        plist.append(('rhi_user45',               ct.c_float))
        plist.append(('rhi_user46',               ct.c_float))
        plist.append(('rhi_user47',               ct.c_float))
        plist.append(('rhi_user48',               ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 76))
        plist.append(('rhi_ctr_R',                ct.c_float))
        plist.append(('rhi_ctr_A',                ct.c_float))
        plist.append(('rhi_ctr_S',                ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 12))
        plist.append(('rhi_tlhc_R',               ct.c_float))
        plist.append(('rhi_tlhc_A',               ct.c_float))
        plist.append(('rhi_tlhc_S',               ct.c_float))
        plist.append(('rhi_trhc_R',               ct.c_float))
        plist.append(('rhi_trhc_A',               ct.c_float))
        plist.append(('rhi_trhc_S',               ct.c_float))
        plist.append(('rhi_brhc_R',               ct.c_float))
        plist.append(('rhi_brhc_A',               ct.c_float))
        plist.append(('rhi_brhc_S',               ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 300))
        plist.append(('rhi_tr',                   ct.c_int))
        plist.append(('rhi_ti',                   ct.c_int))
        plist.append(('rhi_te',                   ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 310))
        plist.append(('rhi_numecho',              ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 32))
        plist.append(('rhi_mr_flip',              ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 20))
        plist.append(('rhi_ctyp',                 ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 64))
        plist.append(('rhi_freq_dir',             ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 130))
        plist.append(('rhi_psdname',              ct.c_char * 33))
        plist.append(('pad_xx',                   ct.c_char * 84))
        plist.append(('rhi_cname',                ct.c_char * 17))
        plist.append(('pad_xx',                   ct.c_char * 51))
        plist.append(('rhi_image_uid',            ct.c_char * 32))

    elif version_major < 23:  # 21-23
        plist.append(('rhr_rh_rdbm_rev',          ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 12))
        plist.append(('rhr_rh_scan_date',         ct.c_char * 10))
        plist.append(('rhr_rh_scan_time',         ct.c_char * 8))
        plist.append(('rhr_rh_logo',              ct.c_char * 10))
        plist.append(('rhr_rh_file_contents',     ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 10))
        plist.append(('rhr_rh_data_collect_type', ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 6))
        plist.append(('rhr_rh_npasses',           ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 2))
        plist.append(('rhr_rh_nslices',           ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 10))
        plist.append(('rhr_rh_frame_size',        ct.c_ushort))
        plist.append(('rhr_rh_point_size',        ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 116))
        plist.append(('rhr_rh_dab[0]_start_rcv',  ct.c_short))
        plist.append(('rhr_rh_dab[0]_stop_rcv',   ct.c_short))
        plist.append(('rhr_rh_dab[1]_start_rcv',  ct.c_short))
        plist.append(('rhr_rh_dab[1]_stop_rcv',   ct.c_short))
        plist.append(('rhr_rh_dab[2]_start_rcv',  ct.c_short))
        plist.append(('rhr_rh_dab[2]_stop_rcv',   ct.c_short))
        plist.append(('rhr_rh_dab[3]_start_rcv',  ct.c_short))
        plist.append(('rhr_rh_dab[3]_stop_rcv',   ct.c_short))
        plist.append(('rhr_rh_user0',             ct.c_float))
        plist.append(('rhr_rh_user1',             ct.c_float))
        plist.append(('rhr_rh_user2',             ct.c_float))
        plist.append(('rhr_rh_user3',             ct.c_float))
        plist.append(('rhr_rh_user4',             ct.c_float))
        plist.append(('rhr_rh_user5',             ct.c_float))
        plist.append(('rhr_rh_user6',             ct.c_float))
        plist.append(('rhr_rh_user7',             ct.c_float))
        plist.append(('rhr_rh_user8',             ct.c_float))
        plist.append(('rhr_rh_user9',             ct.c_float))
        plist.append(('rhr_rh_user10',            ct.c_float))
        plist.append(('rhr_rh_user11',            ct.c_float))
        plist.append(('rhr_rh_user12',            ct.c_float))
        plist.append(('rhr_rh_user13',            ct.c_float))
        plist.append(('rhr_rh_user14',            ct.c_float))
        plist.append(('rhr_rh_user15',            ct.c_float))
        plist.append(('rhr_rh_user16',            ct.c_float))
        plist.append(('rhr_rh_user17',            ct.c_float))
        plist.append(('rhr_rh_user18',            ct.c_float))
        plist.append(('rhr_rh_user19',            ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 72))
        plist.append(('rhr_spectral_width',       ct.c_float))
        plist.append(('rhr_csi_dims',             ct.c_short))
        plist.append(('rhr_xcsi',                 ct.c_short))
        plist.append(('rhr_ycsi',                 ct.c_short))
        plist.append(('rhr_zcsi',                 ct.c_short))
        plist.append(('rhr_roilenx',              ct.c_float))
        plist.append(('rhr_roileny',              ct.c_float))
        plist.append(('rhr_roilenz',              ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 32))
        plist.append(('rhr_rh_ps_mps_freq',       ct.c_uint))
        plist.append(('pad_xx',                   ct.c_char * 560))
        plist.append(('rhr_rh_user_usage_tag',    ct.c_uint))
        plist.append(('pad_xx',                   ct.c_char * 8))
        plist.append(('rhr_rh_user20',            ct.c_float))
        plist.append(('rhr_rh_user21',            ct.c_float))
        plist.append(('rhr_rh_user22',            ct.c_float))
        plist.append(('rhr_rh_user23',            ct.c_float))
        plist.append(('rhr_rh_user24',            ct.c_float))
        plist.append(('rhr_rh_user25',            ct.c_float))
        plist.append(('rhr_rh_user26',            ct.c_float))
        plist.append(('rhr_rh_user27',            ct.c_float))
        plist.append(('rhr_rh_user28',            ct.c_float))
        plist.append(('rhr_rh_user29',            ct.c_float))
        plist.append(('rhr_rh_user30',            ct.c_float))
        plist.append(('rhr_rh_user31',            ct.c_float))
        plist.append(('rhr_rh_user32',            ct.c_float))
        plist.append(('rhr_rh_user33',            ct.c_float))
        plist.append(('rhr_rh_user34',            ct.c_float))
        plist.append(('rhr_rh_user35',            ct.c_float))
        plist.append(('rhr_rh_user36',            ct.c_float))
        plist.append(('rhr_rh_user37',            ct.c_float))
        plist.append(('rhr_rh_user38',            ct.c_float))
        plist.append(('rhr_rh_user39',            ct.c_float))
        plist.append(('rhr_rh_user40',            ct.c_float))
        plist.append(('rhr_rh_user41',            ct.c_float))
        plist.append(('rhr_rh_user42',            ct.c_float))
        plist.append(('rhr_rh_user43',            ct.c_float))
        plist.append(('rhr_rh_user44',            ct.c_float))
        plist.append(('rhr_rh_user45',            ct.c_float))
        plist.append(('rhr_rh_user46',            ct.c_float))
        plist.append(('rhr_rh_user47',            ct.c_float))
        plist.append(('rhr_rh_user48',            ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 352))
        plist.append(('rhr_rdb_hdr_off_data',     ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 188))
        plist.append(('rhr_rh_raw_pass_size',     ct.c_longlong))
        plist.append(('pad_xx',                   ct.c_char * 142272))
        plist.append(('rhe_magstrength',          ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 4))
        plist.append(('rhe_ex_datetime',          ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 112))
        plist.append(('rhe_ex_no',                ct.c_ushort))
        plist.append(('pad_xx',                   ct.c_char * 22))
        plist.append(('rhe_patsex',               ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 335))
        plist.append(('rhe_refphy',               ct.c_char * 65))
        plist.append(('pad_xx',                   ct.c_char * 198))
        plist.append(('rhe_ex_sysid',             ct.c_char * 9))
        plist.append(('pad_xx',                   ct.c_char * 14))
        plist.append(('rhe_hospname',             ct.c_char * 33))
        plist.append(('pad_xx',                   ct.c_char * 4))
        plist.append(('rhe_ex_verscre',           ct.c_char * 2))
        plist.append(('pad_xx',                   ct.c_char * 2))
        plist.append(('rhe_uniq_sys_id',          ct.c_char * 16))
        plist.append(('pad_xx',                   ct.c_char * 20))
        plist.append(('rhe_study_uid',            ct.c_char * 32))
        plist.append(('pad_xx',                   ct.c_char * 64))
        plist.append(('rhe_patname',              ct.c_char * 65))
        plist.append(('rhe_patid',                ct.c_char * 65))
        plist.append(('rhe_reqnum',               ct.c_char * 17))
        plist.append(('rhe_dateofbirth',          ct.c_char * 9))
        plist.append(('pad_xx',                   ct.c_char * 928))
        plist.append(('rhs_position',             ct.c_int))
        plist.append(('rhs_entry',                ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 194))
        plist.append(('rhs_se_no',                ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 138))
        plist.append(('rhs_se_desc',              ct.c_char * 65))
        plist.append(('pad_xx',                   ct.c_char * 18))
        plist.append(('rhs_anref',                ct.c_char * 3))
        plist.append(('pad_xx',                   ct.c_char * 27))
        plist.append(('rhs_series_uid',           ct.c_char * 32))
        plist.append(('rhs_landmark_uid',         ct.c_char * 32))
        plist.append(('pad_xx',                   ct.c_char * 1705))
        plist.append(('rhi_dfov',                 ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 12))
        plist.append(('rhi_scanspacing',          ct.c_float))
        plist.append(('rhi_loc',                  ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 4))
        plist.append(('rhi_nex',                  ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 20))
        plist.append(('rhi_user0',                ct.c_float))
        plist.append(('rhi_user1',                ct.c_float))
        plist.append(('rhi_user2',                ct.c_float))
        plist.append(('rhi_user3',                ct.c_float))
        plist.append(('rhi_user4',                ct.c_float))
        plist.append(('rhi_user5',                ct.c_float))
        plist.append(('rhi_user6',                ct.c_float))
        plist.append(('rhi_user7',                ct.c_float))
        plist.append(('rhi_user8',                ct.c_float))
        plist.append(('rhi_user9',                ct.c_float))
        plist.append(('rhi_user10',               ct.c_float))
        plist.append(('rhi_user11',               ct.c_float))
        plist.append(('rhi_user12',               ct.c_float))
        plist.append(('rhi_user13',               ct.c_float))
        plist.append(('rhi_user14',               ct.c_float))
        plist.append(('rhi_user15',               ct.c_float))
        plist.append(('rhi_user16',               ct.c_float))
        plist.append(('rhi_user17',               ct.c_float))
        plist.append(('rhi_user18',               ct.c_float))
        plist.append(('rhi_user19',               ct.c_float))
        plist.append(('rhi_user20',               ct.c_float))
        plist.append(('rhi_user21',               ct.c_float))
        plist.append(('rhi_user22',               ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 8))
        plist.append(('rhi_user23',               ct.c_float))
        plist.append(('rhi_user24',               ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 60))
        plist.append(('rhi_user25',               ct.c_float))
        plist.append(('rhi_user26',               ct.c_float))
        plist.append(('rhi_user27',               ct.c_float))
        plist.append(('rhi_user28',               ct.c_float))
        plist.append(('rhi_user29',               ct.c_float))
        plist.append(('rhi_user30',               ct.c_float))
        plist.append(('rhi_user31',               ct.c_float))
        plist.append(('rhi_user32',               ct.c_float))
        plist.append(('rhi_user33',               ct.c_float))
        plist.append(('rhi_user34',               ct.c_float))
        plist.append(('rhi_user35',               ct.c_float))
        plist.append(('rhi_user36',               ct.c_float))
        plist.append(('rhi_user37',               ct.c_float))
        plist.append(('rhi_user38',               ct.c_float))
        plist.append(('rhi_user39',               ct.c_float))
        plist.append(('rhi_user40',               ct.c_float))
        plist.append(('rhi_user41',               ct.c_float))
        plist.append(('rhi_user42',               ct.c_float))
        plist.append(('rhi_user43',               ct.c_float))
        plist.append(('rhi_user44',               ct.c_float))
        plist.append(('rhi_user45',               ct.c_float))
        plist.append(('rhi_user46',               ct.c_float))
        plist.append(('rhi_user47',               ct.c_float))
        plist.append(('rhi_user48',               ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 76))
        plist.append(('rhi_ctr_R',                ct.c_float))
        plist.append(('rhi_ctr_A',                ct.c_float))
        plist.append(('rhi_ctr_S',                ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 12))
        plist.append(('rhi_tlhc_R',               ct.c_float))
        plist.append(('rhi_tlhc_A',               ct.c_float))
        plist.append(('rhi_tlhc_S',               ct.c_float))
        plist.append(('rhi_trhc_R',               ct.c_float))
        plist.append(('rhi_trhc_A',               ct.c_float))
        plist.append(('rhi_trhc_S',               ct.c_float))
        plist.append(('rhi_brhc_R',               ct.c_float))
        plist.append(('rhi_brhc_A',               ct.c_float))
        plist.append(('rhi_brhc_S',               ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 300))
        plist.append(('rhi_tr',                   ct.c_int))
        plist.append(('rhi_ti',                   ct.c_int))
        plist.append(('rhi_te',                   ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 310))
        plist.append(('rhi_numecho',              ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 32))
        plist.append(('rhi_mr_flip',              ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 20))
        plist.append(('rhi_ctyp',                 ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 64))
        plist.append(('rhi_freq_dir',             ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 130))
        plist.append(('rhi_psdname',              ct.c_char * 33))
        plist.append(('pad_xx',                   ct.c_char * 84))
        plist.append(('rhi_cname',                ct.c_char * 17))
        plist.append(('pad_xx',                   ct.c_char * 51))
        plist.append(('rhi_image_uid',            ct.c_char * 32))

    elif version_major == 23:
        plist.append(('rhr_rh_rdbm_rev',          ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 12))
        plist.append(('rhr_rh_scan_date',         ct.c_char * 10))
        plist.append(('rhr_rh_scan_time',         ct.c_char * 8))
        plist.append(('rhr_rh_logo',              ct.c_char * 10))
        plist.append(('rhr_rh_file_contents',     ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 10))
        plist.append(('rhr_rh_data_collect_type', ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 6))
        plist.append(('rhr_rh_npasses',           ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 2))
        plist.append(('rhr_rh_nslices',           ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 10))
        plist.append(('rhr_rh_frame_size',        ct.c_ushort))
        plist.append(('rhr_rh_point_size',        ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 116))
        plist.append(('rhr_rh_dab[0]_start_rcv',  ct.c_short))
        plist.append(('rhr_rh_dab[0]_stop_rcv',   ct.c_short))
        plist.append(('rhr_rh_dab[1]_start_rcv',  ct.c_short))
        plist.append(('rhr_rh_dab[1]_stop_rcv',   ct.c_short))
        plist.append(('rhr_rh_dab[2]_start_rcv',  ct.c_short))
        plist.append(('rhr_rh_dab[2]_stop_rcv',   ct.c_short))
        plist.append(('rhr_rh_dab[3]_start_rcv',  ct.c_short))
        plist.append(('rhr_rh_dab[3]_stop_rcv',   ct.c_short))
        plist.append(('rhr_rh_user0',             ct.c_float))
        plist.append(('rhr_rh_user1',             ct.c_float))
        plist.append(('rhr_rh_user2',             ct.c_float))
        plist.append(('rhr_rh_user3',             ct.c_float))
        plist.append(('rhr_rh_user4',             ct.c_float))
        plist.append(('rhr_rh_user5',             ct.c_float))
        plist.append(('rhr_rh_user6',             ct.c_float))
        plist.append(('rhr_rh_user7',             ct.c_float))
        plist.append(('rhr_rh_user8',             ct.c_float))
        plist.append(('rhr_rh_user9',             ct.c_float))
        plist.append(('rhr_rh_user10',            ct.c_float))
        plist.append(('rhr_rh_user11',            ct.c_float))
        plist.append(('rhr_rh_user12',            ct.c_float))
        plist.append(('rhr_rh_user13',            ct.c_float))
        plist.append(('rhr_rh_user14',            ct.c_float))
        plist.append(('rhr_rh_user15',            ct.c_float))
        plist.append(('rhr_rh_user16',            ct.c_float))
        plist.append(('rhr_rh_user17',            ct.c_float))
        plist.append(('rhr_rh_user18',            ct.c_float))
        plist.append(('rhr_rh_user19',            ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 72))
        plist.append(('rhr_spectral_width',       ct.c_float))
        plist.append(('rhr_csi_dims',             ct.c_short))
        plist.append(('rhr_xcsi',                 ct.c_short))
        plist.append(('rhr_ycsi',                 ct.c_short))
        plist.append(('rhr_zcsi',                 ct.c_short))
        plist.append(('rhr_roilenx',              ct.c_float))
        plist.append(('rhr_roileny',              ct.c_float))
        plist.append(('rhr_roilenz',              ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 32))
        plist.append(('rhr_rh_ps_mps_freq',       ct.c_uint))
        plist.append(('pad_xx',                   ct.c_char * 560))
        plist.append(('rhr_rh_user_usage_tag',    ct.c_uint))
        plist.append(('pad_xx',                   ct.c_char * 8))
        plist.append(('rhr_rh_user20',            ct.c_float))
        plist.append(('rhr_rh_user21',            ct.c_float))
        plist.append(('rhr_rh_user22',            ct.c_float))
        plist.append(('rhr_rh_user23',            ct.c_float))
        plist.append(('rhr_rh_user24',            ct.c_float))
        plist.append(('rhr_rh_user25',            ct.c_float))
        plist.append(('rhr_rh_user26',            ct.c_float))
        plist.append(('rhr_rh_user27',            ct.c_float))
        plist.append(('rhr_rh_user28',            ct.c_float))
        plist.append(('rhr_rh_user29',            ct.c_float))
        plist.append(('rhr_rh_user30',            ct.c_float))
        plist.append(('rhr_rh_user31',            ct.c_float))
        plist.append(('rhr_rh_user32',            ct.c_float))
        plist.append(('rhr_rh_user33',            ct.c_float))
        plist.append(('rhr_rh_user34',            ct.c_float))
        plist.append(('rhr_rh_user35',            ct.c_float))
        plist.append(('rhr_rh_user36',            ct.c_float))
        plist.append(('rhr_rh_user37',            ct.c_float))
        plist.append(('rhr_rh_user38',            ct.c_float))
        plist.append(('rhr_rh_user39',            ct.c_float))
        plist.append(('rhr_rh_user40',            ct.c_float))
        plist.append(('rhr_rh_user41',            ct.c_float))
        plist.append(('rhr_rh_user42',            ct.c_float))
        plist.append(('rhr_rh_user43',            ct.c_float))
        plist.append(('rhr_rh_user44',            ct.c_float))
        plist.append(('rhr_rh_user45',            ct.c_float))
        plist.append(('rhr_rh_user46',            ct.c_float))
        plist.append(('rhr_rh_user47',            ct.c_float))
        plist.append(('rhr_rh_user48',            ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 352))
        plist.append(('rhr_rdb_hdr_off_data',     ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 188))
        plist.append(('rhr_rh_raw_pass_size',     ct.c_longlong))
        plist.append(('pad_xx',                   ct.c_char * 141724))
        plist.append(('rhe_magstrength',          ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 4))
        plist.append(('rhe_ex_datetime',          ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 112))
        plist.append(('rhe_ex_no',                ct.c_ushort))
        plist.append(('pad_xx',                   ct.c_char * 22))
        plist.append(('rhe_patsex',               ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 335))
        plist.append(('rhe_refphy',               ct.c_char * 65))
        plist.append(('pad_xx',                   ct.c_char * 198))
        plist.append(('rhe_ex_sysid',             ct.c_char * 9))
        plist.append(('pad_xx',                   ct.c_char * 22))
        plist.append(('rhe_hospname',             ct.c_char * 33))
        plist.append(('pad_xx',                   ct.c_char * 4))
        plist.append(('rhe_ex_verscre',           ct.c_char * 2))
        plist.append(('pad_xx',                   ct.c_char * 2))
        plist.append(('rhe_uniq_sys_id',          ct.c_char * 16))
        plist.append(('pad_xx',                   ct.c_char * 20))
        plist.append(('rhe_study_uid',            ct.c_char * 32))
        plist.append(('pad_xx',                   ct.c_char * 64))
        plist.append(('rhe_patname',              ct.c_char * 65))
        plist.append(('rhe_patid',                ct.c_char * 65))
        plist.append(('rhe_reqnum',               ct.c_char * 17))
        plist.append(('rhe_dateofbirth',          ct.c_char * 9))
        plist.append(('pad_xx',                   ct.c_char * 920))
        plist.append(('rhs_position',             ct.c_int))
        plist.append(('rhs_entry',                ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 194))
        plist.append(('rhs_se_no',                ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 138))
        plist.append(('rhs_se_desc',              ct.c_char * 65))
        plist.append(('pad_xx',                   ct.c_char * 18))
        plist.append(('rhs_anref',                ct.c_char * 3))
        plist.append(('pad_xx',                   ct.c_char * 27))
        plist.append(('rhs_series_uid',           ct.c_char * 32))
        plist.append(('rhs_landmark_uid',         ct.c_char * 32))
        plist.append(('pad_xx',                   ct.c_char * 1705))
        plist.append(('rhi_dfov',                 ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 12))
        plist.append(('rhi_scanspacing',          ct.c_float))
        plist.append(('rhi_loc',                  ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 4))
        plist.append(('rhi_nex',                  ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 20))
        plist.append(('rhi_user0',                ct.c_float))
        plist.append(('rhi_user1',                ct.c_float))
        plist.append(('rhi_user2',                ct.c_float))
        plist.append(('rhi_user3',                ct.c_float))
        plist.append(('rhi_user4',                ct.c_float))
        plist.append(('rhi_user5',                ct.c_float))
        plist.append(('rhi_user6',                ct.c_float))
        plist.append(('rhi_user7',                ct.c_float))
        plist.append(('rhi_user8',                ct.c_float))
        plist.append(('rhi_user9',                ct.c_float))
        plist.append(('rhi_user10',               ct.c_float))
        plist.append(('rhi_user11',               ct.c_float))
        plist.append(('rhi_user12',               ct.c_float))
        plist.append(('rhi_user13',               ct.c_float))
        plist.append(('rhi_user14',               ct.c_float))
        plist.append(('rhi_user15',               ct.c_float))
        plist.append(('rhi_user16',               ct.c_float))
        plist.append(('rhi_user17',               ct.c_float))
        plist.append(('rhi_user18',               ct.c_float))
        plist.append(('rhi_user19',               ct.c_float))
        plist.append(('rhi_user20',               ct.c_float))
        plist.append(('rhi_user21',               ct.c_float))
        plist.append(('rhi_user22',               ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 8))
        plist.append(('rhi_user23',               ct.c_float))
        plist.append(('rhi_user24',               ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 60))
        plist.append(('rhi_user25',               ct.c_float))
        plist.append(('rhi_user26',               ct.c_float))
        plist.append(('rhi_user27',               ct.c_float))
        plist.append(('rhi_user28',               ct.c_float))
        plist.append(('rhi_user29',               ct.c_float))
        plist.append(('rhi_user30',               ct.c_float))
        plist.append(('rhi_user31',               ct.c_float))
        plist.append(('rhi_user32',               ct.c_float))
        plist.append(('rhi_user33',               ct.c_float))
        plist.append(('rhi_user34',               ct.c_float))
        plist.append(('rhi_user35',               ct.c_float))
        plist.append(('rhi_user36',               ct.c_float))
        plist.append(('rhi_user37',               ct.c_float))
        plist.append(('rhi_user38',               ct.c_float))
        plist.append(('rhi_user39',               ct.c_float))
        plist.append(('rhi_user40',               ct.c_float))
        plist.append(('rhi_user41',               ct.c_float))
        plist.append(('rhi_user42',               ct.c_float))
        plist.append(('rhi_user43',               ct.c_float))
        plist.append(('rhi_user44',               ct.c_float))
        plist.append(('rhi_user45',               ct.c_float))
        plist.append(('rhi_user46',               ct.c_float))
        plist.append(('rhi_user47',               ct.c_float))
        plist.append(('rhi_user48',               ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 76))
        plist.append(('rhi_ctr_R',                ct.c_float))
        plist.append(('rhi_ctr_A',                ct.c_float))
        plist.append(('rhi_ctr_S',                ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 12))
        plist.append(('rhi_tlhc_R',               ct.c_float))
        plist.append(('rhi_tlhc_A',               ct.c_float))
        plist.append(('rhi_tlhc_S',               ct.c_float))
        plist.append(('rhi_trhc_R',               ct.c_float))
        plist.append(('rhi_trhc_A',               ct.c_float))
        plist.append(('rhi_trhc_S',               ct.c_float))
        plist.append(('rhi_brhc_R',               ct.c_float))
        plist.append(('rhi_brhc_A',               ct.c_float))
        plist.append(('rhi_brhc_S',               ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 300))
        plist.append(('rhi_tr',                   ct.c_int))
        plist.append(('rhi_ti',                   ct.c_int))
        plist.append(('rhi_te',                   ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 310))
        plist.append(('rhi_numecho',              ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 32))
        plist.append(('rhi_mr_flip',              ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 20))
        plist.append(('rhi_ctyp',                 ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 64))
        plist.append(('rhi_freq_dir',             ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 130))
        plist.append(('rhi_psdname',              ct.c_char * 33))
        plist.append(('pad_xx',                   ct.c_char * 84))
        plist.append(('rhi_cname',                ct.c_char * 17))
        plist.append(('pad_xx',                   ct.c_char * 51))
        plist.append(('rhi_image_uid',            ct.c_char * 32))

    elif version_major in (24, 25):
        plist.append(('rhr_rh_rdbm_rev',          ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 12))
        plist.append(('rhr_rh_scan_date',         ct.c_char * 10))
        plist.append(('rhr_rh_scan_time',         ct.c_char * 8))
        plist.append(('rhr_rh_logo',              ct.c_char * 10))
        plist.append(('rhr_rh_file_contents',     ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 10))
        plist.append(('rhr_rh_data_collect_type', ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 6))
        plist.append(('rhr_rh_npasses',           ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 2))
        plist.append(('rhr_rh_nslices',           ct.c_short))
        plist.append(('rhr_rh_nechoes',           ct.c_short))
        plist.append(('rhr_rh_navs',              ct.c_short))
        plist.append(('rhr_rh_nframes',           ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 4))
        plist.append(('rhr_rh_frame_size',        ct.c_ushort))
        plist.append(('rhr_rh_point_size',        ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 18))
        plist.append(('rhr_rh_da_xres',           ct.c_short))
        plist.append(('rhr_rh_da_yres',           ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 94))
        plist.append(('rhr_rh_dab[0]_start_rcv',  ct.c_short))
        plist.append(('rhr_rh_dab[0]_stop_rcv',   ct.c_short))
        plist.append(('rhr_rh_dab[1]_start_rcv',  ct.c_short))
        plist.append(('rhr_rh_dab[1]_stop_rcv',   ct.c_short))
        plist.append(('rhr_rh_dab[2]_start_rcv',  ct.c_short))
        plist.append(('rhr_rh_dab[2]_stop_rcv',   ct.c_short))
        plist.append(('rhr_rh_dab[3]_start_rcv',  ct.c_short))
        plist.append(('rhr_rh_dab[3]_stop_rcv',   ct.c_short))
        plist.append(('rhr_rh_user0',             ct.c_float))
        plist.append(('rhr_rh_user1',             ct.c_float))
        plist.append(('rhr_rh_user2',             ct.c_float))
        plist.append(('rhr_rh_user3',             ct.c_float))
        plist.append(('rhr_rh_user4',             ct.c_float))
        plist.append(('rhr_rh_user5',             ct.c_float))
        plist.append(('rhr_rh_user6',             ct.c_float))
        plist.append(('rhr_rh_user7',             ct.c_float))
        plist.append(('rhr_rh_user8',             ct.c_float))
        plist.append(('rhr_rh_user9',             ct.c_float))
        plist.append(('rhr_rh_user10',            ct.c_float))
        plist.append(('rhr_rh_user11',            ct.c_float))
        plist.append(('rhr_rh_user12',            ct.c_float))
        plist.append(('rhr_rh_user13',            ct.c_float))
        plist.append(('rhr_rh_user14',            ct.c_float))
        plist.append(('rhr_rh_user15',            ct.c_float))
        plist.append(('rhr_rh_user16',            ct.c_float))
        plist.append(('rhr_rh_user17',            ct.c_float))
        plist.append(('rhr_rh_user18',            ct.c_float))
        plist.append(('rhr_rh_user19',            ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 72))
        plist.append(('rhr_spectral_width',       ct.c_float))
        plist.append(('rhr_csi_dims',             ct.c_short))
        plist.append(('rhr_xcsi',                 ct.c_short))
        plist.append(('rhr_ycsi',                 ct.c_short))
        plist.append(('rhr_zcsi',                 ct.c_short))
        plist.append(('rhr_roilenx',              ct.c_float))
        plist.append(('rhr_roileny',              ct.c_float))
        plist.append(('rhr_roilenz',              ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 32))
        plist.append(('rhr_rh_ps_mps_freq',       ct.c_uint))
        plist.append(('pad_xx',                   ct.c_char * 560))
        plist.append(('rhr_rh_user_usage_tag',    ct.c_uint))
        plist.append(('pad_xx',                   ct.c_char * 8))
        plist.append(('rhr_rh_user20',            ct.c_float))
        plist.append(('rhr_rh_user21',            ct.c_float))
        plist.append(('rhr_rh_user22',            ct.c_float))
        plist.append(('rhr_rh_user23',            ct.c_float))
        plist.append(('rhr_rh_user24',            ct.c_float))
        plist.append(('rhr_rh_user25',            ct.c_float))
        plist.append(('rhr_rh_user26',            ct.c_float))
        plist.append(('rhr_rh_user27',            ct.c_float))
        plist.append(('rhr_rh_user28',            ct.c_float))
        plist.append(('rhr_rh_user29',            ct.c_float))
        plist.append(('rhr_rh_user30',            ct.c_float))
        plist.append(('rhr_rh_user31',            ct.c_float))
        plist.append(('rhr_rh_user32',            ct.c_float))
        plist.append(('rhr_rh_user33',            ct.c_float))
        plist.append(('rhr_rh_user34',            ct.c_float))
        plist.append(('rhr_rh_user35',            ct.c_float))
        plist.append(('rhr_rh_user36',            ct.c_float))
        plist.append(('rhr_rh_user37',            ct.c_float))
        plist.append(('rhr_rh_user38',            ct.c_float))
        plist.append(('rhr_rh_user39',            ct.c_float))
        plist.append(('rhr_rh_user40',            ct.c_float))
        plist.append(('rhr_rh_user41',            ct.c_float))
        plist.append(('rhr_rh_user42',            ct.c_float))
        plist.append(('rhr_rh_user43',            ct.c_float))
        plist.append(('rhr_rh_user44',            ct.c_float))
        plist.append(('rhr_rh_user45',            ct.c_float))
        plist.append(('rhr_rh_user46',            ct.c_float))
        plist.append(('rhr_rh_user47',            ct.c_float))
        plist.append(('rhr_rh_user48',            ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 352))
        plist.append(('rhr_rdb_hdr_off_data',     ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 188))
        plist.append(('rhr_rh_raw_pass_size',     ct.c_longlong))
        plist.append(('pad_xx',                   ct.c_char * 141724))
        plist.append(('rhe_magstrength',          ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 4))
        plist.append(('rhe_ex_datetime',          ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 112))
        plist.append(('rhe_ex_no',                ct.c_ushort))
        plist.append(('pad_xx',                   ct.c_char * 22))
        plist.append(('rhe_patsex',               ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 335))
        plist.append(('rhe_refphy',               ct.c_char * 65))
        plist.append(('pad_xx',                   ct.c_char * 198))
        plist.append(('rhe_ex_sysid',             ct.c_char * 9))
        plist.append(('pad_xx',                   ct.c_char * 22))
        plist.append(('rhe_hospname',             ct.c_char * 33))
        plist.append(('pad_xx',                   ct.c_char * 4))
        plist.append(('rhe_ex_verscre',           ct.c_char * 2))
        plist.append(('pad_xx',                   ct.c_char * 2))
        plist.append(('rhe_uniq_sys_id',          ct.c_char * 16))
        plist.append(('pad_xx',                   ct.c_char * 20))
        plist.append(('rhe_study_uid',            ct.c_char * 32))
        plist.append(('pad_xx',                   ct.c_char * 64))
        plist.append(('rhe_patname',              ct.c_char * 65))
        plist.append(('rhe_patid',                ct.c_char * 65))
        plist.append(('rhe_reqnum',               ct.c_char * 17))
        plist.append(('rhe_dateofbirth',          ct.c_char * 9))
        plist.append(('pad_xx',                   ct.c_char * 920))
        plist.append(('rhs_position',             ct.c_int))
        plist.append(('rhs_entry',                ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 194))
        plist.append(('rhs_se_no',                ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 138))
        plist.append(('rhs_se_desc',              ct.c_char * 65))
        plist.append(('pad_xx',                   ct.c_char * 18))
        plist.append(('rhs_anref',                ct.c_char * 3))
        plist.append(('pad_xx',                   ct.c_char * 27))
        plist.append(('rhs_series_uid',           ct.c_char * 32))
        plist.append(('rhs_landmark_uid',         ct.c_char * 32))
        plist.append(('pad_xx',                   ct.c_char * 1705))
        plist.append(('rhi_dfov',                 ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 12))
        plist.append(('rhi_scanspacing',          ct.c_float))
        plist.append(('rhi_loc',                  ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 4))
        plist.append(('rhi_nex',                  ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 20))
        plist.append(('rhi_user0',                ct.c_float))
        plist.append(('rhi_user1',                ct.c_float))
        plist.append(('rhi_user2',                ct.c_float))
        plist.append(('rhi_user3',                ct.c_float))
        plist.append(('rhi_user4',                ct.c_float))
        plist.append(('rhi_user5',                ct.c_float))
        plist.append(('rhi_user6',                ct.c_float))
        plist.append(('rhi_user7',                ct.c_float))
        plist.append(('rhi_user8',                ct.c_float))
        plist.append(('rhi_user9',                ct.c_float))
        plist.append(('rhi_user10',               ct.c_float))
        plist.append(('rhi_user11',               ct.c_float))
        plist.append(('rhi_user12',               ct.c_float))
        plist.append(('rhi_user13',               ct.c_float))
        plist.append(('rhi_user14',               ct.c_float))
        plist.append(('rhi_user15',               ct.c_float))
        plist.append(('rhi_user16',               ct.c_float))
        plist.append(('rhi_user17',               ct.c_float))
        plist.append(('rhi_user18',               ct.c_float))
        plist.append(('rhi_user19',               ct.c_float))
        plist.append(('rhi_user20',               ct.c_float))
        plist.append(('rhi_user21',               ct.c_float))
        plist.append(('rhi_user22',               ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 8))
        plist.append(('rhi_user23',               ct.c_float))
        plist.append(('rhi_user24',               ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 60))
        plist.append(('rhi_user25',               ct.c_float))
        plist.append(('rhi_user26',               ct.c_float))
        plist.append(('rhi_user27',               ct.c_float))
        plist.append(('rhi_user28',               ct.c_float))
        plist.append(('rhi_user29',               ct.c_float))
        plist.append(('rhi_user30',               ct.c_float))
        plist.append(('rhi_user31',               ct.c_float))
        plist.append(('rhi_user32',               ct.c_float))
        plist.append(('rhi_user33',               ct.c_float))
        plist.append(('rhi_user34',               ct.c_float))
        plist.append(('rhi_user35',               ct.c_float))
        plist.append(('rhi_user36',               ct.c_float))
        plist.append(('rhi_user37',               ct.c_float))
        plist.append(('rhi_user38',               ct.c_float))
        plist.append(('rhi_user39',               ct.c_float))
        plist.append(('rhi_user40',               ct.c_float))
        plist.append(('rhi_user41',               ct.c_float))
        plist.append(('rhi_user42',               ct.c_float))
        plist.append(('rhi_user43',               ct.c_float))
        plist.append(('rhi_user44',               ct.c_float))
        plist.append(('rhi_user45',               ct.c_float))
        plist.append(('rhi_user46',               ct.c_float))
        plist.append(('rhi_user47',               ct.c_float))
        plist.append(('rhi_user48',               ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 76))
        plist.append(('rhi_ctr_R',                ct.c_float))
        plist.append(('rhi_ctr_A',                ct.c_float))
        plist.append(('rhi_ctr_S',                ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 12))
        plist.append(('rhi_tlhc_R',               ct.c_float))
        plist.append(('rhi_tlhc_A',               ct.c_float))
        plist.append(('rhi_tlhc_S',               ct.c_float))
        plist.append(('rhi_trhc_R',               ct.c_float))
        plist.append(('rhi_trhc_A',               ct.c_float))
        plist.append(('rhi_trhc_S',               ct.c_float))
        plist.append(('rhi_brhc_R',               ct.c_float))
        plist.append(('rhi_brhc_A',               ct.c_float))
        plist.append(('rhi_brhc_S',               ct.c_float))
        plist.append(('pad_xx',                   ct.c_char * 300))
        plist.append(('rhi_tr',                   ct.c_int))
        plist.append(('rhi_ti',                   ct.c_int))
        plist.append(('rhi_te',                   ct.c_int))
        plist.append(('pad_xx',                   ct.c_char * 310))
        plist.append(('rhi_numecho',              ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 32))
        plist.append(('rhi_mr_flip',              ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 20))
        plist.append(('rhi_ctyp',                 ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 64))
        plist.append(('rhi_freq_dir',             ct.c_short))
        plist.append(('pad_xx',                   ct.c_char * 130))
        plist.append(('rhi_psdname',              ct.c_char * 33))
        plist.append(('pad_xx',                   ct.c_char * 84))
        plist.append(('rhi_cname',                ct.c_char * 17))
        plist.append(('pad_xx',                   ct.c_char * 51))
        plist.append(('rhi_image_uid',            ct.c_char * 32))

    elif version_major in (26, 27, 28):
        plist.append(('rhr_rh_rdbm_rev',           ct.c_float))
        plist.append(('rhr_rdb_hdr_off_data',      ct.c_int))
        plist.append(('pad_xx',                    ct.c_char * 84))
        plist.append(('rhr_rh_scan_date',          ct.c_char * 10))
        plist.append(('rhr_rh_scan_time',          ct.c_char * 8))
        plist.append(('rhr_rh_logo',               ct.c_char * 10))
        plist.append(('rhr_rh_file_contents',      ct.c_short))
        plist.append(('pad_xx',                    ct.c_char * 10))
        plist.append(('rhr_rh_data_collect_type',  ct.c_short))
        plist.append(('pad_xx',                    ct.c_char * 6))
        plist.append(('rhr_rh_npasses',            ct.c_short))
        plist.append(('pad_xx',                    ct.c_char * 2))

        if version < 28.002:
            plist.append(('rhr_rh_nslices',        ct.c_short))  # uint16
        else:
            plist.append(('rhr_rh_nslices_deprecated', ct.c_short))

        plist.append(('rhr_rh_nechoes',            ct.c_short))
        plist.append(('rhr_rh_navs',               ct.c_short))
        plist.append(('rhr_rh_nframes',            ct.c_short))
        plist.append(('pad_xx',                    ct.c_char * 4))
        plist.append(('rhr_rh_frame_size',         ct.c_short))
        plist.append(('rhr_rh_point_size',         ct.c_short))
        plist.append(('pad_xx',                    ct.c_char * 18))
        plist.append(('rhr_rh_da_xres',            ct.c_short))
        plist.append(('rhr_rh_da_yres',            ct.c_short))
        plist.append(('pad_xx',                    ct.c_char * 82))
        plist.append(('rhr_rh_dab[0]_start_rcv',   ct.c_short))
        plist.append(('rhr_rh_dab[0]_stop_rcv',    ct.c_short))
        plist.append(('rhr_rh_dab[1]_start_rcv',   ct.c_short))
        plist.append(('rhr_rh_dab[1]_stop_rcv',    ct.c_short))
        plist.append(('rhr_rh_dab[2]_start_rcv',   ct.c_short))
        plist.append(('rhr_rh_dab[2]_stop_rcv',    ct.c_short))
        plist.append(('rhr_rh_dab[3]_start_rcv',   ct.c_short))
        plist.append(('rhr_rh_dab[3]_stop_rcv',    ct.c_short))
        plist.append(('rhr_rh_user0',              ct.c_float))
        plist.append(('rhr_rh_user1',              ct.c_float))
        plist.append(('rhr_rh_user2',              ct.c_float))
        plist.append(('rhr_rh_user3',              ct.c_float))
        plist.append(('rhr_rh_user4',              ct.c_float))
        plist.append(('rhr_rh_user5',              ct.c_float))
        plist.append(('rhr_rh_user6',              ct.c_float))
        plist.append(('rhr_rh_user7',              ct.c_float))
        plist.append(('rhr_rh_user8',              ct.c_float))
        plist.append(('rhr_rh_user9',              ct.c_float))
        plist.append(('rhr_rh_user10',             ct.c_float))
        plist.append(('rhr_rh_user11',             ct.c_float))
        plist.append(('rhr_rh_user12',             ct.c_float))
        plist.append(('rhr_rh_user13',             ct.c_float))
        plist.append(('rhr_rh_user14',             ct.c_float))
        plist.append(('rhr_rh_user15',             ct.c_float))
        plist.append(('rhr_rh_user16',             ct.c_float))
        plist.append(('rhr_rh_user17',             ct.c_float))
        plist.append(('rhr_rh_user18',             ct.c_float))
        plist.append(('rhr_rh_user19',             ct.c_float))
        plist.append(('pad_xx',                    ct.c_char * 72))
        plist.append(('rhr_spectral_width',        ct.c_float))
        plist.append(('rhr_csi_dims',              ct.c_short))
        plist.append(('rhr_xcsi',                  ct.c_short))
        plist.append(('rhr_ycsi',                  ct.c_short))
        plist.append(('rhr_zcsi',                  ct.c_short))
        plist.append(('rhr_roilenx',               ct.c_float))
        plist.append(('rhr_roileny',               ct.c_float))
        plist.append(('rhr_roilenz',               ct.c_float))
        plist.append(('pad_xx',                    ct.c_char * 32))
        plist.append(('rhr_rh_ps_mps_freq',        ct.c_uint))
        plist.append(('pad_xx',                    ct.c_char * 432))
        plist.append(('rhr_rh_user_usage_tag',     ct.c_uint))
        plist.append(('pad_xx',                    ct.c_char * 8))
        plist.append(('rhr_rh_user20',             ct.c_float))
        plist.append(('rhr_rh_user21',             ct.c_float))
        plist.append(('rhr_rh_user22',             ct.c_float))
        plist.append(('rhr_rh_user23',             ct.c_float))
        plist.append(('rhr_rh_user24',             ct.c_float))
        plist.append(('rhr_rh_user25',             ct.c_float))
        plist.append(('rhr_rh_user26',             ct.c_float))
        plist.append(('rhr_rh_user27',             ct.c_float))
        plist.append(('rhr_rh_user28',             ct.c_float))
        plist.append(('rhr_rh_user29',             ct.c_float))
        plist.append(('rhr_rh_user30',             ct.c_float))
        plist.append(('rhr_rh_user31',             ct.c_float))
        plist.append(('rhr_rh_user32',             ct.c_float))
        plist.append(('rhr_rh_user33',             ct.c_float))
        plist.append(('rhr_rh_user34',             ct.c_float))
        plist.append(('rhr_rh_user35',             ct.c_float))
        plist.append(('rhr_rh_user36',             ct.c_float))
        plist.append(('rhr_rh_user37',             ct.c_float))
        plist.append(('rhr_rh_user38',             ct.c_float))
        plist.append(('rhr_rh_user39',             ct.c_float))
        plist.append(('rhr_rh_user40',             ct.c_float))
        plist.append(('rhr_rh_user41',             ct.c_float))
        plist.append(('rhr_rh_user42',             ct.c_float))
        plist.append(('rhr_rh_user43',             ct.c_float))
        plist.append(('rhr_rh_user44',             ct.c_float))
        plist.append(('rhr_rh_user45',             ct.c_float))
        plist.append(('rhr_rh_user46',             ct.c_float))
        plist.append(('rhr_rh_user47',             ct.c_float))
        plist.append(('rhr_rh_user48',             ct.c_float))
        plist.append(('pad_xx',                    ct.c_char * 488))
        plist.append(('rhr_rh_raw_pass_size',      ct.c_longlong))

        if version < 28.002:
            plist.append(('pad_xx',                    ct.c_char * 192684))
        else:
            plist.append(('pad_xx',                    ct.c_char * 1652))
            plist.append(('rhr_rh_nslices',            ct.c_int))  # uint32
            plist.append(('pad_xx',                    ct.c_char * (192684 - 1652 - 4)))

        if version > 27.0:  # 27.001+
            plist.append(('pad_xx',                    ct.c_char * 8192))

        plist.append(('rhe_magstrength',           ct.c_int))
        plist.append(('pad_xx',                    ct.c_char * 4))
        plist.append(('rhe_ex_datetime',           ct.c_int))
        plist.append(('pad_xx',                    ct.c_char * 112))
        plist.append(('rhe_ex_no',                 ct.c_short))
        plist.append(('pad_xx',                    ct.c_char * 22))
        plist.append(('rhe_patsex',                ct.c_short))
        plist.append(('pad_xx',                    ct.c_char * 335))
        plist.append(('rhe_refphy',                ct.c_char * 65))
        plist.append(('pad_xx',                    ct.c_char * 198))
        plist.append(('rhe_ex_sysid',              ct.c_char * 9))
        plist.append(('pad_xx',                    ct.c_char * 22))
        plist.append(('rhe_hospname',              ct.c_char * 33))
        plist.append(('pad_xx',                    ct.c_char * 4))
        plist.append(('rhe_ex_verscre',            ct.c_char * 2))
        plist.append(('pad_xx',                    ct.c_char * 2))
        plist.append(('rhe_uniq_sys_id',           ct.c_char * 16))
        plist.append(('pad_xx',                    ct.c_char * 20))
        plist.append(('rhe_study_uid',             ct.c_char * 32))
        plist.append(('pad_xx',                    ct.c_char * 64))
        plist.append(('rhe_patname',               ct.c_char * 65))
        plist.append(('rhe_patid',                 ct.c_char * 65))
        plist.append(('rhe_reqnum',                ct.c_char * 17))
        plist.append(('rhe_dateofbirth',           ct.c_char * 9))
        plist.append(('pad_xx',                    ct.c_char * 920))
        plist.append(('rhs_position',              ct.c_int))
        plist.append(('rhs_entry',                 ct.c_int))
        plist.append(('pad_xx',                    ct.c_char * 88))
        plist.append(('rhs_se_no',                 ct.c_int))
        plist.append(('pad_xx',                    ct.c_char * 242))
        plist.append(('rhs_se_desc',               ct.c_char * 65))
        plist.append(('pad_xx',                    ct.c_char * 18))
        plist.append(('rhs_anref',                 ct.c_char * 3))
        plist.append(('pad_xx',                    ct.c_char * 77))
        plist.append(('rhs_series_uid',            ct.c_char * 32))
        plist.append(('rhs_landmark_uid',          ct.c_char * 32))
        plist.append(('pad_xx',                    ct.c_char * 1655))
        plist.append(('rhi_dfov',                  ct.c_float))
        plist.append(('pad_xx',                    ct.c_char * 12))
        plist.append(('rhi_scanspacing',           ct.c_float))
        plist.append(('rhi_loc',                   ct.c_float))
        plist.append(('pad_xx',                    ct.c_char * 4))
        plist.append(('rhi_nex',                   ct.c_float))
        plist.append(('pad_xx',                    ct.c_char * 20))
        plist.append(('rhi_user0',                 ct.c_float))
        plist.append(('rhi_user1',                 ct.c_float))
        plist.append(('rhi_user2',                 ct.c_float))
        plist.append(('rhi_user3',                 ct.c_float))
        plist.append(('rhi_user4',                 ct.c_float))
        plist.append(('rhi_user5',                 ct.c_float))
        plist.append(('rhi_user6',                 ct.c_float))
        plist.append(('rhi_user7',                 ct.c_float))
        plist.append(('rhi_user8',                 ct.c_float))
        plist.append(('rhi_user9',                 ct.c_float))
        plist.append(('rhi_user10',                ct.c_float))
        plist.append(('rhi_user11',                ct.c_float))
        plist.append(('rhi_user12',                ct.c_float))
        plist.append(('rhi_user13',                ct.c_float))
        plist.append(('rhi_user14',                ct.c_float))
        plist.append(('rhi_user15',                ct.c_float))
        plist.append(('rhi_user16',                ct.c_float))
        plist.append(('rhi_user17',                ct.c_float))
        plist.append(('rhi_user18',                ct.c_float))
        plist.append(('rhi_user19',                ct.c_float))
        plist.append(('rhi_user20',                ct.c_float))
        plist.append(('rhi_user21',                ct.c_float))
        plist.append(('rhi_user22',                ct.c_float))
        plist.append(('pad_xx',                    ct.c_char * 8))
        plist.append(('rhi_user23',                ct.c_float))
        plist.append(('rhi_user24',                ct.c_float))
        plist.append(('pad_xx',                    ct.c_char * 60))
        plist.append(('rhi_user25',                ct.c_float))
        plist.append(('rhi_user26',                ct.c_float))
        plist.append(('rhi_user27',                ct.c_float))
        plist.append(('rhi_user28',                ct.c_float))
        plist.append(('rhi_user29',                ct.c_float))
        plist.append(('rhi_user30',                ct.c_float))
        plist.append(('rhi_user31',                ct.c_float))
        plist.append(('rhi_user32',                ct.c_float))
        plist.append(('rhi_user33',                ct.c_float))
        plist.append(('rhi_user34',                ct.c_float))
        plist.append(('rhi_user35',                ct.c_float))
        plist.append(('rhi_user36',                ct.c_float))
        plist.append(('rhi_user37',                ct.c_float))
        plist.append(('rhi_user38',                ct.c_float))
        plist.append(('rhi_user39',                ct.c_float))
        plist.append(('rhi_user40',                ct.c_float))
        plist.append(('rhi_user41',                ct.c_float))
        plist.append(('rhi_user42',                ct.c_float))
        plist.append(('rhi_user43',                ct.c_float))
        plist.append(('rhi_user44',                ct.c_float))
        plist.append(('rhi_user45',                ct.c_float))
        plist.append(('rhi_user46',                ct.c_float))
        plist.append(('rhi_user47',                ct.c_float))
        plist.append(('rhi_user48',                ct.c_float))
        plist.append(('pad_xx',                    ct.c_char * 76))
        plist.append(('rhi_ctr_R',                 ct.c_float))
        plist.append(('rhi_ctr_A',                 ct.c_float))
        plist.append(('rhi_ctr_S',                 ct.c_float))
        plist.append(('pad_xx',                    ct.c_char * 12))
        plist.append(('rhi_tlhc_R',                ct.c_float))
        plist.append(('rhi_tlhc_A',                ct.c_float))
        plist.append(('rhi_tlhc_S',                ct.c_float))
        plist.append(('rhi_trhc_R',                ct.c_float))
        plist.append(('rhi_trhc_A',                ct.c_float))
        plist.append(('rhi_trhc_S',                ct.c_float))
        plist.append(('rhi_brhc_R',                ct.c_float))
        plist.append(('rhi_brhc_A',                ct.c_float))
        plist.append(('rhi_brhc_S',                ct.c_float))
        plist.append(('pad_xx',                    ct.c_char * 300))
        plist.append(('rhi_tr',                    ct.c_int))
        plist.append(('rhi_ti',                    ct.c_int))
        plist.append(('rhi_te',                    ct.c_int))
        plist.append(('pad_xx',                    ct.c_char * 40))
        plist.append(('rhi_rawrunnum',             ct.c_int))
        plist.append(('pad_xx',                    ct.c_char * 266))
        plist.append(('rhi_numecho',               ct.c_short))
        plist.append(('pad_xx',                    ct.c_char * 32))
        plist.append(('rhi_mr_flip',               ct.c_short))
        plist.append(('pad_xx',                    ct.c_char * 20))
        plist.append(('rhi_ctyp',                  ct.c_short))
        plist.append(('pad_xx',                    ct.c_char * 64))
        plist.append(('rhi_freq_dir',              ct.c_short))
        plist.append(('pad_xx',                    ct.c_char * 130))
        plist.append(('rhi_psdname',               ct.c_char * 33))
        plist.append(('pad_xx',                    ct.c_char * 84))
        plist.append(('rhi_cname',                 ct.c_char * 17))
        plist.append(('pad_xx',                    ct.c_char * 51))
        plist.append(('rhi_image_uid',             ct.c_char * 32))

    else:
        raise UnknownPfileHdr(f"Unfamiliar header revision: {version:0.3f}.")

    return plist
