# coding: utf-8
"""
Data source: Dutour Sikirić, Mathieu, Olaf Delgado-Friedrichs, and Michel Deza. “Space Fullerenes: a Computer Search for New Frank-Kasper Structures” Acta Crystallographica Section A Foundations of Crystallography 66.Pt 5 (2010): 602–615.

Cage composition:
 (12,14,15,16) = (24,20,8,4,)
"""
desc={"ref": {"SpaceFullerene": 'Sikiric 2010'},
      "usage": "No options available.",
      "brief": "A space fullerene."
      }

import genice2.lattices
from genice2.cell import cellvectors

class Lattice(genice2.lattices.Lattice):
    def __init__(self):
        self.pairs="""
        209 169
        44 3
        311 239
        118 184
        314 51
        38 97
        40 299
        55 223
        130 102
        132 104
        50 197
        185 138
        216 287
        238 18
        302 79
        160 97
        171 147
        260 307
        256 43
        244 59
        105 100
        76 228
        211 161
        232 65
        299 308
        292 53
        249 100
        191 306
        113 179
        106 68
        186 222
        272 79
        170 177
        178 176
        271 165
        66 133
        243 188
        21 223
        152 251
        67 19
        26 40
        3 31
        224 282
        315 241
        65 121
        203 18
        112 53
        2 297
        195 28
        54 81
        289 4
        206 103
        257 123
        243 223
        249 207
        132 122
        32 211
        121 237
        160 31
        137 272
        22 141
        268 71
        219 231
        285 310
        32 284
        8 216
        167 43
        197 141
        149 169
        58 122
        44 96
        194 24
        79 231
        171 311
        172 108
        259 49
        13 19
        154 177
        132 231
        61 81
        37 72
        210 150
        87 298
        88 300
        167 199
        94 169
        243 182
        198 253
        250 244
        266 263
        316 248
        135 241
        26 197
        143 239
        105 111
        239 133
        98 65
        256 78
        178 297
        109 278
        17 318
        8 155
        292 81
        178 317
        147 306
        16 92
        17 93
        48 176
        210 36
        50 179
        116 64
        196 318
        252 296
        230 148
        192 198
        11 63
        78 283
        25 239
        143 86
        283 51
        315 123
        308 80
        136 149
        272 141
        66 52
        27 281
        151 120
        53 14
        170 258
        141 126
        77 23
        284 125
        12 245
        195 142
        54 14
        118 290
        9 310
        213 214
        42 306
        115 270
        58 37
        214 69
        302 212
        15 201
        73 222
        167 146
        50 188
        180 126
        5 282
        243 319
        57 214
        282 102
        71 62
        274 211
        85 126
        58 215
        64 75
        188 22
        76 234
        213 275
        12 73
        202 36
        218 67
        160 1
        86 296
        268 18
        164 59
        194 276
        180 94
        233 270
        91 123
        168 145
        49 116
        19 128
        203 77
        45 236
        303 197
        259 228
        168 89
        291 46
        19 10
        170 91
        76 257
        111 68
        28 275
        138 217
        99 185
        16 294
        38 22
        84 88
        192 228
        140 136
        267 57
        22 254
        187 258
        173 89
        264 91
        295 183
        224 314
        225 314
        87 0
        267 275
        132 110
        192 202
        235 277
        34 103
        38 128
        106 86
        278 107
        262 30
        148 156
        185 134
        20 280
        175 318
        5 240
        134 120
        74 177
        198 189
        283 268
        204 102
        153 268
        154 269
        6 228
        227 103
        78 139
        180 45
        244 279
        172 138
        72 286
        232 176
        262 208
        176 145
        139 314
        7 234
        54 276
        153 246
        60 209
        6 90
        193 49
        216 206
        82 10
        16 83
        98 114
        84 17
        279 200
        0 174
        273 311
        308 307
        157 135
        293 150
        190 260
        48 227
        42 142
        250 226
        152 205
        295 46
        55 269
        250 312
        315 36
        113 223
        285 116
        63 205
        25 131
        161 290
        85 308
        124 123
        36 189
        9 71
        275 263
        248 127
        224 217
        219 242
        273 306
        196 312
        109 110
        191 118
        212 117
        13 144
        209 183
        37 242
        303 182
        107 14
        171 73
        109 316
        181 248
        304 160
        89 28
        204 295
        15 80
        82 242
        219 127
        157 210
        93 61
        151 253
        181 269
        87 30
        32 271
        215 135
        238 162
        83 6
        38 79
        266 30
        256 151
        288 296
        196 59
        20 316
        5 51
        52 288
        175 309
        279 110
        172 149
        124 258
        124 200
        305 72
        98 71
        139 120
        119 221
        118 221
        163 209
        222 142
        198 90
        32 213
        217 152
        128 242
        108 236
        288 35
        67 3
        114 75
        191 208
        204 225
        127 110
        121 291
        131 229
        143 56
        15 138
        175 29
        54 96
        125 51
        265 241
        153 95
        73 155
        74 156
        17 222
        156 241
        39 252
        195 208
        167 95
        98 297
        124 55
        174 14
        109 119
        181 164
        298 316
        205 237
        153 125
        154 127
        218 107
        319 129
        257 202
        244 119
        299 47
        91 156
        193 277
        300 1
        88 312
        247 129
        163 204
        11 52
        9 75
        170 129
        52 34
        260 305
        278 104
        114 237
        230 120
        313 277
        246 238
        159 177
        100 276
        260 126
        158 288
        148 4
        151 4
        261 214
        106 158
        33 294
        88 147
        82 248
        203 145
        130 69
        48 220
        311 162
        274 158
        149 45
        8 112
        105 287
        60 189
        194 290
        230 90
        190 135
        173 273
        105 213
        261 158
        65 220
        27 253
        108 92
        115 21
        220 252
        78 9
        43 285
        136 235
        150 94
        39 291
        301 102
        35 166
        302 104
        6 255
        40 182
        133 296
        182 254
        21 304
        173 142
        249 96
        301 41
        251 35
        159 55
        259 7
        273 23
        85 236
        299 101
        140 80
        212 97
        247 26
        66 227
        298 218
        96 218
        283 199
        145 95
        34 41
        315 58
        187 226
        279 187
        84 309
        83 310
        162 245
        217 295
        152 291
        189 265
        191 165
        23 165
        303 137
        300 292
        185 169
        50 129
        148 255
        139 281
        252 103
        111 261
        233 70
        159 319
        233 1
        164 20
        262 59
        173 12
        256 64
        57 240
        215 231
        0 221
        301 46
        108 80
        292 56
        280 184
        137 286
        24 211
        114 317
        178 66
        190 94
        203 199
        266 184
        264 76
        93 300
        172 205
        2 133
        174 207
        304 188
        240 199
        7 33
        25 227
        53 117
        230 265
        161 165
        277 121
        8 56
        45 101
        285 62
        254 47
        107 212
        115 318
        264 255
        7 101
        144 3
        85 26
        131 155
        113 270
        63 235
        99 190
        271 28
        154 187
        168 246
        304 70
        229 143
        74 202
        181 200
        93 31
        46 235
        280 309
        281 310
        290 263
        117 1
        259 289
        67 97
        305 272
        186 147
        293 47
        186 208
        193 140
        48 245
        15 183
        0 278
        13 137
        84 42
        313 116
        284 69
        39 41
        286 254
        99 201
        60 150
        163 253
        111 206
        112 207
        70 179
        99 265
        194 174
        100 263
        61 44
        11 251
        140 101
        234 319
        232 62
        70 226
        10 104
        29 226
        144 270
        92 193
        131 206
        20 30
        294 255
        287 207
        122 200
        175 164
        40 234
        21 29
        24 287
        229 68
        297 18
        24 106
        247 33
        61 155
        89 77
        286 128
        201 60
        171 56
        267 161
        192 4
        313 317
        146 125
        16 75
        144 117
        251 282
        25 12
        180 47
        216 86
        284 166
        33 236
        83 49
        289 294
        225 146
        293 307
        92 237
        95 62
        195 266
        13 302
        11 301
        2 220
        274 166
        163 134
        27 225
        196 186
        289 64
        267 77
        130 146
        261 34
        298 10
        27 43
        119 280
        229 81
        136 183
        39 35
        130 240
        5 166
        168 245
        249 87
        271 246
        82 122
        262 221
        157 74
        269 29
        233 312
        232 313
        250 309
        115 31
        219 157
        274 57
        264 247
        215 305
        72 293
        41 69
        258 179
        42 184
        201 307
        276 68
        281 90
        134 224
        159 257
        112 44
        113 303
        2 162
        63 317
        23 238
        37 210
        """

        self.waters="""
        0.375 0.44514 0.78574
        0.18967 0.38702 0.18864
        0.31033 0.7121 0.26917
        0.68533 0.39204 0.09366
        0.0 0.01678 0.54401
        0.18967 0.7879 0.76917
        0.5 0.01092 0.46436
        0.875 0.05486 0.28574
        0.5 0.54001 0.10957
        0.30842 0.87741 0.45703
        0.625 0.33675 0.84394
        0.0 0.81036 0.02416
        0.75 0.61247 0.31753
        0.5 0.31036 0.02416
        0.19158 0.45598 0.94745
        0.5 0.98908 0.96436
        0.30842 0.95995 0.33207
        0.80842 0.45995 0.33207
        0.18967 0.73913 0.45017
        0.68533 0.31739 0.95361
        0.80842 0.40756 0.64104
        0.81033 0.30993 0.31548
        0.0 0.22297 0.09988
        0.18967 0.64134 0.50046
        0.31658 0.5951 0.86864
        0.875 0.62846 0.2288
        0.375 0.12846 0.2288
        0.69158 0.90756 0.64104
        0.68533 0.60796 0.59366
        0.875 0.32286 0.42653
        0.68342 0.45928 0.67765
        0.81033 0.38702 0.18864
        0.5 0.66204 0.7322
        0.125 0.05486 0.28574
        0.81467 0.72097 0.00677
        0.31033 0.76087 0.95017
        0.68967 0.11298 0.68864
        0.68967 0.19007 0.81548
        0.0 0.2693 0.014
        0.5 0.7693 0.014
        0.625 0.12846 0.2288
        0.68967 0.76087 0.95017
        0.0 0.51092 0.46436
        0.81658 0.87289 0.55261
        0.68342 0.45405 0.06035
        0.0 0.04001 0.10957
        0.68967 0.85866 0.00046
        0.81658 0.12712 0.05261
        0.68967 0.7121 0.26917
        0.69158 0.95995 0.33207
        0.18967 0.2121 0.26917
        0.31467 0.80926 0.69404
        0.0 0.74858 0.06044
        0.31658 0.45405 0.06035
        0.0 0.48908 0.96436
        0.68967 0.23913 0.45017
        0.31658 0.54072 0.17765
        0.0 0.69774 0.74414
        0.5 0.19774 0.74414
        0.5 0.40301 0.53325
        0.69158 0.04005 0.83207
        0.80842 0.48786 0.14534
        0.625 0.82286 0.42653
        0.0 0.85921 0.11064
        0.0 0.92407 0.41557
        0.5 0.80226 0.24414
        0.0 0.73005 0.17871
        0.81033 0.35866 0.00046
        0.0 0.58721 0.97738
        0.68533 0.74093 0.82517
        0.18967 0.30993 0.31548
        0.375 0.82286 0.42653
        0.625 0.17715 0.92653
        0.625 0.55486 0.28574
        0.0 0.1408 0.61064
        0.18342 0.9049 0.36864
        0.625 0.099 0.41022
        0.0 0.67025 0.55068
        0.18342 0.87289 0.55261
        0.18967 0.26087 0.95017
        0.5 0.00945 0.08936
        0.0 0.50945 0.08936
        0.68967 0.2879 0.76917
        0.5 0.96258 0.4011
        0.0 0.46258 0.4011
        0.30842 0.09244 0.14104
        0.31658 0.62712 0.05261
        0.625 0.44514 0.78574
        0.19158 0.45995 0.33207
        0.81033 0.64134 0.50046
        0.5 0.99055 0.58936
        0.31033 0.14134 0.50046
        0.375 0.94974 0.2234
        0.875 0.44974 0.2234
        0.0 0.07594 0.91557
        0.68533 0.77903 0.50677
        0.80842 0.45598 0.94745
        0.0 0.32975 0.05068
        0.31033 0.80993 0.31548
        0.30842 0.04005 0.83207
        0.80842 0.54005 0.83207
        0.81658 0.04072 0.17765
        0.875 0.83675 0.84394
        0.68967 0.69011 0.08593
        0.375 0.33675 0.84394
        0.68342 0.5951 0.86864
        0.19158 0.62259 0.95703
        0.125 0.40101 0.91022
        0.30842 0.98786 0.14534
        0.125 0.37154 0.7288
        0.18533 0.30926 0.69404
        0.80842 0.62259 0.95703
        0.5 0.48323 0.04401
        0.5 0.27058 0.264
        0.18533 0.86185 0.27696
        0.68533 0.36185 0.27696
        0.81658 0.9049 0.36864
        0.31467 0.39204 0.09366
        0.19158 0.51214 0.64534
        0.19158 0.40756 0.64104
        0.18342 0.95928 0.67765
        0.5 0.84661 0.16598
        0.5 0.26093 0.71472
        0.5 0.17025 0.55068
        0.5 0.2307 0.514
        0.5 0.76996 0.67871
        0.18342 0.12712 0.05261
        0.0 0.26996 0.67871
        0.81033 0.26087 0.95017
        0.125 0.16325 0.34394
        0.81033 0.7879 0.76917
        0.80842 0.59244 0.14104
        0.31033 0.2879 0.76917
        0.18533 0.69074 0.19404
        0.125 0.94514 0.78574
        0.18533 0.13815 0.77696
        0.81658 0.95405 0.06035
        0.5 0.24858 0.06044
        0.30842 0.95598 0.94745
        0.30842 0.90756 0.64104
        0.69158 0.98786 0.14534
        0.18967 0.19011 0.08593
        0.80842 0.54402 0.44745
        0.19158 0.59244 0.14104
        0.5 0.35921 0.11064
        0.81033 0.73913 0.45017
        0.68533 0.80926 0.69404
        0.31658 0.51221 0.36209
        0.18342 0.04595 0.56035
        0.0 0.98323 0.04401
        0.81658 0.0951 0.86864
        0.0 0.95999 0.60957
        0.31033 0.85866 0.00046
        0.5 0.75142 0.56044
        0.0 0.25142 0.56044
        0.68342 0.54072 0.17765
        0.18533 0.10796 0.59366
        0.0 0.16204 0.7322
        0.125 0.67715 0.92653
        0.81467 0.18261 0.45361
        0.0 0.34661 0.16598
        0.18967 0.61298 0.68864
        0.375 0.66325 0.34394
        0.875 0.94514 0.78574
        0.68342 0.37289 0.55261
        0.31467 0.60796 0.59366
        0.31467 0.74093 0.82517
        0.81033 0.8099 0.58593
        0.68533 0.68261 0.45361
        0.0 0.00746 0.91901
        0.18533 0.18261 0.45361
        0.375 0.55486 0.28574
        0.18342 0.95405 0.06035
        0.875 0.599 0.41022
        0.31658 0.48779 0.86209
        0.80842 0.37741 0.45703
        0.81467 0.75907 0.32517
        0.0 0.18965 0.52416
        0.0 0.77058 0.264
        0.31467 0.25907 0.32517
        0.0 0.09699 0.03325
        0.68967 0.3099 0.58593
        0.68533 0.19074 0.19404
        0.69158 0.95598 0.94745
        0.0 0.49055 0.58936
        0.18342 0.98779 0.86209
        0.5 0.49255 0.41901
        0.18533 0.27903 0.50677
        0.0 0.23907 0.21472
        0.625 0.05027 0.7234
        0.18342 0.0951 0.86864
        0.31658 0.54595 0.56035
        0.81658 0.04595 0.56035
        0.625 0.94974 0.2234
        0.19158 0.54005 0.83207
        0.68342 0.54595 0.56035
        0.5 0.42407 0.41557
        0.31467 0.19074 0.19404
        0.69158 0.01214 0.64534
        0.0 0.77703 0.59988
        0.5 0.27703 0.59988
        0.5 0.03742 0.9011
        0.81467 0.10796 0.59366
        0.0 0.7307 0.514
        0.75 0.88753 0.81753
        0.18533 0.89204 0.09366
        0.68342 0.62712 0.05261
        0.5 0.50746 0.91901
        0.5 0.51678 0.54401
        0.81658 0.98779 0.86209
        0.81467 0.13815 0.77696
        0.31467 0.63815 0.77696
        0.18967 0.35866 0.00046
        0.68533 0.63815 0.77696
        0.81033 0.69007 0.81548
        0.31033 0.19007 0.81548
        0.5 0.59699 0.03325
        0.375 0.90101 0.91022
        0.875 0.40101 0.91022
        0.0 0.22942 0.764
        0.5 0.73907 0.21472
        0.31658 0.45928 0.67765
        0.68342 0.51221 0.36209
        0.68533 0.25907 0.32517
        0.25 0.88753 0.81753
        0.625 0.87154 0.7288
        0.125 0.32286 0.42653
        0.81467 0.69074 0.19404
        0.69158 0.04402 0.44745
        0.0 0.56875 0.09239
        0.30842 0.01214 0.64534
        0.18533 0.24093 0.82517
        0.68967 0.80993 0.31548
        0.31467 0.36185 0.27696
        0.75 0.11247 0.31753
        0.81467 0.89204 0.09366
        0.18342 0.04072 0.17765
        0.31033 0.88702 0.18864
        0.31467 0.68261 0.45361
        0.125 0.62846 0.2288
        0.0 0.76093 0.71472
        0.31033 0.11298 0.68864
        0.81467 0.24093 0.82517
        0.81033 0.2121 0.26917
        0.31658 0.37289 0.55261
        0.625 0.66325 0.34394
        0.5 0.68965 0.52416
        0.25 0.11247 0.31753
        0.81467 0.30926 0.69404
        0.68342 0.48779 0.86209
        0.19158 0.37741 0.45703
        0.18533 0.81739 0.95361
        0.5 0.72297 0.09988
        0.81658 0.95928 0.67765
        0.81033 0.19011 0.08593
        0.30842 0.04402 0.44745
        0.0 0.90301 0.53325
        0.68967 0.14134 0.50046
        0.31033 0.23913 0.45017
        0.81658 0.01221 0.36209
        0.30842 0.12259 0.95703
        0.875 0.67715 0.92653
        0.5 0.45999 0.60957
        0.875 0.55027 0.7234
        0.375 0.099 0.41022
        0.375 0.05027 0.7234
        0.80842 0.51214 0.64534
        0.0 0.6534 0.66598
        0.31467 0.77903 0.50677
        0.81467 0.27903 0.50677
        0.5 0.33797 0.2322
        0.5 0.6408 0.61064
        0.31467 0.22097 0.00677
        0.125 0.599 0.41022
        0.18967 0.69007 0.81548
        0.81033 0.61298 0.68864
        0.0 0.53742 0.9011
        0.68967 0.88702 0.18864
        0.25 0.38753 0.81753
        0.31033 0.3099 0.58593
        0.0 0.43125 0.59239
        0.5 0.93125 0.59239
        0.125 0.83675 0.84394
        0.18967 0.8099 0.58593
        0.5 0.72942 0.764
        0.69158 0.87741 0.45703
        0.68533 0.22097 0.00677
        0.5 0.57594 0.91557
        0.18533 0.72097 0.00677
        0.0 0.99255 0.41901
        0.125 0.55027 0.7234
        0.5 0.82975 0.05068
        0.19158 0.48786 0.14534
        0.69158 0.12259 0.95703
        0.18342 0.01221 0.36209
        0.625 0.90101 0.91022
        0.31033 0.69011 0.08593
        0.18533 0.75907 0.32517
        0.75 0.38753 0.81753
        0.69158 0.09244 0.14104
        0.125 0.44974 0.2234
        0.81467 0.81739 0.95361
        0.31467 0.31739 0.95361
        0.5 0.23005 0.17871
        0.0 0.30226 0.24414
        0.375 0.17715 0.92653
        0.19158 0.54402 0.44745
        0.5 0.08721 0.97738
        0.5 0.06875 0.09239
        0.0 0.41279 0.47738
        0.5 0.91279 0.47738
        0.25 0.61247 0.31753
        0.31658 0.4049 0.36864
        0.81467 0.86185 0.27696
        0.375 0.87154 0.7288
        0.5 0.1534 0.66598
        0.875 0.37154 0.7288
        0.0 0.83797 0.2322
        0.68342 0.4049 0.36864
        0.875 0.16325 0.34394
        """

        self.coord= "relative"

        self.cages="""
        14 -0.25868 -0.28988 0.63821
        14 0.0 -0.09448 0.93731
        15 0.0 0.17944 0.92355
        14 0.5 0.63267 0.19953
        12 0.5 0.74386 0.38292
        12 1.0 0.57877 0.57029
        14 0.0 -0.13267 0.69953
        15 -0.5 -0.32056 0.92355
        14 -0.5 -0.18199 0.85601
        14 0.75868 0.21012 0.63821
        12 0.0 -0.24386 0.88292
        14 0.5 0.40552 0.93731
        12 0.23369 0.03792 0.00495
        12 0.0 0.34157 0.58241
        14 0.5 0.36733 0.69953
        14 0.25868 0.28988 0.13821
        15 0.5 0.04074 0.27726
        12 0.5 0.11457 0.81722
        12 0.26631 0.53792 1.00495
        14 0.24132 0.78988 1.13821
        15 0.0 0.45926 0.77726
        12 0.73369 0.46208 0.50495
        14 0.0 0.13267 0.19953
        15 0.5 0.32056 0.42355
        15 -0.5 -0.04074 0.77726
        12 0.5 0.88543 0.31722
        12 0.5 0.25614 0.88292
        15 1.0 0.54074 0.27726
        14 0.24132 0.21012 0.63821
        12 0.23369 -0.03792 0.50495
        14 0.0 0.09448 0.43731
        12 -0.23369 0.03792 1.00495
        14 -0.25868 0.28988 1.13821
        12 0.0 0.42123 1.07029
        16 1.0 0.95154 0.22884
        12 0.5 0.15843 0.08241
        12 0.0 -0.38543 0.81722
        12 -0.5 -0.07877 1.07029
        15 1.0 0.82056 0.42355
        12 -0.23369 -0.03792 0.50495
        16 -0.5 -0.45154 0.72884
        14 0.5 0.18199 0.35601
        12 0.73369 0.53792 0.00495
        14 0.5 0.59448 0.43731
        14 1.0 0.68199 0.35601
        16 0.0 0.04846 0.72884
        12 0.0 0.24386 0.38292
        12 1.0 0.65843 0.08241
        14 0.75868 0.78988 0.13821
        12 0.5 0.07877 0.57029
        12 -0.5 -0.15843 0.58241
        12 0.0 0.38543 0.31722
        12 0.26631 0.46208 0.50495
        14 0.25868 -0.28988 0.63821
        14 0.0 0.31801 0.85601
        16 0.5 0.45154 0.22884
        """

        self.bondlen = 3


        self.cell = """
        13.428552098172085 47.5352303679546 25.84065059445176
        """

        self.density = 0.5798738137727003



        self.cell = cellvectors(a=13.428552098172085,
                           b=47.5352303679546,
                           c=25.84065059445176)
