# coding: utf-8
"""
Data source: Dutour Sikirić, Mathieu, Olaf Delgado-Friedrichs, and Michel Deza. “Space Fullerenes: a Computer Search for New Frank-Kasper Structures” Acta Crystallographica Section A Foundations of Crystallography 66.Pt 5 (2010): 602–615.

Cage composition:
 (12,14,15,16) = (40,12,24,4,)
"""
desc={"ref": {"SpaceFullerene": 'Sikiric 2010'},
      "usage": "No options available.",
      "brief": "A space fullerene."
      }

import genice2.lattices
from genice2.cell import cellvectors

class Lattice(genice2.lattices.Lattice):
    def __init__(self):
        self.pairs="""
        176 436
        47 401
        151 170
        442 222
        120 172
        252 449
        277 418
        331 307
        62 22
        364 3
        199 276
        272 230
        18 254
        12 224
        402 74
        202 301
        104 134
        166 54
        135 168
        428 287
        15 318
        403 163
        359 295
        175 200
        51 392
        133 8
        372 98
        316 142
        148 318
        421 97
        446 313
        193 415
        453 287
        454 288
        303 153
        440 454
        418 11
        66 100
        454 43
        223 274
        377 161
        75 355
        171 342
        111 416
        334 62
        110 386
        285 407
        166 173
        57 179
        319 140
        345 392
        247 42
        117 104
        403 86
        138 42
        90 93
        261 308
        126 198
        255 79
        377 429
        200 235
        356 436
        40 420
        109 143
        113 424
        312 162
        15 77
        27 271
        337 206
        197 436
        413 173
        157 131
        231 266
        327 306
        281 210
        129 360
        287 370
        85 57
        382 297
        409 380
        65 112
        182 41
        185 150
        32 112
        445 152
        52 275
        302 194
        69 307
        201 267
        333 211
        334 212
        115 331
        189 130
        133 73
        255 330
        377 9
        228 251
        352 351
        215 216
        6 5
        30 117
        404 170
        329 325
        447 64
        366 265
        283 127
        419 130
        233 196
        309 312
        273 100
        368 423
        252 74
        260 409
        273 43
        184 439
        129 371
        185 240
        149 64
        208 217
        234 310
        134 197
        329 232
        161 423
        277 252
        323 429
        258 427
        443 426
        109 315
        61 57
        253 224
        348 44
        268 414
        177 303
        326 20
        371 388
        178 410
        237 149
        363 388
        91 380
        250 53
        372 431
        440 313
        141 152
        122 70
        91 187
        190 81
        127 231
        55 46
        13 412
        36 172
        116 64
        4 200
        121 432
        141 111
        89 220
        256 66
        190 84
        38 366
        302 154
        31 143
        373 35
        309 204
        253 132
        312 158
        412 94
        298 169
        238 18
        343 358
        117 447
        281 450
        15 142
        98 48
        395 314
        201 163
        4 22
        365 399
        0 155
        179 2
        112 306
        175 139
        114 337
        383 86
        4 73
        71 277
        164 437
        391 72
        368 108
        386 349
        174 210
        343 340
        221 38
        130 422
        380 196
        322 299
        121 125
        349 68
        323 294
        444 97
        35 18
        121 447
        23 98
        394 188
        363 206
        451 364
        413 59
        440 33
        327 4
        80 182
        114 286
        434 310
        396 157
        374 210
        71 131
        67 444
        23 413
        5 428
        239 407
        383 423
        373 435
        242 296
        387 246
        290 451
        254 125
        40 65
        397 382
        368 304
        186 356
        37 317
        260 410
        394 111
        24 263
        331 73
        17 46
        403 304
        290 241
        228 209
        92 82
        389 241
        203 431
        281 412
        442 182
        157 155
        373 16
        394 395
        441 280
        47 21
        170 26
        425 446
        424 341
        419 159
        284 162
        234 105
        34 8
        50 13
        50 55
        325 447
        249 131
        84 230
        378 407
        14 275
        161 317
        242 291
        421 443
        385 58
        190 154
        333 272
        269 251
        274 137
        115 34
        348 145
        444 344
        253 32
        55 311
        326 251
        165 59
        306 350
        20 375
        70 306
        455 417
        441 411
        292 247
        41 341
        136 360
        245 243
        400 300
        197 336
        379 342
        284 211
        166 16
        256 39
        298 424
        40 347
        381 87
        146 170
        180 332
        156 361
        136 153
        264 143
        416 76
        328 71
        406 262
        126 304
        45 148
        84 401
        62 83
        336 398
        326 147
        169 213
        444 82
        52 320
        114 106
        250 433
        453 88
        95 1
        90 196
        25 355
        236 37
        0 239
        133 69
        440 96
        167 424
        120 290
        242 177
        270 427
        175 132
        372 19
        88 279
        12 67
        400 416
        51 377
        221 122
        389 74
        45 433
        404 145
        317 108
        14 205
        165 370
        172 357
        168 153
        223 88
        132 339
        25 305
        71 438
        21 362
        99 171
        337 191
        324 181
        12 96
        351 82
        115 212
        116 211
        244 24
        311 191
        441 291
        450 204
        139 26
        332 144
        166 287
        270 297
        396 217
        261 266
        207 369
        233 147
        179 226
        328 78
        69 414
        30 149
        65 399
        388 26
        228 178
        156 315
        320 448
        203 297
        92 180
        16 19
        214 198
        174 42
        90 11
        283 346
        54 316
        326 278
        141 318
        104 314
        2 204
        282 202
        156 349
        134 257
        425 87
        35 316
        173 372
        43 68
        29 369
        325 362
        183 301
        95 293
        236 214
        323 185
        127 328
        1 27
        146 33
        335 100
        273 443
        208 278
        234 296
        360 296
        298 229
        280 347
        140 398
        189 102
        177 310
        321 358
        338 314
        28 388
        178 212
        244 158
        101 125
        336 367
        37 294
        91 147
        8 58
        390 446
        245 285
        434 439
        129 276
        10 56
        344 286
        25 302
        433 279
        344 387
        19 262
        405 83
        276 3
        351 422
        126 312
        198 61
        205 193
        308 402
        284 292
        396 203
        28 353
        237 398
        208 269
        180 103
        397 431
        25 80
        250 54
        426 379
        268 364
        195 357
        128 437
        273 143
        72 254
        92 189
        225 108
        162 2
        274 53
        23 438
        126 225
        419 437
        324 74
        150 369
        386 144
        448 278
        145 276
        11 438
        79 240
        20 209
        429 358
        270 400
        370 123
        124 368
        122 65
        14 20
        397 300
        259 345
        9 374
        324 248
        27 415
        301 265
        147 53
        390 247
        85 232
        270 318
        343 185
        94 374
        354 260
        267 211
        256 164
        30 289
        352 180
        334 73
        359 305
        322 82
        69 3
        118 150
        14 258
        174 89
        144 361
        216 128
        428 438
        320 382
        31 112
        119 343
        448 192
        46 144
        410 271
        371 411
        36 241
        47 101
        97 379
        389 105
        329 230
        425 450
        66 67
        50 299
        320 433
        227 338
        52 300
        175 151
        239 243
        48 188
        128 288
        448 53
        169 18
        365 291
        60 106
        110 450
        85 63
        94 332
        138 281
        347 339
        237 340
        282 402
        439 235
        272 81
        353 307
        6 243
        250 453
        77 152
        441 360
        442 356
        256 215
        348 34
        402 155
        178 293
        384 385
        189 97
        227 76
        391 101
        119 79
        397 76
        335 39
        116 432
        140 220
        386 412
        434 408
        414 415
        351 159
        160 145
        405 376
        165 142
        44 28
        323 423
        41 213
        384 408
        135 199
        282 268
        221 303
        15 279
        275 278
        422 392
        103 130
        34 3
        325 254
        275 266
        40 246
        298 188
        6 380
        131 231
        406 395
        223 375
        427 279
        136 183
        253 399
        182 406
        7 338
        38 235
        86 154
        224 426
        79 257
        159 124
        290 49
        63 432
        227 406
        209 271
        24 81
        352 345
        378 408
        391 201
        244 304
        363 315
        7 417
        399 387
        322 286
        135 49
        45 316
        136 49
        214 24
        70 22
        327 139
        297 192
        238 362
        104 367
        31 139
        137 93
        299 422
        165 88
        421 437
        239 418
        200 58
        119 149
        29 154
        55 33
        117 152
        385 70
        338 148
        245 409
        252 78
        455 35
        124 294
        375 93
        187 27
        248 78
        289 336
        348 350
        99 60
        442 113
        192 217
        219 193
        394 113
        333 263
        191 315
        401 295
        282 105
        390 381
        409 293
        327 44
        174 284
        92 361
        115 218
        365 184
        309 87
        57 263
        47 329
        0 202
        10 378
        31 420
        363 171
        407 265
        177 184
        5 328
        243 78
        181 346
        285 83
        190 207
        259 321
        333 232
        221 347
        213 262
        321 42
        186 257
        234 301
        261 157
        32 264
        228 195
        28 160
        75 167
        300 231
        181 308
        277 155
        322 311
        107 194
        445 289
        111 222
        376 310
        293 187
        244 430
        335 313
        426 420
        102 299
        120 307
        416 48
        232 64
        95 285
        357 269
        109 68
        452 137
        13 17
        434 265
        398 432
        389 376
        127 431
        181 357
        455 125
        379 246
        133 1
        443 288
        383 240
        151 32
        1 10
        405 408
        340 319
        387 106
        334 95
        120 218
        119 220
        425 454
        255 140
        371 404
        164 225
        138 446
        390 39
        41 355
        224 344
        37 150
        56 212
        452 11
        195 219
        195 218
        23 370
        249 98
        193 209
        245 449
        216 67
        121 367
        223 258
        113 194
        280 153
        242 168
        51 94
        428 196
        359 163
        123 48
        90 260
        7 367
        0 248
        168 60
        226 321
        267 63
        319 9
        86 305
        54 59
        249 203
        354 418
        341 435
        383 330
        249 400
        233 375
        167 302
        135 160
        21 455
        29 240
        156 102
        50 349
        84 167
        158 381
        75 169
        179 247
        362 77
        46 313
        10 410
        76 19
        12 288
        99 280
        205 217
        417 77
        30 257
        176 330
        233 453
        141 314
        72 75
        235 339
        401 341
        391 295
        160 206
        366 83
        124 430
        210 2
        214 207
        309 164
        451 199
        85 237
        129 353
        44 331
        93 271
        413 452
        364 218
        146 264
        263 292
        128 87
        340 226
        187 251
        324 36
        352 294
        89 358
        384 62
        354 378
        56 8
        268 219
        171 411
        236 225
        123 229
        109 26
        183 393
        118 319
        114 411
        419 108
        359 207
        350 58
        289 356
        236 430
        52 427
        405 449
        183 241
        215 381
        61 267
        103 317
        382 148
        61 162
        29 186
        342 286
        33 68
        226 374
        118 161
        118 330
        146 191
        215 430
        384 56
        7 445
        6 452
        238 229
        308 219
        451 105
        122 184
        255 197
        96 264
        216 159
        89 9
        132 420
        435 229
        51 103
        5 173
        303 393
        107 80
        238 142
        72 230
        421 66
        346 266
        80 436
        274 59
        283 248
        262 188
        272 201
        269 415
        39 204
        259 17
        365 339
        96 100
        355 295
        445 222
        110 43
        60 206
        176 305
        259 332
        261 205
        258 192
        227 222
        199 296
        13 392
        151 350
        107 134
        311 361
        414 172
        63 101
        45 417
        208 346
        404 337
        186 194
        373 213
        291 106
        16 123
        36 202
        376 393
        353 49
        99 246
        116 220
        158 292
        403 81
        354 449
        91 137
        385 439
        38 22
        110 335
        198 163
        429 345
        396 283
        138 17
        366 393
        176 369
        21 435
        102 342
        107 395
        """

        self.waters="""
        0.0 0.94984 0.31208
        0.0 0.00386 0.875
        0.32207 0.44268 0.84286
        0.82207 0.07119 0.65995
        0.18442 0.10933 0.90527
        0.30942 0.85463 0.15681
        0.18442 0.89067 0.09473
        0.31559 0.68335 0.6434
        0.82207 0.07119 0.84005
        0.19707 0.46888 0.59464
        0.82207 0.00193 0.9375
        0.81559 0.89067 0.09473
        0.80942 0.28496 0.05978
        0.0 0.35853 0.60051
        0.69059 0.8724 0.66029
        0.75 0.7427 0.75
        0.375 0.75417 0.125
        0.80942 0.3724 0.66029
        0.0 0.69418 0.96407
        0.25 0.75731 0.25
        0.625 0.89334 0.75
        0.5 0.67344 0.92182
        0.30942 0.09608 0.00033
        0.81559 0.81665 0.1434
        0.67793 0.49807 0.0625
        0.125 0.60666 0.25
        0.125 0.20421 0.75
        0.0 0.96373 0.81292
        0.30942 0.14537 0.65681
        0.67793 0.55733 0.34286
        0.68442 0.60933 0.59473
        0.30942 0.21504 0.94022
        0.69059 0.21504 0.94022
        0.875 0.27551 0.75
        0.69707 0.08022 0.75
        0.19059 0.71504 0.94022
        0.17793 0.99807 0.4375
        0.5 0.44984 0.31208
        0.18442 0.09932 0.09736
        0.5 0.37973 0.93248
        0.30942 0.20049 0.14885
        0.31559 0.66263 0.19022
        0.80293 0.43748 0.75
        0.19059 0.29951 0.85115
        0.375 0.12826 0.75
        0.25 0.7427 0.75
        0.68442 0.33737 0.69022
        0.5 0.62644 0.94252
        0.75 0.75731 0.25
        0.30942 0.09608 0.49967
        0.0 0.31359 0.58907
        0.19059 0.40392 0.50033
        0.5 0.81359 0.58907
        0.18442 0.83737 0.80978
        0.18442 0.78079 0.93478
        0.80942 0.29951 0.64885
        0.69707 0.03882 0.90255
        0.5 0.50386 0.875
        0.81559 0.10933 0.90527
        0.0 0.80479 0.95318
        0.5 0.18642 0.41093
        0.32207 0.50193 0.9375
        0.375 0.05601 0.99761
        0.32207 0.57119 0.84005
        0.80293 0.58022 0.75
        0.5 0.18642 0.08907
        0.5 0.32656 0.07818
        0.68442 0.31665 0.1434
        0.125 0.27551 0.75
        0.0 0.05016 0.68792
        0.5 0.12222 0.00348
        0.625 0.87174 0.25
        0.0 0.62222 0.00348
        0.17793 0.07119 0.84005
        0.5 0.97318 0.34047
        0.0 0.64147 0.10051
        0.375 0.75417 0.375
        0.625 0.70421 0.75
        0.30293 0.91978 0.25
        0.875 0.55601 0.50239
        0.19059 0.62761 0.33972
        0.80293 0.53112 0.09464
        0.68442 0.31665 0.3566
        0.30293 0.03112 0.09464
        0.68442 0.59932 0.09736
        0.5 0.55016 0.81208
        0.0 0.53439 0.25
        0.0 0.37779 0.99652
        0.69059 0.79951 0.85115
        0.0 0.48474 0.65756
        0.69059 0.90392 0.99967
        0.18442 0.90068 0.90264
        0.5 0.32656 0.42182
        0.81559 0.90068 0.90264
        0.31559 0.40068 0.59736
        0.17793 0.00193 0.9375
        0.68442 0.28079 0.93478
        0.375 0.29579 0.25
        0.875 0.79579 0.25
        0.30942 0.20049 0.35115
        0.5 0.30479 0.95318
        0.31559 0.60933 0.90527
        0.19059 0.28496 0.44022
        0.31559 0.39067 0.40527
        0.0 0.65307 0.59159
        0.69707 0.03112 0.40536
        0.69059 0.20049 0.35115
        0.0 0.64147 0.39949
        0.19707 0.41978 0.25
        0.25 0.2427 0.75
        0.31559 0.33737 0.80978
        0.68442 0.71921 0.43478
        0.5 0.19418 0.96407
        0.68442 0.66263 0.30978
        0.81559 0.21921 0.43478
        0.5 0.04978 0.75
        0.0 0.54978 0.75
        0.80942 0.64537 0.65681
        0.32207 0.49807 0.4375
        0.80293 0.53882 0.59745
        0.30293 0.03882 0.59745
        0.125 0.62826 0.75
        0.5 0.14147 0.10051
        0.625 0.75417 0.125
        0.80293 0.41978 0.25
        0.19059 0.64537 0.84319
        0.19707 0.46118 0.09745
        0.30942 0.85463 0.34319
        0.0 0.34693 0.09159
        0.0 0.12644 0.55748
        0.19059 0.35463 0.34319
        0.69059 0.85463 0.34319
        0.0 0.19521 0.04682
        0.0 0.05016 0.81208
        0.0 0.62222 0.49652
        0.5 0.12222 0.49652
        0.18442 0.09932 0.40264
        0.0 0.87973 0.93248
        0.875 0.39334 0.75
        0.18442 0.18335 0.8566
        0.19707 0.53882 0.59745
        0.80942 0.71504 0.55978
        0.875 0.74583 0.875
        0.375 0.24583 0.875
        0.5 0.33952 0.63045
        0.69059 0.14537 0.65681
        0.75 0.2427 0.75
        0.30942 0.8724 0.83972
        0.125 0.74583 0.625
        0.67793 0.57119 0.65995
        0.5 0.49614 0.375
        0.81559 0.18335 0.8566
        0.68442 0.68335 0.6434
        0.30942 0.12761 0.33972
        0.80293 0.56252 0.25
        0.82207 0.92881 0.34005
        0.31559 0.28079 0.56522
        0.81559 0.89067 0.40527
        0.875 0.44399 0.00239
        0.875 0.37174 0.25
        0.5 0.15307 0.59159
        0.19707 0.46118 0.40255
        0.19707 0.46888 0.90536
        0.19707 0.53112 0.09464
        0.31559 0.39067 0.09473
        0.81559 0.78079 0.93478
        0.30942 0.78496 0.05978
        0.80942 0.62761 0.16029
        0.5 0.14147 0.39949
        0.0 0.68642 0.08907
        0.875 0.20421 0.75
        0.18442 0.21921 0.43478
        0.17793 0.00193 0.5625
        0.18442 0.81665 0.1434
        0.0 0.46562 0.75
        0.0 0.17344 0.92182
        0.32207 0.55733 0.34286
        0.625 0.10666 0.25
        0.5 0.98474 0.84244
        0.5 0.46373 0.81292
        0.5 0.37356 0.44252
        0.375 0.94399 0.49761
        0.31559 0.66263 0.30978
        0.17793 0.05733 0.34286
        0.69059 0.12761 0.16029
        0.67793 0.49807 0.4375
        0.68442 0.59932 0.40264
        0.17793 0.94268 0.84286
        0.875 0.72449 0.25
        0.31559 0.31665 0.3566
        0.67793 0.55733 0.15714
        0.625 0.24583 0.625
        0.0 0.83952 0.63045
        0.82207 0.94268 0.65714
        0.80942 0.62761 0.33972
        0.5 0.98474 0.65756
        0.5 0.87779 0.99652
        0.19059 0.59608 0.49967
        0.32207 0.49807 0.0625
        0.69059 0.09608 0.49967
        0.0 0.12644 0.94252
        0.125 0.55601 0.99761
        0.0 0.99614 0.375
        0.0 0.82656 0.42182
        0.31559 0.40068 0.90264
        0.81559 0.90068 0.59736
        0.5 0.19418 0.53593
        0.5 0.53627 0.18708
        0.18442 0.90068 0.59736
        0.69707 0.93748 0.75
        0.19707 0.43748 0.75
        0.0 0.52682 0.84047
        0.5 0.02682 0.84047
        0.19059 0.70049 0.14885
        0.5 0.49614 0.125
        0.68442 0.39067 0.09473
        0.80942 0.35463 0.15681
        0.0 0.87973 0.56752
        0.5 0.02682 0.65953
        0.69707 0.96888 0.59464
        0.0 0.52682 0.65953
        0.30942 0.12761 0.16029
        0.5 0.69521 0.45318
        0.81559 0.83737 0.80978
        0.875 0.25417 0.125
        0.32207 0.42881 0.15995
        0.5 0.46373 0.68708
        0.31559 0.71921 0.43478
        0.5 0.96562 0.75
        0.68442 0.71921 0.06522
        0.80942 0.59608 0.00033
        0.5 0.84693 0.40842
        0.67793 0.57119 0.84005
        0.5 0.85853 0.89949
        0.82207 0.05733 0.34286
        0.0 0.12027 0.06752
        0.5 0.44984 0.18792
        0.5 0.55016 0.68792
        0.80942 0.71504 0.94022
        0.0 0.94984 0.18792
        0.80293 0.53112 0.40536
        0.30293 0.03112 0.40536
        0.69059 0.12761 0.33972
        0.17793 0.92881 0.15995
        0.80293 0.46118 0.09745
        0.30293 0.96118 0.09745
        0.375 0.22449 0.25
        0.67793 0.44268 0.84286
        0.17793 0.92881 0.34005
        0.81559 0.81665 0.3566
        0.30942 0.79951 0.85115
        0.30293 0.93748 0.75
        0.5 0.95023 0.25
        0.81559 0.21921 0.06522
        0.0 0.65307 0.90842
        0.125 0.55601 0.50239
        0.5 0.37356 0.05748
        0.80942 0.59608 0.49967
        0.81559 0.83737 0.69022
        0.68442 0.40068 0.59736
        0.625 0.94399 0.00239
        0.69059 0.90392 0.50033
        0.125 0.72449 0.25
        0.67793 0.50193 0.9375
        0.625 0.24583 0.875
        0.0 0.03627 0.18708
        0.5 0.87779 0.50348
        0.19707 0.53882 0.90255
        0.82207 0.00193 0.5625
        0.17793 0.94268 0.65714
        0.81559 0.78079 0.56522
        0.82207 0.94268 0.84286
        0.875 0.55601 0.99761
        0.31559 0.28079 0.93478
        0.0 0.83952 0.86956
        0.5 0.85853 0.60051
        0.81559 0.10933 0.59473
        0.69707 0.91978 0.25
        0.30942 0.8724 0.66029
        0.625 0.77551 0.75
        0.18442 0.16263 0.30978
        0.125 0.39334 0.75
        0.82207 0.99807 0.4375
        0.18442 0.89067 0.40527
        0.0 0.48474 0.84244
        0.17793 0.99807 0.0625
        0.875 0.25417 0.375
        0.5 0.80582 0.03593
        0.0 0.30582 0.03593
        0.5 0.62644 0.55748
        0.375 0.05601 0.50239
        0.81559 0.16263 0.30978
        0.80293 0.46888 0.90536
        0.30293 0.96888 0.90536
        0.67793 0.42881 0.34005
        0.31559 0.59932 0.09736
        0.81559 0.09932 0.40264
        0.0 0.80479 0.54682
        0.80942 0.70049 0.14885
        0.0 0.30582 0.46407
        0.5 0.80582 0.46407
        0.0 0.03627 0.31292
        0.875 0.60666 0.25
        0.375 0.10666 0.25
        0.0 0.47318 0.15953
        0.19707 0.56252 0.25
        0.5 0.15307 0.90842
        0.17793 0.07119 0.65995
        0.625 0.94399 0.49761
        0.19059 0.40392 0.99967
        0.69707 0.06252 0.25
        0.68442 0.28079 0.56522
        0.125 0.44399 0.00239
        0.68442 0.33737 0.80978
        0.0 0.69418 0.53593
        0.375 0.24583 0.625
        0.125 0.74583 0.875
        0.32207 0.42881 0.34005
        0.875 0.74583 0.625
        0.32207 0.50193 0.5625
        0.30942 0.79951 0.64885
        0.67793 0.44268 0.65714
        0.80942 0.28496 0.44022
        0.80293 0.46118 0.40255
        0.30293 0.96118 0.40255
        0.80942 0.64537 0.84319
        0.375 0.89334 0.75
        0.30942 0.14537 0.84319
        0.375 0.87174 0.25
        0.68442 0.60933 0.90527
        0.19707 0.53112 0.40536
        0.30293 0.08022 0.75
        0.5 0.37973 0.56752
        0.80293 0.53882 0.90255
        0.30293 0.03882 0.90255
        0.5 0.33952 0.86956
        0.31559 0.60933 0.59473
        0.69059 0.21504 0.55978
        0.19059 0.71504 0.55978
        0.0 0.16048 0.13045
        0.5 0.50386 0.625
        0.5 0.66048 0.13045
        0.125 0.25417 0.375
        0.67793 0.50193 0.5625
        0.75 0.25731 0.25
        0.80942 0.40392 0.50033
        0.30942 0.90392 0.50033
        0.18442 0.16263 0.19022
        0.625 0.12826 0.75
        0.19059 0.29951 0.64885
        0.69059 0.14537 0.84319
        0.80942 0.35463 0.34319
        0.68442 0.39067 0.40527
        0.18442 0.10933 0.59473
        0.69707 0.96118 0.09745
        0.19059 0.62761 0.16029
        0.5 0.62027 0.43248
        0.30293 0.96888 0.59464
        0.80293 0.46888 0.59464
        0.32207 0.55733 0.15714
        0.0 0.12027 0.43248
        0.5 0.30479 0.54682
        0.68442 0.68335 0.8566
        0.30942 0.21504 0.55978
        0.69707 0.03882 0.59745
        0.81559 0.16263 0.19022
        0.17793 0.05733 0.15714
        0.19059 0.64537 0.65681
        0.0 0.45023 0.25
        0.5 0.53627 0.31292
        0.69059 0.78496 0.05978
        0.0 0.17344 0.57818
        0.125 0.79579 0.25
        0.31559 0.71921 0.06522
        0.32207 0.44268 0.65714
        0.69059 0.8724 0.83972
        0.5 0.03439 0.25
        0.125 0.44399 0.49761
        0.82207 0.99807 0.0625
        0.25 0.25731 0.25
        0.30942 0.90392 0.99967
        0.80942 0.40392 0.99967
        0.18442 0.78079 0.56522
        0.0 0.51526 0.34244
        0.625 0.05601 0.99761
        0.69059 0.09608 0.00033
        0.31559 0.33737 0.69022
        0.625 0.22449 0.25
        0.18442 0.18335 0.6434
        0.5 0.01526 0.34244
        0.68442 0.40068 0.90264
        0.19059 0.59608 0.00033
        0.0 0.37779 0.50348
        0.30293 0.06252 0.25
        0.80942 0.70049 0.35115
        0.0 0.68642 0.41093
        0.0 0.87356 0.44252
        0.30942 0.78496 0.44022
        0.32207 0.57119 0.65995
        0.69059 0.20049 0.14885
        0.69059 0.78496 0.44022
        0.5 0.62027 0.06752
        0.69707 0.96118 0.40255
        0.0 0.51526 0.15756
        0.81559 0.18335 0.6434
        0.5 0.01526 0.15756
        0.19059 0.70049 0.35115
        0.0 0.99614 0.125
        0.69707 0.03112 0.09464
        0.375 0.94399 0.00239
        0.69707 0.96888 0.90536
        0.0 0.19521 0.45318
        0.19059 0.3724 0.66029
        0.0 0.82656 0.07818
        0.0 0.00386 0.625
        0.0 0.96373 0.68708
        0.625 0.75417 0.375
        0.375 0.70421 0.75
        0.82207 0.92881 0.15995
        0.125 0.37174 0.25
        0.18442 0.21921 0.06522
        0.31559 0.31665 0.1434
        0.0 0.34693 0.40842
        0.0 0.47318 0.34047
        0.68442 0.66263 0.19022
        0.0 0.35853 0.89949
        0.125 0.25417 0.125
        0.69059 0.79951 0.64885
        0.5 0.84693 0.09159
        0.875 0.44399 0.49761
        0.67793 0.42881 0.15995
        0.18442 0.81665 0.3566
        0.19707 0.58022 0.75
        0.375 0.77551 0.75
        0.82207 0.05733 0.15714
        0.5 0.69521 0.04682
        0.31559 0.59932 0.40264
        0.19059 0.35463 0.15681
        0.69059 0.85463 0.15681
        0.81559 0.09932 0.09736
        0.80942 0.29951 0.85115
        0.0 0.16048 0.36956
        0.5 0.66048 0.36956
        0.19059 0.28496 0.05978
        0.625 0.29579 0.25
        0.5 0.67344 0.57818
        0.80942 0.3724 0.83972
        0.875 0.62826 0.75
        0.18442 0.83737 0.69022
        0.5 0.97318 0.15953
        0.19059 0.3724 0.83972
        0.625 0.05601 0.50239
        0.0 0.87356 0.05748
        0.5 0.81359 0.91093
        0.0 0.31359 0.91093
        0.31559 0.68335 0.8566
        """

        self.coord= "relative"

        self.cages="""
        15 0.5 0.55572 0.50169
        15 0.5 0.25627 0.0845
        12 0.0 0.5 0.0
        15 0.0 0.24373 0.5845
        15 0.0 -0.10481 0.75
        12 0.0 0.57649 0.36975
        12 0.5 0.09183 -0.13812
        12 0.26234 0.33973 0.51089
        15 1.0 0.75627 0.0845
        14 -0.28829 0.49228 0.25
        16 0.5 0.37051 0.25
        12 0.5 0.09183 0.63812
        15 -0.5 -0.1999 1.25
        12 0.5 0.0 0.5
        12 0.23766 -0.16027 -0.01089
        15 0.5 0.44428 1.00169
        12 0.73766 0.33973 -0.01089
        12 1.0 0.66885 0.25
        12 1.0 0.57649 0.13025
        16 -0.5 -0.37051 0.75
        12 0.0 0.42351 0.63025
        15 -0.5 -0.25627 0.5845
        12 0.73766 0.33973 -0.48911
        15 0.5 0.55572 -0.00169
        14 0.0 0.21658 0.25
        14 0.78829 0.99228 0.25
        15 0.5 0.44428 -0.50169
        12 -0.23766 0.16027 0.01089
        15 -0.5 -0.25627 -0.0845
        12 0.0 -0.40817 -0.13812
        15 0.0 0.10481 0.25
        12 0.0 -0.5 0.5
        15 0.5 0.39519 0.75
        14 0.5 0.28342 0.75
        15 -0.5 0.25627 0.4155
        15 0.0 -0.05572 1.00169
        16 0.0 0.12949 0.75
        12 0.73766 0.66027 -0.51089
        12 0.26234 0.66027 0.48911
        14 0.0 -0.21658 0.75
        15 0.0 0.05572 0.50169
        12 -0.5 0.07649 0.36975
        15 0.0 0.75627 0.4155
        16 1.0 0.87051 0.25
        12 0.26234 0.66027 0.01089
        12 0.0 0.33115 0.75
        15 0.0 -0.05572 -0.50169
        14 0.78829 0.00772 -0.25
        14 0.5 0.71658 0.25
        15 0.5 0.60481 0.25
        12 -0.5 -0.07649 0.63025
        12 -0.5 -0.16885 0.75
        15 0.5 0.1999 0.75
        12 0.0 0.40817 0.13812
        12 -0.23766 0.16027 0.48911
        12 0.23766 0.16027 0.01089
        12 0.23766 0.16027 -0.51089
        12 0.5 0.16885 0.25
        12 -0.23766 -0.16027 -0.01089
        12 0.5 0.90817 0.36188
        15 0.0 0.24373 -0.0845
        12 0.0 -0.40817 0.63812
        12 0.5 1.0 0.0
        14 0.21171 0.00772 0.75
        14 -0.28829 -0.49228 0.75
        12 -0.5 -0.07649 -0.13025
        14 0.28829 0.49228 0.25
        14 0.21171 0.99228 0.25
        14 0.28829 -0.49228 -0.25
        15 0.0 0.3001 1.25
        12 0.5 0.07649 0.13025
        12 0.0 0.42351 -0.13025
        15 0.0 0.05572 -0.00169
        12 0.5 0.90817 0.13812
        12 -0.23766 -0.16027 0.51089
        12 0.73766 0.66027 0.01089
        12 0.23766 -0.16027 -0.48911
        12 0.26234 0.33973 -0.01089
        12 0.0 0.40817 0.36188
        15 1.0 0.6999 0.75
        """

        self.bondlen = 3


        self.cell = """
        14.084857064659905 71.32905196652955 25.95741836645526
        """

        self.density = 0.5226563170138255



        self.cell = cellvectors(a=14.084857064659905,
                           b=71.32905196652955,
                           c=25.95741836645526)
