# coding: utf-8
"""
Data source: Dutour Sikirić, Mathieu, Olaf Delgado-Friedrichs, and Michel Deza. “Space Fullerenes: a Computer Search for New Frank-Kasper Structures” Acta Crystallographica Section A Foundations of Crystallography 66.Pt 5 (2010): 602–615.

Cage composition:
 (12,14,15,16) = (32,20,8,8,)
"""
desc={"ref": {"SpaceFullerene": 'Sikiric 2010'},
      "usage": "No options available.",
      "brief": "A space fullerene."
      }

import genice2.lattices
from genice2.cell import cellvectors

class Lattice(genice2.lattices.Lattice):
    def __init__(self):
        self.pairs="""
        158 332
        227 319
        381 240
        50 295
        204 56
        183 266
        359 189
        387 263
        248 354
        221 166
        97 307
        282 203
        157 321
        234 197
        385 375
        198 150
        370 282
        5 144
        23 75
        55 62
        322 70
        237 170
        158 24
        108 25
        114 318
        0 324
        346 1
        222 261
        373 317
        105 327
        326 113
        378 360
        41 356
        218 94
        55 285
        185 341
        91 121
        228 194
        313 202
        344 192
        242 237
        180 88
        356 184
        238 35
        77 376
        119 325
        323 336
        59 79
        94 200
        52 368
        84 158
        238 259
        33 172
        30 263
        168 361
        154 40
        316 77
        310 268
        45 107
        33 91
        135 372
        128 113
        319 359
        89 21
        156 152
        191 120
        289 54
        345 24
        92 204
        42 326
        60 355
        63 212
        124 349
        75 358
        111 48
        60 343
        42 179
        240 151
        38 229
        310 247
        42 122
        147 16
        73 327
        383 78
        205 166
        160 140
        342 174
        213 256
        67 29
        304 67
        221 286
        206 168
        216 255
        345 306
        190 369
        122 276
        125 346
        273 275
        225 27
        12 53
        186 234
        347 45
        68 179
        106 273
        310 187
        160 223
        26 328
        330 93
        320 252
        242 374
        148 142
        47 328
        161 293
        72 257
        260 164
        51 63
        239 94
        128 47
        305 243
        33 193
        44 114
        45 114
        387 64
        350 297
        84 246
        121 35
        150 359
        146 231
        80 6
        61 166
        81 110
        58 200
        30 360
        207 195
        304 341
        165 73
        164 301
        288 142
        198 210
        225 184
        357 381
        52 173
        226 194
        151 20
        0 184
        123 25
        292 32
        262 163
        267 119
        260 86
        293 369
        374 98
        14 317
        161 298
        298 354
        207 202
        93 322
        314 362
        339 352
        255 381
        137 270
        27 178
        37 353
        259 172
        171 142
        229 208
        226 204
        58 116
        124 272
        253 15
        145 300
        76 90
        301 109
        11 254
        176 230
        332 61
        18 135
        95 99
        0 178
        186 349
        169 253
        370 228
        20 360
        259 340
        378 312
        299 307
        262 353
        66 102
        382 265
        58 81
        247 17
        98 170
        132 256
        23 199
        217 4
        49 78
        239 76
        382 284
        232 329
        34 146
        258 8
        206 190
        380 208
        331 211
        378 115
        20 102
        22 105
        64 140
        132 124
        80 176
        314 209
        23 127
        338 194
        51 109
        168 354
        278 36
        384 55
        264 235
        148 119
        34 295
        73 104
        175 385
        78 147
        97 322
        269 122
        86 365
        278 218
        335 39
        338 203
        41 163
        321 261
        292 318
        95 369
        91 307
        196 324
        249 287
        69 130
        87 214
        124 197
        118 335
        290 362
        347 317
        153 83
        356 209
        77 157
        5 109
        335 89
        128 63
        231 287
        304 187
        149 159
        326 56
        296 10
        314 37
        342 83
        130 180
        140 8
        313 50
        115 366
        227 48
        343 220
        215 353
        57 348
        12 1
        125 308
        29 223
        209 16
        330 358
        216 189
        239 297
        311 40
        328 276
        10 177
        300 135
        117 68
        11 299
        207 106
        217 59
        46 62
        7 169
        303 56
        29 28
        42 212
        251 35
        228 164
        66 64
        182 249
        210 96
        162 191
        284 344
        364 43
        289 89
        80 18
        71 264
        234 133
        97 193
        232 211
        251 192
        240 14
        245 173
        277 380
        162 262
        348 102
        69 35
        272 235
        57 357
        116 230
        281 3
        384 325
        351 249
        216 378
        169 379
        178 159
        296 283
        352 224
        245 181
        233 384
        47 371
        343 18
        112 104
        368 134
        64 61
        150 246
        315 333
        38 277
        66 319
        139 235
        233 377
        182 21
        295 250
        117 133
        181 6
        220 191
        299 241
        46 142
        183 107
        308 220
        294 272
        139 267
        207 100
        379 177
        367 190
        276 63
        215 177
        334 168
        215 346
        344 311
        30 189
        125 37
        336 312
        54 82
        52 141
        95 152
        180 280
        294 365
        340 311
        90 290
        233 79
        67 140
        129 240
        265 104
        128 222
        103 164
        170 288
        20 318
        370 157
        305 367
        361 99
        87 241
        188 143
        281 359
        274 14
        373 283
        15 257
        330 251
        118 291
        31 183
        192 127
        201 324
        386 99
        379 266
        106 231
        155 290
        25 306
        195 236
        342 22
        156 214
        86 179
        334 36
        292 189
        92 28
        30 66
        31 274
        355 176
        120 6
        238 375
        334 224
        185 269
        254 375
        139 98
        154 127
        300 6
        65 134
        271 150
        26 108
        355 188
        13 90
        226 122
        72 14
        200 352
        134 143
        289 165
        136 88
        221 96
        255 336
        132 277
        335 106
        264 288
        217 295
        236 174
        263 48
        162 80
        376 204
        279 62
        173 200
        239 60
        28 303
        329 337
        363 22
        85 70
        7 149
        245 302
        59 100
        162 350
        13 120
        339 81
        347 131
        31 115
        58 181
        136 73
        308 163
        57 151
        341 268
        167 55
        363 74
        129 257
        278 176
        256 2
        153 146
        215 78
        171 50
        258 306
        155 9
        267 234
        257 45
        68 194
        129 318
        85 180
        87 293
        7 27
        43 17
        288 256
        296 225
        61 210
        367 385
        341 25
        154 105
        329 241
        46 325
        386 143
        68 186
        285 231
        136 363
        94 230
        186 365
        52 252
        12 201
        213 374
        275 285
        18 163
        71 2
        38 171
        268 303
        247 108
        148 197
        175 361
        309 188
        138 387
        172 40
        92 269
        111 336
        153 112
        1 9
        177 184
        109 101
        15 115
        41 19
        338 349
        281 48
        0 266
        377 119
        263 32
        185 26
        248 305
        136 244
        111 57
        38 79
        13 343
        242 377
        98 325
        315 72
        244 126
        147 262
        301 235
        252 143
        95 385
        308 9
        331 87
        110 141
        34 219
        260 338
        205 43
        283 131
        242 294
        118 174
        222 17
        138 258
        254 85
        81 252
        116 320
        161 243
        386 339
        246 96
        332 187
        69 307
        21 174
        213 380
        237 79
        286 84
        88 358
        93 172
        236 219
        123 17
        161 368
        279 250
        151 312
        149 274
        175 248
        344 280
        51 103
        56 261
        138 227
        346 196
        329 121
        226 321
        53 155
        305 337
        260 272
        146 167
        371 326
        374 144
        129 216
        275 208
        316 92
        376 113
        293 337
        371 269
        371 268
        324 19
        24 32
        118 153
        248 156
        137 1
        296 201
        11 175
        265 83
        333 266
        273 291
        93 121
        3 32
        167 291
        220 297
        47 247
        373 270
        317 159
        229 100
        120 362
        297 290
        71 133
        11 211
        279 291
        53 19
        199 40
        8 246
        82 22
        21 82
        145 350
        112 219
        74 104
        212 101
        36 188
        198 102
        356 353
        363 311
        284 74
        76 320
        71 282
        75 97
        300 116
        327 54
        138 332
        323 149
        351 219
        7 283
        244 280
        23 54
        357 3
        103 179
        302 218
        160 96
        111 44
        137 383
        39 112
        33 375
        316 43
        165 126
        274 312
        347 381
        182 126
        278 181
        277 148
        49 209
        53 314
        327 358
        182 195
        321 203
        315 253
        298 339
        217 167
        76 173
        70 211
        330 154
        304 258
        238 232
        286 187
        299 156
        203 101
        158 271
        137 333
        85 193
        205 28
        130 192
        16 372
        123 223
        309 65
        279 208
        322 241
        271 3
        309 302
        232 367
        13 245
        233 275
        351 342
        337 152
        331 361
        383 27
        145 16
        270 178
        34 202
        348 227
        350 230
        125 19
        155 372
        382 289
        366 107
        41 372
        365 144
        315 373
        298 214
        145 362
        196 333
        218 224
        287 89
        193 199
        117 51
        229 313
        91 152
        319 8
        183 72
        117 370
        345 387
        366 44
        110 36
        201 270
        75 130
        383 379
        345 160
        210 24
        31 169
        83 287
        49 225
        221 364
        147 9
        2 144
        313 285
        355 320
        301 282
        357 114
        86 101
        141 243
        67 166
        10 253
        323 366
        334 386
        309 141
        50 62
        10 196
        29 185
        139 5
        110 354
        88 340
        191 37
        123 303
        310 205
        39 195
        131 15
        12 49
        264 197
        316 328
        369 134
        340 251
        113 103
        284 126
        206 243
        202 249
        364 26
        286 108
        351 74
        294 267
        360 44
        199 280
        255 281
        222 77
        331 190
        60 302
        2 349
        198 292
        90 135
        132 237
        384 4
        364 223
        165 39
        84 306
        254 69
        59 273
        214 99
        5 133
        244 82
        170 4
        157 276
        323 131
        224 65
        228 376
        265 105
        107 159
        100 250
        46 213
        382 127
        259 70
        352 368
        250 236
        377 380
        206 65
        212 261
        171 4
        348 271
        """

        self.waters="""
        0.5 0.75 0.375
        0.0 0.0 0.34429
        0.125 0.25 0.77137
        0.68238 0.0625 0.51069
        0.5 0.0 0.84429
        0.8125 0.06763 0.76069
        0.5 0.44263 0.2548
        0.875 0.43337 0.40535
        0.0 0.375 0.56101
        0.0 0.875 0.31893
        0.375 0.25 0.38285
        0.375 0.43337 0.09465
        0.81663 0.125 0.34465
        0.5 0.05738 0.2548
        0.0 0.875 0.43899
        0.375 0.25 0.43107
        0.81663 0.56763 0.30585
        0.5 0.05837 0.63962
        0.375 0.75 0.27137
        0.5 0.93238 0.33233
        0.19263 0.75 0.4952
        0.0 0.44163 0.94898
        0.0 0.125 0.97863
        0.81763 0.5625 0.01069
        0.5 0.05837 0.55102
        0.69163 0.25 0.61038
        0.0 0.125 0.63285
        0.81663 0.55837 0.38213
        0.30837 0.56663 0.63213
        0.18337 0.44163 0.61787
        0.31763 0.4375 0.51069
        0.19263 0.55837 0.42592
        0.5 0.125 0.52137
        0.0 0.75 0.0689
        0.375 0.93337 0.90535
        0.5 0.875 0.06101
        0.31663 0.56763 0.19415
        0.375 0.25 0.31101
        0.31663 0.625 0.84465
        0.5 0.375 0.93899
        0.0 0.875 0.02137
        0.5 0.75 0.3189
        0.81663 0.43238 0.69415
        0.30837 0.93337 0.63213
        0.5 0.625 0.47863
        0.5 0.94163 0.44898
        0.0 0.06763 0.83233
        0.81663 0.875 0.65535
        0.68238 0.4375 0.51069
        0.81663 0.375 0.34465
        0.19163 0.93337 0.86787
        0.8125 0.94263 0.71791
        0.68337 0.93238 0.19415
        0.69163 0.05738 0.32409
        0.81763 0.4375 0.98932
        0.80837 0.93337 0.86787
        0.5 0.43238 0.66767
        0.80738 0.75 0.4952
        0.6875 0.44263 0.21791
        0.5 0.375 0.86716
        0.1875 0.93238 0.23932
        0.375 0.75 0.56893
        0.0 0.05837 0.86038
        0.81663 0.06763 0.69415
        0.31763 0.56663 0.55585
        0.19163 0.05738 0.17592
        0.19263 0.5625 0.53209
        0.125 0.56663 0.59465
        0.0 0.625 0.7286
        0.5 0.625 0.06101
        0.125 0.25 0.06893
        0.1875 0.06763 0.76069
        0.19263 0.94163 0.42592
        0.5 0.25 0.97863
        0.30738 0.9375 0.96791
        0.69263 0.4375 0.03209
        0.8125 0.93238 0.23932
        0.30837 0.94263 0.67592
        0.0 0.5 0.34429
        0.5 0.5 0.84429
        0.3125 0.56763 0.26069
        0.68337 0.56763 0.19415
        0.0 0.375 0.97863
        0.81763 0.93337 0.94415
        0.80738 0.05837 0.57409
        0.18238 0.43337 0.05585
        0.6875 0.43238 0.73932
        0.875 0.25 0.11716
        0.375 0.25 0.02141
        0.81763 0.56663 0.94415
        0.6875 0.93238 0.26069
        0.81763 0.75 0.08233
        0.18337 0.625 0.65535
        0.81763 0.06663 0.05585
        0.0 0.25 0.22863
        0.0 0.75 0.125
        0.19263 0.05837 0.57409
        0.81763 0.43337 0.05585
        0.68337 0.06763 0.80585
        0.0 0.55837 0.13962
        0.31663 0.44163 0.88213
        0.625 0.25 0.72863
        0.125 0.75 0.52141
        0.6875 0.75 0.71311
        0.5 0.0625 0.96311
        0.81763 0.0625 0.98932
        0.625 0.56663 0.90535
        0.5 0.75 0.43111
        0.81663 0.05837 0.61787
        0.6875 0.06763 0.73932
        0.5 0.625 0.18107
        0.68238 0.5625 0.48932
        0.5 0.125 0.93899
        0.625 0.75 0.68899
        0.5 0.875 0.47863
        0.31763 0.43337 0.44415
        0.8125 0.56763 0.23932
        0.0 0.875 0.7286
        0.81763 0.25 0.91767
        0.875 0.75 0.81101
        0.5 0.25 0.27137
        0.69263 0.94163 0.07409
        0.0 0.375 0.68107
        0.5 0.25 0.625
        0.3125 0.55738 0.78209
        0.30837 0.05738 0.32409
        0.30738 0.5625 0.96791
        0.69263 0.75 0.0048
        0.69163 0.94263 0.67592
        0.19263 0.0625 0.46791
        0.5 0.5625 0.03689
        0.625 0.25 0.43107
        0.31663 0.43238 0.80585
        0.0 0.94263 0.7548
        0.0 0.93238 0.16767
        0.625 0.75 0.27137
        0.30738 0.25 0.9952
        0.0 0.875 0.36716
        0.68238 0.56663 0.55585
        0.6875 0.94263 0.78209
        0.19263 0.44163 0.57409
        0.5 0.875 0.18107
        0.19163 0.94263 0.82409
        0.0 0.75 0.18111
        0.875 0.25 0.77137
        0.8125 0.44263 0.28209
        0.625 0.93337 0.90535
        0.0 0.625 0.31893
        0.125 0.75 0.81101
        0.80738 0.55837 0.42592
        0.0 0.0625 0.53689
        0.0 0.75 0.47863
        0.80837 0.75 0.11038
        0.69263 0.05837 0.92592
        0.81763 0.9375 0.01069
        0.81663 0.93238 0.30585
        0.68337 0.55837 0.11787
        0.18337 0.06763 0.69415
        0.68238 0.93337 0.55585
        0.68238 0.75 0.41767
        0.31763 0.25 0.58233
        0.68337 0.125 0.15535
        0.1875 0.44263 0.28209
        0.30837 0.75 0.30102
        0.5 0.75 0.72863
        0.5 0.4375 0.96311
        0.25 0.75 0.59429
        0.68337 0.05837 0.88213
        0.31663 0.375 0.15535
        0.125 0.43337 0.40535
        0.5 0.125 0.81893
        0.31663 0.875 0.84465
        0.0 0.94163 0.05102
        0.6875 0.05738 0.21791
        0.0 0.25 0.93111
        0.31663 0.55837 0.11787
        0.1875 0.56763 0.23932
        0.30837 0.43337 0.36787
        0.69163 0.75 0.38962
        0.8125 0.55738 0.71791
        0.30738 0.4375 0.03209
        0.5 0.375 0.2286
        0.18238 0.56663 0.94415
        0.31763 0.75 0.41767
        0.5 0.55837 0.36038
        0.0 0.375 0.63285
        0.0 0.55738 0.7548
        0.75 0.75 0.59429
        0.19163 0.75 0.19898
        0.19263 0.25 0.5048
        0.19163 0.06663 0.13213
        0.3125 0.25 0.28689
        0.5 0.75 0.02137
        0.0 0.55837 0.05102
        0.1875 0.55738 0.71791
        0.30738 0.44163 0.92592
        0.30837 0.06663 0.36787
        0.1875 0.75 0.78689
        0.19263 0.9375 0.53209
        0.0 0.625 0.02137
        0.8125 0.25 0.21311
        0.69163 0.06663 0.36787
        0.25 0.75 0.90571
        0.375 0.25 0.72863
        0.30837 0.55738 0.67592
        0.375 0.75 0.61716
        0.31663 0.125 0.15535
        0.375 0.56663 0.90535
        0.0 0.44163 0.86038
        0.69163 0.44263 0.32409
        0.31763 0.93337 0.55585
        0.25 0.25 0.09429
        0.69163 0.25 0.69898
        0.0 0.25 0.8189
        0.80837 0.43337 0.13213
        0.18337 0.375 0.34465
        0.125 0.25 0.4786
        0.5 0.125 0.86716
        0.1875 0.25 0.21311
        0.30738 0.05837 0.92592
        0.1875 0.05738 0.28209
        0.125 0.93337 0.59465
        0.5 0.06763 0.66767
        0.30837 0.25 0.61038
        0.125 0.25 0.18899
        0.69163 0.43337 0.36787
        0.18337 0.43238 0.69415
        0.80738 0.5625 0.53209
        0.3125 0.75 0.71311
        0.19163 0.56663 0.86787
        0.0 0.44263 0.2452
        0.75 0.75 0.90571
        0.375 0.06663 0.09465
        0.68337 0.625 0.84465
        0.0 0.75 0.77137
        0.5 0.875 0.77141
        0.18238 0.25 0.91767
        0.5 0.375 0.81893
        0.30738 0.94163 0.07409
        0.0 0.05738 0.2452
        0.0 0.9375 0.46311
        0.75 0.25 0.09429
        0.68337 0.43238 0.80585
        0.5 0.0 0.15571
        0.18238 0.4375 0.98932
        0.5 0.125 0.2286
        0.0 0.125 0.56101
        0.69163 0.93337 0.63213
        0.5 0.625 0.13285
        0.125 0.75 0.93107
        0.19163 0.25 0.88962
        0.5 0.9375 0.03689
        0.80837 0.75 0.19898
        0.25 0.25 0.40571
        0.30738 0.55837 0.07409
        0.875 0.25 0.4786
        0.19163 0.25 0.80102
        0.31763 0.06663 0.44415
        0.80738 0.44163 0.57409
        0.18238 0.06663 0.05585
        0.5 0.55738 0.7452
        0.5 0.25 0.68111
        0.18337 0.56763 0.30585
        0.5 0.375 0.52137
        0.3125 0.94263 0.78209
        0.69263 0.9375 0.96791
        0.30837 0.75 0.38962
        0.8125 0.75 0.78689
        0.69163 0.56663 0.63213
        0.0 0.5 0.65571
        0.81663 0.94163 0.38213
        0.80738 0.9375 0.53209
        0.5 0.625 0.77141
        0.68337 0.44163 0.88213
        0.0 0.625 0.43899
        0.80837 0.56663 0.86787
        0.0 0.125 0.68107
        0.19163 0.55738 0.82409
        0.3125 0.44263 0.21791
        0.0 0.25 0.875
        0.18238 0.5625 0.01069
        0.80738 0.25 0.5048
        0.3125 0.06763 0.73932
        0.75 0.25 0.40571
        0.375 0.75 0.9786
        0.875 0.75 0.88285
        0.875 0.93337 0.59465
        0.875 0.75 0.93107
        0.31663 0.06763 0.80585
        0.69263 0.5625 0.96791
        0.8125 0.05738 0.28209
        0.80837 0.25 0.88962
        0.31763 0.0625 0.51069
        0.80837 0.06663 0.13213
        0.6875 0.55738 0.78209
        0.31663 0.05837 0.88213
        0.625 0.25 0.38285
        0.0 0.125 0.27141
        0.68337 0.375 0.15535
        0.625 0.43337 0.09465
        0.6875 0.56763 0.26069
        0.5 0.94263 0.7452
        0.3125 0.05738 0.21791
        0.5 0.44163 0.63962
        0.875 0.56663 0.59465
        0.5 0.875 0.13285
        0.68238 0.25 0.58233
        0.69263 0.55837 0.07409
        0.18337 0.93238 0.30585
        0.31663 0.93238 0.19415
        0.625 0.75 0.61716
        0.18238 0.9375 0.01069
        0.0 0.5625 0.46311
        0.125 0.75 0.88285
        0.625 0.25 0.31101
        0.125 0.06663 0.40535
        0.18337 0.875 0.65535
        0.80738 0.94163 0.42592
        0.31763 0.9375 0.48932
        0.0 0.4375 0.53689
        0.875 0.75 0.22863
        0.30837 0.25 0.69898
        0.875 0.25 0.06893
        0.68238 0.43337 0.44415
        0.5 0.94163 0.36038
        0.80837 0.94263 0.82409
        0.69163 0.55738 0.67592
        0.69263 0.25 0.9952
        0.0 0.0 0.65571
        0.625 0.06663 0.09465
        0.69263 0.0625 0.03209
        0.125 0.25 0.11716
        0.625 0.75 0.56893
        0.18337 0.94163 0.38213
        0.19163 0.44263 0.17592
        0.69263 0.44163 0.92592
        0.80738 0.4375 0.46791
        0.68337 0.94163 0.11787
        0.3125 0.43238 0.73932
        0.80837 0.44263 0.17592
        0.30738 0.0625 0.03209
        0.81663 0.44163 0.61787
        0.0 0.05837 0.94898
        0.3125 0.93238 0.26069
        0.30738 0.75 0.0048
        0.5 0.25 0.5689
        0.18337 0.125 0.34465
        0.68238 0.06663 0.44415
        0.875 0.75 0.52141
        0.1875 0.43238 0.76069
        0.0 0.375 0.27141
        0.18238 0.93337 0.94415
        0.875 0.25 0.18899
        0.30837 0.44263 0.32409
        0.5 0.5 0.15571
        0.125 0.75 0.22863
        0.5 0.56763 0.33233
        0.68238 0.9375 0.48932
        0.625 0.25 0.02141
        0.0 0.25 0.52137
        0.31763 0.5625 0.48932
        0.19163 0.43337 0.13213
        0.6875 0.25 0.28689
        0.18238 0.0625 0.98932
        0.18337 0.05837 0.61787
        0.8125 0.43238 0.76069
        0.5 0.55837 0.44898
        0.31663 0.94163 0.11787
        0.80837 0.05738 0.17592
        0.0 0.94163 0.13962
        0.1875 0.94263 0.71791
        0.81663 0.625 0.65535
        0.69163 0.75 0.30102
        0.875 0.06663 0.40535
        0.80837 0.25 0.80102
        0.18238 0.75 0.08233
        0.375 0.75 0.68899
        0.80837 0.55738 0.82409
        0.19263 0.4375 0.46791
        0.18337 0.55837 0.38213
        0.0 0.43238 0.83233
        0.80738 0.0625 0.46791
        0.625 0.75 0.9786
        0.0 0.625 0.36716
        0.68337 0.875 0.84465
        0.19163 0.75 0.11038
        0.0 0.56763 0.16767
        0.5 0.44163 0.55102
        """

        self.coord= "relative"

        self.cages="""
        12 0.5 1.5 1.0
        15 0.0 0.75 0.56207
        14 0.23349 0.75 0.34505
        14 0.5 -0.01651 0.59505
        12 0.0 -0.5205 -0.20726
        12 -0.7705 -1.25 -0.95726
        12 0.25 -0.25 0.75
        12 -0.2705 0.75 0.45726
        12 -0.25 -0.25 -0.25
        15 0.5 0.25 0.18793
        12 1.0 1.5 1.5
        15 0.5 1.25 1.06207
        12 0.0 -0.25 -0.15352
        12 0.2705 -0.75 -0.45726
        14 1.0 0.51651 0.90495
        14 0.0 0.01651 0.09505
        12 -0.2705 1.25 0.54274
        14 -0.23349 -0.75 -0.34505
        15 0.5 -0.25 0.81207
        12 0.5 1.25 0.90352
        16 0.5 1.25 0.77355
        14 -0.26651 -1.25 -0.84505
        12 0.0 1.0 0.5
        14 0.5 0.01651 0.40495
        12 0.2295 1.25 0.95726
        12 0.5 0.75 0.09648
        14 0.26651 0.75 0.15495
        14 0.5 0.48349 0.40495
        16 0.0 -0.25 -0.02355
        14 0.26651 1.25 0.84505
        14 0.73349 1.25 0.84505
        15 0.5 0.75 -0.06207
        14 1.0 0.48349 1.09505
        12 0.7705 1.25 0.95726
        12 0.0 -0.75 -0.40352
        14 0.0 0.75 0.625
        14 0.5 0.25 0.125
        16 0.5 0.25 0.47645
        12 0.5 1.0 1.0
        15 0.0 -0.75 -0.56207
        14 0.76651 1.75 1.34505
        16 0.5 -0.25 0.52355
        14 0.5 -0.25 0.875
        16 0.5 0.75 0.22645
        12 0.0 0.75 0.40352
        16 0.0 0.75 0.27355
        12 0.5 -0.5205 0.70726
        12 0.5 0.25 0.34648
        16 0.0 0.25 0.02355
        14 0.0 0.25 0.375
        16 0.0 -0.75 -0.27355
        12 0.7705 0.75 0.04274
        12 0.5 -0.0205 0.29274
        12 0.5 -0.25 0.65352
        12 1.2705 1.75 1.45726
        12 0.5 0.5205 0.29274
        15 0.0 0.25 0.31207
        12 0.0 0.5205 0.20726
        12 -0.25 0.25 -0.75
        12 0.5 1.0205 0.70726
        14 0.23349 1.25 0.65495
        12 1.0 1.0205 0.79274
        12 0.0 0.25 0.15352
        12 1.0 -0.0205 1.20726
        14 0.0 -0.01651 -0.09505
        15 0.0 -0.25 -0.31207
        14 0.5 0.51651 0.59505
        12 0.25 0.25 0.25
        """

        self.bondlen = 3


        self.cell = """
        13.27885453677605 13.27885453677605 109.13204656869078
        """

        self.density = 0.6026844037544047



        self.cell = cellvectors(a=13.27885453677605,
                           b=13.27885453677605,
                           c=109.13204656869078)
