# coding: utf-8
"""
XMol file format (.xyz)
"""

import numpy as np

from genice2 import rigid
from logging import getLogger
from genice2.decorators import timeit, banner
import genice2.formats
from genice2.molecules  import serialize


class Format(genice2.formats.Format):
    """
The atomic positions of the molecules are output in a crude XYZ format.
No options available.
    """
    def __init__(self, **kwargs):
        super().__init__(**kwargs)


    def hooks(self):
        return {7:self.Hook7}


    @timeit
    @banner
    def Hook7(self, ice):
        "Output in XYZ format."
        logger = getLogger()
        atoms = []
        for mols in ice.universe:
            atoms += serialize(mols)

        s = ""
        s += "{0}\n".format(len(atoms))
        s += "Generated by GenIce. https://github.com/vitroid/GenIce\n"
        for atom in atoms:
            molorder, resname, atomname, position, order = atom
            logger.info(atom)
            s += "{0:5} {1:9.4f} {2:9.4f} {3:9.4f}\n".format(atomname,position[0]*10,position[1]*10,position[2]*10)
        s = '#' + "\n#".join(ice.doc) + "\n" + s
        self.output = s
