# GitGuard Examples

<img src="../Project_Himalaya_Icon_Round_256.png" alt="Project Himalaya" width="32" height="32" style="vertical-align: middle;"> *Part of Project Himalaya*

This directory contains usage examples for different GitGuard scenarios.

## Available Examples

### [Basic Usage](basic/)

**Target Audience**: Individual developers  
**Use Case**: Personal projects and simple security needs  
**Features**: Basic scanning, automatic fixes, personal audit trail

### [Enterprise Setup](enterprise/) *(Coming Soon)*

**Target Audience**: Enterprise development teams  
**Use Case**: Large organizations with compliance requirements  
**Features**: Policy enforcement, team coordination, advanced audit logging

### [CI/CD Integration](cicd/) *(Coming Soon)*

**Target Audience**: DevOps teams  
**Use Case**: Automated security in deployment pipelines  
**Features**: GitHub Actions, Jenkins, GitLab CI integrations

## Quick Start Recommendations

### For Individual Developers

```bash
# Start with basic example
cd basic/
cat README.md
```

### For Teams

```bash
# Review basic first, then move to enterprise
cd basic/ && cat README.md
# cd enterprise/ && cat README.md  # Coming soon
```

### For DevOps Engineers

```bash
# Check CI/CD integration examples
# cd cicd/ && cat README.md  # Coming soon
```

## Getting Help

- **Configuration Issues**: See [Configuration Guide](../docs/configuration.md)
- **Integration Questions**: See [Integrations Guide](../docs/integrations.md)
- **Bug Reports**: See [Contributing Guide](../CONTRIBUTING.md)

## Contributing Examples

We welcome contributions of new examples! Please:

1. **Follow the existing structure**: README.md + configuration files
2. **Target specific use cases**: Don't try to cover everything in one example
3. **Include clear documentation**: Step-by-step instructions
4. **Test thoroughly**: Ensure examples work as documented

See [Contributing Guide](../CONTRIBUTING.md) for detailed guidelines.