"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnDashboards = exports.toJson_CfnDashboardsProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnDashboardsProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnDashboardsProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'DashboardInput': obj.dashboardInput,
        'ListQueryFilter': obj.listQueryFilter,
        'Variables': obj.variables,
        'Tags': obj.tags,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnDashboardsProps = toJson_CfnDashboardsProps;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `NewRelic::Observability::Dashboards`
 *
 * @cloudformationResource NewRelic::Observability::Dashboards
 * @stability external
 * @link https://github.com/newrelic-experimental/newrelic-cloudformation-resource-providers-dashboards
 */
class CfnDashboards extends cdk.CfnResource {
    /**
     * Create a new `NewRelic::Observability::Dashboards`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnDashboards.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnDashboardsProps(props) });
        this.props = props;
        this.attrGuid = cdk.Token.asString(this.getAtt('Guid'));
    }
}
exports.CfnDashboards = CfnDashboards;
_a = JSII_RTTI_SYMBOL_1;
CfnDashboards[_a] = { fqn: "@cdk-cloudformation/newrelic-observability-dashboards.CfnDashboards", version: "1.0.0-alpha.6" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnDashboards.CFN_RESOURCE_TYPE_NAME = "NewRelic::Observability::Dashboards";
//# sourceMappingURL=data:application/json;base64,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