# TabPy

[![Tableau Supported](https://img.shields.io/badge/Support%20Level-Tableau%20Supported-53bd92.svg)](https://www.tableau.com/support-levels-it-and-developer-tools)
[![GitHub](https://img.shields.io/badge/license-MIT-brightgreen.svg)](https://raw.githubusercontent.com/Tableau/TabPy/master/LICENSE)

[![GitHub Workflow Status](https://img.shields.io/github/workflow/status/tableau/tabpy/Test%20Run%20on%20Push)](https://github.com/tableau/TabPy/actions?query=workflow%3A%22Test+Run+on+Push%22)
![Scrutinizer coverage](https://img.shields.io/scrutinizer/coverage/g/tableau/tabpy)
[![Scrutinizer Code Quality](https://scrutinizer-ci.com/g/tableau/TabPy/badges/quality-score.png?b=master)](https://scrutinizer-ci.com/g/tableau/TabPy/?branch=master)

[![Python 3.6](https://img.shields.io/badge/python-3.6-blue.svg)](https://www.python.org/downloads/release/python-360/)
[![Python 3.7](https://img.shields.io/badge/python-3.7-blue.svg)](https://www.python.org/downloads/release/python-370/)
[![Python 3.8](https://img.shields.io/badge/python-3.8-blue.svg)](https://www.python.org/downloads/release/python-380/)
![PyPI - Python Version](https://img.shields.io/pypi/pyversions/tabpy?label=PyPI%20Python%20versions)
![PyPI - Wheel](https://img.shields.io/pypi/wheel/tabpy)
[![PyPI version](https://badge.fury.io/py/tabpy.svg)](https://pypi.python.org/pypi/tabpy/)
![Release](https://img.shields.io/github/release/tableau/TabPy.svg)

TabPy (the Tableau Python Server) is an Analytics Extension implementation which
expands Tableau's capabilities by allowing users to execute Python scripts and
saved functions via Tableau's table calculations.

Consider reading TabPy documentation in the following order:

* [About TabPy](docs/about.md)
* [TabPy Installation Instructions](docs/server-install.md)
* [TabPy Server Configuration Instructions](docs/server-config.md)
* [Running TabPy in Python Virtual Environment](docs/tabpy-virtualenv.md)
* [Authoring Python calculations in Tableau](docs/TableauConfiguration.md).
* [TabPy Tools](docs/tabpy-tools.md)

Troubleshooting:

* [FAQ for configuration, startup and other issues](docs/FAQ.md)

More technical topics:

* [Contributing Guide](CONTRIBUTING.md) for TabPy developers
* [TabPy REST API](docs/server-rest.md)
* [TabPy Security Considerations](docs/security.md)

Other useful resources:

* [Tableau Sci-Fi Blog](http://tabscifi.com/) provides tips, tricks, under
  the hood, useful resources, and technical details for how to extend
  Tableau with data science.
* [Known Issues for the Tableau Analytics Extensions API](https://tableau.github.io/analytics-extensions-api/docs/ae_known_issues.html).
* For all questions not related to the TabPy code (installation, deployment,
  connections, Python issues, etc.) and requests use the
  [Analytics Extensions Forum](https://community.tableau.com/community/forums/analyticsextensions)
  on [Tableau Community](https://community.tableau.com).
* [Building advanced analytics applications with TabPy](https://www.tableau.com/about/blog/2017/1/building-advanced-analytics-applications-tabpy-64916)
* [Building Data Science Applications with TabPy Video Tutorial](https://youtu.be/nRtOMTnBz_Y)
* [TabPy Tutorial on TabWiki](https://community.tableau.com/docs/DOC-10856)

![GitHub commit activity](https://img.shields.io/github/commit-activity/m/tableau/TabPy.svg)
![GitHub forks](https://img.shields.io/github/forks/tableau/TabPy.svg?label=Forks&style=social)
![GitHub stars](https://img.shields.io/github/stars/tableau/TabPy.svg?style=social)
