"""Add AccountUser model

Revision ID: a43c2a95cbbf
Revises: d869327be6c4
Create Date: 2022-02-16 11:33:48.452549

"""
import sqlalchemy as sa
from alembic import op

import fief

# revision identifiers, used by Alembic.
revision = "a43c2a95cbbf"
down_revision = "d869327be6c4"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "account_users",
        sa.Column("id", fief.models.generics.GUID(), nullable=False),
        sa.Column(
            "created_at",
            sa.TIMESTAMP(timezone=True),
            server_default=sa.text("now()"),
            nullable=False,
        ),
        sa.Column(
            "updated_at",
            sa.TIMESTAMP(timezone=True),
            server_default=sa.text("now()"),
            nullable=False,
        ),
        sa.Column("account_id", fief.models.generics.GUID(), nullable=False),
        sa.Column("user_id", fief.models.generics.GUID(), nullable=False),
        sa.ForeignKeyConstraint(["account_id"], ["accounts.id"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_account_users_created_at"),
        "account_users",
        ["created_at"],
        unique=False,
    )
    op.create_index(
        op.f("ix_account_users_updated_at"),
        "account_users",
        ["updated_at"],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_account_users_updated_at"), table_name="account_users")
    op.drop_index(op.f("ix_account_users_created_at"), table_name="account_users")
    op.drop_table("account_users")
    # ### end Alembic commands ###
