"""Move id token encryption key from Tenant to Client

Revision ID: 2deef74e6904
Revises: 55d24818a4b7
Create Date: 2022-03-07 12:52:03.892095

"""
import sqlalchemy as sa
from alembic import op

import fief

# revision identifiers, used by Alembic.
revision = "2deef74e6904"
down_revision = "55d24818a4b7"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("fief_clients", sa.Column("encrypt_jwk", sa.Text(), nullable=True))
    op.drop_column("fief_tenants", "encrypt_jwk")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "fief_tenants",
        sa.Column("encrypt_jwk", sa.TEXT(), autoincrement=False, nullable=True),
    )
    op.drop_column("fief_clients", "encrypt_jwk")
    # ### end Alembic commands ###
