from .corehelper import *
from .itransformer import InterfaceTransform


# coding=utf8
# the above tag defines encoding for this document and is for Python 2.x compatibility


class Jsi18n(InterfaceTransform):
    def __init__(self):
        self.name = "Jsi18n"

    def __eq__(self, profile):
        return self.id == profile.id  # I made it up the id property.

    def __lt__(self, profile):
        return self.id < profile.id

    def __hash__(self):
        return hash(self.id)

    """ implementation of interface transformation """

    def autoGeneratedTag(self) -> str:
        #  return "// AUTO-GENERATED - DO NOT EDIT THE LINES BELOW "
        return ""

    def autoFileName(self) -> str:
        return "_{}.json"

    def transformComment(self, comment: str) -> str:
        """comment replace"""
        return ""

    # You can manually specify the number of replacements by changing the 4th argument
    def transformKeyValue(self, key: str, value: str, isLast: bool = False) -> str:
        if key.find(" ", 0) > -1:
            return self.transformComment(key)

        if len(key) == 0:
            return ""

        normalizedValue = RegexBoxNewLine(value)
        normalizedValue = RegexBoxDoubleQuote(normalizedValue)
        normalizedValue = RegexBoxDF(normalizedValue)
        normalizedValue = RegexBoxBR(normalizedValue)
        normalizedValue = RegexBoxStrAt(normalizedValue)
        normalizedValue = RegexBoxAmp(normalizedValue)

        line_template = ' "{}": "{}"{}'
        if isLast:
            return line_template.format(key, normalizedValue, "")
        else:
            return line_template.format(key, normalizedValue, ",")

    def wrap_file(self, input: str, newValues: list) -> list:
        return ["{"] + newValues + ["}"]
