# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['SentryPluginArgs', 'SentryPlugin']

@pulumi.input_type
class SentryPluginArgs:
    def __init__(__self__, *,
                 organization: pulumi.Input[str],
                 plugin: pulumi.Input[str],
                 project: pulumi.Input[str],
                 config: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        The set of arguments for constructing a SentryPlugin resource.
        :param pulumi.Input[str] organization: The slug of the organization the plugin should be enabled for.
        :param pulumi.Input[str] plugin: Identifier of the plugin.
        :param pulumi.Input[str] project: The slug of the project the plugin should be enabled for.
        :param pulumi.Input[Mapping[str, Any]] config: Configuration of the plugin.
        """
        pulumi.set(__self__, "organization", organization)
        pulumi.set(__self__, "plugin", plugin)
        pulumi.set(__self__, "project", project)
        if config is not None:
            pulumi.set(__self__, "config", config)

    @property
    @pulumi.getter
    def organization(self) -> pulumi.Input[str]:
        """
        The slug of the organization the plugin should be enabled for.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: pulumi.Input[str]):
        pulumi.set(self, "organization", value)

    @property
    @pulumi.getter
    def plugin(self) -> pulumi.Input[str]:
        """
        Identifier of the plugin.
        """
        return pulumi.get(self, "plugin")

    @plugin.setter
    def plugin(self, value: pulumi.Input[str]):
        pulumi.set(self, "plugin", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        The slug of the project the plugin should be enabled for.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Configuration of the plugin.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "config", value)


@pulumi.input_type
class _SentryPluginState:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 plugin: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SentryPlugin resources.
        :param pulumi.Input[Mapping[str, Any]] config: Configuration of the plugin.
        :param pulumi.Input[str] organization: The slug of the organization the plugin should be enabled for.
        :param pulumi.Input[str] plugin: Identifier of the plugin.
        :param pulumi.Input[str] project: The slug of the project the plugin should be enabled for.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if organization is not None:
            pulumi.set(__self__, "organization", organization)
        if plugin is not None:
            pulumi.set(__self__, "plugin", plugin)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Configuration of the plugin.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def organization(self) -> Optional[pulumi.Input[str]]:
        """
        The slug of the organization the plugin should be enabled for.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization", value)

    @property
    @pulumi.getter
    def plugin(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the plugin.
        """
        return pulumi.get(self, "plugin")

    @plugin.setter
    def plugin(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plugin", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The slug of the project the plugin should be enabled for.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


class SentryPlugin(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 plugin: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## # SentryPlugin Resource

        Sentry Plugin resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_sentry as sentry

        # Create a plugin
        default = sentry.SentryPlugin("default",
            config={
                "webhook": "slack://webhook",
            },
            organization="my-organization",
            plugin="slack",
            project="web-app")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, Any]] config: Configuration of the plugin.
        :param pulumi.Input[str] organization: The slug of the organization the plugin should be enabled for.
        :param pulumi.Input[str] plugin: Identifier of the plugin.
        :param pulumi.Input[str] project: The slug of the project the plugin should be enabled for.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SentryPluginArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # SentryPlugin Resource

        Sentry Plugin resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_sentry as sentry

        # Create a plugin
        default = sentry.SentryPlugin("default",
            config={
                "webhook": "slack://webhook",
            },
            organization="my-organization",
            plugin="slack",
            project="web-app")
        ```

        :param str resource_name: The name of the resource.
        :param SentryPluginArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SentryPluginArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 plugin: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        else:
            opts = copy.copy(opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SentryPluginArgs.__new__(SentryPluginArgs)

            __props__.__dict__["config"] = config
            if organization is None and not opts.urn:
                raise TypeError("Missing required property 'organization'")
            __props__.__dict__["organization"] = organization
            if plugin is None and not opts.urn:
                raise TypeError("Missing required property 'plugin'")
            __props__.__dict__["plugin"] = plugin
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
        super(SentryPlugin, __self__).__init__(
            'sentry:index/sentryPlugin:SentryPlugin',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            organization: Optional[pulumi.Input[str]] = None,
            plugin: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None) -> 'SentryPlugin':
        """
        Get an existing SentryPlugin resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, Any]] config: Configuration of the plugin.
        :param pulumi.Input[str] organization: The slug of the organization the plugin should be enabled for.
        :param pulumi.Input[str] plugin: Identifier of the plugin.
        :param pulumi.Input[str] project: The slug of the project the plugin should be enabled for.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SentryPluginState.__new__(_SentryPluginState)

        __props__.__dict__["config"] = config
        __props__.__dict__["organization"] = organization
        __props__.__dict__["plugin"] = plugin
        __props__.__dict__["project"] = project
        return SentryPlugin(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def config(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        Configuration of the plugin.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def organization(self) -> pulumi.Output[str]:
        """
        The slug of the organization the plugin should be enabled for.
        """
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter
    def plugin(self) -> pulumi.Output[str]:
        """
        Identifier of the plugin.
        """
        return pulumi.get(self, "plugin")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The slug of the project the plugin should be enabled for.
        """
        return pulumi.get(self, "project")

