#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['scglue', 'scglue.models']

package_data = \
{'': ['*']}

install_requires = \
['numpy>=1.19',
 'scipy>=1.3',
 'pandas>=1.1',
 'matplotlib>=3.1.2',
 'seaborn>=0.9',
 'dill>=0.2.3',
 'tqdm>=4.27',
 'scikit-learn>=0.21.2',
 'statsmodels>=0.10',
 'parse>=1.3.2',
 'networkx>=2',
 'pynvml>=8.0.1',
 'torch>=1.7',
 'pytorch-ignite>=0.4.1',
 'tensorboardX>=1.4',
 'anndata>=0.7',
 'scanpy>=1.5',
 'pybedtools>=0.8.1']

extras_require = \
{'doc': ['sphinx<4',
         'sphinx-autodoc-typehints<1.12',
         'sphinx-copybutton',
         'nbsphinx',
         'sphinx-rtd-theme',
         'ipython'],
 'test': ['flake8', 'pytest', 'pytest-cov']}

setup(name='scglue',
      version='0.1.1',
      description='Graph-linked unified embedding for unpaired single-cell multi-omics data integration',
      author=None,
      author_email='Zhi-Jie Cao <caozj@mail.cbi.pku.edu.cn>',
      url=None,
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>=3.6',
     )
