# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class ShiftStartVariance(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ShiftStartVariance - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'applicable_days': 'list[str]',
            'max_shift_start_variance_minutes': 'int'
        }

        self.attribute_map = {
            'applicable_days': 'applicableDays',
            'max_shift_start_variance_minutes': 'maxShiftStartVarianceMinutes'
        }

        self._applicable_days = None
        self._max_shift_start_variance_minutes = None

    @property
    def applicable_days(self):
        """
        Gets the applicable_days of this ShiftStartVariance.
        Days for which shift start variance is configured

        :return: The applicable_days of this ShiftStartVariance.
        :rtype: list[str]
        """
        return self._applicable_days

    @applicable_days.setter
    def applicable_days(self, applicable_days):
        """
        Sets the applicable_days of this ShiftStartVariance.
        Days for which shift start variance is configured

        :param applicable_days: The applicable_days of this ShiftStartVariance.
        :type: list[str]
        """
        
        if not applicable_days:
            raise ValueError("Invalid value for `applicable_days`, must not be `None`")


        self._applicable_days = applicable_days

    @property
    def max_shift_start_variance_minutes(self):
        """
        Gets the max_shift_start_variance_minutes of this ShiftStartVariance.
        Maximum variance in minutes across shift starts

        :return: The max_shift_start_variance_minutes of this ShiftStartVariance.
        :rtype: int
        """
        return self._max_shift_start_variance_minutes

    @max_shift_start_variance_minutes.setter
    def max_shift_start_variance_minutes(self, max_shift_start_variance_minutes):
        """
        Sets the max_shift_start_variance_minutes of this ShiftStartVariance.
        Maximum variance in minutes across shift starts

        :param max_shift_start_variance_minutes: The max_shift_start_variance_minutes of this ShiftStartVariance.
        :type: int
        """
        
        if not max_shift_start_variance_minutes:
            raise ValueError("Invalid value for `max_shift_start_variance_minutes`, must not be `None`")


        self._max_shift_start_variance_minutes = max_shift_start_variance_minutes

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

