# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class ScimPhoneNumber(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ScimPhoneNumber - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'value': 'str',
            'type': 'str',
            'primary': 'bool'
        }

        self.attribute_map = {
            'value': 'value',
            'type': 'type',
            'primary': 'primary'
        }

        self._value = None
        self._type = None
        self._primary = None

    @property
    def value(self):
        """
        Gets the value of this ScimPhoneNumber.
        The phone number in E.164 or tel URI format, for example, tel:+nnnnnnnn; ext=xxxxx.

        :return: The value of this ScimPhoneNumber.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this ScimPhoneNumber.
        The phone number in E.164 or tel URI format, for example, tel:+nnnnnnnn; ext=xxxxx.

        :param value: The value of this ScimPhoneNumber.
        :type: str
        """
        

        self._value = value

    @property
    def type(self):
        """
        Gets the type of this ScimPhoneNumber.
        The type of phone number.

        :return: The type of this ScimPhoneNumber.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this ScimPhoneNumber.
        The type of phone number.

        :param type: The type of this ScimPhoneNumber.
        :type: str
        """
        allowed_values = ["work", "work2", "work3", "work4", "home", "mobile", "other", "microsoftteams", "zoomphone"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def primary(self):
        """
        Gets the primary of this ScimPhoneNumber.
        Indicates whether the phone number is the primary phone number.

        :return: The primary of this ScimPhoneNumber.
        :rtype: bool
        """
        return self._primary

    @primary.setter
    def primary(self, primary):
        """
        Sets the primary of this ScimPhoneNumber.
        Indicates whether the phone number is the primary phone number.

        :param primary: The primary of this ScimPhoneNumber.
        :type: bool
        """
        

        self._primary = primary

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

