# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class PatchCallbackRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        PatchCallbackRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'conversation_id': 'str',
            'queue_id': 'str',
            'agent_id': 'str',
            'callback_scheduled_time': 'datetime'
        }

        self.attribute_map = {
            'conversation_id': 'conversationId',
            'queue_id': 'queueId',
            'agent_id': 'agentId',
            'callback_scheduled_time': 'callbackScheduledTime'
        }

        self._conversation_id = None
        self._queue_id = None
        self._agent_id = None
        self._callback_scheduled_time = None

    @property
    def conversation_id(self):
        """
        Gets the conversation_id of this PatchCallbackRequest.
        The conversationId.

        :return: The conversation_id of this PatchCallbackRequest.
        :rtype: str
        """
        return self._conversation_id

    @conversation_id.setter
    def conversation_id(self, conversation_id):
        """
        Sets the conversation_id of this PatchCallbackRequest.
        The conversationId.

        :param conversation_id: The conversation_id of this PatchCallbackRequest.
        :type: str
        """
        
        if not conversation_id:
            raise ValueError("Invalid value for `conversation_id`, must not be `None`")


        self._conversation_id = conversation_id

    @property
    def queue_id(self):
        """
        Gets the queue_id of this PatchCallbackRequest.
        The identifier of the queue to be used for the callback.

        :return: The queue_id of this PatchCallbackRequest.
        :rtype: str
        """
        return self._queue_id

    @queue_id.setter
    def queue_id(self, queue_id):
        """
        Sets the queue_id of this PatchCallbackRequest.
        The identifier of the queue to be used for the callback.

        :param queue_id: The queue_id of this PatchCallbackRequest.
        :type: str
        """
        

        self._queue_id = queue_id

    @property
    def agent_id(self):
        """
        Gets the agent_id of this PatchCallbackRequest.
        The agentId.

        :return: The agent_id of this PatchCallbackRequest.
        :rtype: str
        """
        return self._agent_id

    @agent_id.setter
    def agent_id(self, agent_id):
        """
        Sets the agent_id of this PatchCallbackRequest.
        The agentId.

        :param agent_id: The agent_id of this PatchCallbackRequest.
        :type: str
        """
        
        if not agent_id:
            raise ValueError("Invalid value for `agent_id`, must not be `None`")


        self._agent_id = agent_id

    @property
    def callback_scheduled_time(self):
        """
        Gets the callback_scheduled_time of this PatchCallbackRequest.
        The scheduled date-time for the callback. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The callback_scheduled_time of this PatchCallbackRequest.
        :rtype: datetime
        """
        return self._callback_scheduled_time

    @callback_scheduled_time.setter
    def callback_scheduled_time(self, callback_scheduled_time):
        """
        Sets the callback_scheduled_time of this PatchCallbackRequest.
        The scheduled date-time for the callback. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param callback_scheduled_time: The callback_scheduled_time of this PatchCallbackRequest.
        :type: datetime
        """
        

        self._callback_scheduled_time = callback_scheduled_time

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

