# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class KnowledgeImport(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        KnowledgeImport - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'upload_key': 'str',
            'file_type': 'str',
            'ignore_headers': 'bool',
            'status': 'str',
            'report': 'ImportReport',
            'knowledge_base': 'KnowledgeBase',
            'language_code': 'str',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'upload_key': 'uploadKey',
            'file_type': 'fileType',
            'ignore_headers': 'ignoreHeaders',
            'status': 'status',
            'report': 'report',
            'knowledge_base': 'knowledgeBase',
            'language_code': 'languageCode',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._upload_key = None
        self._file_type = None
        self._ignore_headers = None
        self._status = None
        self._report = None
        self._knowledge_base = None
        self._language_code = None
        self._date_created = None
        self._date_modified = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this KnowledgeImport.
        Id of the import operation

        :return: The id of this KnowledgeImport.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this KnowledgeImport.
        Id of the import operation

        :param id: The id of this KnowledgeImport.
        :type: str
        """
        

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this KnowledgeImport.
        Name of the import operation

        :return: The name of this KnowledgeImport.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this KnowledgeImport.
        Name of the import operation

        :param name: The name of this KnowledgeImport.
        :type: str
        """
        

        self._name = name

    @property
    def upload_key(self):
        """
        Gets the upload_key of this KnowledgeImport.
        Upload key

        :return: The upload_key of this KnowledgeImport.
        :rtype: str
        """
        return self._upload_key

    @upload_key.setter
    def upload_key(self, upload_key):
        """
        Sets the upload_key of this KnowledgeImport.
        Upload key

        :param upload_key: The upload_key of this KnowledgeImport.
        :type: str
        """
        
        if not upload_key:
            raise ValueError("Invalid value for `upload_key`, must not be `None`")


        self._upload_key = upload_key

    @property
    def file_type(self):
        """
        Gets the file_type of this KnowledgeImport.
        file type of the document

        :return: The file_type of this KnowledgeImport.
        :rtype: str
        """
        return self._file_type

    @file_type.setter
    def file_type(self, file_type):
        """
        Sets the file_type of this KnowledgeImport.
        file type of the document

        :param file_type: The file_type of this KnowledgeImport.
        :type: str
        """
        allowed_values = ["Csv", "JsonLines", "Json"]
        if file_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for file_type -> " + file_type)
            self._file_type = "outdated_sdk_version"
        else:
            self._file_type = file_type

    @property
    def ignore_headers(self):
        """
        Gets the ignore_headers of this KnowledgeImport.
        Ignore headers for the specified file

        :return: The ignore_headers of this KnowledgeImport.
        :rtype: bool
        """
        return self._ignore_headers

    @ignore_headers.setter
    def ignore_headers(self, ignore_headers):
        """
        Sets the ignore_headers of this KnowledgeImport.
        Ignore headers for the specified file

        :param ignore_headers: The ignore_headers of this KnowledgeImport.
        :type: bool
        """
        

        self._ignore_headers = ignore_headers

    @property
    def status(self):
        """
        Gets the status of this KnowledgeImport.
        Status of the operation

        :return: The status of this KnowledgeImport.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this KnowledgeImport.
        Status of the operation

        :param status: The status of this KnowledgeImport.
        :type: str
        """
        allowed_values = ["Created", "ValidationInProgress", "ValidationCompleted", "ValidationFailed", "Started", "InProgress", "Completed", "PartialCompleted", "Failed"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def report(self):
        """
        Gets the report of this KnowledgeImport.
        Report of the import operation

        :return: The report of this KnowledgeImport.
        :rtype: ImportReport
        """
        return self._report

    @report.setter
    def report(self, report):
        """
        Sets the report of this KnowledgeImport.
        Report of the import operation

        :param report: The report of this KnowledgeImport.
        :type: ImportReport
        """
        

        self._report = report

    @property
    def knowledge_base(self):
        """
        Gets the knowledge_base of this KnowledgeImport.
        Knowledge base which document import does belong to

        :return: The knowledge_base of this KnowledgeImport.
        :rtype: KnowledgeBase
        """
        return self._knowledge_base

    @knowledge_base.setter
    def knowledge_base(self, knowledge_base):
        """
        Sets the knowledge_base of this KnowledgeImport.
        Knowledge base which document import does belong to

        :param knowledge_base: The knowledge_base of this KnowledgeImport.
        :type: KnowledgeBase
        """
        

        self._knowledge_base = knowledge_base

    @property
    def language_code(self):
        """
        Gets the language_code of this KnowledgeImport.
        Language code

        :return: The language_code of this KnowledgeImport.
        :rtype: str
        """
        return self._language_code

    @language_code.setter
    def language_code(self, language_code):
        """
        Sets the language_code of this KnowledgeImport.
        Language code

        :param language_code: The language_code of this KnowledgeImport.
        :type: str
        """
        allowed_values = ["en-US", "en-UK", "en-AU", "de-DE", "es-US", "es-ES", "fr-FR", "pt-BR", "nl-NL", "it-IT"]
        if language_code.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for language_code -> " + language_code)
            self._language_code = "outdated_sdk_version"
        else:
            self._language_code = language_code

    @property
    def date_created(self):
        """
        Gets the date_created of this KnowledgeImport.
        Created date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this KnowledgeImport.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created):
        """
        Sets the date_created of this KnowledgeImport.
        Created date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this KnowledgeImport.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def date_modified(self):
        """
        Gets the date_modified of this KnowledgeImport.
        Last modified date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this KnowledgeImport.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified):
        """
        Sets the date_modified of this KnowledgeImport.
        Last modified date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this KnowledgeImport.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def self_uri(self):
        """
        Gets the self_uri of this KnowledgeImport.
        The URI for this object

        :return: The self_uri of this KnowledgeImport.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this KnowledgeImport.
        The URI for this object

        :param self_uri: The self_uri of this KnowledgeImport.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

