# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class IntegrationExport(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        IntegrationExport - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'integration': 'DomainEntityRef',
            'should_export_screen_recordings': 'bool'
        }

        self.attribute_map = {
            'integration': 'integration',
            'should_export_screen_recordings': 'shouldExportScreenRecordings'
        }

        self._integration = None
        self._should_export_screen_recordings = None

    @property
    def integration(self):
        """
        Gets the integration of this IntegrationExport.
        The aws-s3-recording-bulk-actions-integration that the policy uses for exports.

        :return: The integration of this IntegrationExport.
        :rtype: DomainEntityRef
        """
        return self._integration

    @integration.setter
    def integration(self, integration):
        """
        Sets the integration of this IntegrationExport.
        The aws-s3-recording-bulk-actions-integration that the policy uses for exports.

        :param integration: The integration of this IntegrationExport.
        :type: DomainEntityRef
        """
        
        if not integration:
            raise ValueError("Invalid value for `integration`, must not be `None`")


        self._integration = integration

    @property
    def should_export_screen_recordings(self):
        """
        Gets the should_export_screen_recordings of this IntegrationExport.
        True if the policy should export screen recordings in addition to the other conversation media. Default = true

        :return: The should_export_screen_recordings of this IntegrationExport.
        :rtype: bool
        """
        return self._should_export_screen_recordings

    @should_export_screen_recordings.setter
    def should_export_screen_recordings(self, should_export_screen_recordings):
        """
        Sets the should_export_screen_recordings of this IntegrationExport.
        True if the policy should export screen recordings in addition to the other conversation media. Default = true

        :param should_export_screen_recordings: The should_export_screen_recordings of this IntegrationExport.
        :type: bool
        """
        

        self._should_export_screen_recordings = should_export_screen_recordings

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

