# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class EvaluationAggregationQueryMe(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        EvaluationAggregationQueryMe - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'interval': 'str',
            'time_zone': 'str',
            'group_by': 'list[str]',
            'metrics': 'list[str]',
            'alternate_time_dimension': 'str',
            'context_id': 'str'
        }

        self.attribute_map = {
            'interval': 'interval',
            'time_zone': 'timeZone',
            'group_by': 'groupBy',
            'metrics': 'metrics',
            'alternate_time_dimension': 'alternateTimeDimension',
            'context_id': 'contextId'
        }

        self._interval = None
        self._time_zone = None
        self._group_by = None
        self._metrics = None
        self._alternate_time_dimension = None
        self._context_id = None

    @property
    def interval(self):
        """
        Gets the interval of this EvaluationAggregationQueryMe.
        Behaves like one clause in a SQL WHERE. Specifies the date and time range of data being queried. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss

        :return: The interval of this EvaluationAggregationQueryMe.
        :rtype: str
        """
        return self._interval

    @interval.setter
    def interval(self, interval):
        """
        Sets the interval of this EvaluationAggregationQueryMe.
        Behaves like one clause in a SQL WHERE. Specifies the date and time range of data being queried. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss

        :param interval: The interval of this EvaluationAggregationQueryMe.
        :type: str
        """
        
        if not interval:
            raise ValueError("Invalid value for `interval`, must not be `None`")


        self._interval = interval

    @property
    def time_zone(self):
        """
        Gets the time_zone of this EvaluationAggregationQueryMe.
        Time zone context used to calculate response intervals (this allows resolving DST changes). The interval offset is used even when timeZone is specified. Default is UTC. Time zones are represented as a string of the zone name as found in the IANA time zone database. For example: UTC, Etc/UTC, or Europe/London

        :return: The time_zone of this EvaluationAggregationQueryMe.
        :rtype: str
        """
        return self._time_zone

    @time_zone.setter
    def time_zone(self, time_zone):
        """
        Sets the time_zone of this EvaluationAggregationQueryMe.
        Time zone context used to calculate response intervals (this allows resolving DST changes). The interval offset is used even when timeZone is specified. Default is UTC. Time zones are represented as a string of the zone name as found in the IANA time zone database. For example: UTC, Etc/UTC, or Europe/London

        :param time_zone: The time_zone of this EvaluationAggregationQueryMe.
        :type: str
        """
        

        self._time_zone = time_zone

    @property
    def group_by(self):
        """
        Gets the group_by of this EvaluationAggregationQueryMe.
        Behaves like a SQL GROUPBY. Allows for multiple levels of grouping as a list of dimensions. Partitions resulting aggregate computations into distinct named subgroups rather than across the entire result set as if it were one group.

        :return: The group_by of this EvaluationAggregationQueryMe.
        :rtype: list[str]
        """
        return self._group_by

    @group_by.setter
    def group_by(self, group_by):
        """
        Sets the group_by of this EvaluationAggregationQueryMe.
        Behaves like a SQL GROUPBY. Allows for multiple levels of grouping as a list of dimensions. Partitions resulting aggregate computations into distinct named subgroups rather than across the entire result set as if it were one group.

        :param group_by: The group_by of this EvaluationAggregationQueryMe.
        :type: list[str]
        """
        

        self._group_by = group_by

    @property
    def metrics(self):
        """
        Gets the metrics of this EvaluationAggregationQueryMe.
        Behaves like a SQL SELECT clause. Only named metrics will be retrieved.

        :return: The metrics of this EvaluationAggregationQueryMe.
        :rtype: list[str]
        """
        return self._metrics

    @metrics.setter
    def metrics(self, metrics):
        """
        Sets the metrics of this EvaluationAggregationQueryMe.
        Behaves like a SQL SELECT clause. Only named metrics will be retrieved.

        :param metrics: The metrics of this EvaluationAggregationQueryMe.
        :type: list[str]
        """
        
        if not metrics:
            raise ValueError("Invalid value for `metrics`, must not be `None`")


        self._metrics = metrics

    @property
    def alternate_time_dimension(self):
        """
        Gets the alternate_time_dimension of this EvaluationAggregationQueryMe.
        Dimension to use as the alternative timestamp for data in the aggregate.  Choosing \"eventTime\" uses the actual time of the data event.

        :return: The alternate_time_dimension of this EvaluationAggregationQueryMe.
        :rtype: str
        """
        return self._alternate_time_dimension

    @alternate_time_dimension.setter
    def alternate_time_dimension(self, alternate_time_dimension):
        """
        Sets the alternate_time_dimension of this EvaluationAggregationQueryMe.
        Dimension to use as the alternative timestamp for data in the aggregate.  Choosing \"eventTime\" uses the actual time of the data event.

        :param alternate_time_dimension: The alternate_time_dimension of this EvaluationAggregationQueryMe.
        :type: str
        """
        allowed_values = ["conversationStart", "evaluationCreatedDate", "evaluationReleaseDate", "eventTime"]
        if alternate_time_dimension.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for alternate_time_dimension -> " + alternate_time_dimension)
            self._alternate_time_dimension = "outdated_sdk_version"
        else:
            self._alternate_time_dimension = alternate_time_dimension

    @property
    def context_id(self):
        """
        Gets the context_id of this EvaluationAggregationQueryMe.
        Evaluation context Id

        :return: The context_id of this EvaluationAggregationQueryMe.
        :rtype: str
        """
        return self._context_id

    @context_id.setter
    def context_id(self, context_id):
        """
        Sets the context_id of this EvaluationAggregationQueryMe.
        Evaluation context Id

        :param context_id: The context_id of this EvaluationAggregationQueryMe.
        :type: str
        """
        

        self._context_id = context_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

