# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class DraftTopics(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        DraftTopics - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'miner': 'Miner',
            'conversation_count': 'int',
            'conversation_percent': 'float',
            'utterance_count': 'int',
            'phrase_count': 'int',
            'phrases': 'list[str]',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'miner': 'miner',
            'conversation_count': 'conversationCount',
            'conversation_percent': 'conversationPercent',
            'utterance_count': 'utteranceCount',
            'phrase_count': 'phraseCount',
            'phrases': 'phrases',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._miner = None
        self._conversation_count = None
        self._conversation_percent = None
        self._utterance_count = None
        self._phrase_count = None
        self._phrases = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this DraftTopics.
        Id for a topic.

        :return: The id of this DraftTopics.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this DraftTopics.
        Id for a topic.

        :param id: The id of this DraftTopics.
        :type: str
        """
        
        if not id:
            raise ValueError("Invalid value for `id`, must not be `None`")


        self._id = id

    @property
    def name(self):
        """
        Gets the name of this DraftTopics.
        Topic name.

        :return: The name of this DraftTopics.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this DraftTopics.
        Topic name.

        :param name: The name of this DraftTopics.
        :type: str
        """
        

        self._name = name

    @property
    def miner(self):
        """
        Gets the miner of this DraftTopics.
        The miner to which the topic belongs.

        :return: The miner of this DraftTopics.
        :rtype: Miner
        """
        return self._miner

    @miner.setter
    def miner(self, miner):
        """
        Sets the miner of this DraftTopics.
        The miner to which the topic belongs.

        :param miner: The miner of this DraftTopics.
        :type: Miner
        """
        

        self._miner = miner

    @property
    def conversation_count(self):
        """
        Gets the conversation_count of this DraftTopics.
        Number of conversations where a topic has occurred.

        :return: The conversation_count of this DraftTopics.
        :rtype: int
        """
        return self._conversation_count

    @conversation_count.setter
    def conversation_count(self, conversation_count):
        """
        Sets the conversation_count of this DraftTopics.
        Number of conversations where a topic has occurred.

        :param conversation_count: The conversation_count of this DraftTopics.
        :type: int
        """
        

        self._conversation_count = conversation_count

    @property
    def conversation_percent(self):
        """
        Gets the conversation_percent of this DraftTopics.
        Percentage of conversations where a topic has occurred.

        :return: The conversation_percent of this DraftTopics.
        :rtype: float
        """
        return self._conversation_percent

    @conversation_percent.setter
    def conversation_percent(self, conversation_percent):
        """
        Sets the conversation_percent of this DraftTopics.
        Percentage of conversations where a topic has occurred.

        :param conversation_percent: The conversation_percent of this DraftTopics.
        :type: float
        """
        

        self._conversation_percent = conversation_percent

    @property
    def utterance_count(self):
        """
        Gets the utterance_count of this DraftTopics.
        Number of unique utterances where a topic has occurred.

        :return: The utterance_count of this DraftTopics.
        :rtype: int
        """
        return self._utterance_count

    @utterance_count.setter
    def utterance_count(self, utterance_count):
        """
        Sets the utterance_count of this DraftTopics.
        Number of unique utterances where a topic has occurred.

        :param utterance_count: The utterance_count of this DraftTopics.
        :type: int
        """
        

        self._utterance_count = utterance_count

    @property
    def phrase_count(self):
        """
        Gets the phrase_count of this DraftTopics.
        Number of unique phrases (sub-utterances) where a topic has occurred.

        :return: The phrase_count of this DraftTopics.
        :rtype: int
        """
        return self._phrase_count

    @phrase_count.setter
    def phrase_count(self, phrase_count):
        """
        Sets the phrase_count of this DraftTopics.
        Number of unique phrases (sub-utterances) where a topic has occurred.

        :param phrase_count: The phrase_count of this DraftTopics.
        :type: int
        """
        

        self._phrase_count = phrase_count

    @property
    def phrases(self):
        """
        Gets the phrases of this DraftTopics.
        The phrases that are extracted for a topic.

        :return: The phrases of this DraftTopics.
        :rtype: list[str]
        """
        return self._phrases

    @phrases.setter
    def phrases(self, phrases):
        """
        Sets the phrases of this DraftTopics.
        The phrases that are extracted for a topic.

        :param phrases: The phrases of this DraftTopics.
        :type: list[str]
        """
        
        if not phrases:
            raise ValueError("Invalid value for `phrases`, must not be `None`")


        self._phrases = phrases

    @property
    def self_uri(self):
        """
        Gets the self_uri of this DraftTopics.
        The URI for this object

        :return: The self_uri of this DraftTopics.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this DraftTopics.
        The URI for this object

        :param self_uri: The self_uri of this DraftTopics.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

