# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class CreateSecureSession(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        CreateSecureSession - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'source_participant_id': 'str',
            'flow_id': 'str',
            'user_data': 'str',
            'disconnect': 'bool'
        }

        self.attribute_map = {
            'source_participant_id': 'sourceParticipantId',
            'flow_id': 'flowId',
            'user_data': 'userData',
            'disconnect': 'disconnect'
        }

        self._source_participant_id = None
        self._flow_id = None
        self._user_data = None
        self._disconnect = None

    @property
    def source_participant_id(self):
        """
        Gets the source_participant_id of this CreateSecureSession.
        requesting participant

        :return: The source_participant_id of this CreateSecureSession.
        :rtype: str
        """
        return self._source_participant_id

    @source_participant_id.setter
    def source_participant_id(self, source_participant_id):
        """
        Sets the source_participant_id of this CreateSecureSession.
        requesting participant

        :param source_participant_id: The source_participant_id of this CreateSecureSession.
        :type: str
        """
        

        self._source_participant_id = source_participant_id

    @property
    def flow_id(self):
        """
        Gets the flow_id of this CreateSecureSession.
        the flow id to execute in the secure session

        :return: The flow_id of this CreateSecureSession.
        :rtype: str
        """
        return self._flow_id

    @flow_id.setter
    def flow_id(self, flow_id):
        """
        Sets the flow_id of this CreateSecureSession.
        the flow id to execute in the secure session

        :param flow_id: The flow_id of this CreateSecureSession.
        :type: str
        """
        
        if not flow_id:
            raise ValueError("Invalid value for `flow_id`, must not be `None`")


        self._flow_id = flow_id

    @property
    def user_data(self):
        """
        Gets the user_data of this CreateSecureSession.
        user data for the secure session

        :return: The user_data of this CreateSecureSession.
        :rtype: str
        """
        return self._user_data

    @user_data.setter
    def user_data(self, user_data):
        """
        Sets the user_data of this CreateSecureSession.
        user data for the secure session

        :param user_data: The user_data of this CreateSecureSession.
        :type: str
        """
        
        if not user_data:
            raise ValueError("Invalid value for `user_data`, must not be `None`")


        self._user_data = user_data

    @property
    def disconnect(self):
        """
        Gets the disconnect of this CreateSecureSession.
        if true, disconnect the agent after creating the session

        :return: The disconnect of this CreateSecureSession.
        :rtype: bool
        """
        return self._disconnect

    @disconnect.setter
    def disconnect(self, disconnect):
        """
        Sets the disconnect of this CreateSecureSession.
        if true, disconnect the agent after creating the session

        :param disconnect: The disconnect of this CreateSecureSession.
        :type: bool
        """
        

        self._disconnect = disconnect

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

