# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class BulkErrorNote(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        BulkErrorNote - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'code': 'str',
            'message': 'str',
            'status': 'int',
            'retryable': 'bool',
            'entity': 'Note',
            'details': 'list[BulkErrorDetail]'
        }

        self.attribute_map = {
            'code': 'code',
            'message': 'message',
            'status': 'status',
            'retryable': 'retryable',
            'entity': 'entity',
            'details': 'details'
        }

        self._code = None
        self._message = None
        self._status = None
        self._retryable = None
        self._entity = None
        self._details = None

    @property
    def code(self):
        """
        Gets the code of this BulkErrorNote.


        :return: The code of this BulkErrorNote.
        :rtype: str
        """
        return self._code

    @code.setter
    def code(self, code):
        """
        Sets the code of this BulkErrorNote.


        :param code: The code of this BulkErrorNote.
        :type: str
        """
        

        self._code = code

    @property
    def message(self):
        """
        Gets the message of this BulkErrorNote.


        :return: The message of this BulkErrorNote.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """
        Sets the message of this BulkErrorNote.


        :param message: The message of this BulkErrorNote.
        :type: str
        """
        

        self._message = message

    @property
    def status(self):
        """
        Gets the status of this BulkErrorNote.


        :return: The status of this BulkErrorNote.
        :rtype: int
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this BulkErrorNote.


        :param status: The status of this BulkErrorNote.
        :type: int
        """
        

        self._status = status

    @property
    def retryable(self):
        """
        Gets the retryable of this BulkErrorNote.


        :return: The retryable of this BulkErrorNote.
        :rtype: bool
        """
        return self._retryable

    @retryable.setter
    def retryable(self, retryable):
        """
        Sets the retryable of this BulkErrorNote.


        :param retryable: The retryable of this BulkErrorNote.
        :type: bool
        """
        

        self._retryable = retryable

    @property
    def entity(self):
        """
        Gets the entity of this BulkErrorNote.


        :return: The entity of this BulkErrorNote.
        :rtype: Note
        """
        return self._entity

    @entity.setter
    def entity(self, entity):
        """
        Sets the entity of this BulkErrorNote.


        :param entity: The entity of this BulkErrorNote.
        :type: Note
        """
        

        self._entity = entity

    @property
    def details(self):
        """
        Gets the details of this BulkErrorNote.


        :return: The details of this BulkErrorNote.
        :rtype: list[BulkErrorDetail]
        """
        return self._details

    @details.setter
    def details(self, details):
        """
        Sets the details of this BulkErrorNote.


        :param details: The details of this BulkErrorNote.
        :type: list[BulkErrorDetail]
        """
        

        self._details = details

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

