# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class BuPlanningGroupHeadcountForecast(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        BuPlanningGroupHeadcountForecast - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'planning_group': 'PlanningGroupReference',
            'required_per_interval': 'list[float]',
            'required_without_shrinkage_per_interval': 'list[float]'
        }

        self.attribute_map = {
            'planning_group': 'planningGroup',
            'required_per_interval': 'requiredPerInterval',
            'required_without_shrinkage_per_interval': 'requiredWithoutShrinkagePerInterval'
        }

        self._planning_group = None
        self._required_per_interval = None
        self._required_without_shrinkage_per_interval = None

    @property
    def planning_group(self):
        """
        Gets the planning_group of this BuPlanningGroupHeadcountForecast.
        The planning group to which this portion of the headcount forecast applies

        :return: The planning_group of this BuPlanningGroupHeadcountForecast.
        :rtype: PlanningGroupReference
        """
        return self._planning_group

    @planning_group.setter
    def planning_group(self, planning_group):
        """
        Sets the planning_group of this BuPlanningGroupHeadcountForecast.
        The planning group to which this portion of the headcount forecast applies

        :param planning_group: The planning_group of this BuPlanningGroupHeadcountForecast.
        :type: PlanningGroupReference
        """
        

        self._planning_group = planning_group

    @property
    def required_per_interval(self):
        """
        Gets the required_per_interval of this BuPlanningGroupHeadcountForecast.
        Required headcount per interval, referenced against the reference start date

        :return: The required_per_interval of this BuPlanningGroupHeadcountForecast.
        :rtype: list[float]
        """
        return self._required_per_interval

    @required_per_interval.setter
    def required_per_interval(self, required_per_interval):
        """
        Sets the required_per_interval of this BuPlanningGroupHeadcountForecast.
        Required headcount per interval, referenced against the reference start date

        :param required_per_interval: The required_per_interval of this BuPlanningGroupHeadcountForecast.
        :type: list[float]
        """
        

        self._required_per_interval = required_per_interval

    @property
    def required_without_shrinkage_per_interval(self):
        """
        Gets the required_without_shrinkage_per_interval of this BuPlanningGroupHeadcountForecast.
        Required headcount per interval without accounting for shrinkage, referenced against the reference start date

        :return: The required_without_shrinkage_per_interval of this BuPlanningGroupHeadcountForecast.
        :rtype: list[float]
        """
        return self._required_without_shrinkage_per_interval

    @required_without_shrinkage_per_interval.setter
    def required_without_shrinkage_per_interval(self, required_without_shrinkage_per_interval):
        """
        Sets the required_without_shrinkage_per_interval of this BuPlanningGroupHeadcountForecast.
        Required headcount per interval without accounting for shrinkage, referenced against the reference start date

        :param required_without_shrinkage_per_interval: The required_without_shrinkage_per_interval of this BuPlanningGroupHeadcountForecast.
        :type: list[float]
        """
        

        self._required_without_shrinkage_per_interval = required_without_shrinkage_per_interval

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

