# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class AssessmentForm(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        AssessmentForm - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'date_modified': 'datetime',
            'context_id': 'str',
            'self_uri': 'str',
            'published': 'bool',
            'pass_percent': 'int',
            'question_groups': 'list[AssessmentFormQuestionGroup]'
        }

        self.attribute_map = {
            'id': 'id',
            'date_modified': 'dateModified',
            'context_id': 'contextId',
            'self_uri': 'selfUri',
            'published': 'published',
            'pass_percent': 'passPercent',
            'question_groups': 'questionGroups'
        }

        self._id = None
        self._date_modified = None
        self._context_id = None
        self._self_uri = None
        self._published = None
        self._pass_percent = None
        self._question_groups = None

    @property
    def id(self):
        """
        Gets the id of this AssessmentForm.
        The globally unique identifier for the object.

        :return: The id of this AssessmentForm.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this AssessmentForm.
        The globally unique identifier for the object.

        :param id: The id of this AssessmentForm.
        :type: str
        """
        

        self._id = id

    @property
    def date_modified(self):
        """
        Gets the date_modified of this AssessmentForm.
        Last modified date of the assessment form. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this AssessmentForm.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified):
        """
        Sets the date_modified of this AssessmentForm.
        Last modified date of the assessment form. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this AssessmentForm.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def context_id(self):
        """
        Gets the context_id of this AssessmentForm.
        The unique Id for all versions of this assessment form

        :return: The context_id of this AssessmentForm.
        :rtype: str
        """
        return self._context_id

    @context_id.setter
    def context_id(self, context_id):
        """
        Sets the context_id of this AssessmentForm.
        The unique Id for all versions of this assessment form

        :param context_id: The context_id of this AssessmentForm.
        :type: str
        """
        

        self._context_id = context_id

    @property
    def self_uri(self):
        """
        Gets the self_uri of this AssessmentForm.
        The URI for this object

        :return: The self_uri of this AssessmentForm.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this AssessmentForm.
        The URI for this object

        :param self_uri: The self_uri of this AssessmentForm.
        :type: str
        """
        

        self._self_uri = self_uri

    @property
    def published(self):
        """
        Gets the published of this AssessmentForm.
        If true, assessment form is published

        :return: The published of this AssessmentForm.
        :rtype: bool
        """
        return self._published

    @published.setter
    def published(self, published):
        """
        Sets the published of this AssessmentForm.
        If true, assessment form is published

        :param published: The published of this AssessmentForm.
        :type: bool
        """
        

        self._published = published

    @property
    def pass_percent(self):
        """
        Gets the pass_percent of this AssessmentForm.
        The pass percent for the assessment form

        :return: The pass_percent of this AssessmentForm.
        :rtype: int
        """
        return self._pass_percent

    @pass_percent.setter
    def pass_percent(self, pass_percent):
        """
        Sets the pass_percent of this AssessmentForm.
        The pass percent for the assessment form

        :param pass_percent: The pass_percent of this AssessmentForm.
        :type: int
        """
        
        if not pass_percent:
            raise ValueError("Invalid value for `pass_percent`, must not be `None`")


        self._pass_percent = pass_percent

    @property
    def question_groups(self):
        """
        Gets the question_groups of this AssessmentForm.
        A list of question groups

        :return: The question_groups of this AssessmentForm.
        :rtype: list[AssessmentFormQuestionGroup]
        """
        return self._question_groups

    @question_groups.setter
    def question_groups(self, question_groups):
        """
        Sets the question_groups of this AssessmentForm.
        A list of question groups

        :param question_groups: The question_groups of this AssessmentForm.
        :type: list[AssessmentFormQuestionGroup]
        """
        
        if not question_groups:
            raise ValueError("Invalid value for `question_groups`, must not be `None`")


        self._question_groups = question_groups

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

