# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['cli2gui', 'cli2gui.application', 'cli2gui.tojson']

package_data = \
{'': ['*']}

install_requires = \
['Pillow>=7.1.1,<8.0.0',
 'PySimpleGui>=4.18.2,<5.0.0',
 'PyYaml>=5.3.1,<6.0.0',
 'art>=4.6,<5.0',
 'emoji>=0.5.4,<0.6.0',
 'getostheme>=2020.2,<2021.0',
 'pypandoc>=1.5,<2.0']

setup_kwargs = {
    'name': 'cli2gui',
    'version': '2020.7.1',
    'description': 'Use this module to convert a cli program to a gui',
    'long_description': '[![Github top language](https://img.shields.io/github/languages/top/FHPythonUtils/Cli2Gui.svg?style=for-the-badge)](../../)\n[![Codacy grade](https://img.shields.io/codacy/grade/6a1ebf45daa347c8a2ed26281e6370db.svg?style=for-the-badge)](https://www.codacy.com/manual/FHPythonUtils/Cli2Gui)\n[![Repository size](https://img.shields.io/github/repo-size/FHPythonUtils/Cli2Gui.svg?style=for-the-badge)](../../)\n[![Issues](https://img.shields.io/github/issues/FHPythonUtils/Cli2Gui.svg?style=for-the-badge)](../../issues)\n[![License](https://img.shields.io/github/license/FHPythonUtils/Cli2Gui.svg?style=for-the-badge)](/LICENSE.md)\n[![Commit activity](https://img.shields.io/github/commit-activity/m/FHPythonUtils/Cli2Gui.svg?style=for-the-badge)](../../commits/master)\n[![Last commit](https://img.shields.io/github/last-commit/FHPythonUtils/Cli2Gui.svg?style=for-the-badge)](../../commits/master)\n[![PyPI Downloads](https://img.shields.io/pypi/dm/cli2gui.svg?style=for-the-badge)](https://pypi.org/project/cli2gui/)\n[![PyPI Version](https://img.shields.io/pypi/v/cli2gui.svg?style=for-the-badge)](https://pypi.org/project/cli2gui/)\n\n<!-- omit in toc -->\n# Cli2Gui\n\n<img src="readme-assets/icons/name.png" alt="Project Icon" width="750">\n\nUse this module to convert a CLI program to a GUI\n\n- [Comparison to similar projects](#comparison-to-similar-projects)\n\t- [Parser Support](#parser-support)\n\t- [GUI Toolkit Support](#gui-toolkit-support)\n\t- [GUI Feature Support](#gui-feature-support)\n- [Roadmap](#roadmap)\n- [Changelog](#changelog)\n- [Decorator](#decorator)\n- [Using the decorator in your project](#using-the-decorator-in-your-project)\n\t- [run_function (optional)](#runfunction-optional)\n\t- [auto_enable (optional)](#autoenable-optional)\n\t- [parser (optional)](#parser-optional)\n\t- [gui (optional)](#gui-optional)\n\t- [theme (optional)](#theme-optional)\n\t- [darkTheme (optional)](#darktheme-optional)\n\t- [sizes (optional)](#sizes-optional)\n\t- [image (optional)](#image-optional)\n\t- [program_name (optional)](#programname-optional)\n\t- [program_description (optional)](#programdescription-optional)\n\t- [max_args_shown (optional)](#maxargsshown-optional)\n\t- [menu (optional)](#menu-optional)\n- [Click](#click)\n\t- [run_function (required)](#runfunction-required)\n\t- [parser (not applicable)](#parser-not-applicable)\n- [Data Structures](#data-structures)\n- [Install With PIP](#install-with-pip)\n- [Language information](#language-information)\n\t- [Built for](#built-for)\n- [Install Python on Windows](#install-python-on-windows)\n\t- [Chocolatey](#chocolatey)\n\t- [Download](#download)\n- [Install Python on Linux](#install-python-on-linux)\n\t- [Apt](#apt)\n- [How to run](#how-to-run)\n\t- [With VSCode](#with-vscode)\n\t- [From the Terminal](#from-the-terminal)\n- [How to update, build and publish](#how-to-update-build-and-publish)\n- [Download](#download-1)\n\t- [Clone](#clone)\n\t\t- [Using The Command Line](#using-the-command-line)\n\t\t- [Using GitHub Desktop](#using-github-desktop)\n\t- [Download Zip File](#download-zip-file)\n- [Licence](#licence)\n- [Screenshots](#screenshots)\n\t- [Desktop](#desktop)\n\t- [Themes](#themes)\n\n## Comparison to similar projects\nDo let me know if any of these are incorrect. Some of the comparisons are\nbased off documentation/ the readme\n\n### Parser Support\n|Parser|Cli2Gui|Gooey|Quick|\n|---|---|---|---|\n|Argparse|:heavy_check_mark:|:heavy_check_mark:|:x:|\n|Optparse|:heavy_check_mark:|:x:|:x:|\n|DocOpt|:heavy_check_mark:|:x:|:x:|\n|Click|:heavy_check_mark: * |:x:|:heavy_check_mark:|\n|GetOpt|:heavy_check_mark:|:x:|:x:|\n\n```none\n* Partial support (use Click2Gui)\n\nThis works for simpler programs but sadly falls flat for more complex programs\n```\n\n### GUI Toolkit Support\n|GUI Toolkits|Cli2Gui|Gooey|Quick|\n|---|---|---|---|\n|Tkinter|:heavy_check_mark:|:x:|:x:|\n|WxWidgets|:x:|:heavy_check_mark:|:x:|\n|Qt|:heavy_check_mark:|:x:|:heavy_check_mark:|\n|Gtk|:x:|:x:|:x:|\n|Web|:heavy_check_mark:|:x:|:x:|\n\n\n### GUI Feature Support\n|Basic GUI|Cli2Gui|Gooey|Quick|\n|---|---|---|---|\n|Override name/ description|:heavy_check_mark:|:heavy_check_mark:|:x:|\n|Theming|:heavy_check_mark:|:warning: Limited|:warning: Limited|\n|DarkMode|:heavy_check_mark:|:x:|:heavy_check_mark:|\n|Window Size|:heavy_check_mark:|:heavy_check_mark:|:x:|\n|Element Size|:heavy_check_mark:|:x:|:x:|\n|Custom Images|:heavy_check_mark:|:heavy_check_mark:|:x:|\n\nCli2Gui is pretty lacking in these features and will probably remain that way\nto ease maintainability - the primary aim is to support multiple argparse\nlibraries over fancy widgets\n\n|Advanced GUI|Cli2Gui|Gooey|Quick|\n|---|---|---|---|\n|Dropdown|:heavy_check_mark:|:heavy_check_mark:|:heavy_check_mark:|\n|Slider|:x:|:heavy_check_mark:|:heavy_check_mark:|\n|Tabs|:x:|:heavy_check_mark:|:heavy_check_mark:|\n|Menus|:heavy_check_mark:|:heavy_check_mark:|:x:|\n|Max Args before Scroll|:heavy_check_mark:|:x:|:x:|\n\n## Roadmap\nFor completed components, see the changelog (link below)\n\n|Feature|Description|Status|\n|---|---|---|\n|Python Fire|https://github.com/google/python-fire|Under consideration|\n\n\n## Changelog\nSee the [CHANGELOG](/CHANGELOG.md) for more information.\n\n\n## Decorator\n```python\n@Cli2Gui(run_function, auto_enable=False, parser="argparse", gui="pysimplegui",\n\t\ttheme=None, darkTheme=None, sizes=None, image=None, program_name=None,\n\t\tprogram_description=None, max_args_shown=5, **kwargs)\n```\n## Using the decorator in your project\n### run_function (optional)\nThe name of the function to call eg. main(args). Defaults to None. If not\nspecified, program continues as normal (can only run once)\n\n```python\ndef main(args):\n\tprint(args.arg)\n\n@Cli2Gui(run_function=main)\ndef cli():\n\tparser = argparse.ArgumentParser(description="this is an example parser")\n\tparser.add_argument("arg", type=str,\n\t\thelp="positional arg")\n\targs = parser.parse_args()\n\tmain(args)\n```\n\n### auto_enable (optional)\nEnable the GUI by default. If enabled by default requires `--disable-cli2gui`, otherwise requires `--cli2gui`\n\n```python\n@Cli2Gui(auto_enable=False)\n```\n\n### parser (optional)\nOverride the parser to use, defaults to argparse. Current options are:\n"argparse", "getopt", "optparse", "docopt"\n\n```python\n@Cli2Gui(parser="argparse")\n```\n\n### gui (optional)\nOverride the gui to use. Current options are:\n"pysimplegui", "pysimpleguiqt","pysimpleguiweb". Defaults to "pysimplegui".\n\npysimplegui is the recommended option\n\n```python\n@Cli2Gui(gui="pysimplegui")\n```\n\n### theme (optional)\nSet a base24 theme. Can also pass a base24 scheme file. eg. `one-light.yaml`\n\n```python\n@Cli2Gui(theme=["#e7e7e9", "#dfdfe1", "#cacace", "#a0a1a7", "#696c77",\n\t\t"#383a42", "#202227", "#090a0b", "#ca1243", "#c18401", "#febb2a",\n\t\t"#50a14f", "#0184bc", "#4078f2", "#a626a4", "#986801", "#f0f0f1",\n\t\t"#fafafa", "#ec2258", "#f4a701", "#6db76c", "#01a7ef", "#709af5",\n\t\t"#d02fcd"])\n```\n\n### darkTheme (optional)\nSet a base24 dark theme variant. Can also pass a base24 scheme file. eg.\n`one-dark.yaml`\n\n```python\n@Cli2Gui(darkTheme=["#282c34", "#3f4451", "#4f5666", "#545862", "#9196a1",\n\t\t"#abb2bf", "#e6e6e6", "#ffffff", "#e06c75", "#d19a66", "#e5c07b",\n\t\t"#98c379", "#56b6c2", "#61afef", "#c678dd", "#be5046", "#21252b",\n\t\t"#181a1f", "#ff7b86", "#efb074", "#b1e18b", "#63d4e0", "#67cdff",\n\t\t"#e48bff"])\n```\n\n### sizes (optional)\nSet the UI sizes such as the button size\n\n```python\n@Cli2Gui(sizes={\n\t\t"title_size": 28,\n\t\t"label_size": (30, None),\n\t\t"input_size": (30, 1),\n\t\t"button":(10, 1),\n\t\t"padding":(5, 10),\n\t\t"helpText_size": 14,\n\t\t"text_size": 11})\n```\n### image (optional)\nSet the program icon. File extensions can be any that PIL supports\n\n```python\n@Cli2Gui(image="path/to/image.png")\n```\n\n### program_name (optional)\nOverride the program name\n\n```python\n@Cli2Gui(program_name="custom name")\n```\n\n### program_description (optional)\nOverride the program description\n\n```python\n@Cli2Gui(program_description="this is a custom description")\n```\n\n### max_args_shown (optional)\nMaximum number of args shown before using a scrollbar\n\n```python\n@Cli2Gui(max_args_shown=5)\n```\n\n### menu (optional)\nAdd a menu to the program. Defaults to None. eg.\n```python\nTHIS_DIR = str(Path(__file__).resolve().parent)\nmenu={"File": THIS_DIR + "/file.md"}\n```\n\nWorks significantly better with pysimplegui than pysimpleguiqt\n\n```python\n@Cli2Gui(menu={"File": THIS_DIR + "/file.md", "Another File": THIS_DIR + "/another_file.md", })\n```\n\n## Click\n```python\ndef Click2Gui(run_function, gui="pysimplegui", theme=None, darkTheme=None,\n\t\tsizes=None, image=None, program_name=None, program_description=None,\n\t\tmax_args_shown=5, menu=None, **kwargs):\n```\n\nVery similar to the decorator but with the following differences...\n\n### run_function (required)\nSpecify the click function to use. (attempts were made to offer full program\nsupport however this behaved very poorly)\n\n### parser (not applicable)\nAs this is exclusively for click, this option is not present\n\n\n## Data Structures\nSee the [DATA_STRUCTURES](/DATA_STRUCTURES.md) for more information.\n\n\n## Install With PIP\n\n```python\npip install cli2gui\n```\n\nHead to https://pypi.org/project/cli2gui/ for more info\n\n\n## Language information\n### Built for\nThis program has been written for Python 3 and has been tested with\nPython version 3.8.0 <https://www.python.org/downloads/release/python-380/>.\n\n## Install Python on Windows\n### Chocolatey\n```powershell\nchoco install python\n```\n### Download\nTo install Python, go to <https://www.python.org/> and download the latest\nversion.\n\n## Install Python on Linux\n### Apt\n```bash\nsudo apt install python3.8\n```\n\n## How to run\n### With VSCode\n1. Open the .py file in vscode\n2. Ensure a python 3.8 interpreter is selected (Ctrl+Shift+P > Python:Select\nInterpreter > Python 3.8)\n3. Run by pressing Ctrl+F5 (if you are prompted to install any modules, accept)\n### From the Terminal\n```bash\n./[file].py\n```\n\n## How to update, build and publish\n\n1. Ensure you have installed the following dependencies\n\tLinux\n\t```bash\n\twget dephell.org/install | python3.8\n\twget https://raw.githubusercontent.com/python-poetry/poetry/master/get-poetry.py | python3.8\n\t```\n\tWindows\n\t```powershell\n\t(wget dephell.org/install -UseBasicParsing).Content | python\n\t(wget https://raw.githubusercontent.com/python-poetry/poetry/master/get-poetry.py -UseBasicParsing).Content | python\n\t```\n2. Use poetry for the heavy lifting and dephell to generate requirements\n\t```bash\n\tpoetry update\n\tdephell deps convert\n\t```\n3. Build/ Publish\n\t```bash\n\tpoetry build\n\tpoetry publish\n\t```\n\tor\n\t```bash\n\tpoetry publish --build\n\t```\n\n## Download\n### Clone\n#### Using The Command Line\n1. Press the Clone or download button in the top right\n2. Copy the URL (link)\n3. Open the command line and change directory to where you wish to\nclone to\n4. Type \'git clone\' followed by URL in step 2\n```bash\n$ git clone https://github.com/FHPythonUtils/Cli2Gui\n```\n\nMore information can be found at\n<https://help.github.com/en/articles/cloning-a-repository>\n\n#### Using GitHub Desktop\n1. Press the Clone or download button in the top right\n2. Click open in desktop\n3. Choose the path for where you want and click Clone\n\nMore information can be found at\n<https://help.github.com/en/desktop/contributing-to-projects/cloning-a-repository-from-github-to-github-desktop>\n\n### Download Zip File\n\n1. Download this GitHub repository\n2. Extract the zip archive\n3. Copy/ move to the desired location\n\n## Licence\nMIT License\n(See the [LICENSE](/LICENSE.md) for more information.)\n\n## Screenshots\n\n### Desktop\n<div>\n<img src="readme-assets/screenshots/desktop/screenshot-0.png" alt="Screenshot 1" width="600">\n<img src="readme-assets/screenshots/desktop/screenshot-1.png" alt="Screenshot 2" width="600">\n<img src="readme-assets/screenshots/desktop/screenshot-2.png" alt="Screenshot 3" width="600">\n</div>\n\n### Themes\n\n|Light                                                                             |Dark                                                                              |Black                                                                             |\n|:-:                                                                               |:-:                                                                               |:-:                                                                               |\n|<img src="readme-assets/screenshots/themes/theme-1.png" alt="Theme 1" width="200">|<img src="readme-assets/screenshots/themes/theme-2.png" alt="Theme 2" width="200">|<img src="readme-assets/screenshots/themes/theme-3.png" alt="Theme 3" width="200">|\n',
    'author': 'FredHappyface',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/FHPythonUtils/Cli2Gui',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.5,<4.0',
}


setup(**setup_kwargs)
