# nomad-cbec-cli
This is the API descriptor for the Nomad CBEC, responsible for CBEC customer queries.<br><br> Developed by <a href=\"https://samarkand.global\">Samarkand Global</a> in partnership with <a href=\"https://www.sf-express.com/cn/sc/\">SF Express</a><br><br> Install for node with <br>`npm install nomad_cbec_cli`<br><br> Install for python with <br>`pip install nomad_cbec-cli`<br>

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.2
- Package version: 1.0.1
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import nomad_cbec_cli
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import nomad_cbec_cli
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import nomad_cbec_cli
from nomad_cbec_cli.rest import ApiException
from pprint import pprint

configuration = nomad_cbec_cli.Configuration()
# Configure API key authorization: ca_key
configuration.api_key['x-ca-key'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['x-ca-key'] = 'Bearer'

# Defining host is optional and default to https://nomad-cbec.samarkand-global.cn
configuration.host = "https://nomad-cbec.samarkand-global.cn"
# Enter a context with an instance of the API client
with nomad_cbec_cli.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = nomad_cbec_cli.UserApi(api_client)
    user_id = 'user_id_example' # str | Customer ID
name = 'name_example' # str | Customer Name

    try:
        # id
        api_response = api_instance.id_check(user_id, name)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling UserApi->id_check: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *https://nomad-cbec.samarkand-global.cn*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*UserApi* | [**id_check**](docs/UserApi.md#id_check) | **GET** /id | id


## Documentation For Models

 - [ApiResponse](docs/ApiResponse.md)
 - [ApiResponseData](docs/ApiResponseData.md)


## Documentation For Authorization


## ca_key

- **Type**: API key
- **API key parameter name**: x-ca-key
- **Location**: HTTP header


## Author

paul@samarkand.global


