from __future__ import annotations

from typing import (
    Any,
    Dict,
    Generic,
    Iterator,
    List,
    Optional,
    Type,
    TypeVar,
    Union,
    overload,
)

from bson import ObjectId
from mongoengine.queryset.visitor import Q
from pymongo import Collection, Cursor
from pymongo.command_cursor import CommandCursor
from typing_extensions import Literal

_T = TypeVar("_T")

_U = TypeVar("_U", bound="QuerySet[Any]")

class QuerySet(Generic[_T]):
    _document: Type[_T]
    _collection: Collection

    _cursor: Cursor

    _query: Dict[str, Any]
    def __init__(self, document: Type[_T], collection: Collection) -> None: ...
    def _clone_into(self, new_qs: _U) -> _U: ...
    def first(self) -> Optional[_T]: ...
    def get(self, *q_objs: Q, **query: object) -> _T: ...
    @overload
    def insert(
        self,
        doc_or_docs: Union[_T, List[_T]],
        load_bulk: Literal[False],
        write_concern: Optional[Any] = ...,
        signal_kwargs: Optional[Any] = ...,
    ) -> List[ObjectId]: ...
    @overload
    def insert(
        self,
        doc_or_docs: Union[_T, List[_T]],
        load_bulk: Literal[True] = ...,
        write_concern: Optional[Any] = ...,
        signal_kwargs: Optional[Any] = ...,
    ) -> List[_T]: ...
    def values(self, *args: str) -> Dict[str, Any]: ...
    def as_pymongo(self) -> QuerySet[Dict[str, Any]]: ...
    def values_list(self, *args: str) -> List[Any]: ...
    def update(self, *args: Q, **kwargs: object) -> int: ...
    def update_one(
        self, upsert: bool = ..., write_concern: Optional[Any] = ..., **update: object
    ) -> int: ...
    def delete(self) -> None: ...
    def filter(self: _U, *args: Q, **kwargs: object) -> _U: ...
    def none(self: _U) -> _U: ...
    def read_preference(self: _U, read_preference: object) -> _U: ...
    def only(self: _U, *args: str) -> _U: ...
    def order_by(self: _U, *args: str) -> _U: ...
    def skip(self: _U, amount: Optional[int]) -> _U: ...
    def limit(self: _U, amount: int) -> _U: ...
    def count(self) -> int: ...
    def __iter__(self) -> Iterator[_T]: ...
    def __next__(self) -> _T: ...
    def all(self: _U) -> _U: ...
    def aggregate(self, *args: object, allowDiskUse: bool = ...) -> CommandCursor: ...
    def max_time_ms(self: _U, ms: Optional[int]) -> _U: ...
    def create(self, **kwargs: object) -> _T: ...
    def distinct(self, field: str) -> List[Any]: ...
    def __getitem__(self, key: int) -> _T: ...
    def fields(self: _U, _only_called: bool = ..., **kwargs: int) -> _U: ...
    def __len__(self) -> int: ...
    def __call__(self: _U, *args: Q, **kwargs: object) -> _U: ...
