/*
 * Decompiled with CFR 0.152.
 */
package basicUtils;

import basicUtils.InspectAnnotation;
import basicUtils.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;

public class ComputeFScore {
    public static final String UsageInfo = "basicUtils.ComputeFScore.java version 2011.03.03\nComputes FScore based on match quality score (MQScore) and delta score.\nWrites out an updated results file.\n[Required Parameters]:\n -r [FILENAME] Read results from filename (and fit the probability mixture\nmodel to these results).  If the option value is a directory, we'll read\nall the results-files from the directory.\n -w [FILENAME] Write re-scored results to a file.\n[Optional Parameters]:\n -c Split by charge (compute the FScore separately for charge 1 and 2, and for charge 3.\n -b Results are from a blind search (not recommended)\n\nInternal use only:\n -v Verbose output (for debugging)\n\n[Example]:\njava -jar ComputeFScore.jar -r ShewanellaResults -w ShewanellaFiltered -c\n";
    public static final double defaultMQScoreWeight = 0.3;
    public static final double defaultDeltaScoreWeight = 1.5;
    public static final double defaultBlindMQScoreWeight = 0.3;
    public static final double defaultBlindDeltaScoreWeight = 1.5;
    public static final double BLIND_MOD_PENALTY = 1.0;
    public static final double MIN_MQSCORE = -10.0;
    public static final int MAX_RESULTS_FILES_TO_PARSE = 100;
    public static final double BIN_MULTIPLIER = 10.0;
    public static final double SQRT2PI = Math.sqrt(Math.PI * 2);
    private boolean debugFlag;
    private double MQScoreWeight;
    private double DeltaScoreWeight;
    private boolean BlindFlag;
    private boolean SplitByChargeFlag;
    private int AllSpectrumCountZ2;
    private int AllSpectrumCountZ3;
    private double MeanDeltaScoreZ2;
    private double MeanDeltaScoreZ3;
    private double MeanDeltaScore;
    private String ReadScoresPath;
    private String WriteScoresPath;

    public ComputeFScore() {
        this.debugFlag = false;
        this.MQScoreWeight = 0.3;
        this.DeltaScoreWeight = 1.5;
        this.BlindFlag = false;
        this.SplitByChargeFlag = false;
    }

    public ComputeFScore(String InputPath, String OutputPath, boolean debug, boolean blindFlag, boolean splitByChargeFlag) {
        this.ReadScoresPath = InputPath;
        this.WriteScoresPath = OutputPath;
        this.debugFlag = debug;
        this.BlindFlag = blindFlag;
        if (this.BlindFlag) {
            this.MQScoreWeight = 0.3;
            this.DeltaScoreWeight = 1.5;
        } else {
            this.MQScoreWeight = 0.3;
            this.DeltaScoreWeight = 1.5;
        }
        this.SplitByChargeFlag = splitByChargeFlag;
    }

    private void ReadDeltaScoreDistribution(String FilePath) {
        this.AllSpectrumCountZ2 = 0;
        this.AllSpectrumCountZ3 = 0;
        this.MeanDeltaScoreZ2 = 0.0;
        this.MeanDeltaScoreZ3 = 0.0;
        if (Utils.IsDir(FilePath)) {
            String[] Files = Utils.ListDir(FilePath);
            int i = 0;
            while (i < Files.length) {
                this.ReadDeltaScoreDistributionFromFile(Files[i]);
                ++i;
            }
        } else {
            this.ReadDeltaScoreDistributionFromFile(FilePath);
        }
        if (this.SplitByChargeFlag) {
            this.MeanDeltaScoreZ2 /= (double)Math.max(1, this.AllSpectrumCountZ2);
            this.MeanDeltaScoreZ3 /= (double)Math.max(1, this.AllSpectrumCountZ3);
            if (this.debugFlag) {
                System.out.println("Mean delta score ch1..2: " + this.MeanDeltaScoreZ2 + " over " + this.AllSpectrumCountZ2 + " spectra");
                System.out.println("Mean delta score ch3: " + this.MeanDeltaScoreZ3 + " over " + this.AllSpectrumCountZ3 + " spectra");
            }
            if (this.MeanDeltaScoreZ2 == 0.0) {
                this.MeanDeltaScoreZ2 = 0.001;
            }
            if (this.MeanDeltaScoreZ3 == 0.0) {
                this.MeanDeltaScoreZ3 = 0.001;
            }
        } else {
            this.MeanDeltaScore = (this.MeanDeltaScoreZ2 + this.MeanDeltaScoreZ3) / (double)Math.max(1, this.AllSpectrumCountZ2 + this.AllSpectrumCountZ3);
            if (this.debugFlag) {
                System.out.println("Mean delta score: " + this.MeanDeltaScore + " over " + (this.AllSpectrumCountZ2 + this.AllSpectrumCountZ3) + " spectra");
            }
        }
    }

    private void ReadDeltaScoreDistributionFromFile(String filePath) {
        System.out.println("Read delta-score distribution from " + filePath);
        BufferedReader buf = null;
        String line = null;
        try {
            buf = new BufferedReader(new FileReader(filePath));
            line = buf.readLine();
        }
        catch (IOException E) {
            E.printStackTrace();
            return;
        }
        String prevSpecKey = null;
        String currSpecKey = null;
        while (line != null) {
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
                try {
                    line = buf.readLine();
                    continue;
                }
                catch (IOException E) {
                    E.printStackTrace();
                    return;
                }
            }
            InspectAnnotation newAnn = new InspectAnnotation(line);
            if (newAnn.Length <= 0) {
                try {
                    line = buf.readLine();
                    continue;
                }
                catch (IOException E) {
                    E.printStackTrace();
                    return;
                }
            }
            currSpecKey = String.valueOf(newAnn.SpectrumFile) + "_" + newAnn.ScanNumber;
            if (prevSpecKey != null && currSpecKey.compareTo(prevSpecKey) == 0) {
                try {
                    line = buf.readLine();
                    continue;
                }
                catch (IOException E) {
                    E.printStackTrace();
                    return;
                }
            }
            prevSpecKey = currSpecKey;
            if (newAnn.DeltaScore < 0.0) {
                System.out.println("## Warning: DeltaScore < 0!");
                System.out.println("DeltaScore: " + newAnn.DeltaScore);
                System.out.println("MQScore: " + newAnn.MQScore);
                System.out.println(line);
                Utils.WaitForEnter();
                try {
                    line = buf.readLine();
                    continue;
                }
                catch (IOException E) {
                    E.printStackTrace();
                    return;
                }
            }
            if (newAnn.Charge < 3) {
                ++this.AllSpectrumCountZ2;
                this.MeanDeltaScoreZ2 += newAnn.DeltaScore;
            } else {
                ++this.AllSpectrumCountZ3;
                this.MeanDeltaScoreZ3 += newAnn.DeltaScore;
            }
            try {
                line = buf.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                return;
            }
        }
        try {
            buf.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            return;
        }
    }

    private void WriteMatchesForSpectrum(ArrayList MatchesForSpectrum, FileWriter f) {
        int i = 0;
        while (i < MatchesForSpectrum.size()) {
            InspectAnnotation Match = (InspectAnnotation)MatchesForSpectrum.get(i);
            String unModdedPep = Utils.GetUnModded(Match.Annotation);
            if (unModdedPep.length() < 7) {
                if (this.debugFlag) {
                    System.out.println("** Removed peptide " + unModdedPep + " because it is so short!!");
                }
            } else {
                double CurrMeanDeltaScore = this.SplitByChargeFlag ? (Match.Charge < 3 ? this.MeanDeltaScoreZ2 : this.MeanDeltaScoreZ3) : this.MeanDeltaScore;
                double WeightedScore = this.MQScoreWeight * Match.MQScore + this.DeltaScoreWeight * (Match.DeltaScore / CurrMeanDeltaScore);
                if (this.debugFlag) {
                    System.out.println("Pep: " + unModdedPep);
                    System.out.println("MQSCORE: " + Match.MQScore);
                    System.out.println("DELTASCORE: " + Match.DeltaScore);
                    System.out.println("MQWeight: " + this.MQScoreWeight + ", DeltaWeight : " + this.DeltaScoreWeight + ", Mean DeltaScore: " + CurrMeanDeltaScore);
                    System.out.println("New FScore: " + WeightedScore);
                    Utils.WaitForEnter();
                }
                Match.FScore = WeightedScore;
                try {
                    f.write(String.valueOf(Match.toStringMinimal()) + "\n");
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
            }
            ++i;
        }
    }

    private void WriteFixedScores(String OutputPath) {
        this.WriteScoresPath = OutputPath;
        if (Utils.IsDir(this.ReadScoresPath)) {
            Utils.MakeDir(this.WriteScoresPath);
        }
        if (Utils.IsDir(this.ReadScoresPath)) {
            String[] Files = Utils.ListDir(this.ReadScoresPath);
            int i = 0;
            while (i < Files.length) {
                this.WriteFixedScoresFile(Files[i]);
                ++i;
            }
        } else {
            this.WriteFixedScoresFile(this.ReadScoresPath);
        }
    }

    private void WriteFixedScoresFile(String Path2) {
        String OutputPath = Utils.IsDir(this.ReadScoresPath) ? String.valueOf(this.WriteScoresPath) + File.separator + Utils.GetBaseName(Path2) : this.WriteScoresPath;
        BufferedReader InFile = null;
        FileWriter OutFile = null;
        String FileLine = null;
        try {
            InFile = new BufferedReader(new FileReader(Path2));
            OutFile = new FileWriter(OutputPath);
            FileLine = InFile.readLine();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
        int LineCount = 0;
        String OldSpectrum = null;
        ArrayList<InspectAnnotation> MatchesForSpectrum = new ArrayList<InspectAnnotation>();
        while (FileLine != null) {
            if ((FileLine = FileLine.trim()).length() == 0 || FileLine.charAt(0) == '#') {
                if (FileLine.charAt(0) == '#') {
                    try {
                        OutFile.write(String.valueOf(FileLine) + "\n");
                    }
                    catch (IOException E) {
                        E.printStackTrace();
                        System.exit(-1);
                    }
                }
                try {
                    FileLine = InFile.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
                ++LineCount;
                continue;
            }
            InspectAnnotation currAnn = new InspectAnnotation(FileLine);
            if (currAnn.Length <= 0) {
                try {
                    FileLine = InFile.readLine();
                }
                catch (IOException E) {
                    E.printStackTrace();
                    System.exit(-1);
                }
                ++LineCount;
                continue;
            }
            String CurrSpecKey = String.valueOf(currAnn.SpectrumFile) + "_" + currAnn.ScanNumber;
            if (OldSpectrum != null && CurrSpecKey.compareTo(OldSpectrum) != 0) {
                this.WriteMatchesForSpectrum(MatchesForSpectrum, OutFile);
                MatchesForSpectrum.clear();
            }
            OldSpectrum = CurrSpecKey;
            MatchesForSpectrum.add(currAnn);
            try {
                FileLine = InFile.readLine();
            }
            catch (IOException E) {
                E.printStackTrace();
                System.exit(-1);
            }
            ++LineCount;
        }
        this.WriteMatchesForSpectrum(MatchesForSpectrum, OutFile);
        try {
            InFile.close();
            OutFile.close();
        }
        catch (IOException E) {
            E.printStackTrace();
            System.exit(-1);
        }
    }

    public void Run() {
        this.ReadDeltaScoreDistribution(this.ReadScoresPath);
        this.WriteFixedScores(this.WriteScoresPath);
    }

    public static void Run(String InputPath, String OutputPath, boolean splitChargeFlag, boolean blindFlag) {
        ComputeFScore computer = new ComputeFScore(InputPath, OutputPath, false, blindFlag, splitChargeFlag);
        computer.Run();
    }

    public static void main(String[] args) {
        String[] Commands = new String[]{"-r", "-w", "-c", "-b", "-v"};
        boolean[] blArray = new boolean[5];
        blArray[0] = true;
        blArray[1] = true;
        boolean[] Values = blArray;
        Hashtable Options = Utils.ParseCommandLine(args, Commands, Values);
        if (!Options.containsKey("-r") || !Options.containsKey("-w")) {
            System.err.println("ERROR: Must specify an input file or directory and an output file or directory");
            System.out.println(UsageInfo);
            return;
        }
        String inputPath = (String)Options.get("-r");
        String outputPath = (String)Options.get("-w");
        boolean splitOnChargeFlag = false;
        boolean blindFlag = false;
        boolean verboseFlag = false;
        if (Options.containsKey("-c")) {
            splitOnChargeFlag = true;
        }
        if (Options.containsKey("-b")) {
            blindFlag = true;
        }
        if (Options.containsKey("-v")) {
            verboseFlag = true;
        }
        ComputeFScore computer = new ComputeFScore(inputPath, outputPath, verboseFlag, blindFlag, splitOnChargeFlag);
        computer.Run();
    }
}

