/*
 * Decompiled with CFR 0.152.
 */
package trieUtils;

import basicUtils.Utils;

public class TrieNode {
    public int StateNum;
    TrieNode FailureNode = null;
    String[] OutputPeptides = null;
    TrieNode[] Transitions = null;

    public TrieNode(int StateNum) {
        this.StateNum = StateNum;
        this.Transitions = new TrieNode[26];
        int i = 0;
        while (i < 26) {
            this.Transitions[i] = null;
            ++i;
        }
    }

    public TrieNode GetNext(char Transition) {
        return this.Transitions[Transition - 65];
    }

    public TrieNode GetFailure() {
        return this.FailureNode;
    }

    public String[] GetOutput() {
        return this.OutputPeptides;
    }

    public boolean equals(TrieNode OtherNode) {
        return this.StateNum == OtherNode.StateNum;
    }

    public void AddNewOutputString(String Peptide2) {
        String[] NewStringList = null;
        NewStringList = this.OutputPeptides == null ? new String[1] : new String[this.OutputPeptides.length + 1];
        int i = 0;
        while (i < NewStringList.length - 1) {
            NewStringList[i] = this.OutputPeptides[i];
            if (this.OutputPeptides[i].compareTo(Peptide2) == 0) {
                return;
            }
            ++i;
        }
        NewStringList[NewStringList.length - 1] = Peptide2;
        this.OutputPeptides = NewStringList;
    }

    public void AddNewOutputStrings(String[] Peptides) {
        if (Peptides == null) {
            return;
        }
        int i = 0;
        while (i < Peptides.length) {
            this.AddNewOutputString(Peptides[i]);
            ++i;
        }
    }

    public void DebugPrintRec() {
        System.out.println("**TrieNode: " + this.StateNum);
        int i = 0;
        while (i < this.Transitions.length) {
            if (this.Transitions[i] != null && this.Transitions[i].StateNum != 0) {
                System.out.println(" " + (char)(i + 65) + " -> " + this.Transitions[i].StateNum);
            }
            ++i;
        }
        if (this.FailureNode != null) {
            System.out.println(" FAILURE: " + this.FailureNode.StateNum);
        } else {
            System.out.println(" FAILURE: " + this.FailureNode);
        }
        if (this.OutputPeptides != null) {
            System.out.println(" OUTPUT: " + this.OutputPeptides.length);
        }
        Utils.WaitForEnter();
        i = 0;
        while (i < this.Transitions.length) {
            if (this.Transitions[i] != null && this.Transitions[i].StateNum != 0) {
                this.Transitions[i].DebugPrintRec();
            }
            ++i;
        }
    }
}

