# Templaer

`Templaer` - универсальный CLI шаблонизатор конфигурационных файлов, основанный на `Jinja2`.

- GitHub - <https://github.com/denisxab/templaer>
- Pip - <https://pypi.org/project/templaer/>
- Habr - <https://habr.com/ru/post/717996/>

## Аналоги

Существует множество инструментов, основанных на `Jinja2`, которые можно использовать для шаблонизации конфигурационных файлов через `CLI`. Вот несколько примеров:

- `j2cli`: это инструмент командной строки, который позволяет использовать Jinja2 для создания конфигурационных файлов. Он может принимать данные из файлов или стандартного ввода и применять их к шаблонам, включая конфигурационные файлы.
- `cookiecutter`: это инструмент командной строки, который использует Jinja2 для генерации проектных шаблонов. Он также может использоваться для создания конфигурационных файлов. cookiecutter может быть установлен через pip.
- `ansible`: это инструмент автоматизации, который использует Jinja2 для шаблонизации конфигурационных файлов и других файлов, используемых в автоматизации. ansible может быть установлен через pip.
- `SaltStack`: это инструмент автоматизации, который использует Jinja2 для шаблонизации конфигурационных файлов и других файлов, используемых в автоматизации. SaltStack также может быть установлен через pip.
- `mustpl` : <https://habr.com/ru/post/684898/>

Я создал `Templaer` потому что им удобнее пользоваться, и так как он на `Python`, его можно гибко кастомизировать. Если вам нравиться использовать другие шаблонизаторы конфигураций, то используйте их.

## Установка

1. Установить `templaer`

    ```bash
    pip install templaer
    ```

2. Получить подсказку по `CLI`

    ```bash
    python -m templaer
    ```

> Можете создать алиас в `.bashrc`/`.zshrc` для этой команды
>
> ```bash
> alias templaer="python -m templaer"
> ```

## Примеры CLI

В файле `context.json` хранятся данные для шаблонов. В простом варианте это может быть словарь. Ключ - это имя переменной, значение ключа - это значение переменной.

```json
{
    "DEBUG": false,
    "PORT_D": 8080,
    "PORT_R": 80
}
```

Пример шаблонного файла. Предлагаю для них указывать расширение `.tpl`. В данном случае этот файл называется `nginx.conf.tpl`. Новый собранный файл не будет иметь расширение `.tpl`, и будет называться `nginx.conf`.

```nginx
server {
    listen {{ PORT_R }};
    server_name "localhost";

    location / {
        default_type text/html;
        return 200 'ok';
    }
}
```

- Собрать указанные файлы (можно указывать несколько файлов).

    ```bash
    python -m templaer -c context.json -f Файл1.conf.tpl Файл2.tpl
    ```

- Поиск в указанной директории всех файлов, которые оканчиваются на .tpl, и сборка этих файлов (можно указывать несколько директорий).

    ```bash
    python -m templaer -c context.json -d Папка  
    ```

## Основы шаблонов на Jinja2

### Тернарный условный оператор

В этом примере показано как в зависимости от переменной `DEBUG`, будет поставлено значение из переменной `PORT_D` или `PORT_R`.

1. Содержание файла `context.json`:

    ```json
    {
        "DEBUG": false,
        "PORT_D": 8080,
        "PORT_R": 80
    }
    ```

2. Содержание файла `ЛюбойФайл.conf.tpl`:

    ```nginx
    server {
        listen {{ PORT_D if DEBUG else PORT_R }};
        server_name "localhost";

        location / {
            default_type text/html;
            return 200 'ok';
        }
    }
    ```

3. Соберем файл используя команду:

    ```bash
    python -m templaer -c context.json -f ЛюбойФайл.conf.tpl
    ```

4. В итоге создастся(или перезапишитесь) новый файл `ЛюбойФайл.conf`, с содержанием:

    ```nginx
    server {
        listen 80;
        server_name "localhost";

        location / {
            default_type text/html;
            return 200 'ok';
        }
    }
    ```
