# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/views.table_widget.ipynb (unless otherwise specified).

__all__ = ['logger', 'Table']

# Cell
from traitlets import Unicode, Bool, validate, TraitError, Instance, Dict, List, Unicode, Int
from ipywidgets import DOMWidget, register
import ipywidgets as ipyw

# Cell
from ..config import APP_DIR, CONFIG
from ..log import HANDLERS
from ..widgets import Widget
logger = HANDLERS.getLogger(__name__)

# Cell
@register
class Table(DOMWidget, Widget):
    _view_name = Unicode('TableView').tag(sync=True)
    _view_module = Unicode('widgets/table_widget').tag(sync=True)
    _view_module_version = Unicode('0.1.0').tag(sync=True)

    # Attributes
    data = List([]).tag(sync=True)
    selected = Int(0).tag(sync=True)

    @validate('data')
    def _valid_value(self, proposal):
        for row in proposal['value']:
            if type(row) is not dict:
                raise TraitError('All list items should be dictionaries')
            required_keys = ['id', 'name', 'runtime', 'runNum']
            for key in required_keys:
                if key not in row:
                    raise TraitError('All table rows must contain the key \"' + key + '\"')
        return proposal['value']